/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.edithgs;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrCheckBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.topwindow.base.SJctrGetSystemOption;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupTableKey;
import sanproject.sn2.controller.wizard.lunm.edithgs.SJctrEditHGApplyParam;
import sanproject.sn2.controller.wizard.lunm.edithgs.SJctrEditHGConfirmData;
import sanproject.sn2.controller.wizard.lunm.edithgs.SJctrErrorTableModel;
import sanproject.sn2.controller.wizard.lunm.edithgs.SJctrHGArea;
import sanproject.sn2.controller.wizard.lunm.edithgs.SJctrHostModeArea;
import sanproject.sn2.controller.wizard.lunm.edithgs.SJctrHostModeComboModel;
import sanproject.sn2.controller.wizard.lunm.edithgs.SJctrHostModeOptTableModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrEditHGDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 0x1100011;
    public static final String KEY_HOSTGROUPINF = "COM_HOSTGROUPINF";
    public static final String KEY_HOSTMODEINF = "COM_HOSTMODEINF";
    public static final String KEY_FOOTER = "COM_FOOTER";
    public static final Class KEY_CLASS_MPORTDETL = SJmoGetPortDetail.class;
    public static final Class KEY_CLASS_MPORTATTR = SJmoGetPortAttributeInfo.class;
    public static final Class KEY_CLASS_MPORTHG = SJmoGetPortHostGroupInfo.class;
    public static final Class KEY_CLASS_MPORTLUN = SJmoGetPortLunInfo.class;
    public static final Class KEY_CLASS_MLDEVDETL = SJmoGetLdevDetail.class;
    public static final Class KEY_CLASS_PORTHGFROMLV = SJctrPortHostGroupTableKey.class;
    public static final String KEY_CLASS_PORTHGINDEX = "KEY_CLASS_PORTHGINDEX";
    public static final Class<?> KEY_CLASS_APPLY_PARAM = SJctrEditHGApplyParam.class;
    public static final Class KEY_CLASS_SYS_OPT = SJctrGetSystemOption.class;
    public static final Class KEY_CLASS_RSG = SJmoGetRSGgetAllRsgs.class;
    public static final String KEY_CLASS_CONFIRM_DATA = "SJctrEditHGConfirmData";
    public static final String TITLE = "DISP_DI1S_TITLE";
    public static final int MIN_STRLEN_HGNAME = 1;
    public static final int MAX_STRLEN_HGNAME = 64;
    public static int EDITHG_ERR1 = 107001;
    public static int EDITHG_ERR2 = 106502;
    public static int EDITHG_ERR3 = 107006;
    public static int EDITHG_ERR4 = 105093;
    public static int EDITHG_ERR5 = 105010;
    public static int EDITHG_ERR6 = 105011;
    public static int EDITHG_ERR7 = 105012;
    public static int EDITHG_ERR8 = 105013;
    public static int EDITHG_ERR9 = 105014;
    public static int EDITHG_ERR10 = 105209;
    public static int EDITHG_ERR11 = 105210;
    public static int EDITHG_ERR12 = 105015;
    public static int EDITHG_ERR13 = 105009;
    public static int EDITHG_ERR14 = 105297;
    public static int EDITHG_ERR15 = 107002;
    public static int EDITHG_ERR_PORT_CHECK = 105421;
    public static int EDITHG_ERR_SysRSG_HG = 205164;
    private boolean initiatorFlg = false;

    public SJctrEditHGDC() throws SJcException {
        super(0x1100011);
        this.initDataModel();
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_HOSTGROUPINF, new SJctrHGArea());
        this.addDataObjectModel(KEY_HOSTMODEINF, new SJctrHostModeArea());
        this.addDataObjectModel(KEY_FOOTER, new SJctrFooterDataModel());
    }

    @Override
    public boolean checkStartData() {
        boolean bRet = true;
        SJctrWizardWindowDC wizard = this.getWizardWindow();
        List<?> targetList = wizard.getCache(KEY_CLASS_PORTHGFROMLV);
        if (targetList == null || targetList.size() == 0) {
            bRet = false;
            SJctrError err = new SJctrError(10, 22, EDITHG_ERR1);
            SJcException exp = err.createException();
            throw exp;
        }
        return bRet;
    }

    @Override
    public boolean checkConstructData() {
        boolean ret = true;
        List<SJctrPortHostGroupTableKey> targetList = this.getCache(KEY_CLASS_PORTHGFROMLV);
        ArrayList<SJctrError> errlist = new ArrayList<SJctrError>(targetList.size());
        for (int errpos = 0; errpos < targetList.size(); ++errpos) {
            SJctrError oneError = new SJctrError(0, 0, 0);
            errlist.add(oneError);
        }
        ret = this.checkEquipHg(targetList, errlist);
        if (ret) {
            ret = this.checkFibrePort(targetList, errlist);
        }
        if (ret) {
            ret = this.checkPortAttribute(targetList, errlist);
        }
        if (!ret) {
            ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>(targetList.size());
            ArrayList<SJctrPortHostGroupTableKey> tableKeyList = new ArrayList<SJctrPortHostGroupTableKey>(targetList.size());
            for (int errpos = 0; errpos < targetList.size(); ++errpos) {
                SJctrError oneError = errlist.get(errpos);
                if (oneError.getError() == 0) continue;
                SJctrErrorColumnData errColumn = new SJctrErrorColumnData(targetList.get(errpos), oneError);
                errColumnList.add(errColumn);
                tableKeyList.add(targetList.get(errpos));
            }
            SJctrError errInfo = ((SJctrErrorColumnData)errColumnList.get(0)).getError();
            SJctrErrorTableModel errTable = new SJctrErrorTableModel(tableKeyList);
            errTable.setDataController(this);
            errTable.initGuidance(this.getComUtility());
            errTable.createModelDirect();
            errTable.divideModelData(this.getProxy().getModelDataMap());
            errTable.makeDataModel();
            SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)this.getOwner().getDataController(rel);
            errDc.setParameter(errTable, errColumnList);
            SJcException exp = errInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
        List<SJctrPortHostGroupTableKey> portHGInfo = this.getCache(KEY_CLASS_PORTHGINDEX);
        this.initData(portHGInfo);
        return ret;
    }

    @Override
    public boolean checkEndData() {
        SJctrCheckBoxDataModel chkHostMode;
        boolean ret = true;
        SJctrLogUty.info(this.getClass().getSimpleName(), "checkEndData", "Start");
        List<SJctrPortHostGroupTableKey> targetList = this.getCache(KEY_CLASS_PORTHGINDEX);
        ArrayList<SJctrError> errlist = new ArrayList<SJctrError>(targetList.size());
        for (int errpos = 0; errpos < targetList.size(); ++errpos) {
            SJctrError oneError = new SJctrError(0, 0, 0);
            errlist.add(oneError);
        }
        SJctrError headErr = new SJctrError(0, 0, 0);
        SJctrCheckBoxDataModel chkHg = this.getHGCheckBoxModel();
        if (chkHg.isSelect()) {
            ret = this.checkHGNameLength(headErr);
            if (ret) {
                ret = this.checkHGNameCharactor(headErr);
            }
            if (ret) {
                ret = this.checkUsedHGName(targetList, errlist);
            }
            if (ret) {
                ret = this.checkHGDefaultID(targetList, errlist);
            }
        }
        if ((chkHostMode = this.getHostModeCheckBoxModel()).isSelect()) {
            if (ret) {
                ret = this.checkHostModeOptionBlank(headErr);
            }
            if (ret) {
                ret = this.checkHostModeIsUVM(targetList, errlist);
            }
        }
        if (!chkHg.isSelect() && !chkHostMode.isSelect()) {
            ret = false;
            headErr.setFunc(10);
            headErr.setModule(22);
            headErr.setError(EDITHG_ERR13);
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkEndData", "not have any edit item.");
        }
        if (!ret) {
            if (headErr.getError() != 0) {
                SJcException exp = headErr.createException();
                throw exp;
            }
            ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>(targetList.size());
            ArrayList<SJctrPortHostGroupTableKey> tableKeyList = new ArrayList<SJctrPortHostGroupTableKey>(targetList.size());
            for (int errpos = 0; errpos < targetList.size(); ++errpos) {
                SJctrError oneError = errlist.get(errpos);
                if (oneError.getError() == 0) continue;
                SJctrErrorColumnData errColumn = new SJctrErrorColumnData(targetList.get(errpos), oneError);
                errColumnList.add(errColumn);
                tableKeyList.add(targetList.get(errpos));
            }
            SJctrError errInfo = ((SJctrErrorColumnData)errColumnList.get(0)).getError();
            SJctrErrorTableModel errTable = new SJctrErrorTableModel(tableKeyList);
            errTable.setDataController(this);
            errTable.initGuidance(this.getComUtility());
            errTable.createModelDirect();
            errTable.divideModelData(this.getProxy().getModelDataMap());
            errTable.makeDataModel();
            SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)this.getOwner().getDataController(rel);
            errDc.setParameter(errTable, errColumnList);
            SJcException exp = errInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
        List<?> portDetailList = this.getCache(KEY_CLASS_MPORTDETL);
        List<SJctrPortHostGroupTableKey> targetHg = this.getCache(KEY_CLASS_PORTHGFROMLV);
        SJctrComUtility comUtil = this.getComUtility();
        SJctrPortUtility portUtil = comUtil.getPortUtility();
        portUtil.checkPortSecurityMsg(portDetailList, targetHg, this);
        SJctrEditHGApplyParam applyParam = this.createApplyData();
        SJctrLogUty.info(this.getClass().getSimpleName(), "checkEndData", "Finish");
        return ret;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        set.add(this.createModelDirect(KEY_CLASS_MPORTDETL));
        set.add(this.createModelDirect(KEY_CLASS_MPORTATTR));
        set.add(this.createModelDirect(KEY_CLASS_MPORTHG));
        set.add(this.createModelDirect(KEY_CLASS_MPORTLUN));
        set.add(this.createModelDirect(KEY_CLASS_MLDEVDETL));
        set.add(this.createModelDirect(KEY_CLASS_SYS_OPT));
        set.add(this.createModelDirect(KEY_CLASS_RSG));
        return set;
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("LUNM", TITLE);
    }

    private SJctrGetDirectWrapper createModelDirect(Class<? extends SJmoGetKind_IF> kindClass) {
        SJctrGetDirectWrapper retValue = null;
        try {
            SJmoGetKind_IF kind = kindClass.newInstance();
            SJmoGetRange_IF range = null;
            ArrayList filterList = new ArrayList();
            SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
            retValue = new SJctrGetDirectWrapper(direct);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return retValue;
    }

    private boolean checkEquipHg(List<SJctrPortHostGroupTableKey> portHg, List<SJctrError> errList) {
        boolean ret = true;
        List<?> ptHgModel = this.getCache(KEY_CLASS_MPORTHG);
        if (ptHgModel == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkEquipHg", "SJmoGetPortHostGroupInfo Not Found in the Cache.");
            return false;
        }
        ArrayList<SJctrPortHostGroupTableKey> keyList = new ArrayList<SJctrPortHostGroupTableKey>(portHg.size());
        for (int index = 0; index < portHg.size(); ++index) {
            SJctrPortHostGroupTableKey onePtHgKey = portHg.get(index);
            boolean includeInfo = false;
            int searchRet = Collections.binarySearch(ptHgModel, onePtHgKey.getPortHostGroupInfo());
            if (searchRet >= 0) {
                SJmoPortHostGroupInfo oneModelPt = (SJmoPortHostGroupInfo)ptHgModel.get(searchRet);
                ArrayList hgArray = oneModelPt.getAlPortHostGroup();
                for (SJmoHostGroupInfo oneModelHg : hgArray) {
                    if (oneModelHg.getSHostGroup() != onePtHgKey.getHostGroupInfo().getSHostGroup()) continue;
                    includeInfo = true;
                    SJctrPortHostGroupTableKey newPortHgKey = new SJctrPortHostGroupTableKey(oneModelPt, oneModelHg);
                    keyList.add(newPortHgKey);
                }
            }
            if (includeInfo) continue;
            ret = false;
            SJctrError errElement = errList.get(index);
            errElement.setFunc(10);
            errElement.setModule(22);
            errElement.setError(EDITHG_ERR2);
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkEquipHg", "Port# = " + onePtHgKey.getPortHostGroupInfo().getSPort() + ", HostGroup # = " + onePtHgKey.getHostGroupInfo().getSHostGroup() + " Not Found.");
        }
        if (ret) {
            this.putCache(KEY_CLASS_PORTHGINDEX, keyList);
        }
        return ret;
    }

    private void initData(List<SJctrPortHostGroupTableKey> keyList) {
        SJctrPortHostGroupTableKey key1;
        SJctrPortHostGroupTableKey key0;
        SJctrCheckBoxDataModel chkHg;
        if (this.initiatorFlg) {
            SJctrHostModeComboModel comboData = this.getHostModeComboBoxModel();
            comboData.setEnable(false);
            SJctrTextBoxDataModel textData = this.getHGTextBoxModel();
            textData.setEnable(false);
            chkHg = this.getHGCheckBoxModel();
            chkHg.setEnable(false);
        }
        if (keyList.size() > 1) {
            boolean samePortFlg = false;
            for (int listpos = 0; listpos < keyList.size() - 1; ++listpos) {
                key0 = keyList.get(listpos);
                key1 = keyList.get(listpos + 1);
                if (key0.getPortHostGroupInfo().getSPort() != key1.getPortHostGroupInfo().getSPort()) continue;
                samePortFlg = true;
            }
            if (samePortFlg) {
                SJctrTextBoxDataModel textData = this.getHGTextBoxModel();
                textData.setEnable(false);
                chkHg = this.getHGCheckBoxModel();
                chkHg.setEnable(false);
            }
        } else {
            SJctrPortHostGroupTableKey inputKey = keyList.get(0);
            String hgName = inputKey.getHostGroupInfo().getStrHostgroupNickName();
            SJctrTextBoxDataModel textData = this.getHGTextBoxModel();
            textData.setValue(hgName);
        }
        boolean allSameHostModeFlg = true;
        for (int listpos = 0; listpos < keyList.size() - 1; ++listpos) {
            key0 = keyList.get(listpos);
            key1 = keyList.get(listpos + 1);
            if (key0.getHostGroupInfo().getByHostMode() == key1.getHostGroupInfo().getByHostMode()) continue;
            allSameHostModeFlg = false;
            break;
        }
        if (allSameHostModeFlg) {
            SJctrPortHostGroupTableKey inputKey = keyList.get(0);
            byte hostModeNum = inputKey.getHostGroupInfo().getByHostMode();
            SJctrHostModeComboModel comboData = this.getHostModeComboBoxModel();
            comboData.initItemListWithSelect(this.getComUtility().getPortUtility(), hostModeNum);
            comboData.setSelection(Byte.toString(hostModeNum));
        } else {
            SJctrHostModeComboModel comboData = this.getHostModeComboBoxModel();
            comboData.initItemListWithEmpty(this.getComUtility().getPortUtility());
        }
        SJctrHostModeOptTableModel optTbl = this.getHostModeOptTableModel();
        optTbl.initBitSet(keyList);
    }

    private boolean checkFibrePort(List<SJctrPortHostGroupTableKey> portHg, List<SJctrError> errList) {
        boolean ret = true;
        List<?> ptDetail = this.getCache(KEY_CLASS_MPORTDETL);
        if (ptDetail == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkFibrePort", "SJmoGetPortDetail Not Found in the Cache.");
            return false;
        }
        for (int index = 0; index < portHg.size(); ++index) {
            SJctrPortHostGroupTableKey onePtHgKey = portHg.get(index);
            int searchRet = Collections.binarySearch(ptDetail, onePtHgKey.getPortHostGroupInfo());
            if (searchRet < 0) {
                SJctrLogUty.info(this.getClass().getSimpleName(), "checkFibrePort", "Skipped Port#= " + onePtHgKey.getPortHostGroupInfo().getSPort());
                continue;
            }
            SJmoPortDetail oneptDetail = (SJmoPortDetail)ptDetail.get(searchRet);
            byte portKind = oneptDetail.getByPortKindNo();
            if (SJctrPortUtility.isSupportPortType(oneptDetail)) continue;
            ret = false;
            SJctrError errElement = errList.get(index);
            errElement.setFunc(10);
            errElement.setModule(22);
            errElement.setError(EDITHG_ERR3);
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkFibrePort", "Port# = " + oneptDetail.getSPort() + ", Kind = " + portKind);
        }
        return ret;
    }

    private boolean checkPortAttribute(List<SJctrPortHostGroupTableKey> portHg, List<SJctrError> errList) {
        boolean ret = true;
        List<?> ptAttr = this.getCache(KEY_CLASS_MPORTATTR);
        if (ptAttr == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkPortAttribute", "SJmoGetPortAttributeInfo Not Found in the Cache.");
            return false;
        }
        List<?> rsgDetailList = this.getCache(KEY_CLASS_RSG);
        if (rsgDetailList == null || rsgDetailList.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkPortAttribute", "SJmoRSGgetAllRsgs Not Found in the Cache.");
            SJctrError err = new SJctrError(10, 22, EDITHG_ERR15);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), (SJmoRSGgetAllRsgs)rsgDetailList.get(0));
        SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
        for (int index = 0; index < portHg.size(); ++index) {
            SJctrPortHostGroupTableKey onePtHgKey = portHg.get(index);
            int searchRet = Collections.binarySearch(ptAttr, onePtHgKey.getPortHostGroupInfo());
            if (searchRet < 0) {
                SJctrLogUty.info(this.getClass().getSimpleName(), "checkPortAttribute", "Skipped Port#= " + onePtHgKey.getPortHostGroupInfo().getSPort());
                continue;
            }
            SJmoPortAttributeInfo onePortAttr = (SJmoPortAttributeInfo)ptAttr.get(searchRet);
            byte portKind = onePortAttr.getByPortKind();
            if (portKind == 3 || portKind == 4 || portKind == 9) {
                hgIndex.setSPort(onePtHgKey.getPortHostGroupInfo().getSPort());
                hgIndex.setSHostGroup(onePtHgKey.getHostGroupInfo().getSHostGroup());
                boolean rsgFlg = SJctrPortUtility.isRsgHostGroupIndex(hgIndex, rsgUtil);
                if (!rsgFlg) {
                    ret = false;
                    SJctrError errElement = errList.get(index);
                    errElement.setFunc(10);
                    errElement.setModule(22);
                    errElement.setError(EDITHG_ERR14);
                    continue;
                }
                boolean sysRsgFlg = rsgUtil.isSelRscHgInSysRsg(hgIndex);
                if (!sysRsgFlg) continue;
                ret = false;
                SJctrError errElement = errList.get(index);
                errElement.setFunc(10);
                errElement.setModule(22);
                errElement.setError(EDITHG_ERR_SysRSG_HG);
                continue;
            }
            if (portKind == 5) {
                this.initiatorFlg = true;
                continue;
            }
            ret = false;
            SJctrError errElement = errList.get(index);
            errElement.setFunc(10);
            errElement.setModule(22);
            errElement.setError(EDITHG_ERR_PORT_CHECK);
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkPortAttribute", "Port# = " + onePortAttr.getSPort() + ", Attribute = " + portKind);
        }
        this.getHostModeOptTableModel().setInitiatorFlg(this.initiatorFlg);
        return ret;
    }

    private boolean checkHGNameLength(SJctrError err) {
        boolean ret = true;
        SJctrTextBoxDataModel textData = this.getHGTextBoxModel();
        String textValue = textData.getValue();
        if (textValue.length() < 1) {
            ret = false;
            err.setFunc(10);
            err.setModule(22);
            err.setError(EDITHG_ERR5);
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkHGNameLength", "HGName TextLength = " + textValue.length());
        } else if (textValue.length() > 64) {
            ret = false;
            err.setFunc(10);
            err.setModule(22);
            err.setError(EDITHG_ERR6);
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkHGNameLength", "HGName TextLength = " + textValue.length());
        }
        return ret;
    }

    private boolean checkHGNameCharactor(SJctrError err) {
        boolean ret = true;
        SJctrTextBoxDataModel textData = this.getHGTextBoxModel();
        String textValue = textData.getValue();
        ret = SJctrComUtility.isUsableChar(textValue);
        if (!ret) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkHGNameCharactor", "Invalid String : " + textValue);
            err.setFunc(10);
            err.setModule(22);
            err.setError(EDITHG_ERR7);
        }
        return ret;
    }

    private boolean checkUsedHGName(List<SJctrPortHostGroupTableKey> portHg, List<SJctrError> errList) {
        boolean ret = true;
        SJctrTextBoxDataModel textData = this.getHGTextBoxModel();
        String textValue = textData.getValue();
        List<?> mdlPortHgList = this.getCache(KEY_CLASS_MPORTHG);
        if (mdlPortHgList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkUsedHGName", "SJmoGetPortHostGroupInfo Not Found in the Cache.");
            return false;
        }
        block0: for (int index = 0; index < portHg.size(); ++index) {
            SJctrPortHostGroupTableKey onePtHgKey = portHg.get(index);
            int searchRet = Collections.binarySearch(mdlPortHgList, onePtHgKey.getPortHostGroupInfo());
            if (searchRet < 0) {
                SJctrLogUty.info(this.getClass().getSimpleName(), "checkUsedHGName", "Skipped Port#= " + onePtHgKey.getPortHostGroupInfo().getSPort());
                continue;
            }
            SJmoPortHostGroupInfo mdlOnePortHg = (SJmoPortHostGroupInfo)mdlPortHgList.get(searchRet);
            for (Object mdlHgObj : mdlOnePortHg.getAlPortHostGroup()) {
                String mdlHgName;
                SJmoHostGroupInfo mdlHg = (SJmoHostGroupInfo)mdlHgObj;
                if (onePtHgKey.getHostGroupInfo().getSHostGroup() == mdlHg.getSHostGroup() || !(mdlHgName = mdlHg.getStrHostgroupNickName()).equals(textValue)) continue;
                ret = false;
                SJctrError errElement = errList.get(index);
                errElement.setFunc(10);
                errElement.setModule(22);
                errElement.setError(EDITHG_ERR8);
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkUsedHGName", "Host Group Name is Conflicted :" + textValue);
                continue block0;
            }
        }
        return ret;
    }

    private boolean checkHGDefaultID(List<SJctrPortHostGroupTableKey> portHg, List<SJctrError> errList) {
        boolean ret = true;
        SJctrTextBoxDataModel textData = this.getHGTextBoxModel();
        String textValue = textData.getValue();
        List<?> ptDetailList = this.getCache(KEY_CLASS_MPORTDETL);
        if (ptDetailList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkHGDefaultID", "SJmoGetPortDetail Not Found in the Cache.");
            return false;
        }
        for (int index = 0; index < portHg.size(); ++index) {
            SJctrPortHostGroupTableKey onePtHgKey = portHg.get(index);
            if (onePtHgKey.getHostGroupInfo().getSHostGroup() == 0) continue;
            int searchRet = Collections.binarySearch(ptDetailList, onePtHgKey.getPortHostGroupInfo());
            if (searchRet < 0) {
                SJctrLogUty.info(this.getClass().getSimpleName(), "checkHGDefaultID", "Skipped Port#= " + onePtHgKey.getPortHostGroupInfo().getSPort());
                continue;
            }
            SJmoPortDetail onePtDetail = (SJmoPortDetail)ptDetailList.get(searchRet);
            SJctrPortUtility util = this.getComUtility().getPortUtility();
            if (!textValue.equals(util.toDefaultHGName(onePtDetail))) continue;
            ret = false;
            SJctrError errElement = errList.get(index);
            errElement.setFunc(10);
            errElement.setModule(22);
            errElement.setError(EDITHG_ERR9);
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkHGDefaultID", "used Default ID at Port = " + onePtHgKey.getPortHostGroupInfo().getSPort() + ", HostGroup = " + onePtHgKey.getHostGroupInfo().getSHostGroup());
        }
        return ret;
    }

    private boolean checkHostModeBlank(SJctrError err) {
        boolean ret = true;
        SJctrHostModeComboModel comboData = this.getHostModeComboBoxModel();
        if (comboData.getSelectedHostModeValue() == -1) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkHostModeBlank", "Host Mode Combobox is blank!!");
            ret = false;
            err.setFunc(10);
            err.setModule(22);
            err.setError(EDITHG_ERR10);
        }
        return ret;
    }

    private boolean checkHostModeOptionBlank(SJctrError err) {
        boolean ret = true;
        SJctrHostModeOptTableModel tblData = this.getHostModeOptTableModel();
        BitSet empryBitSet = tblData.getIndefiniteBitSet();
        if (!empryBitSet.isEmpty()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkHostModeOptionBlank", "Host Mode Option is blank!! First blank = " + empryBitSet.nextSetBit(0));
            ret = false;
            err.setFunc(10);
            err.setModule(22);
            err.setError(EDITHG_ERR11);
        }
        return ret;
    }

    private boolean checkHostModeIsUVM(List<SJctrPortHostGroupTableKey> portHg, List<SJctrError> errList) {
        boolean ret = true;
        SJctrHostModeComboModel comboData = this.getHostModeComboBoxModel();
        List<?> ldevDetailList = this.getCache(KEY_CLASS_MLDEVDETL);
        if (ldevDetailList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkHostModeIsUVM", "SJmoGetLdevDetail Not Found in the Cache.");
            return false;
        }
        if (comboData.getSelectedHostModeValue() == 76) {
            block0: for (int index = 0; index < portHg.size(); ++index) {
                SJctrPortHostGroupTableKey onePtHgKey = portHg.get(index);
                ArrayList<SJmoPortLunDetail> alHtgLun = this.getConnectLUPath(onePtHgKey);
                for (SJmoPortLunDetail htgLun : alHtgLun) {
                    short ldkc = htgLun.getSLDKC();
                    short cu = htgLun.getSCU();
                    short dev = htgLun.getSLDEV();
                    SJmoLdevIndex ldevidx = new SJmoLdevIndex();
                    ldevidx.setLdevIndex(ldkc, cu, dev);
                    int searchRet = Collections.binarySearch(ldevDetailList, ldevidx);
                    if (searchRet < 0) {
                        SJctrLogUty.info(this.getClass().getSimpleName(), "checkHostModeIsUVM", "Ldev Not Found. Ldkc = " + ldkc + ", Cu = " + cu + ", Dev = " + dev);
                        continue;
                    }
                    SJmoLdevDetail ldevDetail = (SJmoLdevDetail)ldevDetailList.get(searchRet);
                    if (SJctrLdevUtility.isATypeVolume(ldevDetail)) continue;
                    ret = false;
                    SJctrError errElement = errList.get(index);
                    errElement.setFunc(10);
                    errElement.setModule(22);
                    errElement.setError(EDITHG_ERR12);
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "checkHostModeIsUVM", "Connected Vol Found. at Port-HG IndexKey = " + onePtHgKey.toString() + ", LDEV IndexKey = " + ldevidx.toString());
                    continue block0;
                }
            }
        }
        return ret;
    }

    private ArrayList<SJmoPortLunDetail> getConnectLUPath(SJctrPortHostGroupTableKey onePtHgKey) {
        ArrayList alHtgLun;
        List<?> ptLunList = this.getCache(KEY_CLASS_MPORTLUN);
        if (ptLunList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getConnectLUPath", "SJmoGetPortLunInfo Not Found in the Cache.");
            return new ArrayList<SJmoPortLunDetail>();
        }
        int searchRet = Collections.binarySearch(ptLunList, onePtHgKey.getPortHostGroupInfo());
        if (searchRet < 0) {
            alHtgLun = new ArrayList();
        } else {
            short iHtgId = onePtHgKey.getHostGroupInfo().getSHostGroup();
            SJmoPortLunInfo lunInfo = (SJmoPortLunInfo)ptLunList.get(searchRet);
            alHtgLun = lunInfo.getAlHostGroupLun(iHtgId);
        }
        return alHtgLun;
    }

    private SJctrEditHGApplyParam createApplyData() {
        SJctrEditHGApplyParam applyParam = new SJctrEditHGApplyParam();
        SJctrCheckBoxDataModel chkHg = this.getHGCheckBoxModel();
        applyParam.setChgHGNameFlg(chkHg.isSelect());
        SJctrTextBoxDataModel textData = this.getHGTextBoxModel();
        String newNickName = new String(textData.getValue());
        applyParam.setStrHostgroupNickName(newNickName);
        SJctrCheckBoxDataModel chkHostMode = this.getHostModeCheckBoxModel();
        applyParam.setChgHostModeFlg(chkHostMode.isSelect());
        SJctrHostModeComboModel comboData = this.getHostModeComboBoxModel();
        applyParam.setByHostMode(comboData.getSelectedHostModeValue());
        SJctrHostModeOptTableModel optTbl = this.getHostModeOptTableModel();
        BitSet newBtOption = (BitSet)optTbl.getBtOption().clone();
        applyParam.setBtOption(newBtOption);
        SJctrEditHGApplyParam realCacheApplyParam = this.setApplyParamToCache(applyParam);
        return realCacheApplyParam;
    }

    private SJctrEditHGApplyParam setApplyParamToCache(SJctrEditHGApplyParam applyParam) {
        SJctrEditHGApplyParam prevApplyParam;
        boolean equalFlag;
        List<?> prevCache = this.getCache(KEY_CLASS_APPLY_PARAM);
        if (prevCache != null && prevCache.size() != 0 && (equalFlag = this.isEqualApplyParam(applyParam, prevApplyParam = (SJctrEditHGApplyParam)prevCache.get(0)))) {
            return prevApplyParam;
        }
        ArrayList<SJctrEditHGApplyParam> cacheList = new ArrayList<SJctrEditHGApplyParam>();
        cacheList.add(applyParam);
        this.putCache(KEY_CLASS_APPLY_PARAM, cacheList);
        return applyParam;
    }

    private boolean isEqualApplyParam(SJctrEditHGApplyParam applyParam, SJctrEditHGApplyParam prevApplyParam) {
        boolean equalFlag = true;
        if (prevApplyParam.getChgHGNameFlg() | applyParam.getChgHGNameFlg()) {
            if (prevApplyParam.getChgHGNameFlg() != applyParam.getChgHGNameFlg()) {
                equalFlag = false;
            } else if (!prevApplyParam.getStrHostgroupNickName().equals(applyParam.getStrHostgroupNickName())) {
                equalFlag = false;
            }
        }
        if (prevApplyParam.getChgHostModeFlg() | applyParam.getChgHostModeFlg()) {
            if (prevApplyParam.getChgHostModeFlg() != applyParam.getChgHostModeFlg()) {
                equalFlag = false;
            } else if (prevApplyParam.getByHostMode() != applyParam.getByHostMode() || !prevApplyParam.getBtOption().equals(applyParam.getBtOption())) {
                equalFlag = false;
            }
        }
        return equalFlag;
    }

    void createConfirmData(List<SJctrPortHostGroupTableKey> targetList, SJctrEditHGApplyParam applyParam) {
        TreeSet<SJmoPortHostGroupInfo> portSet = new TreeSet<SJmoPortHostGroupInfo>();
        for (SJctrPortHostGroupTableKey key : targetList) {
            portSet.add(key.getPortHostGroupInfo());
        }
        ArrayList<SJmoPortIndex> targetPortList = new ArrayList<SJmoPortIndex>(portSet);
        List<SJmoPortAttributeInfo> confirmPortAttrList = this.getConfirmPortAttrInfo(targetPortList);
        List<SJmoPortDetail> confirmPortDetailList = this.getConfirmPortDetail(targetPortList);
        List<SJmoPortHostGroupInfo> confirmPortHgList = this.replaceConfirmPortHgInfo(targetList, applyParam);
        List<SJctrPortHostGroupTableKey> newTargetList = this.replaceConfirmTargetList(targetList, confirmPortHgList);
        SJctrEditHGConfirmData confirmData = new SJctrEditHGConfirmData();
        confirmData.setPortAttributeList(confirmPortAttrList);
        confirmData.setPortDetailList(confirmPortDetailList);
        confirmData.setPortHgList(confirmPortHgList);
        confirmData.setPortHGTableKey(newTargetList);
        confirmData.setAllRsgList(this.getCache(KEY_CLASS_RSG));
        ArrayList<SJctrEditHGConfirmData> confirmDataList = new ArrayList<SJctrEditHGConfirmData>();
        confirmDataList.add(confirmData);
        this.putCache(KEY_CLASS_CONFIRM_DATA, confirmDataList);
    }

    private List<SJmoPortAttributeInfo> getConfirmPortAttrInfo(ArrayList<SJmoPortIndex> targetPortList) {
        ArrayList<SJmoPortAttributeInfo> confirmPortAttrList = new ArrayList<SJmoPortAttributeInfo>();
        List<?> portAttributeList = this.getCache(KEY_CLASS_MPORTATTR);
        for (SJmoPortIndex portIndex : targetPortList) {
            int searchResult = Collections.binarySearch(portAttributeList, portIndex);
            if (searchResult < 0) {
                this.getLogUty().putlog("getConfirmPortAttrInfo", "SJmoPortAttributeInfo not found.", null, 30000);
                continue;
            }
            SJmoPortAttributeInfo portAttribute = (SJmoPortAttributeInfo)portAttributeList.get(searchResult);
            confirmPortAttrList.add(portAttribute);
        }
        return confirmPortAttrList;
    }

    private List<SJmoPortDetail> getConfirmPortDetail(ArrayList<SJmoPortIndex> targetPortList) {
        List<?> portDetailList = this.getCache(KEY_CLASS_MPORTDETL);
        ArrayList<SJmoPortDetail> confirmPortDetailList = new ArrayList<SJmoPortDetail>();
        for (SJmoPortIndex portIndex : targetPortList) {
            int searchResult = Collections.binarySearch(portDetailList, portIndex);
            if (searchResult < 0) {
                this.getLogUty().putlog("getConfirmPortDetail", "SJmoPortDetail not found.", null, 30000);
                continue;
            }
            SJmoPortDetail portDetail = (SJmoPortDetail)portDetailList.get(searchResult);
            confirmPortDetailList.add(portDetail);
        }
        return confirmPortDetailList;
    }

    private List<SJmoPortHostGroupInfo> replaceConfirmPortHgInfo(List<SJctrPortHostGroupTableKey> targetList, SJctrEditHGApplyParam applyParam) {
        List<?> portHgList = this.getCache(KEY_CLASS_MPORTHG);
        ArrayList<SJmoPortHostGroupInfo> confirmPortHgList = new ArrayList<SJmoPortHostGroupInfo>();
        for (SJctrPortHostGroupTableKey ptHgKey : targetList) {
            int searchResult = Collections.binarySearch(portHgList, ptHgKey.getPortHostGroupInfo());
            if (searchResult < 0) {
                this.getLogUty().putlog("replaceConfirmPortHgInfo", "SJmoPortHostGroupInfo not found.", null, 30000);
                continue;
            }
            SJmoPortHostGroupInfo portHg = (SJmoPortHostGroupInfo)portHgList.get(searchResult);
            SJmoPortHostGroupInfo createPortHg = null;
            int copyedIndex = Collections.binarySearch(confirmPortHgList, ptHgKey.getPortHostGroupInfo());
            createPortHg = copyedIndex < 0 ? this.createNewPortHgInfo(portHg) : (SJmoPortHostGroupInfo)confirmPortHgList.get(copyedIndex);
            ArrayList hgArray = createPortHg.getAlPortHostGroup();
            SJmoHostGroupInfo createTargetHg = null;
            for (SJmoHostGroupInfo oneModelHg : hgArray) {
                if (oneModelHg.getSHostGroup() != ptHgKey.getHostGroupInfo().getSHostGroup()) continue;
                createTargetHg = oneModelHg;
                break;
            }
            if (createTargetHg == null) {
                this.getLogUty().putlog("replaceConfirmPortHgInfo", "SJmoHostGroupInfo not found.", null, 30000);
                continue;
            }
            if (applyParam.getChgHGNameFlg()) {
                createTargetHg.setStrHostgroupNickName(applyParam.getStrHostgroupNickName());
            }
            if (applyParam.getChgHostModeFlg()) {
                if (applyParam.getByHostMode() != -1) {
                    createTargetHg.setByHostMode(applyParam.getByHostMode());
                }
                createTargetHg.setBtOption(applyParam.getBtOption());
            }
            if (copyedIndex >= 0) continue;
            confirmPortHgList.add(createPortHg);
        }
        Collections.sort(confirmPortHgList);
        return confirmPortHgList;
    }

    private SJmoPortHostGroupInfo createNewPortHgInfo(SJmoPortHostGroupInfo portHg) {
        SJmoPortHostGroupInfo createPortHg = null;
        createPortHg = new SJmoPortHostGroupInfo();
        createPortHg.setSPort(portHg.getSPort());
        ArrayList<SJmoHostGroupInfo> alPortHostGroup = new ArrayList<SJmoHostGroupInfo>();
        for (Object hgObj : portHg.getAlPortHostGroup()) {
            SJmoHostGroupInfo hg = (SJmoHostGroupInfo)hgObj;
            SJmoHostGroupInfo createHg = new SJmoHostGroupInfo();
            createHg.setSPort(hg.getSPort());
            createHg.setSHostGroup(hg.getSHostGroup());
            createHg.setStrHostgroupNickName(hg.getStrHostgroupNickName());
            createHg.setByHostMode(hg.getByHostMode());
            createHg.setStrHostModeDisplayName(hg.getStrHostModeDisplayName());
            createHg.setBtOption(hg.getBtOption());
            createHg.setAlHostGroupWwn(hg.getAlHostGroupWwn());
            alPortHostGroup.add(createHg);
        }
        createPortHg.setAlPortHostGroup(alPortHostGroup);
        return createPortHg;
    }

    private List<SJctrPortHostGroupTableKey> replaceConfirmTargetList(List<SJctrPortHostGroupTableKey> targetList, List<SJmoPortHostGroupInfo> confirmPortHgList) {
        ArrayList<SJctrPortHostGroupTableKey> retList = new ArrayList<SJctrPortHostGroupTableKey>(targetList.size());
        for (SJctrPortHostGroupTableKey oldKey : targetList) {
            int searchResult = Collections.binarySearch(confirmPortHgList, oldKey.getPortHostGroupInfo());
            if (searchResult < 0) {
                this.getLogUty().putlog("replaceConfirmTargetList", "SJmoHostGroupInfo(For CONFIRM) not found.", null, 30000);
                retList.add(oldKey);
                continue;
            }
            SJmoPortHostGroupInfo newPtHg = confirmPortHgList.get(searchResult);
            boolean findHgFlg = false;
            for (Object hgObj : newPtHg.getAlPortHostGroup()) {
                SJmoHostGroupInfo newHg = (SJmoHostGroupInfo)hgObj;
                if (oldKey.getHostGroupInfo().getSHostGroup() != newHg.getSHostGroup()) continue;
                retList.add(new SJctrPortHostGroupTableKey(newPtHg, newHg));
                findHgFlg = true;
                break;
            }
            if (findHgFlg) continue;
            retList.add(new SJctrPortHostGroupTableKey(newPtHg, oldKey.getHostGroupInfo()));
            this.getLogUty().putlog("replaceConfirmTargetList", "HG# miss. Port#=" + oldKey.getPortHostGroupInfo().getSPort() + " HG# =" + oldKey.getHostGroupInfo().getSHostGroup(), null, 30000);
        }
        return retList;
    }

    private SJctrCheckBoxDataModel getHGCheckBoxModel() {
        SJctrHGArea hgArea = (SJctrHGArea)this.getDataObjectModel(KEY_HOSTGROUPINF);
        SJctrCheckBoxDataModel chkHg = (SJctrCheckBoxDataModel)hgArea.getDataModel("COM_CHECKBOX");
        return chkHg;
    }

    private SJctrTextBoxDataModel getHGTextBoxModel() {
        SJctrHGArea hgArea = (SJctrHGArea)this.getDataObjectModel(KEY_HOSTGROUPINF);
        SJctrTextBoxDataModel textData = (SJctrTextBoxDataModel)hgArea.getDataModel("COM_HOSTGROUPNAME");
        return textData;
    }

    private SJctrCheckBoxDataModel getHostModeCheckBoxModel() {
        SJctrHostModeArea hostModeArea = (SJctrHostModeArea)this.getDataObjectModel(KEY_HOSTMODEINF);
        SJctrCheckBoxDataModel chkHostMode = (SJctrCheckBoxDataModel)hostModeArea.getDataModel("COM_CHECKBOX");
        return chkHostMode;
    }

    private SJctrHostModeComboModel getHostModeComboBoxModel() {
        SJctrHostModeArea hostModeArea = (SJctrHostModeArea)this.getDataObjectModel(KEY_HOSTMODEINF);
        SJctrHostModeComboModel comboData = (SJctrHostModeComboModel)hostModeArea.getDataModel("COM_HOSTMODE");
        return comboData;
    }

    private SJctrHostModeOptTableModel getHostModeOptTableModel() {
        SJctrHostModeArea hostModeArea = (SJctrHostModeArea)this.getDataObjectModel(KEY_HOSTMODEINF);
        SJctrHostModeOptTableModel optTbl = (SJctrHostModeOptTableModel)hostModeArea.getDataModel("COM_TABLE_OPTION");
        return optTbl;
    }
}

