/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.edithgs;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sanproject.common.Robj_interface_DKCgetSystemOption;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.topwindow.base.SJctrGetSystemOption;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.lunm.edithgs.SJctrHostModeOptTableModel;
import sanproject.sn2.model.data.SJmoThroughRmiData;

public class SJctrHostModeComboModel
extends SJctrComboBoxDataModel {
    public static final byte HOST_MODE_EMPTY = -1;
    private static final String HOST_MODE_PTN = "[0-9A-F]+ \\[Reserve\\]";

    public SJctrHostModeComboModel() {
        this.initListener();
    }

    private void initListener() {
        this.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrHostModeComboModel.this.fireMessageEvent(SJctrHostModeOptTableModel.NOTIFY_HMO_TBL.CHANGE_COMBO_BOX, SJctrHostModeComboModel.this.getSelectedHostModeValue());
                }
            }
        });
    }

    public final void initItemList(SJctrPortUtility portUtil) {
        boolean sysoptflg = this.getSystemOption();
        Pattern pattern = Pattern.compile(HOST_MODE_PTN);
        for (byte byHostMode = 0; byHostMode < 80; byHostMode = (byte)(byHostMode + 1)) {
            String str = portUtil.toHostModeDisplay(byHostMode);
            if (!sysoptflg) {
                Matcher matcher = pattern.matcher(str);
                boolean bMatch = matcher.matches();
                if (bMatch) continue;
                this.addItem(Byte.toString(byHostMode), str);
                continue;
            }
            this.addItem(Byte.toString(byHostMode), str);
        }
        this.setSelectedIndex(0);
    }

    public final void initItemListWithSelect(SJctrPortUtility portUtil, Byte selectHostMode) {
        boolean sysoptflg = this.getSystemOption();
        Pattern pattern = Pattern.compile(HOST_MODE_PTN);
        for (byte byHostMode = 0; byHostMode < 80; byHostMode = (byte)(byHostMode + 1)) {
            String str = portUtil.toHostModeDisplay(byHostMode);
            if (!sysoptflg) {
                Matcher matcher = pattern.matcher(str);
                boolean bMatch = matcher.matches();
                if (bMatch && byHostMode != selectHostMode) continue;
                this.addItem(Byte.toString(byHostMode), str);
                continue;
            }
            this.addItem(Byte.toString(byHostMode), str);
        }
        this.setSelectedIndex(0);
    }

    private boolean getSystemOption() {
        SJctrWizardDataController dc = (SJctrWizardDataController)this.getDataController();
        List<?> optList = dc.getCache(SJctrGetSystemOption.class);
        boolean sysoptflg = false;
        if (optList != null && optList.size() > 0) {
            Robj_interface_DKCgetSystemOption[] sysOptList;
            SJmoThroughRmiData rmiData = (SJmoThroughRmiData)optList.get(0);
            for (Robj_interface_DKCgetSystemOption sysopt : sysOptList = (Robj_interface_DKCgetSystemOption[])rmiData.getObjRmi()) {
                int clpr = sysopt.getNCLPR();
                if (clpr != -1) continue;
                sysoptflg = sysopt.isEnable(847);
            }
        }
        return sysoptflg;
    }

    public final void initItemListWithEmpty(SJctrPortUtility portUtil) {
        this.addItem(Byte.toString((byte)-1), "");
        this.initItemList(portUtil);
    }

    public byte getSelectedHostModeValue() {
        String str = this.getSelection();
        byte hostMode = Byte.valueOf(str);
        return hostMode;
    }
}

