/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.editportsiscsi;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.wizard.lunm.editportsiscsi.SJctrEditIscsiPortsData;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrIscsiOperationError;
import sanproject.sn2.datasupplier.SJdsSupplierAgent;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.inf.SJmoKeyValueDefine_IF;

public class SJctrEditIscsiPortsPortAC
extends SJctrApplyController
implements SJmoKeyValueDefine_IF {
    private static final int PORT_TIME = 6;
    private List<SJmoPortDetail> mPortDetailList = null;
    private HashSet<SJctrEditIscsiPortsData.CHECKBOX_ITEM> mCheckBoxSet;
    private List<SJmoPortDetail> beforePortDetailList = null;
    List<SJctrError> resultData = null;
    SanResponse result = null;
    private Map<String, SJctrIscsiOperationError> errorMap = new TreeMap<String, SJctrIscsiOperationError>();
    private SJctrError representativeError = null;

    @Override
    public int getLeadTime() {
        ArrayList<?> applylist = this.getSetList();
        int leadtime = 6 * applylist.size();
        return leadtime;
    }

    public void setApplyList(List<SJmoPortDetail> portDetailList, List<SJmoPortDetail> beforePortDetailList, HashSet<SJctrEditIscsiPortsData.CHECKBOX_ITEM> checkBoxSet) {
        this.mPortDetailList = portDetailList;
        this.beforePortDetailList = beforePortDetailList;
        this.mCheckBoxSet = checkBoxSet;
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList applyList = new ArrayList(1);
        return applyList;
    }

    @Override
    protected void applyStart(SJdsSupplierAgent supplier) {
        if (supplier == null) {
            SJctrLogUty.info(this.title, "applyStart", "SJdsSupplierAgent is null.");
            throw new NullPointerException();
        }
        try {
            SanRequest requestData = supplier.newRequest("iSCSIupdatePortInfo");
            SanList reqPortList = requestData.newList("iScsiPorts");
            if (this.mPortDetailList == null) {
                SJctrLogUty.error("SJctrEditIscsiPortIsnsAC", "applyStart", "Parameter is invalid.");
                return;
            }
            for (SJmoPortDetail portDetail : this.mPortDetailList) {
                int indexPort;
                SanObject portsParam = reqPortList.addObj();
                portsParam.putInt("Id", (int)portDetail.getSPort());
                if (this.mCheckBoxSet.contains((Object)SJctrEditIscsiPortsData.CHECKBOX_ITEM.IPV4_ADDR) || this.mCheckBoxSet.contains((Object)SJctrEditIscsiPortsData.CHECKBOX_ITEM.IPV4_GATEWAY) || this.mCheckBoxSet.contains((Object)SJctrEditIscsiPortsData.CHECKBOX_ITEM.IPV4_SUBNET)) {
                    SanObject portsIpv4 = portsParam.newObj("Ipv4");
                    if (this.mCheckBoxSet.contains((Object)SJctrEditIscsiPortsData.CHECKBOX_ITEM.IPV4_ADDR)) {
                        portsIpv4.putIntArray("IpAddress", portDetail.getIV4IPAddress());
                        SJctrLogUty.info(this.title, "applyStart", "IPv4 IP : " + portDetail.getIV4IPAddress());
                    }
                    if (this.mCheckBoxSet.contains((Object)SJctrEditIscsiPortsData.CHECKBOX_ITEM.IPV4_GATEWAY)) {
                        portsIpv4.putIntArray("DefaultGateway", portDetail.getIV4GateWayAddress());
                        SJctrLogUty.info(this.title, "applyStart", "IPv4 GateWay : " + portDetail.getIV4GateWayAddress());
                    }
                    if (this.mCheckBoxSet.contains((Object)SJctrEditIscsiPortsData.CHECKBOX_ITEM.IPV4_SUBNET)) {
                        portsIpv4.putIntArray("SubNetMask", portDetail.getIV4NetMaskAddress());
                        SJctrLogUty.info(this.title, "applyStart", "IPv4 SubnetMask : " + portDetail.getIV4NetMaskAddress());
                    }
                }
                if (this.mCheckBoxSet.contains((Object)SJctrEditIscsiPortsData.CHECKBOX_ITEM.IPV6_MODE) || this.mCheckBoxSet.contains((Object)SJctrEditIscsiPortsData.CHECKBOX_ITEM.IPV6_LOCAL_ADDR) || this.mCheckBoxSet.contains((Object)SJctrEditIscsiPortsData.CHECKBOX_ITEM.IPV6_GLOVAL_ADDR) || this.mCheckBoxSet.contains((Object)SJctrEditIscsiPortsData.CHECKBOX_ITEM.IPV6_GATEWAY_ADDR)) {
                    SanObject portsIpv6 = portsParam.newObj("Ipv6");
                    boolean ipv6Mode = portDetail.getBV6Mode();
                    if (this.mCheckBoxSet.contains((Object)SJctrEditIscsiPortsData.CHECKBOX_ITEM.IPV6_MODE)) {
                        portsIpv6.putBoolean("Available", ipv6Mode);
                        SJctrLogUty.info(this.title, "applyStart", "IPv6 Mode : " + ipv6Mode);
                    }
                    if (ipv6Mode) {
                        boolean ipv6GlobalAuto;
                        if (this.mCheckBoxSet.contains((Object)SJctrEditIscsiPortsData.CHECKBOX_ITEM.IPV6_LOCAL_ADDR)) {
                            SanObject portsIpv6Link = portsIpv6.newObj("LinkLocalAddress");
                            boolean ipv6LinkAuto = portDetail.getBV6LinkAddressMode();
                            portsIpv6Link.putBoolean("AutoMode", ipv6LinkAuto);
                            SJctrLogUty.info(this.title, "applyStart", "IPv6 LinkLocal Auto : " + ipv6LinkAuto);
                            if (!ipv6LinkAuto) {
                                portsIpv6Link.putIntArray("ManualAddress", portDetail.getIV6LinkAddressManual());
                                SJctrLogUty.info(this.title, "applyStart", "IPv6 LinkLocal : " + SJctrPortUtility.toDispIPv6(portDetail.getIV6LinkAddressManual()));
                            }
                        }
                        if (this.mCheckBoxSet.contains((Object)SJctrEditIscsiPortsData.CHECKBOX_ITEM.IPV6_GLOVAL_ADDR)) {
                            SanObject portsIpv6Global = portsIpv6.newObj("GlobalAddress");
                            ipv6GlobalAuto = portDetail.getBV6GlobalAddressMode();
                            portsIpv6Global.putBoolean("AutoMode", ipv6GlobalAuto);
                            SJctrLogUty.info(this.title, "applyStart", "IPv6 Global Auto : " + ipv6GlobalAuto);
                            if (!ipv6GlobalAuto && this.mCheckBoxSet.contains((Object)SJctrEditIscsiPortsData.CHECKBOX_ITEM.IPV6_GLOVAL_ADDR1)) {
                                portsIpv6Global.putIntArray("ManualAddress", portDetail.getIV6GlobalAddressManual());
                                SJctrLogUty.info(this.title, "applyStart", "IPv6 Grobal 1 : " + SJctrPortUtility.toDispIPv6(portDetail.getIV6GlobalAddressManual()));
                            }
                        }
                        if (this.mCheckBoxSet.contains((Object)SJctrEditIscsiPortsData.CHECKBOX_ITEM.IPV6_GLOVAL_ADDR) && this.mCheckBoxSet.contains((Object)SJctrEditIscsiPortsData.CHECKBOX_ITEM.IPV6_GLOVAL_ADDR2)) {
                            SanObject portsIpv6Global2 = portsIpv6.newObj("GlobalAddress2");
                            ipv6GlobalAuto = portDetail.getBV6GlobalAddressMode();
                            if (!ipv6GlobalAuto) {
                                portsIpv6Global2.putIntArray("ManualAddress", portDetail.getIV6GlobalAddress2Manual());
                                SJctrLogUty.info(this.title, "applyStart", "IPv6 Grobal 2 : " + SJctrPortUtility.toDispIPv6(portDetail.getIV6GlobalAddress2Manual()));
                            }
                        }
                        if (this.mCheckBoxSet.contains((Object)SJctrEditIscsiPortsData.CHECKBOX_ITEM.IPV6_GATEWAY_ADDR)) {
                            SanObject portsIpv6Gateway = portsIpv6.newObj("DefaultGateway");
                            portsIpv6Gateway.putIntArray("AssignedAddress", portDetail.getIV6GateWayAddress());
                            SJctrLogUty.info(this.title, "applyStart", "IPv6 DefaultGateWay : " + SJctrPortUtility.toDispIPv6(portDetail.getIV6GateWayAddress()));
                        }
                    }
                }
                if (this.mCheckBoxSet.contains((Object)SJctrEditIscsiPortsData.CHECKBOX_ITEM.TCP_PORT_NUM)) {
                    portsParam.putInt("TcpPortNumber", portDetail.getITcpPortNumber());
                    SJctrLogUty.info(this.title, "applyStart", "TCP Port Num : " + portDetail.getITcpPortNumber());
                }
                if (this.mCheckBoxSet.contains((Object)SJctrEditIscsiPortsData.CHECKBOX_ITEM.SEL_ACK)) {
                    portsParam.putBoolean("AvailableSelectiveAck", portDetail.getBAvailableSelectiveACK());
                    SJctrLogUty.info(this.title, "applyStart", "Selective ACK : " + portDetail.getBAvailableSelectiveACK());
                }
                if (this.mCheckBoxSet.contains((Object)SJctrEditIscsiPortsData.CHECKBOX_ITEM.DEL_ACK)) {
                    portsParam.putBoolean("AvailableDelayedAck", portDetail.getBAvailableDelayedACK());
                    SJctrLogUty.info(this.title, "applyStart", "Delayed ACK : " + portDetail.getBAvailableDelayedACK());
                }
                if (this.mCheckBoxSet.contains((Object)SJctrEditIscsiPortsData.CHECKBOX_ITEM.MAX_WIN_SIZE)) {
                    portsParam.putInt("TcpWindowSize", portDetail.getITcpWindowSize());
                    SJctrLogUty.info(this.title, "applyStart", "WinSize : " + portDetail.getITcpWindowSize());
                }
                if (this.mCheckBoxSet.contains((Object)SJctrEditIscsiPortsData.CHECKBOX_ITEM.MTU_SIZE)) {
                    SanObject portsMtu = portsParam.newObj("EthernetMtuSize");
                    portsMtu.putInt("Mtu", portDetail.getIMtuSize());
                    SJctrLogUty.info(this.title, "applyStart", "MTU : " + portDetail.getIMtuSize());
                }
                if (this.mCheckBoxSet.contains((Object)SJctrEditIscsiPortsData.CHECKBOX_ITEM.KEEP_ALIVE_TIMER)) {
                    portsParam.putInt("KeepAliveTimer", portDetail.getiKeepAliveTimer());
                    SJctrLogUty.info(this.title, "applyStart", "KeepAliveTimer:" + portDetail.getiKeepAliveTimer());
                }
                if (!this.mCheckBoxSet.contains((Object)SJctrEditIscsiPortsData.CHECKBOX_ITEM.VLAN)) continue;
                SanObject portsVlan = portsParam.newObj("Vlan");
                boolean vlanTagging = portDetail.getBAvailableVlanTagging();
                portsVlan.putBoolean("AvailableTagging", vlanTagging);
                SJctrLogUty.info(this.title, "applyStart", "Vlan Tagging : " + vlanTagging);
                if (!vlanTagging || (indexPort = Collections.binarySearch(this.beforePortDetailList, portDetail)) <= -1) continue;
                SJmoPortDetail beforePortDetail = this.beforePortDetailList.get(indexPort);
                int beforeVlanId = beforePortDetail.getIVlanId();
                if (beforeVlanId == 0) {
                    portsVlan.putInt("AdditionId", portDetail.getIVlanId());
                } else {
                    portsVlan.putInt("RemovalId", beforeVlanId);
                    portsVlan.putInt("AdditionId", portDetail.getIVlanId());
                }
                SJctrLogUty.info(this.title, "applyStart", "VlanID : " + portDetail.getIVlanId());
            }
            ArrayList<SanRequest> applyList = new ArrayList<SanRequest>(1);
            applyList.add(requestData);
            SJctrLogUty.info(this.title, "applyStart", "Apply Start!! (iSCSIupdatePortInfo)");
            Object resultObject = supplier.applyStart(this.getLockId(), applyList);
            SJctrLogUty.info(this.title, "applyStart", "Apply End!! (iSCSIupdatePortInfo)");
            this.getMapPortError(resultObject);
            this.setApplyResult();
        }
        catch (SanDataException e) {
            SJctrLogUty.info(this.title, "applyStart", "exception", e);
            SJctrError error = SJctrError.parseError((Exception)((Object)e));
            this.setError(error);
        }
    }

    @Override
    protected List<SJctrError> getResultData() {
        return this.resultData;
    }

    private void getMapPortError(Object resultObject) throws SanDataException {
        SanObject repErrorInfo;
        int[] errMsgId;
        if (!(resultObject instanceof SanResponse)) {
            SJcException error = SJctrIscsiUtility.makeException(107001);
            throw error;
        }
        SanResponse responseData = (SanResponse)resultObject;
        if (this.representativeError == null && 0 != (errMsgId = (repErrorInfo = responseData.getObj("ErrorInfo")).getIntArray("MessageId"))[1]) {
            this.representativeError = new SJctrIscsiOperationError(errMsgId);
        }
        SanList iScsiPortList = responseData.getList("iScsiPorts");
        SJmoPortIndex portIndex = new SJmoPortIndex();
        for (SanObject iScsiPort : iScsiPortList) {
            SanObject errInfo = iScsiPort.getObj("ErrorInfo");
            int[] errMsgId2 = errInfo.getIntArray("MessageId");
            portIndex.setSPort((short)iScsiPort.getInt("Id"));
            String strPort = portIndex.toString();
            if (this.errorMap.containsKey(strPort)) continue;
            if (0 != errMsgId2[1]) {
                SJctrLogUty.info(this.title, "getMapPortErrorInfo", "Port : " + strPort + ", Error : " + errMsgId2);
            }
            SJctrIscsiOperationError iscsiError = new SJctrIscsiOperationError(errMsgId2);
            this.errorMap.put(strPort, iscsiError);
        }
    }

    protected void setApplyResult() {
        super.setApplyResult(null);
        if (this.representativeError != null) {
            this.setError(this.representativeError);
        } else {
            this.setError(SJctrIscsiUtility.makeError(0));
        }
        if (this.errorMap.size() > 0) {
            this.resultData = new ArrayList<SJctrError>(this.mPortDetailList.size());
            for (SJmoPortIndex sJmoPortIndex : this.mPortDetailList) {
                SJctrError error = this.errorMap.get(sJmoPortIndex.toString());
                this.resultData.add(error);
            }
        }
    }

    @Override
    public boolean hasApplyResult() {
        boolean rtn = false;
        if (this.resultData != null && this.resultData.size() > 0) {
            rtn = true;
        }
        return rtn;
    }
}

