/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.iscsi.deleteiscsitargets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.comparator.SJctrIscsiTargetAliasComparator;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.lunm.iscsi.deleteiscsitargets.SJctrDeleteIscsiTargetsAC;
import sanproject.sn2.controller.wizard.lunm.iscsi.deleteiscsitargets.SJctrDeleteIscsiTargetsConfirmDC;
import sanproject.sn2.controller.wizard.lunm.iscsi.deleteiscsitargets.SJctrDeleteIscsiTargetsConfirmData;
import sanproject.sn2.controller.wizard.lunm.iscsi.deleteiscsitargets.SJctrDeleteIscsiTargetsConfirmTableDataModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevGuardInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoLdevGuardInfo;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrDeleteIscsiTargetsSubWizard
extends SJctrSubWizard {
    private static final String TITLE = "DELETE_ISCSI_TARGETS";
    private static final Class<?> CONFIRM_DC = SJctrDeleteIscsiTargetsConfirmDC.class;

    @Override
    public Class<?>[] getClassList() {
        Class[] Class2 = new Class[]{};
        return Class2;
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        SJctrGuidance guidance = new SJctrGuidance("COMMON", TITLE);
        return guidance;
    }

    @Override
    public Class<?> getConfirmClass() {
        return CONFIRM_DC;
    }

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        try {
            SJctrErrorColumnData errData;
            SJctrError err;
            ArrayList pathDtlList;
            SJmoPortLunInfo portLunInfo;
            SJctrUserController uc = wizard.getOwner();
            SJctrRelatedDispDataObject related = uc.getRelatedDispData(CONFIRM_DC);
            SJctrDeleteIscsiTargetsAC applyCntl = new SJctrDeleteIscsiTargetsAC();
            SJctrRelatedDispDataObject wizardWindowRelateDisp = uc.getRelatedDispData(SJctrWizardWindowDC.class);
            SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(wizardWindowRelateDisp);
            List<SJmoIscsiTargetInfo> deleteIscsiTargetsList = dc.getProxy().getCache("KEY_SELECTED_ISCSI_TARGETS");
            if (null == deleteIscsiTargetsList) {
                dc.getLogUty().putlog("constructConfirmData", "Inherited data list is null.");
                SJctrError err2 = new SJctrError(12, 22, 107001);
                SJcException exp = err2.createException();
                throw exp;
            }
            if (0 == deleteIscsiTargetsList.size()) {
                dc.getLogUty().putlog("constructConfirmData", "Size of inherited data list is zero.");
                SJctrError err3 = new SJctrError(12, 22, 107001);
                SJcException exp = err3.createException();
                throw exp;
            }
            List<SJmoPortIscsiTargetInfo> portTargetInfoList = SJctrIscsiUtility.getSJmoPortIscsiTargetInfoList(dc);
            ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>(deleteIscsiTargetsList.size());
            SJctrError errInfo = null;
            List<SJmoRSGgetAllRsgs> rsgDetailList = SJctrIscsiUtility.getSJmoRSGgetAllRsgsList(dc);
            SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(dc.getOwner(), rsgDetailList.get(0));
            List<SJmoLdevGuardInfo> ldevGDList = SJctrIscsiUtility.getSJmoLdevGuardInfo(dc);
            List<SJmoPortLunInfo> portLunList = SJctrIscsiUtility.getSJmoPortLunInfo(dc);
            SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
            SJmoPortIndex portIndex = new SJmoPortIndex();
            block2: for (SJmoIscsiTargetInfo info : deleteIscsiTargetsList) {
                portIndex.setSPort(info.getSPort());
                int index = Collections.binarySearch(portLunList, portIndex);
                if (index < 0) continue;
                portLunInfo = portLunList.get(index);
                pathDtlList = portLunInfo.getAlHostGroupLun(info.getSIscsiTarget());
                for (SJmoPortLunDetail pathDtl : pathDtlList) {
                    ldevIndex.setLdevIndex(pathDtl.getSLDKC(), pathDtl.getSCU(), pathDtl.getSLDEV());
                    int rsgId = rsgUtil.getRsgId(ldevIndex);
                    boolean rsgLdevFlg = SJctrPortUtility.chkResourceGroup(rsgId, rsgUtil);
                    if (rsgLdevFlg) continue;
                    dc.getLogUty().putlog("constructConfirmData", "Extract Impossible LDev RSG ID =." + rsgId);
                    err = new SJctrError(12, 22, 206227);
                    errData = new SJctrErrorColumnData(info, err);
                    errList.add(errData);
                    if (errInfo != null) continue block2;
                    errInfo = err;
                    continue block2;
                }
            }
            if (errList.size() == 0) {
                for (SJmoIscsiTargetInfo info : deleteIscsiTargetsList) {
                    SJmoIscsiTargetInfo chkIscsiTarget = SJctrIscsiUtility.getIscsiTargetInfoByIndex(portTargetInfoList, (SJmoIscsiTargetIndex)info);
                    if (chkIscsiTarget != null) continue;
                    dc.getLogUty().putlog("constructConfirmData", "iSCSI Target list is null.");
                    SJctrError err4 = new SJctrError(12, 22, 206513);
                    SJctrErrorColumnData errData2 = new SJctrErrorColumnData(info, err4);
                    errList.add(errData2);
                    if (errInfo != null) continue;
                    errInfo = err4;
                }
            }
            if (errList.size() == 0) {
                block5: for (SJmoIscsiTargetInfo info : deleteIscsiTargetsList) {
                    portIndex.setSPort(info.getSPort());
                    int index = Collections.binarySearch(portLunList, portIndex);
                    if (index < 0) continue;
                    portLunInfo = portLunList.get(index);
                    pathDtlList = portLunInfo.getAlHostGroupLun(info.getSIscsiTarget());
                    for (SJmoPortLunDetail pathDtl : pathDtlList) {
                        SJmoLdevGuardInfo ldevGDInfo;
                        ldevIndex.setLdevIndex(pathDtl.getSLDKC(), pathDtl.getSCU(), pathDtl.getSLDEV());
                        int guardIndex = Collections.binarySearch(ldevGDList, ldevIndex);
                        if (guardIndex < 0 || ((ldevGDInfo = ldevGDList.get(guardIndex)).getByLdevGuardStatus() & 8) != 8) continue;
                        dc.getLogUty().putlog("constructConfirmData", "The status of LDEV guard is reserved.");
                        err = new SJctrError(12, 22, 206228);
                        errData = new SJctrErrorColumnData(info, err);
                        errList.add(errData);
                        if (errInfo != null) continue block5;
                        errInfo = err;
                        continue block5;
                    }
                }
            }
            SJctrDeleteIscsiTargetsConfirmData confirmData = new SJctrDeleteIscsiTargetsConfirmData();
            Collections.sort(deleteIscsiTargetsList, new SJctrIscsiTargetAliasComparator());
            if (errList.size() > 0) {
                this.createError(confirmData, dc, deleteIscsiTargetsList, errList, errInfo);
            }
            ArrayList<SJctrDeleteIscsiTargetsConfirmData> confirmDataList = new ArrayList<SJctrDeleteIscsiTargetsConfirmData>();
            confirmData.setNeedData(dc);
            confirmData.setIscsiTargetList(deleteIscsiTargetsList);
            confirmDataList.add(confirmData);
            dc.getProxy().putCache(SJctrDeleteIscsiTargetsConfirmData.class, confirmDataList);
            applyCntl.setApplyData(confirmData);
            wizard.addConfirmData(applyCntl, related);
        }
        catch (SJcException exp) {
            throw SJctrIscsiUtility.convIscsiLogicErrorException(exp, 107002);
        }
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        SJmoGetKind_IF kind = new SJmoGetPortDetail();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortAttributeInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortIscsiTargetInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortLunInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevGuardInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void createError(SJctrDeleteIscsiTargetsConfirmData confirmData, SJctrWizardWindowDC dc, List<SJmoIscsiTargetInfo> transInfoList, List<SJctrErrorColumnData> errList, SJctrError errInfo) {
        Collections.sort(transInfoList, new SJctrIscsiTargetAliasComparator());
        SJctrDeleteIscsiTargetsConfirmTableDataModel iscsiTable = new SJctrDeleteIscsiTargetsConfirmTableDataModel();
        iscsiTable.setPaging(false);
        iscsiTable.setDataController(dc);
        iscsiTable.setBasicDataList(transInfoList);
        iscsiTable.initGuidance(this.getComUtility());
        iscsiTable.createModelDirect();
        iscsiTable.divideModelData(dc.getProxy().getModelDataMap());
        iscsiTable.makeDataModel();
        SJctrRelatedDispDataObject rel = dc.createDialog(SJctrErrorDataController.class, null);
        SJctrErrorDataController errDc = (SJctrErrorDataController)dc.getOwner().getDataController(rel);
        errDc.setParameter(iscsiTable, errList);
        SJctrError err = errDc.getRepresentativeError(errList);
        SJcException exp = err.createException();
        exp.setErrDisp(rel);
        throw exp;
    }
}

