/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.loginwwnstatus;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import sanproject.serverux.dataimpl.LUNMgetAllLoginWWNStatus_IN;
import sanproject.serverux.dataimpl.LUNMgetAllLoginWWNStatus_OUT;
import sanproject.serverux.dataimpl.LUNMgetLoginWWNStatus;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.lunm.loginwwnstatus.SJctrGetCurrentLoginWwnStatus;
import sanproject.sn2.controller.wizard.lunm.loginwwnstatus.SJctrLoginWwnTableModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortWwnInfo;
import sanproject.sn2.model.data.SJmoThroughRmiData;
import sanproject.sn2.model.data.device.SJmoPortIndex;

public class SJctrViewLoginWwnStatusDC
extends SJctrDialogDataController {
    private static final int DISP_ID = 34664516;
    private static final String KEY_FOOTER = "COM_FOOTER";
    private static final String KEY_TABLE = "COM_TABLE";
    public static int LOGINWWNST_ERR_CACHE_INVALID_LEVEL4 = 107002;
    public static int LOGINWWNST_ERR_PORT_NOT_EXIST_LEVEL4 = 106533;

    public SJctrViewLoginWwnStatusDC() throws SJcException {
        super(34664516);
        this.initDataModel();
    }

    private void initDataModel() {
        SJctrLoginWwnTableModel tableModel = new SJctrLoginWwnTableModel();
        this.addDataObjectModel(KEY_TABLE, tableModel);
        this.addDataObjectModel(KEY_FOOTER, new SJctrFooterDataModel(SJctrFooterDataModel.BGO_CLOSE));
    }

    @Override
    public boolean checkConstructData() {
        boolean result = true;
        List<?> moPortDetailList = this.getCache(SJmoGetPortDetail.class);
        if (moPortDetailList == null || moPortDetailList.size() == 0) {
            result = false;
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "SJmoPortDetail not found in the Cache.");
            SJctrError err = new SJctrError(10, 22, LOGINWWNST_ERR_CACHE_INVALID_LEVEL4);
            SJcException exp = err.createException();
            throw exp;
        }
        List<?> moPortWwnInfoList = this.getCache(SJmoGetPortWwnInfo.class);
        if (moPortWwnInfoList == null || moPortWwnInfoList.size() == 0) {
            result = false;
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "SJmoPortWwnInfo not found in the Cache.");
            SJctrError err = new SJctrError(10, 22, LOGINWWNST_ERR_CACHE_INVALID_LEVEL4);
            SJcException exp = err.createException();
            throw exp;
        }
        List<LUNMgetLoginWWNStatus> allLoginWwnList = this.getCurrentLoginWwnStatusList();
        if (allLoginWwnList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "Getting Current Login WWN info failed.");
            SJctrError err = new SJctrError(10, 22, LOGINWWNST_ERR_CACHE_INVALID_LEVEL4);
            SJcException exp = err.createException();
            throw exp;
        }
        for (LUNMgetLoginWWNStatus portLoginWwn : allLoginWwnList) {
            SJmoPortIndex portIndex = new SJmoPortIndex();
            portIndex.setSPort(portLoginWwn.getSPort());
            int searchIdx = Collections.binarySearch(moPortWwnInfoList, portIndex);
            if (searchIdx >= 0) continue;
            result = false;
            SJctrError err = new SJctrError(10, 22, LOGINWWNST_ERR_PORT_NOT_EXIST_LEVEL4);
            SJcException exp = err.createException();
            throw exp;
        }
        return result;
    }

    public List<LUNMgetLoginWWNStatus> getCurrentLoginWwnStatusList() {
        ArrayList<LUNMgetLoginWWNStatus> retList = new ArrayList();
        SJmoThroughRmiData rmiObj = null;
        LUNMgetAllLoginWWNStatus_OUT output = null;
        rmiObj = (SJmoThroughRmiData)this.getCache(SJctrGetCurrentLoginWwnStatus.class).get(0);
        output = (LUNMgetAllLoginWWNStatus_OUT)rmiObj.getObjRmi();
        if (output == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getCurrentLoginWWNStatusList", "Getting LUNMgetHostReserved_OUT from RMI failed.");
            return null;
        }
        LUNMgetLoginWWNStatus[] arrLoginWwnStatus = (LUNMgetLoginWWNStatus[])output.getDataObject();
        retList = Arrays.asList(arrLoginWwnStatus);
        return retList;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetPortDetail();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortWwnInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        LUNMgetAllLoginWWNStatus_IN input = new LUNMgetAllLoginWWNStatus_IN();
        SJctrGetCurrentLoginWwnStatus kind2 = new SJctrGetCurrentLoginWwnStatus(input);
        SJmoGetRange_IF range2 = null;
        ArrayList filterList2 = new ArrayList();
        SJmoGetDirect direct2 = new SJmoGetDirect(kind2, range2, filterList2);
        set.add(new SJctrGetDirectWrapper(direct2));
        return set;
    }
}

