/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.monitor.optmon.editwwn;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrCheckBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrTextBoxEvent;
import sanproject.sn2.controller.com.model.event.SJctrTextChangeListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrMonitorPortWWNInfo;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrOptionMonitorGuidance;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrOptionMonitorUtility;
import sanproject.sn2.controller.wizard.monitor.optmon.editwwn.SJctrEditWWNConfirmData;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPPCALLPortWWNInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.lu.SJmoWwn;
import sanproject.sn2.model.data.monitor.SJmoPPCALLPortWWNInfo;

public class SJctrEditWWNDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 17827953;
    private static final String[] DISP_TITLE = SJctrOptionMonitorGuidance.MON_EDIT_WWN;
    private static final String KEY_HBA_WWN_TITLE = "COM_HBA_WWN_TITLE";
    private static final String KEY_HBA_WWN_INF = "COM_HBA_WWN_INF";
    private static final String KEY_WWN_NAME_TITLE = "COM_WWN_NAME_TITLE";
    private static final String KEY_WWN_NAME_INF = "COM_WWN_NAME_INF";
    private static final String KEY_CHECKBOX = "COM_CHECKBOX";

    public SJctrEditWWNDC() throws SJcException {
        super(17827953);
        this.initDataModel();
    }

    @Override
    public String getDispName() {
        String dispName = SJctrOptionMonitorGuidance.getMonitorGuidanceStr(this.getComUtility(), DISP_TITLE);
        return dispName;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetPPCALLPortWWNInfo();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void initDataModel() {
        SJctrSimpleDataModel hbaWwnTitleBox = new SJctrSimpleDataModel();
        this.addDataObjectModel(KEY_HBA_WWN_TITLE, hbaWwnTitleBox);
        final SJctrCheckBoxDataModel hbaWwnCheckBox = new SJctrCheckBoxDataModel();
        hbaWwnCheckBox.setSelect(false);
        hbaWwnTitleBox.addDataModel(KEY_CHECKBOX, hbaWwnCheckBox);
        final SJctrTextBoxDataModel hbaWwnTextBox = new SJctrTextBoxDataModel();
        hbaWwnTextBox.setValue("");
        hbaWwnTextBox.setVisible(true);
        this.addDataObjectModel(KEY_HBA_WWN_INF, hbaWwnTextBox);
        hbaWwnCheckBox.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrEditWWNDC.this.setFinishChangeCheck(true);
                if (hbaWwnCheckBox.isSelect()) {
                    hbaWwnTextBox.setChangeCheck(true);
                } else {
                    hbaWwnTextBox.setChangeCheck(false);
                }
            }
        });
        hbaWwnTextBox.addTextChangeListener(new SJctrTextChangeListener(){

            @Override
            public void textChanged(SJctrTextBoxEvent event) {
                if (hbaWwnCheckBox.isSelect()) {
                    hbaWwnTextBox.setChangeCheck(true);
                } else {
                    hbaWwnTextBox.setChangeCheck(false);
                }
            }
        });
        SJctrSimpleDataModel wwnNameTitleBox = new SJctrSimpleDataModel();
        this.addDataObjectModel(KEY_WWN_NAME_TITLE, wwnNameTitleBox);
        final SJctrCheckBoxDataModel wwnNameCheckBox = new SJctrCheckBoxDataModel();
        wwnNameCheckBox.setSelect(false);
        wwnNameTitleBox.addDataModel(KEY_CHECKBOX, wwnNameCheckBox);
        final SJctrTextBoxDataModel wwnNameTextBox = new SJctrTextBoxDataModel();
        wwnNameTextBox.setValue("");
        wwnNameTextBox.setVisible(true);
        this.addDataObjectModel(KEY_WWN_NAME_INF, wwnNameTextBox);
        wwnNameCheckBox.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrEditWWNDC.this.setFinishChangeCheck(true);
                if (wwnNameCheckBox.isSelect()) {
                    wwnNameTextBox.setChangeCheck(true);
                } else {
                    wwnNameTextBox.setChangeCheck(false);
                }
            }
        });
        wwnNameTextBox.addTextChangeListener(new SJctrTextChangeListener(){

            @Override
            public void textChanged(SJctrTextBoxEvent event) {
                if (wwnNameCheckBox.isSelect()) {
                    wwnNameTextBox.setChangeCheck(true);
                } else {
                    wwnNameTextBox.setChangeCheck(false);
                }
            }
        });
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> viewDataList = this.getProxy().getCache(SJctrMonitorPortWWNInfo.class);
        if (null == viewDataList) {
            this.logUty.putlog("checkConstructData", "Inherited list data is null.");
            SJctrError err = new SJctrError(51, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == viewDataList.size()) {
            this.logUty.putlog("checkConstructData", "Size of inherited list data is zero.");
            SJctrError err = new SJctrError(51, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrMonitorPortWWNInfo viewData = (SJctrMonitorPortWWNInfo)viewDataList.get(0);
        if (null == viewData) {
            this.logUty.putlog("checkConstructData", "Information of selected WWN is null.");
            SJctrError err = new SJctrError(51, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        try {
            SJctrOptionMonitorUtility.getPPCALLPortWWNInfo(this);
            SJctrOptionMonitorUtility.getSJmoPortDetail(this);
            List<?> viewDataList = this.getProxy().getCache(SJctrMonitorPortWWNInfo.class);
            SJctrMonitorPortWWNInfo viewData = (SJctrMonitorPortWWNInfo)viewDataList.get(0);
            SJctrTextBoxDataModel hbaWwnTextBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_HBA_WWN_INF);
            String hbaWwn = SJctrComUtility.toWWNDisplay(viewData.getWwn());
            hbaWwnTextBox.setValue(hbaWwn);
            hbaWwnTextBox.setLabel(SJctrOptionMonitorGuidance.getMonitorGuidanceStr(this.getComUtility(), SJctrOptionMonitorGuidance.DISP_HBA_WWN_MAX_CHAR));
            SJctrTextBoxDataModel wwnNameTextBox = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_WWN_NAME_INF);
            String wwnName = viewData.getWwn().getStrWWNNickName();
            wwnNameTextBox.setValue(wwnName);
            wwnNameTextBox.setLabel(SJctrOptionMonitorGuidance.getMonitorGuidanceStr(this.getComUtility(), SJctrOptionMonitorGuidance.DISP_WWN_NAME_MAX_CHAR));
        }
        catch (SJcException e) {
            throw SJctrOptionMonitorUtility.convMonitorLogicalErr(e, 107002);
        }
        return true;
    }

    @Override
    public boolean checkEndData() {
        boolean ret = true;
        try {
            SJctrEditWWNConfirmData confirmData = new SJctrEditWWNConfirmData();
            List<SJmoPPCALLPortWWNInfo> monWwnInfos = SJctrOptionMonitorUtility.getPPCALLPortWWNInfo(this);
            List<SJmoPortDetail> portDetails = SJctrOptionMonitorUtility.getSJmoPortDetail(this);
            List<?> viewDataList = this.getProxy().getCache(SJctrMonitorPortWWNInfo.class);
            SJctrMonitorPortWWNInfo oldWwnInfo = (SJctrMonitorPortWWNInfo)viewDataList.get(0);
            SJctrSimpleDataModel hbaWwnTitle = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_HBA_WWN_TITLE);
            SJctrCheckBoxDataModel hbaWwnCheck = (SJctrCheckBoxDataModel)hbaWwnTitle.getDataModel(KEY_CHECKBOX);
            SJctrTextBoxDataModel hbaWwnField = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_HBA_WWN_INF);
            SJctrSimpleDataModel wwnNameTitle = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_WWN_NAME_TITLE);
            SJctrCheckBoxDataModel wwnNameCheck = (SJctrCheckBoxDataModel)wwnNameTitle.getDataModel(KEY_CHECKBOX);
            SJctrTextBoxDataModel wwnNameField = (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_WWN_NAME_INF);
            SJmoWwn chgWwnInfo = new SJmoWwn();
            String oldHbaWwn = SJctrComUtility.toWWNDisplay(oldWwnInfo.getWwn());
            String newHbaWwn = hbaWwnField.getValue();
            if (hbaWwnCheck.isSelect()) {
                if (newHbaWwn.equalsIgnoreCase(oldHbaWwn)) {
                    SJctrError err = new SJctrError(51, 22, 105227);
                    SJcException exp = err.createException();
                    throw exp;
                }
                if (SJctrOptionMonitorUtility.isDuplicationHBAWWNEditWWN(newHbaWwn, monWwnInfos, portDetails)) {
                    SJctrError err = new SJctrError(51, 22, 105103);
                    SJcException exp = err.createException();
                    throw exp;
                }
                newHbaWwn = newHbaWwn.toUpperCase();
                chgWwnInfo.setByWWN(SJctrComUtility.toByteFromString(newHbaWwn));
                confirmData.setChgHbaWwn(true);
            } else {
                chgWwnInfo.setByWWN(oldWwnInfo.getWwn().getByWWN());
                confirmData.setChgHbaWwn(false);
            }
            String oldWwnName = oldWwnInfo.getWwn().getStrWWNNickName();
            String newWwnName = wwnNameField.getValue();
            if (wwnNameCheck.isSelect()) {
                if (newWwnName.equals(oldWwnName)) {
                    SJctrError err = new SJctrError(51, 22, 105228);
                    SJcException exp = err.createException();
                    throw exp;
                }
                chgWwnInfo.setStrWWNNickName(newWwnName);
                if (SJctrOptionMonitorUtility.isDuplicationWWNNameEditWWN(chgWwnInfo, monWwnInfos, portDetails)) {
                    SJctrError err = new SJctrError(51, 22, 105104);
                    SJcException exp = err.createException();
                    throw exp;
                }
                confirmData.setChgWwnName(true);
            } else {
                chgWwnInfo.setStrWWNNickName(oldWwnName);
                confirmData.setChgWwnName(false);
            }
            confirmData.setOldWwn(oldWwnInfo);
            SJctrMonitorPortWWNInfo newWwnInfo = new SJctrMonitorPortWWNInfo(chgWwnInfo, oldWwnInfo.getPortDetail());
            confirmData.setNewWwn(newWwnInfo);
            ArrayList<SJctrEditWWNConfirmData> confirmDataList = new ArrayList<SJctrEditWWNConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrEditWWNConfirmData.class, confirmDataList);
            this.setFinishChangeCheck(false);
        }
        catch (SJcException e) {
            throw SJctrOptionMonitorUtility.convMonitorLogicalErr(e, 107003);
        }
        return ret;
    }

    private void setFinishChangeCheck(boolean changeCheckFlg) {
        SJctrButtonDataModel finishButton;
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        if (null != footer && null != (finishButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.FINISH))) {
            finishButton.setChangeCheck(changeCheckFlg);
        }
    }
}

