/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pbtsm.com;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import sanproject.common.Robj_interface_POOLIndex;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.serversx.data.RJiLDEVIndex;
import sanproject.serverux.dataimpl.POOLIndex;
import sanproject.serverux.dataimpl.POOLgetAOUVolRelation3;
import sanproject.serverux.dataimpl.POOLgetAOUVolRelation3_IN;
import sanproject.serverux.dataimpl.POOLgetAOUVolRelation3_OUT;
import sanproject.serverux.dataimpl.POOLgetPagesEachPolicy;
import sanproject.serverux.dataimpl.POOLgetPagesEachPolicyInfo;
import sanproject.serverux.dataimpl.POOLgetPagesEachPolicy_IN;
import sanproject.serverux.dataimpl.POOLgetPagesEachPolicy_OUT;
import sanproject.serverux.dataimpl.POOLgetPbTSMFrequencyDistributionEachLane_OUT;
import sanproject.serverux.dataimpl.POOLgetPbTSMFrequencyDistributionInfo;
import sanproject.serverux.dataimpl.POOLgetPbTSMFrequencyDistributionInfo2;
import sanproject.serverux.dataimpl.POOLgetPbTSMFrequencyDistributionInfoEachLane;
import sanproject.serverux.dataimpl.TierInfoAtCurrent;
import sanproject.serverux.dataimpl.TierInfoPerPbTSMMonitor;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.wizard.pbtsm.com.SJctrPbTsmGuidance;
import sanproject.sn2.controller.wizard.pbtsm.tierproperty.SJctrGetPbTSMFrequencyDistributionEachLaneInfo;
import sanproject.sn2.controller.wizard.pbtsm.tierproperty.SJctrPbTSMFrequencyDistributionInfo;
import sanproject.sn2.controller.wizard.pbtsm.tierproperty.SJctrPoolGetAouVolRelationInfo;
import sanproject.sn2.controller.wizard.pbtsm.tierproperty.SJctrPoolGetPagesEachPolicyInfo;
import sanproject.sn2.datasupplier.SJdsSupplierAgent;
import sanproject.sn2.datasupplier.SJdsSupplierException;
import sanproject.sn2.datasupplier.SJdsSupplierMgr;
import sanproject.sn2.model.connector.kind.SJmoGetPbTSMFrequencyDistributionInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPoolDetail;
import sanproject.sn2.model.data.SJmoModelData_Base;
import sanproject.sn2.model.data.SJmoThroughRmiData;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolIndex;
import sanproject.sn2.model.data.group.SJmoPoolNameInfo;
import sanproject.sn2.model.data.group.SJmoPoolTieringPolicy;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;

public class SJctrPbTsmUtility {
    private static final String className = "SJctrPbTsmUtility";
    public static final String KEY_PBTSM_TIER_INFO = "COM_PBTSM_TIER_INFO";
    public static final int DISP_ID_V_9_1 = 2305;
    public static final int DISP_ID_V_9_3 = 2307;
    public static final int DISP_ID_V_6_1 = 1537;
    public static final int INDEX_OF_SUCCESSION_INFO_DISP = 0;
    public static final int INDEX_OF_SUCCESSION_INFO_POOL_ID = 1;
    public static final int INDEX_OF_SUCCESSION_INFO_VVOL_ID = 2;
    private static final int FUNC_TIER_PROPERTY = 204;
    private static final int MODULE_CTR = 22;
    public static final int ERR_LOGIC_ERROR_LV7 = 107001;
    public static final int ERR_LOGIC_ERROR_LV5 = 107002;
    public static final int ERR_NOT_PBTSM_POOL = 105241;
    public static final int ERR_NOT_PBTSM_VVOL = 105242;
    public static final int ERR_POOL_VVOL_INFO_INVALID = 105247;
    public static final int ERR_NOT_DP_POOL = 105486;
    public static final String KEY_SELECT_OBJECT_TOGGLE_BUTTON = "COM_SELECT_OBJECT_TOGGLE_BUTTON";
    public static final String KEY_ENTIRE_POOL = "COM_ENTIRE_POOL";
    public static final String KEY_TIERING_POLICY = "COM_TIERING_POLICY";
    public static final String KEY_TIERING_POLICY_PULLDOWNLIST = "COM_TIERING_POLICY_PULLDOWNLIST";
    public static final String KEY_PBTSM_ENTIRE_POOL_DATA = "COM_PBTSM_ENTIRE_POOL_DATA";
    public static final String KEY_PBTSM_TIERING_POLICY_DATA = "COM_PBTSM_TIERING_POLICY_DATA";
    public static final String KEY_PBTSM_PAGE_TIERING_POLICY_DATA = "COM_PBTSM_PAGE_TIERING_POLICY_DATA";
    public static final String KEY_AOU_VOL_RELATION_DATA = "COM_AOU_VOL_RELATION_DATA";
    public static final String STR_DATE_FORMAT = "yyyy/MM/dd HH:mm";
    private static final String STR_GMT = "GMT";
    public static final long TIER_IO_PER_HOUR_INVALID = -1L;
    public static final long TIER_IO_PER_HOUR_ILLEGAL = -2L;
    private static final int AOU_VOL_ERROR_VAL = -1;
    private static final String INVALID_POOLNAMEID = "?(?)";
    private static final String FORMAT_POOLNAMEID = "%s(%d)";
    private static final String INVALID_POLICYNAME = "?(?)";
    private static final String FORMAT_POLICYNAME = "%s(%d)";

    public static void SJctrErrorDialog(int iError) {
        SJctrError error = new SJctrError(204, 22, iError);
        SJcException exception = error.createException();
        throw exception;
    }

    public static String getPoolNameId(SJmoPoolNameInfo poolNameInfo) {
        String strRet = "?(?)";
        if (null != poolNameInfo) {
            int sPoolId = poolNameInfo.getPoolId();
            String strPoolName = poolNameInfo.getStrName();
            if (null == strPoolName) {
                strPoolName = "?";
            }
            strRet = String.format("%s(%d)", strPoolName, sPoolId);
        }
        return strRet;
    }

    public static String getLdevName(SJmoLdevNicknameInfo ldevNickNameInfo) {
        String strNickname;
        String strRet = "?";
        if (null != ldevNickNameInfo && null != (strNickname = ldevNickNameInfo.getStrNickname())) {
            strRet = strNickname;
        }
        return strRet;
    }

    public static String getTieringPolicyNameLabel(SJmoPoolTieringPolicy policy) {
        String strRet = "?(?)";
        if (null != policy) {
            short sPolicyId = policy.getPolicyId();
            String strPolicyName = policy.getStrPolicyName();
            if (null == strPolicyName) {
                strPolicyName = "?";
            }
            strRet = String.format("%s(%d)", strPolicyName, sPolicyId);
        }
        return strRet;
    }

    public static String getTierCapacity(SJctrComUtility util, long lCapacity, SJctrCapacityUtility.UNIT unit) {
        SJctrCapacityUtility capUtil = util.getCapacityUtility();
        long lBlock = capUtil.valueOf(lCapacity, SJctrCapacityUtility.UNIT.KB);
        String strCapacity = capUtil.toString(lBlock, unit);
        return strCapacity;
    }

    public static void initializeTierData(SJctrSimpleDataModel obj, String key, String str) {
        for (int iTier = 0; iTier < 3; ++iTier) {
            ((SJctrDataObject)obj.getManageData()).setData(key + String.valueOf(iTier + 1), str);
        }
    }

    public static void makeUnmountedTierData(SJctrSimpleDataModel obj, String key, String str) {
        int numTier;
        SJmoPoolDetail poolDetail = SJctrPbTsmUtility.getPoolDetail(obj.getDataController());
        for (int iTier = numTier = poolDetail.getAlTierInfo().size(); iTier < 3; ++iTier) {
            ((SJctrDataObject)obj.getManageData()).setData(key + String.valueOf(iTier + 1), str);
        }
    }

    public static void makeUnmountedTierRmiData(TierInfoPerPbTSMMonitor[] tierInfo, SJctrSimpleDataModel obj, String key, String str) {
        String strFuncName = "makeUnmountedTierRmiData";
        if (null != tierInfo && 0 < tierInfo.length) {
            for (int iTier = tierInfo.length; iTier < 3; ++iTier) {
                ((SJctrDataObject)obj.getManageData()).setData(key + String.valueOf(iTier + 1), str);
            }
        } else {
            SJctrLogUty.warn(className, strFuncName, "tierInfo is null or size zero");
        }
    }

    public static void makeUnmountedTierRmiData(TierInfoAtCurrent[] tierInfoAtCurrent, SJctrSimpleDataModel obj, String key, String str) {
        String strFuncName = "makeUnmountedTierRmiData";
        if (null != tierInfoAtCurrent && 0 < tierInfoAtCurrent.length) {
            for (int iTier = tierInfoAtCurrent.length; iTier < 3; ++iTier) {
                ((SJctrDataObject)obj.getManageData()).setData(key + String.valueOf(iTier + 1), str);
            }
        } else {
            SJctrLogUty.warn(className, strFuncName, "tierInfoAtCurrent is null or size zero");
        }
    }

    public static int getAgencyScreenId(SJctrDataController ctrl) {
        return (Integer)SJctrPbTsmUtility.viewTierPropertiesParameter(ctrl, 0);
    }

    public static SJmoPoolIndex getPoolIndex(SJctrDataController ctrl) {
        return (SJmoPoolIndex)SJctrPbTsmUtility.viewTierPropertiesParameter(ctrl, 1);
    }

    public static SJmoLdevIndex getLdevIndex(SJctrDataController ctrl) {
        return (SJmoLdevIndex)SJctrPbTsmUtility.viewTierPropertiesParameter(ctrl, 2);
    }

    public static SJmoPoolDetail getPoolDetail(SJctrDataController ctrl) {
        SJmoPoolIndex poolIndex = SJctrPbTsmUtility.getPoolIndex(ctrl);
        return (SJmoPoolDetail)SJctrPbTsmUtility.getCtrlCacheModelData(ctrl, SJmoGetPoolDetail.class, poolIndex);
    }

    private static Object viewTierPropertiesParameter(SJctrDataController ctrl, int index) {
        Object ret;
        List<?> tierParamInfoList;
        String strFuncName = "viewTierPropertiesParameter";
        if (null == ctrl) {
            SJctrLogUty.warn(className, strFuncName, "ctrl is null");
            SJctrPbTsmUtility.SJctrErrorDialog(107002);
        }
        if (null == (tierParamInfoList = ctrl.getProxy().getCache(KEY_PBTSM_TIER_INFO))) {
            SJctrLogUty.warn(className, strFuncName, "tierParamInfoList is null");
            SJctrPbTsmUtility.SJctrErrorDialog(107002);
        }
        if (null == (ret = tierParamInfoList.get(index))) {
            SJctrLogUty.warn(className, strFuncName, "return is null");
            SJctrPbTsmUtility.SJctrErrorDialog(107002);
        }
        return ret;
    }

    public static SJmoModelData_Base getCtrlCacheModelData(SJctrDataController ctrl, Class<?> cls, SJmoModelData_Base key) {
        List<?> modelList;
        String strFuncName = "getCtrlCacheModelData";
        SJmoModelData_Base retModel = null;
        if (null == ctrl || null == cls || null == key) {
            SJctrLogUty.warn(className, strFuncName, "parameter is null");
            SJctrPbTsmUtility.SJctrErrorDialog(107002);
        }
        if (null != (modelList = ctrl.getProxy().getCache(cls)) && 0 < modelList.size()) {
            Collections.sort(modelList);
            int idx = Collections.binarySearch(modelList, key);
            if (0 <= idx) {
                retModel = (SJmoModelData_Base)modelList.get(idx);
            } else {
                SJctrPbTsmUtility.SJctrErrorDialog(105247);
                SJctrLogUty.warn(className, strFuncName, "idx is zero");
            }
        } else {
            SJctrPbTsmUtility.SJctrErrorDialog(107002);
            SJctrLogUty.warn(className, strFuncName, "modelList is null or size zero");
        }
        if (null == retModel) {
            SJctrLogUty.warn(className, strFuncName, "return is null");
            SJctrPbTsmUtility.SJctrErrorDialog(107002);
        }
        return retModel;
    }

    public static POOLgetPbTSMFrequencyDistributionInfo[] getRmiPbtsmInfo(SJctrDataController ctrl) {
        List<?> rmiList = ctrl.getProxy().getCache(SJmoGetPbTSMFrequencyDistributionInfo.class);
        POOLgetPbTSMFrequencyDistributionInfo[] pbtsmInfoList = (POOLgetPbTSMFrequencyDistributionInfo[])((SJmoThroughRmiData)rmiList.get(0)).getObjRmi();
        return pbtsmInfoList;
    }

    public static POOLgetPbTSMFrequencyDistributionInfoEachLane[] getRmiPbtsmInfoEachLane(SJctrDataController ctrl) {
        List<?> rmiList = ctrl.getProxy().getCache(SJctrGetPbTSMFrequencyDistributionEachLaneInfo.class);
        POOLgetPbTSMFrequencyDistributionEachLane_OUT eachLane = (POOLgetPbTSMFrequencyDistributionEachLane_OUT)((SJmoThroughRmiData)rmiList.get(0)).getObjRmi();
        POOLgetPbTSMFrequencyDistributionInfo2[] info2List = (POOLgetPbTSMFrequencyDistributionInfo2[])eachLane.getDataObject();
        POOLgetPbTSMFrequencyDistributionInfo2 info2 = info2List[0];
        POOLgetPbTSMFrequencyDistributionInfoEachLane[] pbtsmInfoList = (POOLgetPbTSMFrequencyDistributionInfoEachLane[])info2.getPbTSMFrequencyDistributionInfo();
        return pbtsmInfoList;
    }

    public static POOLgetPagesEachPolicyInfo[] getRmiPagesEachPolicyInfo(SJctrDataController ctrl) {
        String strFuncName = "getRmiPagesEachPolicyInfo";
        SJmoPoolIndex poolIndex = SJctrPbTsmUtility.getPoolIndex(ctrl);
        POOLgetPagesEachPolicy_IN input = new POOLgetPagesEachPolicy_IN();
        POOLIndex rmiPoolIndex = new POOLIndex();
        rmiPoolIndex.setSPoolId((short)poolIndex.getPoolId());
        Robj_interface_POOLIndex[] arrayRmiPoolIndex = new POOLIndex[]{rmiPoolIndex};
        input.setPoolInfo(arrayRmiPoolIndex);
        SJdsSupplierMgr supMgr = SJdsSupplierMgr.getSupplierMgr();
        SJdsSupplierAgent m_supAgnt = supMgr.getAgent();
        POOLgetPagesEachPolicyInfo[] pagesEachPolicyInfoList = null;
        try {
            POOLgetPagesEachPolicy_OUT output = (POOLgetPagesEachPolicy_OUT)m_supAgnt.getDataInf(input, false);
            if (null != output) {
                POOLgetPagesEachPolicy[] pagesEachPolicyList = (POOLgetPagesEachPolicy[])output.getDataObject();
                if (null != pagesEachPolicyList && 0 < pagesEachPolicyList.length) {
                    pagesEachPolicyInfoList = (POOLgetPagesEachPolicyInfo[])pagesEachPolicyList[0].getObjPolicyPagesInfo();
                } else {
                    SJctrLogUty.warn(className, strFuncName, "pagesEachPolicyList is null or size zero");
                }
            } else {
                SJctrLogUty.warn(className, strFuncName, "RmiData is null or size zero");
            }
        }
        catch (SJdsSupplierException e) {
            SJctrLogUty.warn(className, strFuncName, "RmiData is not able to acquire from Supplier");
        }
        return pagesEachPolicyInfoList;
    }

    public static POOLgetAOUVolRelation3 getRmiAOUVolRelation(SJctrDataController ctrl) {
        String strFuncName = "getRmiAOUVolRelation";
        SJmoLdevIndex ldevIndex = SJctrPbTsmUtility.getLdevIndex(ctrl);
        Robj_interface_RJiLDEVIndex[] rmiargs = new RJiLDEVIndex[1];
        RJiLDEVIndex rmiarg = new RJiLDEVIndex();
        rmiarg.setSLDKC((short)0);
        rmiarg.setSCU(ldevIndex.getSCu());
        rmiarg.setSLDEV(ldevIndex.getSLdev());
        rmiargs[0] = rmiarg;
        SJdsSupplierMgr supMgr = SJdsSupplierMgr.getSupplierMgr();
        SJdsSupplierAgent m_supAgnt = supMgr.getAgent();
        POOLgetAOUVolRelation3_IN input = new POOLgetAOUVolRelation3_IN();
        input.setLdevInfo(rmiargs);
        POOLgetAOUVolRelation3_OUT output = (POOLgetAOUVolRelation3_OUT)m_supAgnt.getDataInf(input, false);
        POOLgetAOUVolRelation3 aouVolRelation = null;
        if (output != null) {
            POOLgetAOUVolRelation3[] aouVolRelationList = (POOLgetAOUVolRelation3[])output.getDataObject();
            if (null != aouVolRelationList && 0 < aouVolRelationList.length) {
                aouVolRelation = aouVolRelationList[0];
                if (aouVolRelation != null) {
                    if (-1 == aouVolRelation.getSPoolId()) {
                        SJctrLogUty.warn(className, strFuncName, "Pool ID of aouVolRelation is illegal");
                        SJctrPbTsmUtility.SJctrErrorDialog(105247);
                    }
                } else {
                    SJctrLogUty.warn(className, strFuncName, "aouVolRelation is null");
                }
            } else {
                SJctrLogUty.warn(className, strFuncName, "aouVolRelationList is null or size zero");
            }
        } else {
            SJctrLogUty.warn(className, strFuncName, "RmiData is null");
        }
        return aouVolRelation;
    }

    public static SJctrPbTSMFrequencyDistributionInfo getPbtsmInfo(SJctrDataController ctrl) {
        SJctrPbTSMFrequencyDistributionInfo pbtsmInfo = null;
        SJctrRadioButtonGroupDataModel toggle = (SJctrRadioButtonGroupDataModel)ctrl.getDataObjectModel(KEY_SELECT_OBJECT_TOGGLE_BUTTON);
        String selectToggle = toggle.getSelect();
        pbtsmInfo = selectToggle == KEY_TIERING_POLICY ? SJctrPbTsmUtility.getPbtsmInfoTieringPolicyData(ctrl) : SJctrPbTsmUtility.getPbtsmInfoEntirePoolData(ctrl);
        return pbtsmInfo;
    }

    public static SJctrPbTSMFrequencyDistributionInfo getPbtsmInfoEntirePoolData(SJctrDataController ctrl) {
        String strFuncName = "getPbtsmInfoEntirePoolData";
        SJctrPbTSMFrequencyDistributionInfo pbtsmInfo = null;
        List<?> pbtsmInfoList = ctrl.getProxy().getCache(KEY_PBTSM_ENTIRE_POOL_DATA);
        if (null != pbtsmInfoList && 0 < pbtsmInfoList.size()) {
            pbtsmInfo = (SJctrPbTSMFrequencyDistributionInfo)pbtsmInfoList.get(0);
        } else {
            SJctrLogUty.warn(className, strFuncName, "pbtsmInfoList is null or size zero");
            pbtsmInfo = new SJctrPbTSMFrequencyDistributionInfo();
        }
        return pbtsmInfo;
    }

    public static SJctrPbTSMFrequencyDistributionInfo getPbtsmInfoTieringPolicyData(SJctrDataController ctrl) {
        String strFuncName = "getPbtsmInfoTieringPolicyData";
        SJctrPbTSMFrequencyDistributionInfo pbtsmInfo = null;
        SJctrComboBoxDataModel tieringPolicyPulldownList = (SJctrComboBoxDataModel)ctrl.getDataObjectModel(KEY_TIERING_POLICY_PULLDOWNLIST);
        int iTieringPolicyKey = tieringPolicyPulldownList.getSelectedIndex();
        List<?> pbtsmInfoList = ctrl.getProxy().getCache(KEY_PBTSM_TIERING_POLICY_DATA);
        if (null != pbtsmInfoList && 0 < pbtsmInfoList.size()) {
            pbtsmInfo = (SJctrPbTSMFrequencyDistributionInfo)pbtsmInfoList.get(iTieringPolicyKey);
        } else {
            SJctrLogUty.warn(className, strFuncName, "pbtsmInfoList is null or size zero");
            pbtsmInfo = new SJctrPbTSMFrequencyDistributionInfo();
        }
        return pbtsmInfo;
    }

    public static SJctrPoolGetPagesEachPolicyInfo getPagesEachPolicyInfo(SJctrDataController ctrl) {
        String strFuncName = "getPagesEachPolicyInfo";
        SJctrPoolGetPagesEachPolicyInfo pagesEachPolicyInfo = null;
        SJctrComboBoxDataModel tieringPolicyPulldownList = (SJctrComboBoxDataModel)ctrl.getDataObjectModel(KEY_TIERING_POLICY_PULLDOWNLIST);
        int iTieringPolicyKey = tieringPolicyPulldownList.getSelectedIndex();
        List<?> pagesEachPolicyList = ctrl.getProxy().getCache(KEY_PBTSM_PAGE_TIERING_POLICY_DATA);
        if (null != pagesEachPolicyList && 0 < pagesEachPolicyList.size()) {
            pagesEachPolicyInfo = (SJctrPoolGetPagesEachPolicyInfo)pagesEachPolicyList.get(iTieringPolicyKey);
        } else {
            SJctrLogUty.warn(className, strFuncName, "pagesEachPolicyList is null or size zero");
            pagesEachPolicyInfo = new SJctrPoolGetPagesEachPolicyInfo();
        }
        return pagesEachPolicyInfo;
    }

    public static SJctrPoolGetAouVolRelationInfo getAouVolRelationInfo(SJctrDataController ctrl) {
        String strFuncName = "getAouVolRelationInfo";
        SJctrPoolGetAouVolRelationInfo aouVolRelationInfo = null;
        List<?> aouVolRelationInfoList = ctrl.getProxy().getCache(KEY_AOU_VOL_RELATION_DATA);
        if (null != aouVolRelationInfoList && 0 < aouVolRelationInfoList.size()) {
            aouVolRelationInfo = (SJctrPoolGetAouVolRelationInfo)aouVolRelationInfoList.get(0);
        } else {
            SJctrLogUty.warn(className, strFuncName, "aouVolRelationInfoList is null or size zero");
            aouVolRelationInfo = new SJctrPoolGetAouVolRelationInfo();
        }
        return aouVolRelationInfo;
    }

    public static String getGMTTimeString(Date date) {
        String strGmtTime = "?";
        String strFuncName = "getGMTTimeString";
        if (date != null) {
            long lTime = date.getTime();
            SJctrLogUty.info(className, strFuncName, "Date num is " + lTime);
            if (lTime > 0L) {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat(STR_DATE_FORMAT);
                    sdf.setTimeZone(TimeZone.getTimeZone(STR_GMT));
                    strGmtTime = sdf.format(lTime);
                }
                catch (IllegalArgumentException e) {
                    SJctrLogUty.error(className, strFuncName, "Date is illegal.");
                }
            } else if (lTime == 0L) {
                strGmtTime = "-";
            } else {
                SJctrLogUty.error(className, strFuncName, "Date is invalid.");
            }
        } else {
            SJctrLogUty.error(className, strFuncName, "Date is null.");
        }
        return strGmtTime;
    }

    public static long getTierHitRate(long tierIoPh, long totalIoPh) {
        long tierHitRate = 0L;
        if (0L < totalIoPh) {
            double tmpHitRate = (double)tierIoPh * 100.0 / (double)totalIoPh;
            tierHitRate = (long)tmpHitRate;
            if (1L <= tierIoPh && 0L == tierHitRate) {
                tierHitRate = 1L;
            }
        }
        return tierHitRate;
    }

    public static String formatIoPhHitRate(SJctrComUtility util, String tierIoPh, String tierHitrate) {
        String tierIoHitRateStr = "-";
        String strLeft = SJctrPbTsmGuidance.getPbTsmGuidanceStr(util, SJctrPbTsmGuidance.BRACKET_L_LEFT);
        String strRight = SJctrPbTsmGuidance.getPbTsmGuidanceStr(util, SJctrPbTsmGuidance.BRACKET_L_RIGHT);
        String strPercent = SJctrPbTsmGuidance.getPbTsmGuidanceStr(util, SJctrPbTsmGuidance.PERCENT);
        tierIoHitRateStr = tierIoPh + " " + strLeft + tierHitrate + " " + strPercent + strRight;
        return tierIoHitRateStr;
    }
}

