/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pbtsm.tierproperty;

import java.util.Date;
import sanproject.serverux.dataimpl.TierInfoPerPbTSMMonitor;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.wizard.pbtsm.com.SJctrPbTsmUtility;
import sanproject.sn2.controller.wizard.pbtsm.tierproperty.SJctrAverageNumberOfIoDataModelBase;

public class SJctrAverageNumberOfIoActualDataModel
extends SJctrAverageNumberOfIoDataModelBase {
    private static final String KEY_AVERAGE_NUMBER_OF_IO_ACTUAL_TOTAL = "COM_AVERAGE_NUMBER_OF_IO_ACTUAL_TOTAL";
    private static final String KEY_AVERAGE_NUMBER_OF_IO_ACTUAL_TIER = "COM_AVERAGE_NUMBER_OF_IO_ACTUAL_TIER";
    private static final String ACTUAL_IO_PER_HOUR_NAME = "Average Number of I/O(per Hour) Actual";

    @Override
    protected long getIoPh(TierInfoPerPbTSMMonitor tierInfo) {
        return tierInfo.getLIOPH();
    }

    @Override
    protected String getKeyAverageNumOfIoTotal() {
        return KEY_AVERAGE_NUMBER_OF_IO_ACTUAL_TOTAL;
    }

    @Override
    protected String getKeyAverageNumOfIoTier() {
        return KEY_AVERAGE_NUMBER_OF_IO_ACTUAL_TIER;
    }

    @Override
    protected String getIoPhNameStr() {
        return ACTUAL_IO_PER_HOUR_NAME;
    }

    @Override
    protected long getTotalIoPh() {
        long tierTotalIoPh = 0L;
        if (null != this.pbtsmInfo) {
            tierTotalIoPh = this.pbtsmInfo.getLIOPH();
        }
        return tierTotalIoPh;
    }

    @Override
    protected void makeTotalIoph(long totalIoPh) {
        if (this.isInValidTierActualIoPh()) {
            ((SJctrDataObject)this.getManageData()).setData(this.getKeyAverageNumOfIoTotal(), "-");
        } else if (totalIoPh >= 0L) {
            String strIoph = String.valueOf(totalIoPh);
            ((SJctrDataObject)this.getManageData()).setData(this.getKeyAverageNumOfIoTotal(), strIoph);
        } else {
            SJctrLogUty.error(this.getClass().getSimpleName(), "makeTotalIoph", "lIoph is illegal");
        }
    }

    @Override
    protected void makeIophEachTier(long tierTotalIoPh) {
        String strFuncName = "makeIophEachTier";
        boolean isInValidIoPh = this.isInValidTierActualIoPh();
        for (int tierNum = 0; tierNum < this.tierInfoPerPbTSMMonitor.length; ++tierNum) {
            TierInfoPerPbTSMMonitor tierInfo = this.tierInfoPerPbTSMMonitor[tierNum];
            if (tierInfo != null) {
                long tierIoPh = this.getIoPh(tierInfo);
                if (isInValidIoPh) {
                    ((SJctrDataObject)this.getManageData()).setData(this.getKeyAverageNumOfIoTier() + String.valueOf(tierNum + 1), SJctrPbTsmUtility.formatIoPhHitRate(this.getComUtility(), "-", "-"));
                } else if (tierIoPh >= 0L) {
                    long tierHitRate = SJctrPbTsmUtility.getTierHitRate(tierIoPh, tierTotalIoPh);
                    String tierIoHitRateStr = SJctrPbTsmUtility.formatIoPhHitRate(this.getComUtility(), String.valueOf(tierIoPh), String.valueOf(tierHitRate));
                    ((SJctrDataObject)this.getManageData()).setData(this.getKeyAverageNumOfIoTier() + String.valueOf(tierNum + 1), tierIoHitRateStr);
                } else {
                    SJctrLogUty.error(this.getClass().getSimpleName(), strFuncName, "tierIoPh of tierInfoPerPbTSMMonitor[" + tierNum + "] is illegal.");
                }
                this.getLogUty().putlog(strFuncName, this.getIoPhNameStr() + " Tier[" + tierNum + "] is " + tierIoPh);
                continue;
            }
            SJctrLogUty.error(this.getClass().getSimpleName(), strFuncName, "tierInfoPerPbTSMMonitor[" + tierNum + "] is null.");
        }
    }

    private boolean isInValidTierActualIoPh() {
        boolean isInvalidTierActualIoPh = false;
        Date monitorStartTime = this.pbtsmInfo.getMonitorStartTime();
        Date monitorEndTime = this.pbtsmInfo.getMonitorEndTime();
        if (this.isInvalidMoniterTime(monitorStartTime) || this.isInvalidMoniterTime(monitorEndTime)) {
            isInvalidTierActualIoPh = true;
        }
        return isInvalidTierActualIoPh;
    }

    private boolean isInvalidMoniterTime(Date date) {
        boolean isInvalidMoniterTime = false;
        if (date == null || date.getTime() <= 0L) {
            isInvalidMoniterTime = true;
        }
        return isInvalidMoniterTime;
    }
}

