/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pool.comdialog.viewpoolmanagementstatus;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.serverux.dataimpl.POOLgetPbTSMMonitorOperationInfo;
import sanproject.serverux.dataimpl.POOLgetPoolProgress;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.wizard.pool.comdialog.viewpoolmanagementstatus.SJctrViewPoolManagementStatusDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetTiPvolStatus;
import sanproject.sn2.model.data.group.SJmoHDPRelationByPool;
import sanproject.sn2.model.data.group.SJmoPbTSMMonitorOperationInfo;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolIndex;
import sanproject.sn2.model.data.group.SJmoPoolNameInfo;
import sanproject.sn2.model.data.group.SJmoPoolSummary;
import sanproject.sn2.model.data.group.SJmoSnapshotVvolRelationByPool;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolInfo;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolStatus;

public class SJctrViewPoolManagementStatusSummaryModel
extends SJctrSimpleDataModel {
    public SJctrViewPoolManagementStatusDC m_ViewPoolManagementStatusDigDC = null;
    public SJctrPoolUtility m_PoolUtl = null;
    public static final String KEY_POOLNAME = "COM_POOLNAME";
    public static final String KEY_POOL_ATTR = "COM_POOL_ATTR";
    public static final String KEY_VVOL_NUM = "COM_VVOL_NUM";
    public static final String KEY_PRIMARY_VOL_NUM = "COM_PRIMARY_VOL_NUM";
    public static final String KEY_POOL_VOL_NUM = "COM_POOL_VOL_NUM";
    public static final String KEY_TIER_MANAGE = "COM_TIER_MANAGE";
    public static final String KEY_MONITOR_MODE = "COM_MONITOR_MODE";
    public static final String KEY_MONITOR_STATUS = "COM_MONITOR_STATUS";
    public static final String KEY_RELOCATION_SPEED = "COM_RELOCATION_SPEED";
    public static final String KEY_POOL_MANAGE_TASK = "COM_POOL_MANAGE_TASK";
    public static final String KEY_CAP_USED_TOTAL = "COM_CAP_USED_TOTAL";
    public static final String KEY_CAP_FREE = "COM_CAP_FREE";
    public static final String KEY_RELOCATION_RESULT = "COM_RELOCATION_RESULT";
    private POOLgetPoolProgress poolProgressInfo = null;
    private POOLgetPbTSMMonitorOperationInfo pbTSMMonitorInfo = null;
    private SJmoTiPvolInfo[] tiPVolArray = null;

    @Override
    public void makeDataObject() {
        List<SJmoGetTiPvolStatus> tiPVolStatusList;
        ArrayList<Serializable> summaryList = new ArrayList<Serializable>();
        SJmoPoolDetail poolDtlSmry = null;
        SJmoPoolNameInfo poolNameInfSmry = null;
        SJmoHDPRelationByPool hdpRelbyPoolSmry = null;
        SJmoPbTSMMonitorOperationInfo pbtsmMonInfListSmry = null;
        SJctrDataController dc = this.getDataController();
        if (null != dc && dc instanceof SJctrViewPoolManagementStatusDC) {
            this.m_ViewPoolManagementStatusDigDC = (SJctrViewPoolManagementStatusDC)dc;
            this.m_PoolUtl = this.getComUtility().getPoolUtility();
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "makeDataObject", "getDataController failed");
            this.m_ViewPoolManagementStatusDigDC = null;
        }
        ArrayList<SJmoPoolDetail> poolDtlList = new ArrayList<SJmoPoolDetail>(this.getBasicDataList(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL));
        poolDtlSmry = this.getPoolDetailSummary(poolDtlList);
        ArrayList<SJmoPoolNameInfo> poolNameInfList = new ArrayList<SJmoPoolNameInfo>(this.getBasicDataList(SJctrPoolUtility.KEY_CLASS_POOLNAME_INFO));
        poolNameInfSmry = this.getPoolNameInfSummary(poolNameInfList);
        ArrayList<SJmoHDPRelationByPool> hdpRelbyPoolList = new ArrayList<SJmoHDPRelationByPool>(this.getBasicDataList(SJctrPoolUtility.KEY_CLASS_HDP_RELATION_BY_POOL));
        hdpRelbyPoolSmry = this.getHDPRelationbyPoolSummary(hdpRelbyPoolList);
        ArrayList<SJmoPbTSMMonitorOperationInfo> pbtsmMonInfList = new ArrayList<SJmoPbTSMMonitorOperationInfo>(this.getBasicDataList(SJctrPoolUtility.KEY_CLASS_POOL_MONOPRATION_INFO));
        pbtsmMonInfListSmry = this.getPbTSMMonInfSummary(pbtsmMonInfList);
        List<?> poolSummaryList = this.getBasicDataList(SJctrPoolUtility.KEY_CLASS_POOL_SUMMARY);
        SJmoPoolSummary poolSummaryInfo = null;
        if (poolSummaryList != null && !poolSummaryList.isEmpty()) {
            poolSummaryInfo = (SJmoPoolSummary)poolSummaryList.get(0);
        }
        if ((tiPVolStatusList = this.getBasicDataList(SJmoGetTiPvolStatus.class)) != null && !tiPVolStatusList.isEmpty()) {
            SJmoTiPvolStatus tiPVolStatus = (SJmoTiPvolStatus)((Object)tiPVolStatusList.get(0));
            this.tiPVolArray = tiPVolStatus.getTiPvolInfo();
        }
        summaryList.add(poolDtlSmry);
        summaryList.add(poolNameInfSmry);
        summaryList.add(hdpRelbyPoolSmry);
        summaryList.add(pbtsmMonInfListSmry);
        summaryList.add(poolSummaryInfo);
        summaryList.add(this.poolProgressInfo);
        summaryList.add(this.pbTSMMonitorInfo);
        this.makeSummary(summaryList);
    }

    @Override
    protected void makeModelDirect() {
        SJctrGetDirectWrapper getDrctWrpPoolDtl = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL);
        this.directList.add(getDrctWrpPoolDtl);
        SJctrGetDirectWrapper getDrctWrpPoolNameInf = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_POOLNAME_INFO);
        this.directList.add(getDrctWrpPoolNameInf);
        SJctrGetDirectWrapper getDrctWrpHDPRelbyPool = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_HDP_RELATION_BY_POOL);
        this.directList.add(getDrctWrpHDPRelbyPool);
        SJctrGetDirectWrapper getDrctWrpPbTSMMonInf = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_POOL_MONOPRATION_INFO);
        this.directList.add(getDrctWrpPbTSMMonInf);
        SJctrGetDirectWrapper getDrctWrpPoolSummaryInfo = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_POOL_SUMMARY);
        this.directList.add(getDrctWrpPoolSummaryInfo);
        SJctrGetDirectWrapper getDrctWrpTiPvolStatus = this.createModelDirect(SJmoGetTiPvolStatus.class);
        this.directList.add(getDrctWrpTiPvolStatus);
    }

    private SJctrGetDirectWrapper createModelDirect(Class<? extends SJmoGetKind_IF> kindClass) {
        SJctrGetDirectWrapper getDrctWrap = null;
        try {
            SJmoGetKind_IF kind = kindClass.newInstance();
            SJmoGetRange_IF range = null;
            ArrayList search = new ArrayList();
            SJmoGetDirect getDrct = new SJmoGetDirect(kind, range, search);
            getDrctWrap = new SJctrGetDirectWrapper(getDrct);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return getDrctWrap;
    }

    protected void makeSummary(List<?> summaryList) {
        SJmoPoolDetail poolDtlSmry = null;
        SJmoPoolNameInfo poolNameInfSmry = null;
        SJmoHDPRelationByPool hdpRelbyPoolSmry = null;
        SJmoPbTSMMonitorOperationInfo pbtsmMonInfListSmry = null;
        SJmoPoolSummary poolSummaryInfo = null;
        POOLgetPoolProgress poolProgressSmry = null;
        POOLgetPbTSMMonitorOperationInfo pbTSMMonitorInfoSmry = null;
        if (null != summaryList) {
            for (int iListIdx = 0; iListIdx < summaryList.size(); ++iListIdx) {
                Object obj = summaryList.get(iListIdx);
                if (null != obj) {
                    if (obj instanceof SJmoPoolDetail) {
                        poolDtlSmry = (SJmoPoolDetail)obj;
                        continue;
                    }
                    if (obj instanceof SJmoPoolNameInfo) {
                        poolNameInfSmry = (SJmoPoolNameInfo)obj;
                        continue;
                    }
                    if (obj instanceof SJmoHDPRelationByPool) {
                        hdpRelbyPoolSmry = (SJmoHDPRelationByPool)obj;
                        continue;
                    }
                    if (obj instanceof SJmoPbTSMMonitorOperationInfo) {
                        pbtsmMonInfListSmry = (SJmoPbTSMMonitorOperationInfo)obj;
                        continue;
                    }
                    if (obj instanceof SJmoPoolSummary) {
                        poolSummaryInfo = (SJmoPoolSummary)obj;
                        continue;
                    }
                    if (obj instanceof POOLgetPoolProgress) {
                        poolProgressSmry = (POOLgetPoolProgress)obj;
                        continue;
                    }
                    if (obj instanceof POOLgetPbTSMMonitorOperationInfo) {
                        pbTSMMonitorInfoSmry = (POOLgetPbTSMMonitorOperationInfo)obj;
                        continue;
                    }
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "makeSummary", "class error in summaryLis : ListIdx=" + iListIdx);
                    continue;
                }
                SJctrLogUty.warn(this.getClass().getSimpleName(), "makeSummary", "null data in summaryList : ListIdx=" + iListIdx);
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "makeSummary", "summaryList is null");
        }
        String strPoolName = this.getPoolName(poolNameInfSmry);
        String strAttribute = this.getPoolAttribute(poolDtlSmry);
        String strVVolNum = this.getVVolNum(hdpRelbyPoolSmry, poolDtlSmry);
        String strPrimayVolNum = this.getPrimaryVolNum(poolDtlSmry, this.tiPVolArray);
        String strPoolVolNum = this.getPoolVolNum(poolDtlSmry);
        String strPoolManageTask = this.getPoolManageTask(poolProgressSmry, pbTSMMonitorInfoSmry);
        String strRelocationResult = this.getRelocationResult(pbTSMMonitorInfoSmry, poolProgressSmry, poolDtlSmry);
        String strPoolCapa = this.getPoolCapa(poolDtlSmry);
        String strPoolFreeCapa = this.getPoolFreeCapa(poolDtlSmry, poolProgressSmry);
        String strTierManagement = this.getTierManagement(poolDtlSmry, poolSummaryInfo);
        String strMonMode = this.getMonMode(poolDtlSmry, poolSummaryInfo);
        String strMonitorStatus = this.getMonitorStatus(pbtsmMonInfListSmry, poolDtlSmry, poolSummaryInfo);
        String strRelocationSpeed = this.getRelocationSpeedActual(poolDtlSmry, pbTSMMonitorInfoSmry);
        Object summaryData = this.getManageData();
        ((SJctrDataObject)summaryData).setData(KEY_POOLNAME, strPoolName);
        ((SJctrDataObject)summaryData).setData(KEY_POOL_ATTR, strAttribute);
        ((SJctrDataObject)summaryData).setData(KEY_VVOL_NUM, strVVolNum);
        ((SJctrDataObject)summaryData).setData(KEY_PRIMARY_VOL_NUM, strPrimayVolNum);
        ((SJctrDataObject)summaryData).setData(KEY_POOL_VOL_NUM, strPoolVolNum);
        ((SJctrDataObject)summaryData).setData(KEY_POOL_MANAGE_TASK, strPoolManageTask);
        ((SJctrDataObject)summaryData).setData(KEY_RELOCATION_RESULT, strRelocationResult);
        ((SJctrDataObject)summaryData).setData(KEY_CAP_USED_TOTAL, strPoolCapa);
        ((SJctrDataObject)summaryData).setData(KEY_CAP_FREE, strPoolFreeCapa);
        ((SJctrDataObject)summaryData).setData(KEY_TIER_MANAGE, strTierManagement);
        ((SJctrDataObject)summaryData).setData(KEY_MONITOR_MODE, strMonMode);
        ((SJctrDataObject)summaryData).setData(KEY_MONITOR_STATUS, strMonitorStatus);
        ((SJctrDataObject)summaryData).setData(KEY_RELOCATION_SPEED, strRelocationSpeed);
    }

    public SJmoPoolDetail getPoolDetailSummary(List<SJmoPoolDetail> poolDetailList) {
        SJmoPoolDetail retPoolDtl = null;
        if (null != this.m_ViewPoolManagementStatusDigDC) {
            SJmoPoolIndex selPoolIdx = this.m_ViewPoolManagementStatusDigDC.getSelectPoolIndex();
            Collections.sort(poolDetailList);
            int iPoolDtlIdx = Collections.binarySearch(poolDetailList, selPoolIdx);
            if (0 <= iPoolDtlIdx) {
                retPoolDtl = poolDetailList.get(iPoolDtlIdx);
            } else {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "getPoolDetailSummary", "Select Pool is not found");
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getPoolDetailSummary", "m_ViewPoolManagementStatusDigDC is null");
        }
        return retPoolDtl;
    }

    public SJmoPoolNameInfo getPoolNameInfSummary(List<SJmoPoolNameInfo> poolNameInfList) {
        SJmoPoolNameInfo retPoolNameInf = null;
        if (null != this.m_ViewPoolManagementStatusDigDC) {
            SJmoPoolIndex selPoolIdx = this.m_ViewPoolManagementStatusDigDC.getSelectPoolIndex();
            Collections.sort(poolNameInfList);
            int iPoolNameInfIdx = Collections.binarySearch(poolNameInfList, selPoolIdx);
            if (0 <= iPoolNameInfIdx) {
                retPoolNameInf = poolNameInfList.get(iPoolNameInfIdx);
            } else {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "getPoolNameInfSummary", "Select Pool is not found");
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getPoolNameInfSummary", "m_ViewPoolManagementStatusDigDC is null");
        }
        return retPoolNameInf;
    }

    public SJmoHDPRelationByPool getHDPRelationbyPoolSummary(List<SJmoHDPRelationByPool> hdpRelationbyPoolList) {
        SJmoHDPRelationByPool retHDPRelationbyPool = null;
        if (null != this.m_ViewPoolManagementStatusDigDC) {
            SJmoPoolIndex selPoolIdx = this.m_ViewPoolManagementStatusDigDC.getSelectPoolIndex();
            Collections.sort(hdpRelationbyPoolList);
            int iPoolHDPRelationbyPoolIdx = Collections.binarySearch(hdpRelationbyPoolList, selPoolIdx);
            if (0 <= iPoolHDPRelationbyPoolIdx) {
                retHDPRelationbyPool = hdpRelationbyPoolList.get(iPoolHDPRelationbyPoolIdx);
            } else {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "getHDPRelationbyPoolSummary", "Select Pool is not found");
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getPoolVolDetailSummary", "m_ViewPoolManagementStatusDigDC is null");
        }
        return retHDPRelationbyPool;
    }

    public SJmoPbTSMMonitorOperationInfo getPbTSMMonInfSummary(List<SJmoPbTSMMonitorOperationInfo> pbtsmMonInfList) {
        SJmoPbTSMMonitorOperationInfo retPbTSMMonInf = null;
        if (null != this.m_ViewPoolManagementStatusDigDC) {
            SJmoPoolIndex selPoolIdx = this.m_ViewPoolManagementStatusDigDC.getSelectPoolIndex();
            Collections.sort(pbtsmMonInfList);
            int iPbtsmMonInfIdx = Collections.binarySearch(pbtsmMonInfList, selPoolIdx);
            if (0 <= iPbtsmMonInfIdx) {
                retPbTSMMonInf = pbtsmMonInfList.get(iPbtsmMonInfIdx);
            } else {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "getPbTSMMonInfSummary", "Select Pool is not found");
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getPbTSMMonInfSummary", "m_ViewPoolManagementStatusDigDC is null");
        }
        return retPbTSMMonInf;
    }

    public SJmoSnapshotVvolRelationByPool getSSVvolRelbyPoolSummary(List<SJmoSnapshotVvolRelationByPool> alSSVvolRelList) {
        SJmoSnapshotVvolRelationByPool retSSVvolRel = null;
        if (null != this.m_ViewPoolManagementStatusDigDC) {
            SJmoPoolIndex selPoolIdx = this.m_ViewPoolManagementStatusDigDC.getSelectPoolIndex();
            Collections.sort(alSSVvolRelList);
            int iPoolIdx = Collections.binarySearch(alSSVvolRelList, selPoolIdx);
            if (0 <= iPoolIdx) {
                retSSVvolRel = alSSVvolRelList.get(iPoolIdx);
            } else {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "getSSVvolRelbyPoolSummary", "Select Pool is not found");
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getSSVvolRelbyPoolSummary", "m_ViewPoolManagementStatusDigDC is null");
        }
        return retSSVvolRel;
    }

    private String getPoolName(SJmoPoolNameInfo poolNameInf) {
        String strRtn = this.m_PoolUtl.toPoolNameDisplay(poolNameInf);
        return strRtn;
    }

    private String getPoolAttribute(SJmoPoolDetail poolDtl) {
        String strRtn = this.m_PoolUtl.toPoolAttributeDisplay(poolDtl);
        return strRtn;
    }

    private String getVVolNum(SJmoHDPRelationByPool hdpRelbyPool, SJmoPoolDetail poolDtl) {
        String strRtn = this.getComUtility().getPoolUtility().toMaxAllowedDisplay("?");
        if (poolDtl != null) {
            if (2 == poolDtl.getPoolKind()) {
                strRtn = this.m_PoolUtl.toVVolNumDisplay(hdpRelbyPool, this.getComUtility(), poolDtl);
            } else if (poolDtl.getPoolKind() == 8) {
                strRtn = this.getComUtility().getPoolUtility().toMaxAllowedDisplay(SJctrPoolUtility.HAIFUN_STR);
            }
        }
        return strRtn;
    }

    private String getPrimaryVolNum(SJmoPoolDetail poolDtl, SJmoTiPvolInfo[] tiPVolArray) {
        return this.m_PoolUtl.toTIPVolNumToDisplay(poolDtl, tiPVolArray);
    }

    private String getPoolVolNum(SJmoPoolDetail poolDtl) {
        String strRtn = this.m_PoolUtl.toPoolVolNumDisplay(poolDtl, this.getComUtility(), true);
        return strRtn;
    }

    private String getPoolManageTask(POOLgetPoolProgress poolProgress, POOLgetPbTSMMonitorOperationInfo pbTSMMonitor) {
        String strRtn = this.m_PoolUtl.toPoolManagementTaskStatusProgressDisplay(poolProgress, pbTSMMonitor);
        return strRtn;
    }

    private String getPoolCapa(SJmoPoolDetail poolDtl) {
        String strRtn = this.m_PoolUtl.toPoolSummaryTotalUsedCapacityDisplay(poolDtl, this.getComUtility(), false);
        return strRtn;
    }

    private String getPoolFreeCapa(SJmoPoolDetail poolDtl, POOLgetPoolProgress poolProgress) {
        String strRtn = this.m_PoolUtl.toPoolSummaryFreeCapacityDisplay(poolDtl, poolProgress, this.getComUtility());
        return strRtn;
    }

    private String getTierManagement(SJmoPoolDetail poolDtl, SJmoPoolSummary poolSummaryInfo) {
        String strRtn = this.m_PoolUtl.toTierManagementDisplay(poolDtl, poolSummaryInfo);
        return strRtn;
    }

    private String getMonMode(SJmoPoolDetail poolDtl, SJmoPoolSummary poolSummaryInfo) {
        String strRtn = this.m_PoolUtl.toMonModeDisplay(poolDtl, poolSummaryInfo);
        return strRtn;
    }

    private String getMonitorStatus(SJmoPbTSMMonitorOperationInfo pbTSMMonitorOpeInfo, SJmoPoolDetail poolDtl, SJmoPoolSummary poolSummaryInfo) {
        String strRtn = this.m_PoolUtl.toMonitorStatusDisplay(pbTSMMonitorOpeInfo, poolDtl, poolSummaryInfo);
        return strRtn;
    }

    private String getRelocationSpeedActual(SJmoPoolDetail poolDtl, POOLgetPbTSMMonitorOperationInfo pbTSMMonitorOpeInfo) {
        String strRtn = this.m_PoolUtl.toRelocationSpeedActual(poolDtl, pbTSMMonitorOpeInfo);
        return strRtn;
    }

    private String getRelocationResult(POOLgetPbTSMMonitorOperationInfo pbTSMMonitorOpeInfo, POOLgetPoolProgress poolProgress, SJmoPoolDetail poolDtl) {
        String strRtn = this.m_PoolUtl.toRmiRelocationResultDisplay(poolDtl, pbTSMMonitorOpeInfo, poolProgress);
        return strRtn;
    }

    public void setPOOLgetPoolProgressInfo(POOLgetPoolProgress poolProgressInfo) {
        this.poolProgressInfo = poolProgressInfo;
    }

    public void setPbTSMMonitorInfo(POOLgetPbTSMMonitorOperationInfo pbTSMMonitorInfo) {
        this.pbTSMMonitorInfo = pbTSMMonitorInfo;
    }
}

