/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pool.editpools;

import java.util.ArrayList;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.model.SJctrCheckBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.wizard.pool.editpools.SJctrEditPoolsDC;
import sanproject.sn2.model.data.group.SJmoPoolDetail;

public class SJctrEditPoolsDepletionThresholdArea
extends SJctrSimpleDataModel {
    private SJctrCheckBoxDataModel depThresholdChkBox = new SJctrCheckBoxDataModel();
    private SJctrTextBoxDataModel depThresholdTextBox = new SJctrTextBoxDataModel();
    private SJctrEditPoolsDC edPDC = null;
    private SJctrComUtility comUtil = null;

    @Override
    public void initGuidance(SJctrComUtility util) {
        this.addDataModel("COM_CHECKBOX", this.depThresholdChkBox);
        this.addDataModel("COM_DEPLE_THRESHOLD", this.depThresholdTextBox);
        this.comUtil = util;
        this.edPDC = (SJctrEditPoolsDC)this.getDataController();
    }

    void initDepThreshold() {
        ArrayList<Object> poolDtlList = new ArrayList();
        int iMinThreshold = 1;
        int iMaxThreshold = 100;
        int iMaxPoolUsedRate = 0;
        boolean bDepThresholdMix = false;
        String strDefDepThresholdText = new String("");
        int sDefDepletionThreshold = 0;
        boolean bEnableSysThreshold = false;
        this.depThresholdTextBox.setEnable(true);
        this.depThresholdChkBox.setEnable(true);
        this.clearData();
        poolDtlList = new ArrayList(this.edPDC.getCache("KEY_CLASS_EDIT_DATA"));
        sDefDepletionThreshold = ((SJmoPoolDetail)poolDtlList.get(0)).getSPoolThresholdMode() == SJctrPoolUtility.THRESHOLD_MODE_DEPLETION_ON ? ((SJmoPoolDetail)poolDtlList.get(0)).getSPoolDepletionThreshold() : (this.comUtil.getPoolUtility().isSysThresChangeDepThres((SJmoPoolDetail)poolDtlList.get(0)) ? ((SJmoPoolDetail)poolDtlList.get(0)).getPoolFixThreshold() : ((SJmoPoolDetail)poolDtlList.get(0)).getPoolThreshold());
        for (int iCnt = 0; iCnt < poolDtlList.size(); ++iCnt) {
            int lPoolUsedRate;
            SJmoPoolDetail poolDtl = (SJmoPoolDetail)poolDtlList.get(iCnt);
            if (poolDtl.getPoolKind() == 8) {
                this.disableDepThresholdText();
                return;
            }
            if (poolDtl.getSPoolThresholdMode() == SJctrPoolUtility.THRESHOLD_MODE_DEPLETION_ON) {
                if (sDefDepletionThreshold != poolDtl.getSPoolDepletionThreshold()) {
                    bDepThresholdMix = true;
                }
            } else if (this.comUtil.getPoolUtility().isSysThresChangeDepThres(poolDtl)) {
                bEnableSysThreshold = true;
                if (sDefDepletionThreshold != poolDtl.getPoolFixThreshold()) {
                    bDepThresholdMix = true;
                }
            } else if (sDefDepletionThreshold != poolDtl.getPoolThreshold()) {
                bDepThresholdMix = true;
            }
            if ((lPoolUsedRate = this.getComUtility().getPoolUtility().getPoolUsed(poolDtl)) <= iMaxPoolUsedRate) continue;
            iMaxPoolUsedRate = lPoolUsedRate;
        }
        if (iMaxPoolUsedRate > iMaxThreshold) {
            this.disableDepThresholdText();
            return;
        }
        if (iMaxPoolUsedRate > iMinThreshold) {
            iMinThreshold = iMaxPoolUsedRate;
        }
        if (!bDepThresholdMix && sDefDepletionThreshold >= iMaxPoolUsedRate && !bEnableSysThreshold) {
            strDefDepThresholdText = new String(SJctrComUtility.toDecString(sDefDepletionThreshold));
        }
        this.depThresholdTextBox.setValue(strDefDepThresholdText);
        this.depThresholdTextBox.setMin(SJctrComUtility.toDecString(iMinThreshold));
        this.depThresholdTextBox.setMax(SJctrComUtility.toDecString(iMaxThreshold));
    }

    public void disableDepThresholdText() {
        this.depThresholdTextBox.setValue("");
        this.depThresholdTextBox.setMin("");
        this.depThresholdTextBox.setMax("");
        this.depThresholdTextBox.setEnable(false);
        this.depThresholdChkBox.setEnable(false);
        this.depThresholdTextBox.clearData();
    }

    String getStrDepThreshold() {
        return this.depThresholdTextBox.getValue();
    }

    boolean getSelCheckBox() {
        return this.depThresholdChkBox.isSelect();
    }

    boolean isDepEnable() {
        boolean bRet = false;
        boolean bText = this.depThresholdTextBox.isEnable();
        boolean bChk = this.depThresholdChkBox.isEnable();
        if (bText && bChk) {
            bRet = true;
        }
        return bRet;
    }

    public void setDepletionThresholdMin(String min) {
        this.depThresholdTextBox.setMin(min);
    }

    public void setDepletionThresholdMax(String max) {
        this.depThresholdTextBox.setMax(max);
    }

    public void setDepletionThresholdValue(String value) {
        this.depThresholdTextBox.setValue(value);
    }

    public void setSelectDepletionThresholdCheckBox(boolean flg) {
        this.depThresholdChkBox.setSelect(flg);
    }
}

