/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pool.expandpool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.controller.com.SJctrAuthorizeContainer;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrMessageDataController;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.comparator.SJctrArrayGroupIndexComparator;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.pool.com.SJctrWarnPGTableDataModel;
import sanproject.sn2.controller.wizard.pool.expandpool.SJctrExpandPoolEventDriveType;
import sanproject.sn2.controller.wizard.pool.expandpool.SJctrExpandPoolEventExit;
import sanproject.sn2.controller.wizard.pool.expandpool.SJctrExpandPoolEventSelPoolVol;
import sanproject.sn2.controller.wizard.pool.expandpool.SJctrExpandPoolPoolVolSelArea;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.data.device.SJmoPdevDetail;
import sanproject.sn2.model.data.group.SJmoHDPRelationByPool;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolIndex;
import sanproject.sn2.model.data.group.SJmoPoolVolDetail;
import sanproject.sn2.model.data.group.SJmoPoolVolInfo;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolStatus;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoDCRInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevGuardInfo;
import sanproject.sn2.model.data.volume.SJmoLdevSecurityInfo;
import sanproject.sn2.model.data.volume.SJmoLdevStatusInfo;
import sanproject.sn2.model.data.volume.SJmoPgDetail;
import sanproject.sn2.model.data.volume.SJmoPgIndex;
import sanproject.sn2.model.data.volume.SJmoPgLdevInfo;
import sanproject.sn2.model.data.volume.SJmoPgScatteredInfo;
import sanproject.sn2.model.data.volume.SJmoVdevDetail;

public class SJctrExpandPoolDC
extends SJctrWizardDataController {
    public static final int DISP_ID = 0x1100221;
    public static final String KEY_POOLVOL_SELECT = "COM_POOLVOL_SELECT";
    public static final String KEY_FOOTER = "COM_FOOTER";
    public static final String KEY_CLASS_POOL_INDEX = "KEY_CLASS_POOL_INDEX";
    public static final String KEY_CLASS_EXP_POOLVOL_CAND = "KEY_CLASS_EXP_POOLVOL_CAND";
    public static final String KEY_CLASS_ADD_POOLVOL = "KEY_CLASS_ADD_POOLVOL";
    public static final String KEY_CLASS_RELATE_POOLVOL = "KEY_CLASS_RELATE_POOLVOL";
    private List<SJmoPoolDetail> m_SelPoolList = null;
    public SJctrExpandPoolPoolVolSelArea expPoolVolSelArea = null;
    private boolean checkEndFlg = true;
    private static final long[] expPoolStatusList = new long[]{4101L, 2147487750L, 1073745926L, 3221229574L, 2684358662L, 2147487746L, 1073745922L, 2684358658L, 3221229570L, 4098L};
    public static final String KEY_DISP_START = "COM_DISP_START";
    private boolean bStart = true;

    public SJctrExpandPoolDC() {
        super(0x1100221);
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        SJctrButtonDataModel dispStart = new SJctrButtonDataModel();
        dispStart.setReceiveOnly();
        this.addDataObjectModel(KEY_DISP_START, dispStart);
        dispStart.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (SJctrExpandPoolDC.this.bStart) {
                    SJctrExpandPoolDC.this.chkWarnDialog();
                    SJctrExpandPoolDC.this.bStart = false;
                }
            }
        });
        this.expPoolVolSelArea = new SJctrExpandPoolPoolVolSelArea();
        this.addDataObjectModel(KEY_POOLVOL_SELECT, this.expPoolVolSelArea);
        this.addDataObjectModel(KEY_FOOTER, new SJctrFooterDataModel());
    }

    private void initListener() {
        SJctrExpandPoolEventDriveType expEvtDrvType = new SJctrExpandPoolEventDriveType(this);
        this.addMessageEventListener(SELECT_EXP_MSG.DRIVETYPE, expEvtDrvType);
        SJctrExpandPoolEventSelPoolVol expEvtSelPoolVol = new SJctrExpandPoolEventSelPoolVol(this);
        this.addMessageEventListener(SELECT_EXP_MSG.SEL_POOLVOL, expEvtSelPoolVol);
        SJctrExpandPoolEventExit expEvtExit = new SJctrExpandPoolEventExit(this);
        this.addMessageEventListener(SJctrDialogDataController.DIALOG_MSG.EXIT, expEvtExit);
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("EXPAND_PL");
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> retSet = super.getModelDirect();
        SJctrGetDirectWrapper getDrctWrpLdevDtl = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL);
        retSet.add(getDrctWrpLdevDtl);
        SJctrGetDirectWrapper getDrctWrpLdevStat = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_LDEV_STATUS);
        retSet.add(getDrctWrpLdevStat);
        SJctrGetDirectWrapper getDrctWrpLdevSec = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_LDEV_SECURITY);
        retSet.add(getDrctWrpLdevSec);
        SJctrGetDirectWrapper getDrctWrpLdevGrd = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_LDEV_GUARD);
        retSet.add(getDrctWrpLdevGrd);
        SJctrGetDirectWrapper getDrctWrpLdevDcr = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_LDEV_DCR);
        retSet.add(getDrctWrpLdevDcr);
        SJctrGetDirectWrapper getDrctWrpPoolDtl = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL);
        retSet.add(getDrctWrpPoolDtl);
        SJctrGetDirectWrapper getDrctWrpPdevDtl = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_PDEV_DETAIL);
        retSet.add(getDrctWrpPdevDtl);
        SJctrGetDirectWrapper getDrctWrpPoolVolDtl = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_POOLVOL_DETAIL);
        retSet.add(getDrctWrpPoolVolDtl);
        SJctrGetDirectWrapper getDrctWrpClprInf = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_CLPR_INFO);
        retSet.add(getDrctWrpClprInf);
        SJctrGetDirectWrapper getDrctWrpPoolNameInf = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_POOLNAME_INFO);
        retSet.add(getDrctWrpPoolNameInf);
        SJctrGetDirectWrapper getDrctWrpLdevNameInf = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_LDEVNAME_INFO);
        retSet.add(getDrctWrpLdevNameInf);
        SJctrGetDirectWrapper getDrctWrpTiPairPVolInf = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_TIPAIR_PVOL_STATUS);
        retSet.add(getDrctWrpTiPairPVolInf);
        retSet.add(this.createModelDirect(SJctrPoolUtility.KEY_CLASS_LUSE_INFO));
        retSet.add(this.createModelDirect(SJctrPoolUtility.KEY_CLASS_HDP_RELATION));
        retSet.add(this.createModelDirect(SJctrPoolUtility.KEY_CLASS_ALL_RSG));
        retSet.add(this.createModelDirect(SJctrPoolUtility.KEY_CLASS_PG_DETAIL));
        retSet.add(this.createModelDirect(SJctrPoolUtility.KEY_CLASS_PGLDEV_INFO));
        retSet.add(this.createModelDirect(SJctrPoolUtility.KEY_CLASS_HDP_RELATION_BY_POOL));
        retSet.add(this.createModelDirect(SJctrPoolUtility.KEY_CLASS_VDEV_DETAIL));
        retSet.add(this.createModelDirect(SJctrPoolUtility.KEY_CLASS_PGSCATTERED_INF));
        retSet.add(this.createModelDirect(SJctrPoolUtility.KEY_CLASS_PG_ENC_INFO));
        return retSet;
    }

    private SJctrGetDirectWrapper createModelDirect(Class<? extends SJmoGetKind_IF> kindClass) throws SJcException {
        SJctrGetDirectWrapper getDrctWrap = null;
        try {
            SJmoGetKind_IF kind = kindClass.newInstance();
            SJmoGetRange_IF range = null;
            ArrayList search = new ArrayList();
            SJmoGetDirect getDrct = new SJmoGetDirect(kind, range, search);
            getDrctWrap = new SJctrGetDirectWrapper(getDrct);
        }
        catch (InstantiationException insExp) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "createModelDirect", "catch InstantiationException", insExp);
            SJctrError ctrErr = new SJctrError(31, 22, 107009);
            SJcException ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        catch (IllegalAccessException illExp) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "createModelDirect", "catch IllegalAccessException", illExp);
            SJctrError ctrErr = new SJctrError(31, 22, 107009);
            SJcException ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        return getDrctWrap;
    }

    @Override
    public void makeDataModel() {
        this.expPoolVolSelArea.setDriveTypeEventListner(false);
        super.makeDataModel();
        this.expPoolVolSelArea.initPoolVolSelArea();
        this.expPoolVolSelArea.setDriveTypeEventListner(true);
    }

    @Override
    public boolean checkStartData() {
        boolean bRetChk = true;
        ArrayList selPoolList = new ArrayList(this.getCache(KEY_CLASS_POOL_INDEX));
        if (null == selPoolList || 0 == selPoolList.size()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkStartData", "Select Pool is null or size 0");
            bRetChk = false;
            SJctrError ctrErr = new SJctrError(31, 22, 107008);
            SJcException ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        this.m_SelPoolList = selPoolList;
        return bRetChk;
    }

    @Override
    public boolean checkConstructData() {
        ArrayList<SJmoPdevDetail> pdevDetailList;
        boolean directMappingFlg;
        SJmoPoolVolInfo poolVolInfo;
        int iLdevDtlIdx;
        SJmoPoolVolDetail poolVolDetail;
        ArrayList poolVolInfoList;
        boolean bRetChk = true;
        int iCnt = 0;
        List<SJmoLdevDetail> poolVolCandList = new ArrayList<SJmoLdevDetail>();
        SJctrPoolUtility poolUtil = this.getComUtility().getPoolUtility();
        ArrayList poolDetailList = new ArrayList(this.getCache(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL));
        if (poolDetailList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "getPoolDetail null");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        Collections.sort(poolDetailList);
        SJmoPoolDetail selPoolDetail = this.m_SelPoolList.get(0);
        int iPoolDtlIdx = Collections.binarySearch(poolDetailList, selPoolDetail);
        if (0 > iPoolDtlIdx) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "PoolDetail not found");
            SJctrPoolUtility.SJctrErrorDialog(107023);
        }
        SJmoPoolDetail poolDetail = (SJmoPoolDetail)poolDetailList.get(iPoolDtlIdx);
        bRetChk = this.checkLicense(poolDetail);
        bRetChk = this.checkPoolStat(poolDetail);
        bRetChk = poolUtil.checkPoolVolNum(poolDetail);
        ArrayList<SJmoLdevDetail> ldevDetailList = new ArrayList<SJmoLdevDetail>(this.getCache(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL));
        if (ldevDetailList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "getLdevDetail null");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        bRetChk = poolUtil.checkLdevNum(ldevDetailList);
        for (iCnt = 0; iCnt < ldevDetailList.size(); ++iCnt) {
            try {
                SJmoLdevDetail ldevcloneData = (SJmoLdevDetail)((SJmoLdevDetail)ldevDetailList.get(iCnt)).clone();
                poolVolCandList.add(ldevcloneData);
                continue;
            }
            catch (CloneNotSupportedException e) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "LdevDetail cloneError");
                SJctrPoolUtility.SJctrErrorDialog(107007);
            }
        }
        ArrayList poolVolDetailList = new ArrayList(this.getCache(SJctrPoolUtility.KEY_CLASS_POOLVOL_DETAIL));
        if (poolVolDetailList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "getPoolVolDetail null");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        Collections.sort(poolVolDetailList);
        int iPoolVolDtlIdx = Collections.binarySearch(poolVolDetailList, poolDetail);
        if (0 > iPoolVolDtlIdx) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "PoolVolDetail not found");
            SJctrPoolUtility.SJctrErrorDialog(107023);
        }
        if ((poolVolInfoList = (poolVolDetail = (SJmoPoolVolDetail)poolVolDetailList.get(iPoolVolDtlIdx)).getAlPoolInfo()) == null || 0 >= poolVolInfoList.size()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "getPoolVolInfo null");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        if (0 > (iLdevDtlIdx = Collections.binarySearch(ldevDetailList, poolVolInfo = (SJmoPoolVolInfo)poolVolInfoList.get(0)))) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "LdevDetail not found");
            SJctrPoolUtility.SJctrErrorDialog(107023);
        }
        SJmoLdevDetail ldevDetail = (SJmoLdevDetail)ldevDetailList.get(iLdevDtlIdx);
        ArrayList allRsgsList = new ArrayList(this.getCache(SJctrPoolUtility.KEY_CLASS_ALL_RSG));
        if (0 < allRsgsList.size()) {
            poolVolCandList = SJctrPoolUtility.extractRsgLdevList(ldevDetail, poolVolCandList, this.getOwner(), (SJmoRSGgetAllRsgs)allRsgsList.get(0));
            bRetChk = poolUtil.checkPoolVolCand(poolVolCandList);
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "SJmoRSGgetAllRsgs error");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        bRetChk = poolUtil.checkLdevsize(poolVolCandList);
        bRetChk = poolUtil.checkVvol(poolVolCandList);
        bRetChk = poolUtil.checkEmulationType(poolVolCandList);
        poolVolCandList = poolUtil.checkRaidLevel(poolVolCandList);
        bRetChk = poolUtil.checkPoolVol(poolVolCandList);
        bRetChk = poolUtil.checkCmdDev(poolVolCandList);
        bRetChk = poolUtil.checkHIHSMReserve(poolVolCandList);
        bRetChk = poolUtil.checkJNLVolume(poolVolCandList);
        bRetChk = poolUtil.checkSystemDisk(poolVolCandList);
        bRetChk = poolUtil.checkLockVolume(poolVolCandList);
        bRetChk = poolUtil.checkLUPathNum(poolVolCandList);
        bRetChk = poolUtil.checkODMSetting(poolVolCandList);
        ArrayList<SJmoLdevStatusInfo> ldevStatuslList = new ArrayList<SJmoLdevStatusInfo>(this.getCache(SJctrPoolUtility.KEY_CLASS_LDEV_STATUS));
        if (ldevStatuslList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "getLdevStatusInfo null");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        bRetChk = poolUtil.checkLdevStatus(poolVolCandList, ldevStatuslList);
        ArrayList<SJmoLdevGuardInfo> ldevGuardList = new ArrayList<SJmoLdevGuardInfo>(this.getCache(SJctrPoolUtility.KEY_CLASS_LDEV_GUARD));
        if (ldevGuardList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "getLdevGuard null");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        bRetChk = poolUtil.checkLdevGuardStatus(poolVolCandList, ldevGuardList);
        ArrayList<SJmoDCRInfo> dcrList = new ArrayList<SJmoDCRInfo>(this.getCache(SJctrPoolUtility.KEY_CLASS_LDEV_DCR));
        if (dcrList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "getLdevGuard null");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        bRetChk = poolUtil.checkDCR(poolVolCandList, dcrList);
        ArrayList<SJmoLdevSecurityInfo> ldevSecurityList = new ArrayList<SJmoLdevSecurityInfo>(this.getCache(SJctrPoolUtility.KEY_CLASS_LDEV_SECURITY));
        if (ldevSecurityList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "getLdevSecurity null");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        bRetChk = poolUtil.checkLdevSecurity(poolVolCandList, ldevSecurityList);
        ArrayList<ArrayList<SJmoLdevDetail>> sysTypePoolVolCandList = poolUtil.makeSysTypePoolVolCandList(poolVolCandList);
        if (poolDetail.getEmulationType() == 1) {
            poolVolCandList = sysTypePoolVolCandList.get(1);
        } else if (poolDetail.getEmulationType() == 0) {
            poolVolCandList = sysTypePoolVolCandList.get(0);
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "Pool EmulationType Error");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        boolean bl = directMappingFlg = 0L != (poolDetail.getLPoolOptionFlag() & 0x20000000L);
        if (!directMappingFlg) {
            poolVolCandList = poolUtil.getNoDmAttributeList(poolVolCandList);
        }
        poolUtil.checkPoolVolCand(poolVolCandList);
        List<SJmoPgDetail> pgDetailList = this.getCache(SJctrPoolUtility.KEY_CLASS_PG_DETAIL);
        List<SJmoPgLdevInfo> pgLdevInfoList = this.getCache(SJctrPoolUtility.KEY_CLASS_PGLDEV_INFO);
        List<SJmoPgIndex> UnusableNfPgList = poolUtil.checkUnusableNfCompressionPg(poolDetail, ldevDetailList, pgDetailList, pgLdevInfoList);
        poolVolCandList = poolUtil.checkUnusableNfVolume(UnusableNfPgList, poolVolCandList);
        List<SJmoHDPRelationByPool> hdpRelationByPoolList = this.getCache(SJctrPoolUtility.KEY_CLASS_HDP_RELATION_BY_POOL);
        poolVolCandList = poolUtil.checkFullAllocationDpVolume(poolDetail, hdpRelationByPoolList, poolVolCandList);
        if (poolDetail.getPoolKind() == 8) {
            SJmoLdevDetail extVolInfo = this.getSelPoolTopExtVolInfo(ldevDetailList, poolVolInfoList);
            if (null != extVolInfo) {
                bRetChk = poolUtil.checkCacheMode(poolVolCandList, extVolInfo.getbCasheMode());
            } else {
                poolUtil.removeExternalCacheOff(poolVolCandList);
                poolUtil.checkPoolVolCand(poolVolCandList);
            }
        }
        if ((pdevDetailList = new ArrayList<SJmoPdevDetail>(this.getCache(SJctrPoolUtility.KEY_CLASS_PDEV_DETAIL))) == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "getPdevDetail null");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        Collections.sort(pdevDetailList, new SJctrArrayGroupIndexComparator());
        this.createEXPBasicData(poolDetail, poolVolCandList, pdevDetailList, poolVolDetail);
        this.checkEXPTier(poolDetail);
        SJctrCapacityUtility util = this.getComUtility().getCapacityUtility();
        if (SJctrPoolUtility.isMainframePool(poolDetail)) {
            this.setUnitSelect(util.getUnitString(SJctrCapacityUtility.UNIT.CYL));
        } else {
            SJctrCapacityUtility.UNIT unitDefaultUnitSelect = SJctrCapacityUtility.UNIT.valueOf(this.getTopWizard().getParentDC().getUnitSelect());
            if (unitDefaultUnitSelect.equals((Object)SJctrCapacityUtility.UNIT.PAGE)) {
                this.setUnitSelect(util.getUnitString(SJctrCapacityUtility.UNIT.GB));
            }
        }
        return bRetChk;
    }

    private boolean checkLicense(SJmoPoolDetail poolDetail) {
        boolean bLicense = true;
        SJctrAuthorizeContainer authCtnr = this.getOwner().getAuthorizeContainer();
        SJctrLicenseContainer lcnsCtnr = authCtnr.getLisenceContainer();
        int iEmu = poolDetail.getEmulationType();
        if (2 == poolDetail.getPoolKind() && 0 == iEmu) {
            List<SJmoTiPvolStatus> tiPVolStatusList;
            SJctrPoolUtility poolUtil;
            if (!lcnsCtnr.checkPP(SJctrLicenseContainer.PPID_DP)) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkLicense", "License Error Dynamic Provisioning");
                SJctrPoolUtility.SJctrErrorDialog(106078);
            }
            if (!lcnsCtnr.checkPP(SJctrLicenseContainer.PPID_DSS) && (poolUtil = this.getComUtility().getPoolUtility()).checkTIPairExistsInPool(poolDetail, tiPVolStatusList = this.getCache(SJctrPoolUtility.KEY_CLASS_TIPAIR_PVOL_STATUS))) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkLicense", "License Error Thin Image TI pair In DP-Pool");
                SJctrPoolUtility.SJctrErrorDialog(206332);
            }
            if ((poolDetail.getITierControlInfo() & 0x80) != 0) {
                boolean hrtFlg;
                if (!lcnsCtnr.checkPP(SJctrLicenseContainer.PPID_HDTPM)) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "checkLicense", "License Error HDTPM");
                    SJctrPoolUtility.SJctrErrorDialog(106078);
                }
                boolean bl = hrtFlg = 144 == (poolDetail.getITierControlInfo() & 0x90);
                if (hrtFlg && !lcnsCtnr.checkPP(SJctrLicenseContainer.PPID_HRT)) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "checkLicense", "License Error HRT");
                    SJctrPoolUtility.SJctrErrorDialog(106078);
                }
            }
        } else if (2 == poolDetail.getPoolKind() && 1 == iEmu) {
            if (!lcnsCtnr.checkPP(SJctrLicenseContainer.PPID_DPFM)) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkLicense", "License Error Mainframe Dynamic Provisioning");
                SJctrPoolUtility.SJctrErrorDialog(106078);
            }
            if ((poolDetail.getITierControlInfo() & 0x80) != 0 && !lcnsCtnr.checkPP(SJctrLicenseContainer.PPID_MFDT)) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkLicense", "License Error MFDT");
                SJctrPoolUtility.SJctrErrorDialog(106078);
            }
        } else if (poolDetail.getPoolKind() == 8) {
            if (!lcnsCtnr.checkPP(SJctrLicenseContainer.PPID_DSS)) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkLicense", "License Error Thin Image");
                SJctrPoolUtility.SJctrErrorDialog(106078);
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkLicense", "Unknown Pool Kind");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        return bLicense;
    }

    private boolean checkPoolStat(SJmoPoolDetail poolDetail) {
        boolean bResult = false;
        int iErrorCode = 107007;
        int iCnt = 0;
        long lPoolStat = poolDetail.getPoolStatus();
        for (iCnt = 0; iCnt < expPoolStatusList.length; ++iCnt) {
            if (expPoolStatusList[iCnt] != lPoolStat) continue;
            bResult = true;
            break;
        }
        if (!bResult) {
            iErrorCode = this.getErrorCode(lPoolStat);
            SJctrPoolUtility.SJctrErrorDialog(iErrorCode);
        }
        return bResult;
    }

    private boolean checkEXPTier(SJmoPoolDetail poolDetail) {
        List<Object> poolVolCandDataList = new ArrayList();
        HashMap pvDriveTypeKeyMap = null;
        HashMap tierDriveTypeKeyMap = null;
        List<Object> driveKeyList = new ArrayList();
        boolean bRtn = false;
        poolVolCandDataList = this.getCache(KEY_CLASS_EXP_POOLVOL_CAND);
        tierDriveTypeKeyMap = this.getComUtility().getPoolUtility().createDriveTypeRpmMap(poolDetail);
        pvDriveTypeKeyMap = (HashMap)poolVolCandDataList.get(0);
        driveKeyList = this.getComUtility().getPoolUtility().getAllMapkey(pvDriveTypeKeyMap);
        if (driveKeyList != null && driveKeyList.size() != 0) {
            bRtn = true;
        }
        if (!bRtn) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkEXPTier", "MasterData is not Exist");
            SJctrPoolUtility.SJctrErrorDialog(106006);
        }
        this.putCache(KEY_CLASS_EXP_POOLVOL_CAND, poolVolCandDataList);
        return bRtn;
    }

    private void chkWarnDialog() {
        SJmoPoolIndex poolIndex = this.m_SelPoolList.get(0);
        List<?> poolDtlList = this.getCache(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL);
        int searchPool = Collections.binarySearch(poolDtlList, poolIndex);
        if (searchPool < 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "chkWarnDialog", "PoolDetail is not Find");
            return;
        }
        SJmoPoolDetail poolDtl = (SJmoPoolDetail)poolDtlList.get(searchPool);
        List<SJmoPoolVolDetail> poolVolDtlList = this.getCache(SJctrPoolUtility.KEY_CLASS_POOLVOL_DETAIL);
        List<SJmoLdevDetail> ldevDtlList = this.getCache(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL);
        List<SJmoPgDetail> pgDtlLst = this.getCache(SJctrPoolUtility.KEY_CLASS_PG_DETAIL);
        List<SJmoVdevDetail> vdevDtlList = this.getCache(SJctrPoolUtility.KEY_CLASS_VDEV_DETAIL);
        List<SJmoPgScatteredInfo> pgScatteredInfoList = this.getCache(SJctrPoolUtility.KEY_CLASS_PGSCATTERED_INF);
        if (!SJctrPoolUtility.hasNF2KPGPoolVol(poolDtl, poolVolDtlList, ldevDtlList)) {
            return;
        }
        Map<SJmoPgDetail, List<SJmoPoolVolInfo>> pgPoolVolMap = SJctrPoolUtility.makePGPoolVolMap(poolDtl, poolVolDtlList, ldevDtlList, pgDtlLst, pgScatteredInfoList);
        ArrayList<SJmoPgDetail> pgDtlList = new ArrayList<SJmoPgDetail>(pgPoolVolMap.keySet());
        Collections.sort(pgDtlList);
        ArrayList<SJctrErrorColumnData> errcolmnDataList = new ArrayList<SJctrErrorColumnData>(pgDtlList.size());
        for (SJmoPgDetail pgDtl : pgDtlList) {
            if (!SJctrPoolUtility.checkNF2KPG(pgDtl)) continue;
            List<SJmoPoolVolInfo> poolVolInfoList = pgPoolVolMap.get(pgDtl);
            List<SJmoVdevDetail> scVdevDtlList = SJctrPoolUtility.getScatteredVdevDtlList(pgDtl, vdevDtlList, pgScatteredInfoList);
            if (SJctrPoolUtility.checkPGExpantionRate(poolDtl, scVdevDtlList, poolVolInfoList)) continue;
            SJctrError err = new SJctrError(31, 22, 209017);
            SJctrErrorColumnData errcolumn = new SJctrErrorColumnData(pgDtl, err);
            errcolmnDataList.add(errcolumn);
        }
        if (!errcolmnDataList.isEmpty()) {
            this.makeWarnDialog(errcolmnDataList, pgPoolVolMap);
        }
    }

    private void makeWarnDialog(List<SJctrErrorColumnData> errcolmnDataList, Map<SJmoPgDetail, List<SJmoPoolVolInfo>> pgPoolVolMap) {
        String strFuncID = Integer.toString(31);
        String strModuleID = Integer.toString(22);
        String strMsgID = Integer.toString(209016);
        SJcMessage msg = new SJcMessage(strFuncID, strModuleID, strMsgID);
        SJctrRelatedDispDataObject related = this.createMsgDialog(msg);
        SJctrUserController uc = this.getOwner();
        SJctrMessageDataController msgDC = (SJctrMessageDataController)uc.getDataController(related);
        ArrayList<Comparable> primaryKeyList = new ArrayList<Comparable>(errcolmnDataList.size());
        for (SJctrErrorColumnData errcolumn : errcolmnDataList) {
            primaryKeyList.add(errcolumn.getKeyObj());
        }
        SJctrWarnPGTableDataModel table = new SJctrWarnPGTableDataModel();
        table.setPrimaryKeyData(primaryKeyList);
        List<?> poolDtlList = this.getCache(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL);
        table.setBasicData(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL, poolDtlList);
        ArrayList<Map<SJmoPgDetail, List<SJmoPoolVolInfo>>> pgPoolVolMapList = new ArrayList<Map<SJmoPgDetail, List<SJmoPoolVolInfo>>>();
        pgPoolVolMapList.add(pgPoolVolMap);
        table.setBasicData(SJctrPoolUtility.KEY_PG_POOLVOL, pgPoolVolMapList);
        List<?> vdevDtlList = this.getCache(SJctrPoolUtility.KEY_CLASS_VDEV_DETAIL);
        table.setBasicData(SJctrPoolUtility.KEY_CLASS_VDEV_DETAIL, vdevDtlList);
        List<?> pgScatteredInfoList = this.getCache(SJctrPoolUtility.KEY_CLASS_PGSCATTERED_INF);
        table.setBasicData(SJctrPoolUtility.KEY_CLASS_PGSCATTERED_INF, pgScatteredInfoList);
        table.setDataController(this);
        table.initGuidance(this.getOwner().getComUtility());
        table.makeDataModel();
        msgDC.setErrColumnTableParam(table.getTableTitle(), table.getAlignRightColumnList(), table, errcolmnDataList);
        this.addUpdateDisp(related);
    }

    private int getErrorCode(long lPoolStatus) {
        int iErrorCode = 107007;
        long lPoolStatusValue = 0L;
        lPoolStatusValue = lPoolStatus & 0xFFFFL;
        if ((lPoolStatus & 0x800000L) != 0L) {
            iErrorCode = 106028;
        }
        if ((lPoolStatus & 0x10000L) != 0L) {
            iErrorCode = 106026;
        }
        if (lPoolStatusValue == 4096L) {
            iErrorCode = 106025;
        } else if (lPoolStatusValue == 4097L) {
            iErrorCode = 106024;
        }
        SJctrLogUty.warn(this.getClass().getSimpleName(), "getErrorCode", "Pool Status Error:" + lPoolStatus);
        return iErrorCode;
    }

    public void createEXPBasicData(SJmoPoolDetail selPoolDetail, List<SJmoLdevDetail> poolVolCandList, List<SJmoPdevDetail> pdevDetailList, SJmoPoolVolDetail selPoolVolDetail) {
        int iCnt = 0;
        ArrayList<HashMap> poolVolCandDataList = new ArrayList<HashMap>();
        HashMap driveKeyMap = new HashMap();
        HashMap checkDriveKeyMap = new HashMap();
        List<Object> checkRaidLevKeyMapList = new ArrayList();
        HashMap checkRaidLevKeyMap = new HashMap();
        List checkPoolVolCandList = new ArrayList();
        ArrayList checkAllPoolVolCandList = new ArrayList();
        ArrayList<SJmoPoolDetail> selectPoolDetail = new ArrayList<SJmoPoolDetail>();
        selectPoolDetail.add(selPoolDetail);
        this.putCache(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL, selectPoolDetail);
        poolVolCandDataList.add(driveKeyMap);
        this.getComUtility().getPoolUtility().createBasicData(poolVolCandDataList, poolVolCandList, pdevDetailList, this.getComUtility());
        try {
            checkDriveKeyMap = this.getComUtility().getPoolUtility().getMapFromList(poolVolCandDataList);
            checkRaidLevKeyMapList = this.getComUtility().getPoolUtility().getAllMapFromMap(checkDriveKeyMap);
            for (iCnt = 0; iCnt < checkRaidLevKeyMapList.size(); ++iCnt) {
                checkRaidLevKeyMap = (HashMap)checkRaidLevKeyMapList.get(iCnt);
                checkPoolVolCandList = this.getComUtility().getPoolUtility().getAllListFromMap(checkRaidLevKeyMap);
                checkAllPoolVolCandList.addAll(checkPoolVolCandList);
                if (checkAllPoolVolCandList.size() == 0) {
                    continue;
                }
                break;
            }
        }
        catch (SJcException exception) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "createCPBasicData", "MasterData is not Exist");
            SJctrPoolUtility.SJctrErrorDialog(106006);
        }
        this.putCache(KEY_CLASS_EXP_POOLVOL_CAND, poolVolCandDataList);
        ArrayList selectPoolVolDataList = new ArrayList();
        this.putCache("KEY_CLASS_SELECT_POOLVOL", selectPoolVolDataList);
        ArrayList<SJmoPoolVolDetail> addPoolVolDataList = new ArrayList<SJmoPoolVolDetail>();
        SJmoPoolVolDetail poolVolDetail = new SJmoPoolVolDetail();
        poolVolDetail.setPoolId(selPoolDetail.getPoolId());
        addPoolVolDataList.add(poolVolDetail);
        this.putCache(KEY_CLASS_ADD_POOLVOL, addPoolVolDataList);
        ArrayList<SJmoPoolVolDetail> relatePoolVolDataList = new ArrayList<SJmoPoolVolDetail>();
        relatePoolVolDataList.add(selPoolVolDetail);
        this.putCache(KEY_CLASS_RELATE_POOLVOL, relatePoolVolDataList);
    }

    @Override
    public boolean checkEndData() {
        ArrayList selectPoolVolDataList;
        boolean bRetChk = true;
        if (this.checkEndFlg && (null == (selectPoolVolDataList = new ArrayList(this.getCache("KEY_CLASS_SELECT_POOLVOL"))) || 0 >= selectPoolVolDataList.size())) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkEndData", "Not select Poolvol");
            SJctrPoolUtility.SJctrErrorDialog(106008);
        }
        return bRetChk;
    }

    public SJctrRelatedDispDataObject createDialogFromEXP(Class<? extends SJctrDialogDataController> dialog, Map<String, List<?>> param) {
        SJctrRelatedDispDataObject relDispObj = this.createDialog(dialog, param);
        return relDispObj;
    }

    public void addUpdateDispFromEXP(SJctrRelatedDispDataObject related) {
        this.addUpdateDisp(related);
    }

    SJctrComUtility getComUty() {
        return this.getComUtility();
    }

    private SJmoLdevDetail getSelPoolTopExtVolInfo(List<SJmoLdevDetail> ldevDtlList, List selPoolVolList) {
        SJmoLdevDetail extVolInfo = null;
        for (int iCnt = 0; iCnt < selPoolVolList.size(); ++iCnt) {
            SJmoPoolVolInfo poolVolInfo = (SJmoPoolVolInfo)selPoolVolList.get(iCnt);
            int iLdevIdx = Collections.binarySearch(ldevDtlList, poolVolInfo);
            if (0 > iLdevIdx) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "getSelPoolTopExtVolInfo", "LDEV Deatil not found");
                SJctrPoolUtility.SJctrErrorDialog(107023);
            }
            if (ldevDtlList.get(iLdevIdx).getByVolumeType() != 1) continue;
            extVolInfo = ldevDtlList.get(iLdevIdx);
            break;
        }
        return extVolInfo;
    }

    @Override
    public boolean checkFinishData(final SJctrMessageEvent msgEvent, final SJctrDataObjectModel<?> dstModel) {
        boolean bReturn = false;
        this.checkEndFlg = true;
        if (this.checkEndFlg) {
            this.checkEndData();
            this.checkEndFlg = false;
        }
        SJctrPoolUtility poolUtil = this.getComUtility().getPoolUtility();
        ArrayList poolDetailList = new ArrayList(this.getCache(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL));
        if (poolDetailList == null || poolDetailList.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkFinishData", "poolDetailList null");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        SJmoPoolDetail poolDetail = (SJmoPoolDetail)poolDetailList.get(0);
        poolDetail.setbEnableVirtMode(this.expPoolVolSelArea.getCapExpPGChkBox());
        poolDetailList.set(0, poolDetail);
        this.putCache(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL, poolDetailList);
        if (poolDetail.getPoolKind() == 2 && (poolDetail.getITierControlInfo() & 0x80) != 0 && !this.checkEndFlg) {
            SJcMessage msg = SJctrPoolUtility.getWarningMsg(31, 22, 106169);
            SJctrRelatedDispDataObject related = this.createMsgDialog(msg);
            SJctrUserController uc = this.getOwner();
            SJctrMessageDataController msgDC = (SJctrMessageDataController)uc.getDataController(related);
            msgDC.addButton(SJctrMessageDataController.MD_OK, new SJctrItemSelectListener(){

                @Override
                public void selectChanged(SJctrItemSelectEvent<?> event) {
                    SJctrExpandPoolDC.this.finishEvent(msgEvent, dstModel);
                }
            });
            this.addUpdateDisp(related);
            bReturn = true;
        }
        return bReturn;
    }

    public static enum SELECT_EXP_MSG implements SJctrNotifyState
    {
        DRIVETYPE,
        SEL_POOLVOL;

    }
}

