/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pool.shrinkpool;

import java.util.ArrayList;
import java.util.List;
import sanproject.common.Robj_interface_AOUShrinkPoolData;
import sanproject.common.Robj_interface_POOLInfoDetailSx;
import sanproject.common.Robj_interface_QSPoolVolData;
import sanproject.common.Robj_interface_SetAOUShrinkPool;
import sanproject.serverux.dataimpl.AOUShrinkPoolData;
import sanproject.serverux.dataimpl.POOLInfoDetail5;
import sanproject.serverux.dataimpl.POOLgetAllPoolInfoEx;
import sanproject.serverux.dataimpl.POOLgetAllPoolInfoEx_IN;
import sanproject.serverux.dataimpl.POOLgetAllPoolInfoEx_OUT;
import sanproject.serverux.dataimpl.QSPoolVolData;
import sanproject.serverux.dataimpl.SetAOUShrinkPool;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.wizard.pool.com.SJctrPoolError;
import sanproject.sn2.model.SJmoException;
import sanproject.sn2.model.SJmoGetAgent;
import sanproject.sn2.model.SJmoModelMgr;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetThroughRmiData;
import sanproject.sn2.model.data.SJmoThroughRmiData;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolIndex;
import sanproject.sn2.model.data.group.SJmoPoolVolInfo;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrShrinkPoolAC
extends SJctrApplyController {
    private ArrayList<SJmoPoolDetail> shkPoolDtlList = null;
    private ArrayList<SJmoPoolVolInfo> shkPoolVolInfList = null;
    private ArrayList<?> VVOLList = null;
    public static final long SET_KIND_SHRINK = 1L;
    private Robj_interface_SetAOUShrinkPool shrinkRst = null;
    private int iPoolTopErr = 0;
    private int iPoolVolTopErr = 0;
    private boolean bStopAsyncWatchFlg = false;
    private int WATCH_WAIT_INTERVAL = 60000;
    private int ERR_HIC_CONNECT_1 = 58575;
    private int ERR_HIC_CONNECT_2 = 58576;

    public void setApplyList(ArrayList<SJmoPoolDetail> poolDtlList, ArrayList<SJmoPoolVolInfo> poolVolInfList, ArrayList<?> poolVVolList) {
        this.shkPoolDtlList = poolDtlList;
        this.shkPoolVolInfList = poolVolInfList;
        this.VVOLList = poolVVolList;
    }

    @Override
    public ArrayList<?> getSetList() {
        Robj_interface_AOUShrinkPoolData[] aouShrkPooldt;
        SetAOUShrinkPool setAOUShrkPool;
        ArrayList<SetAOUShrinkPool> applyList = new ArrayList<SetAOUShrinkPool>();
        if (null != this.shkPoolDtlList && 0 != this.shkPoolDtlList.size() && null != this.shkPoolVolInfList && 0 != this.shkPoolVolInfList.size()) {
            setAOUShrkPool = new SetAOUShrinkPool();
            aouShrkPooldt = new Robj_interface_AOUShrinkPoolData[this.shkPoolDtlList.size()];
            Robj_interface_QSPoolVolData[] qsPoolVoldt = new Robj_interface_QSPoolVolData[this.shkPoolVolInfList.size()];
            setAOUShrkPool.setLComannd(1L);
            for (int iSPCnt = 0; iSPCnt < this.shkPoolDtlList.size(); ++iSPCnt) {
                SJmoPoolDetail poolDtl = this.shkPoolDtlList.get(iSPCnt);
                aouShrkPooldt[iSPCnt] = new AOUShrinkPoolData();
                aouShrkPooldt[iSPCnt].setSPoolId((short)poolDtl.getPoolId());
                for (int iSPVolCnt = 0; iSPVolCnt < this.shkPoolVolInfList.size(); ++iSPVolCnt) {
                    SJmoPoolVolInfo poolVolInf = this.shkPoolVolInfList.get(iSPVolCnt);
                    qsPoolVoldt[iSPVolCnt] = new QSPoolVolData();
                    qsPoolVoldt[iSPVolCnt].setSLDKC(poolVolInf.getSLdkc());
                    qsPoolVoldt[iSPVolCnt].setSCU(poolVolInf.getSCu());
                    qsPoolVoldt[iSPVolCnt].setSLDEV(poolVolInf.getSLdev());
                }
                aouShrkPooldt[iSPCnt].setObjPoolVolData(qsPoolVoldt);
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getSetList", "PoolDetail or PoolVolInfo is null or size 0");
            SJctrError ctrErr = new SJctrError(31, 22, 107007);
            SJcException ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        setAOUShrkPool.setObjPoolData(aouShrkPooldt);
        applyList.add(setAOUShrkPool);
        return applyList;
    }

    @Override
    protected void setApplyResult(Object resultObject) {
        ArrayList<Object> rstList = null;
        if (null == resultObject) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "setApplyResult", "The parameter is illegal.");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        if (resultObject instanceof List) {
            rstList = (ArrayList<Object>)resultObject;
        } else {
            rstList = new ArrayList<Object>();
            rstList.add(resultObject);
        }
        for (int iCnt = 0; iCnt < rstList.size(); ++iCnt) {
            if (null != rstList.get(iCnt) && rstList.get(iCnt) instanceof Robj_interface_SetAOUShrinkPool) {
                this.shrinkRst = (Robj_interface_SetAOUShrinkPool)rstList.get(iCnt);
                continue;
            }
            SJctrLogUty.warn(this.getClass().getSimpleName(), "setApplyResult", "The element in the list is illegal.");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
    }

    @Override
    protected List<List<SJctrError>> getResultDataEx() {
        ArrayList<List<SJctrError>> shrinkErrList = new ArrayList<List<SJctrError>>();
        int iTopErrCode = 0;
        if (null == this.shrinkRst || null == this.shrinkRst.getObjPoolData() || this.shrinkRst.getObjPoolData().length == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getResultDataEx", "The ApplyResult is illegal.");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        Robj_interface_AOUShrinkPoolData[] shrinkRstData = this.shrinkRst.getObjPoolData();
        List<SJctrError> poolErrList = this.getPoolError(shrinkRstData);
        shrinkErrList.add(poolErrList);
        for (int iCnt = 0; iCnt < shrinkRstData.length; ++iCnt) {
            if (null != shrinkRstData[iCnt].getObjPoolVolData() && shrinkRstData[iCnt].getObjPoolVolData().length != 0) {
                List<SJctrError> poolVolErrList = this.getPoolVolError(shrinkRstData[iCnt].getObjPoolVolData());
                shrinkErrList.add(poolVolErrList);
                continue;
            }
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getResultDataEx", "The element in the array is illegal.");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        if (this.iPoolTopErr == 0 && this.iPoolVolTopErr == 0) {
            super.setApplyResult(shrinkErrList);
        } else {
            iTopErrCode = this.iPoolTopErr != 0 ? this.iPoolTopErr : this.iPoolVolTopErr;
            SJctrError topErr = new SJctrError(31, 22, iTopErrCode);
            this.setError(topErr);
        }
        return shrinkErrList;
    }

    @Override
    public int getLeadTime() {
        boolean shkSystemPoolFlg = false;
        int iLeadTime = (int)(45.0 + (double)this.VVOLList.size() * 0.25 + (double)this.shkPoolVolInfList.size() * 0.2 + (double)this.getShrinkTime());
        for (int index = 0; index < this.shkPoolVolInfList.size(); ++index) {
            SJmoPoolVolInfo shkPoolVolInf = this.shkPoolVolInfList.get(index);
            if (!shkPoolVolInf.isHeadPoolVol()) continue;
            shkSystemPoolFlg = true;
            break;
        }
        if (shkSystemPoolFlg) {
            iLeadTime += this.getSystemPoolVolShrinkTime();
        }
        return iLeadTime;
    }

    private List<SJctrError> getPoolError(Robj_interface_AOUShrinkPoolData[] poolErr) {
        ArrayList<SJctrError> poolErrList = new ArrayList<SJctrError>();
        for (int iCnt = 0; iCnt < poolErr.length; ++iCnt) {
            if (null != poolErr[iCnt]) {
                if (poolErr[iCnt].getLErrorCode() == 0L) continue;
                if (this.iPoolTopErr == 0) {
                    this.iPoolTopErr = 106061;
                }
                SJctrPoolError poolIndexErr = new SJctrPoolError(30, 5, (int)poolErr[iCnt].getLErrorCode());
                SJmoPoolIndex poolIdx = new SJmoPoolIndex();
                poolIdx.setPoolId(poolErr[iCnt].getSPoolId());
                poolIndexErr.setkeyData(poolIdx);
                poolIndexErr.setStrAssignTableKey("COM_TABLE_SHRINKRSLT");
                poolErrList.add(poolIndexErr);
                continue;
            }
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getPoolError", "The array element is null.");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        return poolErrList;
    }

    private List<SJctrError> getPoolVolError(Robj_interface_QSPoolVolData[] poolVolErr) {
        ArrayList<SJctrError> poolVolErrList = new ArrayList<SJctrError>();
        for (int iCnt = 0; iCnt < poolVolErr.length; ++iCnt) {
            if (null != poolVolErr[iCnt]) {
                if (poolVolErr[iCnt].getLErrorCode() == 0L) continue;
                if (this.iPoolVolTopErr == 0) {
                    this.iPoolVolTopErr = 106061;
                }
                SJctrPoolError ldevIndexErr = new SJctrPoolError(30, 5, (int)poolVolErr[iCnt].getLErrorCode());
                SJmoLdevIndex ldIdx = new SJmoLdevIndex();
                ldIdx.setLdevIndex(poolVolErr[iCnt].getSLDKC(), poolVolErr[iCnt].getSCU(), poolVolErr[iCnt].getSLDEV());
                ldevIndexErr.setkeyData(ldIdx);
                ldevIndexErr.setStrAssignTableKey("COM_TABLE_POOLVOLUMES");
                poolVolErrList.add(ldevIndexErr);
                continue;
            }
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getPoolVolError", "The array element is null.");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        return poolVolErrList;
    }

    @Override
    public boolean hasApplyResult() {
        return true;
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public boolean isShrink() {
        return true;
    }

    @Override
    public void stopMonitor() {
        this.bStopAsyncWatchFlg = true;
    }

    @Override
    public SJctrError monitorBackground() {
        int iError;
        SJctrError result;
        block7: {
            POOLInfoDetail5 poolInfoDetail;
            result = null;
            Class[] refArgs = new Class[]{};
            Object[] refParam = new Object[]{};
            SJmoGetDirect direct = null;
            ArrayList<SJmoGetDirect> directList = new ArrayList<SJmoGetDirect>();
            List getDataList = new ArrayList();
            long lPoolStatus = 0L;
            int iProgress = 0;
            iError = 0;
            SJcMessage msg = null;
            boolean bResult = true;
            result = new SJctrError(31, 22, 0);
            SJctrLogUty.warn(this.getClass().getSimpleName(), "monitorBackground", "ShrinkPool Async Watch Start!!  PoolID:" + this.shkPoolDtlList.get(0).getPoolId());
            this.changeDispApplyResult(false);
            SJctrGetAllPoolInfoEx kind = new SJctrGetAllPoolInfoEx();
            SJmoGetRange_IF range = null;
            ArrayList filterList = new ArrayList();
            direct = new SJmoGetDirect(kind, range, filterList);
            directList.add(direct);
            while (true) {
                if (this.isPauseMonitor()) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "monitorBackground", "StopMonitor publish");
                    result = new SJctrError(31, 22, -1);
                    break block7;
                }
                try {
                    Thread.sleep(this.WATCH_WAIT_INTERVAL);
                }
                catch (Exception ex) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "monitorBackground", "Sleep failed");
                    result = new SJctrError(31, 22, 107007);
                    break block7;
                }
                try {
                    getDataList = this.getRmiDataList(directList);
                }
                catch (SJmoException modelExcep) {
                    msg = modelExcep.getMsg();
                    bResult = SJctrComUtility.checkSVPException(modelExcep);
                    if (bResult || (bResult = this.checkConnectError(msg.getFunctionID(), msg.getModuleID(), msg.getMsgID()))) continue;
                    throw modelExcep;
                }
                POOLgetAllPoolInfoEx_OUT outPut = (POOLgetAllPoolInfoEx_OUT)getDataList.get(0);
                POOLgetAllPoolInfoEx allPoolInfo = (POOLgetAllPoolInfoEx)outPut.getDataObject();
                poolInfoDetail = this.getPoolInfoDetail(allPoolInfo);
                if (poolInfoDetail == null) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "monitorBackground", "Pool is deleted or Data is not found");
                    this.setProgress(100);
                    break block7;
                }
                lPoolStatus = poolInfoDetail.getLPoolStatus();
                if ((lPoolStatus & 0x800000L) == 0L) break;
                iProgress = (int)poolInfoDetail.getByShrinkProgress();
                this.setProgress(iProgress);
            }
            iError = (int)poolInfoDetail.getByShrinkResult();
            iError = iError == 0 ? 0 : (int)poolInfoDetail.getLShrinkError();
            result = new SJctrError(30, 5, iError);
            this.setProgress(100);
        }
        SJctrLogUty.warn(this.getClass().getSimpleName(), "monitorBackground", "ShrinkPool Async Watch End!!  PoolID:" + this.shkPoolDtlList.get(0).getPoolId() + " Result:" + iError);
        return result;
    }

    public SJmoGetDirect createRmiData(String getStr, Class[] refArgs, Object[] refParam) {
        SJmoGetDirect direct = null;
        SJmoGetThroughRmiData kind = new SJmoGetThroughRmiData(getStr, refArgs, refParam);
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        return direct;
    }

    public List getRmiDataList(List directList) {
        ArrayList<Object> rmiDataList = new ArrayList<Object>();
        SJmoGetAgent agent = null;
        List throughRmiDataListList = new ArrayList();
        List throughRmiDataList = new ArrayList();
        SJmoThroughRmiData throughRmi = null;
        Object rmiDataObj = null;
        int iCnt = 0;
        agent = SJmoModelMgr.getModelMgr().getDataAgent();
        throughRmiDataListList = agent.getDataInf(directList);
        throughRmiDataList = (List)throughRmiDataListList.get(0);
        for (iCnt = 0; iCnt < throughRmiDataList.size(); ++iCnt) {
            throughRmi = (SJmoThroughRmiData)throughRmiDataList.get(iCnt);
            rmiDataObj = throughRmi.getObjRmi();
            rmiDataList.add(rmiDataObj);
        }
        return rmiDataList;
    }

    private POOLInfoDetail5 getPoolInfoDetail(POOLgetAllPoolInfoEx allPoolInfo) {
        POOLInfoDetail5 ret = null;
        SJmoPoolDetail poolDetail = this.shkPoolDtlList.get(0);
        Robj_interface_POOLInfoDetailSx[] poolInfoDetailArray = allPoolInfo.getObjPoolInfo();
        for (int iCnt = 0; iCnt < poolInfoDetailArray.length; ++iCnt) {
            POOLInfoDetail5 poolInfoDetail = (POOLInfoDetail5)poolInfoDetailArray[iCnt];
            if (poolInfoDetail.getSPoolId() != poolDetail.getPoolId()) continue;
            ret = poolInfoDetail;
            break;
        }
        return ret;
    }

    private boolean checkConnectError(String strFunc, String strModule, String strMsg) {
        boolean bResult = true;
        int iFunc = Integer.valueOf(strFunc);
        int iModule = Integer.valueOf(strModule);
        int iMsg = Integer.valueOf(strMsg);
        if (iFunc != 30) {
            bResult = false;
        } else if (iModule != 5) {
            bResult = false;
        } else if (iMsg != this.ERR_HIC_CONNECT_1 && iMsg != this.ERR_HIC_CONNECT_2) {
            bResult = false;
        }
        return bResult;
    }

    public int getShrinkTime() {
        long shrinkTotalPage = 0L;
        for (int iCnt = 0; iCnt < this.shkPoolVolInfList.size(); ++iCnt) {
            shrinkTotalPage += this.shkPoolVolInfList.get(iCnt).getLPoolVolPages();
        }
        long lPoolUsedPages = this.shkPoolDtlList.get(0).getPoolUsedPages();
        long lPoolPages = this.shkPoolDtlList.get(0).getPoolPages();
        int iShrinkTime = (int)((double)shrinkTotalPage * ((double)lPoolUsedPages / (double)lPoolPages) * 0.87);
        return iShrinkTime;
    }

    public int getSystemPoolVolShrinkTime() {
        int iSystemPoolVolShrinkTime = (int)((double)this.VVOLList.size() * 0.25 + 100.0);
        return iSystemPoolVolShrinkTime;
    }

    private class SJctrGetAllPoolInfoEx
    extends SJmoGetThroughRmiData {
        public SJctrGetAllPoolInfoEx() {
            super(new POOLgetAllPoolInfoEx_IN());
        }
    }
}

