/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pool.stoprelocatingpools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.pool.stoprelocatingpools.SJctrStopRelocatingPoolsAC;
import sanproject.sn2.controller.wizard.pool.stoprelocatingpools.SJctrStopRelocatingPoolsConfirmDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.data.group.SJmoPbTSMMonitorOperationInfo;
import sanproject.sn2.model.data.group.SJmoPoolDetail;

public class SJctrStopRelocatingPoolsSubWizard
extends SJctrSubWizard {
    private static final Class<?> CONFIRM_DC = SJctrStopRelocatingPoolsConfirmDC.class;
    public static final String KEY_CLASS_DISPID = "KEY_CLASS_DISPID";
    public static final String KEY_CLASS_POOL_INDEX = "KEY_CLASS_POOL_INDEX";
    private List<SJmoPoolDetail> m_SelPoolList = null;

    @Override
    public Class<?>[] getClassList() {
        Class[] clsList = new Class[]{};
        return clsList;
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        return new SJctrGuidance("COMMON", "STOPRELOCATING_PL");
    }

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        try {
            this.checkStartData(wizard);
            this.checkConstructData(wizard);
            SJctrUserController uc = wizard.getOwner();
            SJctrRelatedDispDataObject related = uc.getRelatedDispData(CONFIRM_DC);
            SJctrStopRelocatingPoolsAC ac = new SJctrStopRelocatingPoolsAC();
            ArrayList<SJmoPoolDetail> poolDtlList = new ArrayList<SJmoPoolDetail>((ArrayList)wizard.getCache(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL));
            ac.setApplyList(poolDtlList);
            wizard.addConfirmData(ac, related);
        }
        catch (SJcException ctrExp) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "constructConfirmData", "catch SJcException", ctrExp);
            throw ctrExp;
        }
    }

    @Override
    public Class<?> getConfirmClass() {
        return CONFIRM_DC;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        HashSet<SJctrGetDirectWrapper> retSet = new HashSet<SJctrGetDirectWrapper>();
        try {
            SJctrGetDirectWrapper getDirectWrpPoolDetail = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL);
            retSet.add(getDirectWrpPoolDetail);
            SJctrGetDirectWrapper getDirectWrpPoolName = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_POOLNAME_INFO);
            retSet.add(getDirectWrpPoolName);
            SJctrGetDirectWrapper getDirectWrpMonInfo = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_POOL_MONOPRATION_INFO);
            retSet.add(getDirectWrpMonInfo);
            SJctrGetDirectWrapper getDirectWrpPoolSummary = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_POOL_SUMMARY);
            retSet.add(getDirectWrpPoolSummary);
        }
        catch (SJcException ctrExp) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getModelDirect", "catch SJcException", ctrExp);
            throw ctrExp;
        }
        return retSet;
    }

    private SJctrGetDirectWrapper createModelDirect(Class<? extends SJmoGetKind_IF> kindClass) throws SJcException {
        SJctrGetDirectWrapper getDrctWrap = null;
        try {
            SJmoGetKind_IF kind = kindClass.newInstance();
            SJmoGetRange_IF range = null;
            ArrayList search = new ArrayList();
            SJmoGetDirect getDrct = new SJmoGetDirect(kind, range, search);
            getDrctWrap = new SJctrGetDirectWrapper(getDrct);
        }
        catch (InstantiationException insExp) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "createModelDirect", "catch InstantiationException", insExp);
            SJctrError ctrErr = new SJctrError(31, 22, 107009);
            SJcException ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        catch (IllegalAccessException illExp) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "createModelDirect", "catch IllegalAccessException", illExp);
            SJctrError ctrErr = new SJctrError(31, 22, 107009);
            SJcException ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        return getDrctWrap;
    }

    public boolean checkStartData(SJctrWizardWindowDC wizard) {
        boolean bRetChk = true;
        ArrayList setPoolList = new ArrayList(wizard.getCache(KEY_CLASS_POOL_INDEX));
        if (null == setPoolList || 0 == setPoolList.size()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "createModelDirect", "selPoolList or selPoolVolList is null or size 0");
            bRetChk = false;
            SJctrError ctrErr = new SJctrError(31, 22, 107008);
            SJcException ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        this.m_SelPoolList = setPoolList;
        return bRetChk;
    }

    public boolean checkConstructData(SJctrWizardWindowDC wizard) {
        boolean bRetChk = true;
        ArrayList<SJmoPoolDetail> stopRelPoolDtlLst = new ArrayList<SJmoPoolDetail>();
        ArrayList shkmonInfoLst = new ArrayList();
        ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>();
        SJcException ctrExp = null;
        ArrayList poolDtlLst = new ArrayList(wizard.getCache(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL));
        ArrayList<SJmoPbTSMMonitorOperationInfo> monInfoLst = new ArrayList<SJmoPbTSMMonitorOperationInfo>(wizard.getCache(SJctrPoolUtility.KEY_CLASS_POOL_MONOPRATION_INFO));
        if (null != poolDtlLst && 0 != poolDtlLst.size()) {
            for (int iSelPoolCnt = 0; iSelPoolCnt < this.m_SelPoolList.size(); ++iSelPoolCnt) {
                SJmoPoolDetail poolDtl = this.m_SelPoolList.get(iSelPoolCnt);
                int iPoolDtlIdx = Collections.binarySearch(poolDtlLst, poolDtl);
                if (0 <= iPoolDtlIdx) {
                    try {
                        SJmoPoolDetail shkPoolDtl = (SJmoPoolDetail)((SJmoPoolDetail)poolDtlLst.get(iPoolDtlIdx)).clone();
                        stopRelPoolDtlLst.add(shkPoolDtl);
                        continue;
                    }
                    catch (CloneNotSupportedException e) {
                        SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "Object.clone() is failed");
                        bRetChk = false;
                        SJctrError ctrErr = new SJctrError(31, 22, 107007);
                        ctrExp = ctrErr.createException();
                        throw ctrExp;
                    }
                }
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "PoolDetail is not found");
                bRetChk = false;
                SJctrError ctrErr = new SJctrError(31, 22, 107023);
                ctrExp = ctrErr.createException();
                throw ctrExp;
            }
            bRetChk = this.checkMonitorPools(stopRelPoolDtlLst, monInfoLst, errList);
            if (!bRetChk) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "checkMonitorPool is Error");
                ctrExp = this.makeErrInfTableSP(wizard, errList);
                throw ctrExp;
            }
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "PoolDetail is null or size 0");
            bRetChk = false;
            SJctrError ctrErr = new SJctrError(31, 22, 107007);
            ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        wizard.putCache(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL, stopRelPoolDtlLst);
        return bRetChk;
    }

    private boolean checkMonitorPools(List<SJmoPoolDetail> poolDetailList, List<SJmoPbTSMMonitorOperationInfo> monInfoList, List<SJctrErrorColumnData> errList) {
        boolean bRet = true;
        ArrayList<SJmoPbTSMMonitorOperationInfo> selMonInfList = new ArrayList<SJmoPbTSMMonitorOperationInfo>();
        SJcException ctrExp = null;
        for (int i = 0; i < poolDetailList.size(); ++i) {
            SJmoPoolDetail poolDtl = poolDetailList.get(i);
            if (1 == poolDtl.getPoolKind() || 8 == poolDtl.getPoolKind()) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkMonitorPools", "Poolkind is QS or TI. - Pool ID :" + poolDtl.getPoolId());
                bRet = false;
                SJctrError ctrErr = new SJctrError(31, 22, 106033);
                ctrExp = ctrErr.createException();
                throw ctrExp;
            }
            if ((0x80 & poolDtl.getITierControlInfo()) != 128) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkMonitorPools", "Tiercheck(Tier pool disabled) is false. - Pool ID :" + poolDtl.getPoolId() + " - TierControlInfo :" + poolDtl.getITierControlInfo());
                bRet = false;
                SJctrError ctrErr = new SJctrError(31, 22, 106101);
                ctrExp = ctrErr.createException();
                throw ctrExp;
            }
            if ((0x40 & poolDtl.getITierControlInfo()) == 64) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkMonitorPools", "Tiercheck(Auto) is false. - Pool ID :" + poolDtl.getPoolId() + " - TierControlInfo :" + poolDtl.getITierControlInfo());
                bRet = false;
                SJctrError ctrErr = new SJctrError(31, 22, 106101);
                ctrExp = ctrErr.createException();
                throw ctrExp;
            }
            int iPoolMonInfIdx = Collections.binarySearch(monInfoList, poolDtl);
            if (0 > iPoolMonInfIdx) continue;
            SJmoPbTSMMonitorOperationInfo poolmonInf = monInfoList.get(iPoolMonInfIdx);
            selMonInfList.add(poolmonInf);
        }
        bRet = this.poolMonOperationCheck(selMonInfList);
        return bRet;
    }

    private boolean poolMonOperationCheck(List<SJmoPbTSMMonitorOperationInfo> poolMonOperation) {
        boolean result = true;
        SJcException ctrExp = null;
        if (null == poolMonOperation || poolMonOperation.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkMonitoringPools", "SJmoPbTSMMonitorOperationInfo is null or size 0");
            SJctrError ctrErr = new SJctrError(31, 22, 106099);
            ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        for (int i = 0; i < poolMonOperation.size(); ++i) {
            if (0L != poolMonOperation.get(i).getLErrorCode()) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkMonitorPools", "poolMonOperation is not Normal. - Pool ID :" + poolMonOperation.get(i).getPoolId());
                result = false;
                SJctrError ctrErr = new SJctrError(31, 22, 106096);
                ctrExp = ctrErr.createException();
                throw ctrExp;
            }
            if (0 != poolMonOperation.get(i).getSTierRelocateStatus()) continue;
            SJctrLogUty.warn(this.getClass().getSimpleName(), "poolMonOperationCheck", "This pool is not Relocating. - Pool ID :" + poolMonOperation.get(i).getPoolId());
            result = false;
            SJctrError ctrErr = new SJctrError(31, 22, 106106);
            ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        return result;
    }

    private SJcException makeErrInfTableSP(SJctrWizardWindowDC wizard, List<SJctrErrorColumnData> errList) {
        SJctrRelatedDispDataObject relDisp = wizard.createDialog(SJctrErrorDataController.class, null);
        SJctrUserController userCtr = wizard.getOwner();
        SJctrDataController beginDC = wizard.getParentDC();
        SJcException ctrExp = SJctrPoolUtility.makeErrInfTable(relDisp, userCtr, beginDC, errList);
        return ctrExp;
    }
}

