/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.com;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrCheckBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.wizard.replication.com.SJctrRemoteReplicationDataMacro;
import sanproject.sn2.controller.wizard.replication.com.SJctrRemoteReplicationHmPortNameMapDataMacro;
import sanproject.sn2.controller.wizard.replication.remote.addremoteconn.com.SJctrRemoteReplicationTargetPathInfo;
import sanproject.sn2.controller.wizard.replication.remote.addremoteconn.model.SJctrLocalStorageSysDataModel;
import sanproject.sn2.controller.wizard.replication.remote.addremoteconn.model.SJctrPulldownPortIDDataModel;
import sanproject.sn2.controller.wizard.replication.remote.addremoteconn.model.SJctrRemotePathDataModel;
import sanproject.sn2.controller.wizard.replication.remote.addremoteconn.model.SJctrRemoteSSIDDataModel;
import sanproject.sn2.controller.wizard.replication.remote.addremoteconn.model.SJctrRemoteStorageSysDataModel;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetPathInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetPathInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationRCUInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationRCUPathInfo;
import sanproject.sn2.model.data.system.SJmoSubsystemInfo;
import sanproject.sn2.sn2com.utility.SJsncProductModelUty;

public class SJctrRemoteConnectionUtility {
    public static final String KEY_CONNECT_TYPE = "COM_CONNECT_TYPE";
    public static final String KEY_CONNECT_TYPE_SYS = "COM_CONNECT_TYPE_SYS";
    public static final String KEY_CONNECT_TYPE_CU = "COM_CONNECT_TYPE_CU";
    public static final String KEY_LOCAL_STORAGE_SYS_PANEL = "COM_LOCAL_STORAGE_SYS_PANEL";
    public static final String KEY_REMOTE_STORAGE_SYS_PANEL = "COM_REMOTE_STORAGE_SYS_PANEL";
    public static final String KEY_REMOTE_PATHS_PANEL = "COM_REMOTE_PATHS_PANEL";
    public static final String KEY_RIO_MIH_TIME = "COM_RIO_MIH_TIME";
    public static final String KEY_ROUND_TRIP_TIME = "COM_ROUND_TRIP_TIME";
    public static final String KEY_FREEZE_OPTION = "COM_FREEZE_OPTION";
    public static final String KEY_ENABLE = "COM_ENABLE";
    public static final String KEY_DISABLE = "COM_DISABLE";
    public static final String KEY_AVA_LOCAL_PORT_ID_LIST = "COM_AVA_LOCAL_PORT_ID_LIST";
    public static final String KEY_AVA_LOCAL_ISCSI_PORT_ID_LIST = "COM_AVA_LOCAL_ISCSI_PORT_ID_LIST";
    public static final String KEY_FIBRE_RCU_PATH_LIST = "COM_FIBRE_RCU_PATH_INFO_LIST";
    public static final String KEY_ISCSI_RCU_PATH_LIST = "COM_ISCSI_RCU_PATH_INFO_LIST";
    public static final String KEY_ISCSI_TARGET_PATH_INFO_LIST = "COM_ISCSI_TARGET_PATH_INFO_LIST";
    public static final int SELECT_TOP_INDEX = 0;
    public static final int PORTID_LIST_SIZE = 2;
    public static final int PORTID_LIST_LOCAL_INDEX = 0;
    public static final int PORTID_LIST_REMOTE_INDEX = 1;
    public static final int CONN_TYPE_SYSTEM_SSID_TEXTBOX_COUNT = 1;
    public static final int DEFAULT_PORT_INDEX = -1;

    public static SJctrRadioButtonGroupDataModel getConnectionTypeRadio(SJctrDataController dc) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getConnectionTypeRadio", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        return (SJctrRadioButtonGroupDataModel)dc.getDataObjectModel(KEY_CONNECT_TYPE);
    }

    public static SJctrLocalStorageSysDataModel getLocalStorageSysModel(SJctrDataController dc) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getLocalStorageSysModel", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        return (SJctrLocalStorageSysDataModel)dc.getDataObjectModel(KEY_LOCAL_STORAGE_SYS_PANEL);
    }

    public static SJctrComboBoxDataModel getLocalCUPullDownModel(SJctrDataController dc) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getLocalCUPullDownModel", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrLocalStorageSysDataModel localSysModel = SJctrRemoteConnectionUtility.getLocalStorageSysModel(dc);
        return (SJctrComboBoxDataModel)localSysModel.getDataModel("COM_LOCAL_CU");
    }

    public static SJctrRemoteStorageSysDataModel getRemoteStorageSysModel(SJctrDataController dc) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getRemoteStorageSysModel", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        return (SJctrRemoteStorageSysDataModel)dc.getDataObjectModel(KEY_REMOTE_STORAGE_SYS_PANEL);
    }

    public static SJctrComboBoxDataModel getRemoteModelComboModel(SJctrDataController dc) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getRemoteModelComboModel", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrRemoteStorageSysDataModel remoteSysModel = SJctrRemoteConnectionUtility.getRemoteStorageSysModel(dc);
        return (SJctrComboBoxDataModel)remoteSysModel.getDataModel("COM_REMOTE_MODEL");
    }

    public static SJctrTextBoxDataModel getRemoteModelTextModel(SJctrDataController dc) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getRemoteModelTextModel", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrRemoteStorageSysDataModel remoteSysModel = SJctrRemoteConnectionUtility.getRemoteStorageSysModel(dc);
        return (SJctrTextBoxDataModel)remoteSysModel.getDataModel("COM_REMOTE_MODEL_VALU");
    }

    public static SJctrTextBoxDataModel getRemoteSerialNumberTextModel(SJctrDataController dc) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getRemoteSerialNumberTextModel", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrRemoteStorageSysDataModel remoteSysModel = SJctrRemoteConnectionUtility.getRemoteStorageSysModel(dc);
        return (SJctrTextBoxDataModel)remoteSysModel.getDataModel("COM_REMOTE_SERIAL_NO");
    }

    public static SJctrComboBoxDataModel getRemoteCUComboModel(SJctrDataController dc) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getRemoteCUComboModel", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrRemoteStorageSysDataModel remoteSysModel = SJctrRemoteConnectionUtility.getRemoteStorageSysModel(dc);
        return (SJctrComboBoxDataModel)remoteSysModel.getDataModel("COM_REMOTE_CU");
    }

    public static SJctrTextBoxDataModel getRemoteCUTextModel(SJctrDataController dc) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getRemoteCUTextModel", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrRemoteStorageSysDataModel remoteSysModel = SJctrRemoteConnectionUtility.getRemoteStorageSysModel(dc);
        return (SJctrTextBoxDataModel)remoteSysModel.getDataModel("COM_REMOTE_CU_VALU");
    }

    public static SJctrButtonDataModel getRemoteAddSSIDButtonModel(SJctrDataController dc) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getRemoteAddSSIDButtonModel", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrRemoteStorageSysDataModel remoteSysModel = SJctrRemoteConnectionUtility.getRemoteStorageSysModel(dc);
        return (SJctrButtonDataModel)remoteSysModel.getDataModel("COM_REMOTE_ADD_SSID");
    }

    public static SJctrRemoteSSIDDataModel getRemoteSSIDModel(SJctrDataController dc, int index) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getRemoteSSIDModel", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrRemoteStorageSysDataModel remoteSysModel = SJctrRemoteConnectionUtility.getRemoteStorageSysModel(dc);
        return (SJctrRemoteSSIDDataModel)remoteSysModel.getDataModel("COM_REMOTE_SSID_INFO_" + index);
    }

    public static SJctrTextBoxDataModel getRemoteSSIDTextModel(SJctrDataController dc, int index) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getRemoteSSIDTextModel", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrRemoteSSIDDataModel ssidModel = SJctrRemoteConnectionUtility.getRemoteSSIDModel(dc, index);
        return (SJctrTextBoxDataModel)ssidModel.getDataModel("COM_REMOTE_TEXT_SSID");
    }

    public static SJctrCheckBoxDataModel getSSIDRemoveCheckboxModel(SJctrDataController dc, int index) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getSSIDRemoveCheckboxModel", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrRemoteSSIDDataModel ssidModel = SJctrRemoteConnectionUtility.getRemoteSSIDModel(dc, index);
        return (SJctrCheckBoxDataModel)ssidModel.getDataModel("COM_CHECK_SSID");
    }

    public static SJctrRemotePathDataModel getRemotePathModel(SJctrDataController dc) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getRemotePathModel", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        return (SJctrRemotePathDataModel)dc.getDataObjectModel(KEY_REMOTE_PATHS_PANEL);
    }

    public static SJctrComboBoxDataModel getPathGroupIDPullDownModel(SJctrDataController dc) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getPathGroupIDPullDownModel", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrRemotePathDataModel pathModel = SJctrRemoteConnectionUtility.getRemotePathModel(dc);
        return (SJctrComboBoxDataModel)pathModel.getDataModel("COM_PATH_GRP_ID");
    }

    public static SJctrComboBoxDataModel getMinNumPathPullDownModel(SJctrDataController dc) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getMinNumPathPullDownModel", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrRemotePathDataModel pathModel = SJctrRemoteConnectionUtility.getRemotePathModel(dc);
        return (SJctrComboBoxDataModel)pathModel.getDataModel("COM_MIN_NUM_OF_PATHS");
    }

    public static SJctrButtonDataModel getRemoteAddPathButtonModel(SJctrDataController dc) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getRemoteAddPathButtonModel", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrRemotePathDataModel pathModel = SJctrRemoteConnectionUtility.getRemotePathModel(dc);
        return (SJctrButtonDataModel)pathModel.getDataModel("COM_ADD_PATH");
    }

    public static SJctrPulldownPortIDDataModel getPortIDModel(SJctrDataController dc, int index) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getPortIDModel", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrRemotePathDataModel pathModel = SJctrRemoteConnectionUtility.getRemotePathModel(dc);
        return (SJctrPulldownPortIDDataModel)pathModel.getDataModel("COM_PORT_ID_INFO_" + index);
    }

    public static SJctrComboBoxDataModel getLocalPortIDPullDownModel(SJctrDataController dc, int index) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getLocalPortIDPullDownModel", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrPulldownPortIDDataModel portIDModel = SJctrRemoteConnectionUtility.getPortIDModel(dc, index);
        return (SJctrComboBoxDataModel)portIDModel.getDataModel("COM_LOCAL_PORT_ID");
    }

    public static SJctrComboBoxDataModel getVirtualPortIDListModel(SJctrDataController dc, int index) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getVirtualPortIDListModel", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrPulldownPortIDDataModel portIDModel = SJctrRemoteConnectionUtility.getPortIDModel(dc, index);
        return (SJctrComboBoxDataModel)portIDModel.getDataModel("COM_VIRTUAL_PORT_ID");
    }

    public static SJctrComboBoxDataModel getRemotePortIDPullDownModel(SJctrDataController dc, int index) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getRemotePortIDPullDownModel", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrPulldownPortIDDataModel portIDModel = SJctrRemoteConnectionUtility.getPortIDModel(dc, index);
        return (SJctrComboBoxDataModel)portIDModel.getDataModel("COM_REMOTE_PORT_ID");
    }

    public static SJctrTextBoxDataModel getRemotePortIDTextModel(SJctrDataController dc, int index) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getRemotePortIDTextModel", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrPulldownPortIDDataModel portIDModel = SJctrRemoteConnectionUtility.getPortIDModel(dc, index);
        return (SJctrTextBoxDataModel)portIDModel.getDataModel("COM_PORT_ID_INFO_VALU");
    }

    public static SJctrCheckBoxDataModel getRemotePathRemoveCheckboxModel(SJctrDataController dc, int index) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getRemotePathRemoveCheckboxModel", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrPulldownPortIDDataModel portIDModel = SJctrRemoteConnectionUtility.getPortIDModel(dc, index);
        return (SJctrCheckBoxDataModel)portIDModel.getDataModel("COM_CHECK_PORT_ID");
    }

    public static SJctrTextBoxDataModel getRioMihTimeTextModel(SJctrDataController dc) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getRioMihTimeTextModel", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        return (SJctrTextBoxDataModel)dc.getDataObjectModel(KEY_RIO_MIH_TIME);
    }

    public static SJctrTextBoxDataModel getRoudTripTimeTextModel(SJctrDataController dc) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getRoudTripTimeTextModel", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        return (SJctrTextBoxDataModel)dc.getDataObjectModel(KEY_ROUND_TRIP_TIME);
    }

    public static SJctrRadioButtonGroupDataModel getFreezeOptionRadio(SJctrDataController dc) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getFreezeOptionRadio", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        return (SJctrRadioButtonGroupDataModel)dc.getDataObjectModel(KEY_FREEZE_OPTION);
    }

    public static void removeSSIDPanel(SJctrDataController dc, int ssidIndex) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "removeSSIDPanel", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrRemoteStorageSysDataModel remoteModel = SJctrRemoteConnectionUtility.getRemoteStorageSysModel(dc);
        int ssidCount = (Integer)((SJctrDataObject)remoteModel.getManageData()).getData("COM_DISP_SSID_COUNT");
        for (int sid = ssidIndex; sid < ssidCount - 1; ++sid) {
            SJctrTextBoxDataModel textUpObj = SJctrRemoteConnectionUtility.getRemoteSSIDTextModel(dc, sid);
            SJctrTextBoxDataModel textDownObj = SJctrRemoteConnectionUtility.getRemoteSSIDTextModel(dc, sid + 1);
            textUpObj.setValue(textDownObj.getValue());
        }
        SJctrTextBoxDataModel initTextObj = SJctrRemoteConnectionUtility.getRemoteSSIDTextModel(dc, ssidCount - 1);
        initTextObj.setValue("");
        ((SJctrDataObject)remoteModel.getManageData()).setData("COM_DISP_SSID_COUNT", --ssidCount);
    }

    public static void addSSIDPanel(SJctrDataController dc) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "addSSIDPanel", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrRemoteStorageSysDataModel remoteModel = SJctrRemoteConnectionUtility.getRemoteStorageSysModel(dc);
        int ssidCount = (Integer)((SJctrDataObject)remoteModel.getManageData()).getData("COM_DISP_SSID_COUNT");
        SJctrTextBoxDataModel ssidText = SJctrRemoteConnectionUtility.getRemoteSSIDTextModel(dc, ssidCount);
        ssidText.setValue("");
        ssidText.setVisible(true);
        ((SJctrDataObject)remoteModel.getManageData()).setData("COM_DISP_SSID_COUNT", ++ssidCount);
    }

    public static void addPathPanel(SJctrDataController dc, int remoteModelID, List<SJmoPortDetail> localPortIDList, SJctrComUtility comUty) {
        if (null == dc || null == localPortIDList || null == comUty) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "addPathPanel", "param is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrRemotePathDataModel remotePathModel = SJctrRemoteConnectionUtility.getRemotePathModel(dc);
        int pathCount = (Integer)((SJctrDataObject)remotePathModel.getManageData()).getData("COM_DISP_PATH_COUNT");
        if (!SJctrRemoteConnectionUtility.createPortIDPanel(dc, remoteModelID, localPortIDList, comUty, pathCount)) {
            return;
        }
        ((SJctrDataObject)remotePathModel.getManageData()).setData("COM_DISP_PATH_COUNT", ++pathCount);
    }

    public static void removePathPanel(SJctrDataController dc, int pathIndex) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "removePathPanel", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrRemotePathDataModel remotePathModel = SJctrRemoteConnectionUtility.getRemotePathModel(dc);
        int pathCount = (Integer)((SJctrDataObject)remotePathModel.getManageData()).getData("COM_DISP_PATH_COUNT");
        for (int pid = pathIndex; pid < pathCount - 1; ++pid) {
            SJctrComboBoxDataModel upLcoalPortcomboObj = SJctrRemoteConnectionUtility.getLocalPortIDPullDownModel(dc, pid);
            SJctrComboBoxDataModel upRemotePortcomboObj = SJctrRemoteConnectionUtility.getRemotePortIDPullDownModel(dc, pid);
            SJctrComboBoxDataModel downLcoalPortcomboObj = SJctrRemoteConnectionUtility.getLocalPortIDPullDownModel(dc, pid + 1);
            SJctrComboBoxDataModel downRemotePortcomboObj = SJctrRemoteConnectionUtility.getRemotePortIDPullDownModel(dc, pid + 1);
            upLcoalPortcomboObj.setSelection(downLcoalPortcomboObj.getSelection());
            upRemotePortcomboObj.setSelection(downRemotePortcomboObj.getSelection());
            SJctrTextBoxDataModel textUpObj = SJctrRemoteConnectionUtility.getRemotePortIDTextModel(dc, pid);
            SJctrTextBoxDataModel textDownObj = SJctrRemoteConnectionUtility.getRemotePortIDTextModel(dc, pid + 1);
            textUpObj.setValue(textDownObj.getValue());
            SJctrComboBoxDataModel upIpAddrTypePulldown = SJctrRemoteConnectionUtility.getRemotePathRemoteIpAddrTypeModel(dc, pid);
            SJctrComboBoxDataModel downIpAddrTypePulldown = SJctrRemoteConnectionUtility.getRemotePathRemoteIpAddrTypeModel(dc, pid + 1);
            upIpAddrTypePulldown.setSelection(downIpAddrTypePulldown.getSelection());
            SJctrTextBoxDataModel upIpAddrTextbox = SJctrRemoteConnectionUtility.getRemotePathRemoteIpAddrModel(dc, pid);
            SJctrTextBoxDataModel downIpAddrTextbox = SJctrRemoteConnectionUtility.getRemotePathRemoteIpAddrModel(dc, pid + 1);
            upIpAddrTextbox.setValue(downIpAddrTextbox.getValue());
            SJctrTextBoxDataModel upTcpPortTextbox = SJctrRemoteConnectionUtility.getRemotePathRemoteTcpPortNumber(dc, pid);
            SJctrTextBoxDataModel downTcpPortTextbox = SJctrRemoteConnectionUtility.getRemotePathRemoteTcpPortNumber(dc, pid + 1);
            upTcpPortTextbox.setValue(downTcpPortTextbox.getValue());
        }
        SJctrComboBoxDataModel initLcoalPortcomboObj = SJctrRemoteConnectionUtility.getLocalPortIDPullDownModel(dc, pathCount - 1);
        SJctrComboBoxDataModel initRemotePortcomboObj = SJctrRemoteConnectionUtility.getRemotePortIDPullDownModel(dc, pathCount - 1);
        SJctrTextBoxDataModel initRemotePortIDTextObj = SJctrRemoteConnectionUtility.getRemotePortIDTextModel(dc, pathCount - 1);
        initLcoalPortcomboObj.removeAllItems();
        initRemotePortcomboObj.removeAllItems();
        initRemotePortIDTextObj.setValue("");
        ((SJctrDataObject)remotePathModel.getManageData()).setData("COM_DISP_PATH_COUNT", --pathCount);
    }

    public static boolean createPortIDPanel(SJctrDataController dc, int remoteModelID, List<SJmoPortDetail> localPortIDList, SJctrComUtility comUty, int index) {
        if (null == dc || null == localPortIDList || null == comUty) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "createPortIDPanel", "param is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrComboBoxDataModel localPortcomboObj = SJctrRemoteConnectionUtility.getLocalPortIDPullDownModel(dc, index);
        SJctrComboBoxDataModel remotePortcomboObj = SJctrRemoteConnectionUtility.getRemotePortIDPullDownModel(dc, index);
        SJctrTextBoxDataModel remotePorttextObj = SJctrRemoteConnectionUtility.getRemotePortIDTextModel(dc, index);
        localPortcomboObj.removeAllItems();
        remotePortcomboObj.removeAllItems();
        remotePorttextObj.setValue("");
        SJctrRemoteReplicationUtility.createLocalPortID(localPortcomboObj, localPortIDList, comUty);
        SJctrRemoteReplicationUtility.createRemotePortID(remotePortcomboObj, remoteModelID, comUty);
        SJctrComboBoxDataModel listVPortID = SJctrRemoteConnectionUtility.getVirtualPortIDListModel(dc, index);
        SJctrRemoteConnectionUtility.createVirtualPortID(listVPortID, localPortIDList);
        SJctrComboBoxDataModel ipAddrTypePulldown = SJctrRemoteConnectionUtility.getRemotePathRemoteIpAddrTypeModel(dc, index);
        ipAddrTypePulldown.removeAllItems();
        ipAddrTypePulldown.addItem(String.valueOf(0), comUty.getGuidance("IPV4"));
        ipAddrTypePulldown.addItem(String.valueOf(1), comUty.getGuidance("IPV6"));
        ipAddrTypePulldown.setSelection(String.valueOf(0));
        SJctrTextBoxDataModel ipAddrTextbox = SJctrRemoteConnectionUtility.getRemotePathRemoteIpAddrModel(dc, index);
        ipAddrTextbox.setValue("");
        SJctrTextBoxDataModel tcpPortTextbox = SJctrRemoteConnectionUtility.getRemotePathRemoteTcpPortNumber(dc, index);
        tcpPortTextbox.setValue("");
        return true;
    }

    public static void setRemoteConnLocalStorageSysLabelPanel(SJmoSubsystemInfo subsysInfo, SJctrDataController dc, SJmoRemoteReplicationRCUInfo rcuInfo, SJctrComUtility utility) {
        if (null == dc || null == subsysInfo || null == rcuInfo || null == utility) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "setRemoteConnLocalStorageSysLabelPanel", "param is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrLocalStorageSysDataModel localSysModel = SJctrRemoteConnectionUtility.getLocalStorageSysModel(dc);
        SJctrRemoteReplicationUtility remoteReplicaUty = utility.getRemoteReplicationUtility();
        int localModelID = remoteReplicaUty.getModelIDfromSubsysInfo(subsysInfo);
        ((SJctrDataObject)localSysModel.getManageData()).setData("COM_LOCAL_MODEL", dc.getOwner().getProductName());
        ((SJctrDataObject)localSysModel.getManageData()).setData("COM_LOCAL_SERIAL_NO", subsysInfo.getDKCSNString());
        if (rcuInfo.getICUFree() == 1) {
            ((SJctrDataObject)localSysModel.getManageData()).setData("COM_LOCAL_CU_STR", "-");
        } else {
            ((SJctrDataObject)localSysModel.getManageData()).setData("COM_LOCAL_CU_STR", SJctrComUtility.toHexString(rcuInfo.getSCUNo(), 2, true));
        }
    }

    public static void setRemoteConnRemoteStorageSysLabelPanel(SJctrDataController dc, SJmoRemoteReplicationRCUInfo rcuInfo, SJctrComUtility utility) {
        if (null == dc || null == rcuInfo || null == utility) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "setRemoteConnRemoteStorageSysLabelPanel", "param is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrRemoteStorageSysDataModel remoteSysModel = SJctrRemoteConnectionUtility.getRemoteStorageSysModel(dc);
        ((SJctrDataObject)remoteSysModel.getManageData()).setData("COM_REMOTE_MODEL_STR", SJctrRemoteReplicationUtility.getModelNameString(rcuInfo.getIControllerID(), utility));
        SJctrTextBoxDataModel serialtext = SJctrRemoteConnectionUtility.getRemoteSerialNumberTextModel(dc);
        serialtext.setValue(rcuInfo.getStrSN());
        if (rcuInfo.getICUFree() == 1) {
            ((SJctrDataObject)remoteSysModel.getManageData()).setData("COM_REMOTE_CU_STR", "-");
            int ssidNum = 1;
            ((SJctrDataObject)remoteSysModel.getManageData()).setData("COM_DISP_SSID_COUNT", ssidNum);
            for (int ssidIdx = 0; ssidIdx < ssidNum; ++ssidIdx) {
                SJctrTextBoxDataModel ssidtext = SJctrRemoteConnectionUtility.getRemoteSSIDTextModel(dc, ssidIdx);
                ssidtext.setValue("-");
            }
        } else {
            ((SJctrDataObject)remoteSysModel.getManageData()).setData("COM_REMOTE_CU_STR", SJctrComUtility.toHexString(rcuInfo.getSCu(), 2, true));
            int ssidNum = rcuInfo.getINumofSSID();
            ((SJctrDataObject)remoteSysModel.getManageData()).setData("COM_DISP_SSID_COUNT", ssidNum);
            for (int ssidIdx = 0; ssidIdx < ssidNum; ++ssidIdx) {
                SJctrTextBoxDataModel ssidtext = SJctrRemoteConnectionUtility.getRemoteSSIDTextModel(dc, ssidIdx);
                ssidtext.setValue(SJctrComUtility.toHexString(rcuInfo.getISSID()[ssidIdx], 4, true));
            }
        }
    }

    public static void setRemoteConnRemotePathLabelPanel(SJctrDataController dc, SJmoRemoteReplicationRCUInfo rcuInfo, List<SJmoPortDetail> portDtlList) {
        if (null == dc || null == rcuInfo || null == portDtlList) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "setRemoteConnRemotePathLabelPanel", "param is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrRemotePathDataModel remotePathModel = SJctrRemoteConnectionUtility.getRemotePathModel(dc);
        if (rcuInfo.getICUFree() == 1) {
            ((SJctrDataObject)remotePathModel.getManageData()).setData("COM_PATH_GRP_ID_STR", SJctrComUtility.toHexString(rcuInfo.getIRCUID(), 2, true));
        } else {
            ((SJctrDataObject)remotePathModel.getManageData()).setData("COM_PATH_GRP_ID_STR", "-");
        }
        ((SJctrDataObject)remotePathModel.getManageData()).setData("COM_MIN_NUM_OF_PATHS_STR", SJctrComUtility.toDecString(rcuInfo.getRCUOption().getINumofMimPath()));
        SJctrRemoteConnectionUtility.setPortIDPanel(dc, rcuInfo, portDtlList);
    }

    public static void setPortIDPanel(SJctrDataController dc, SJmoRemoteReplicationRCUInfo rcuInfo, List<SJmoPortDetail> portDtlList) {
        if (null == dc || null == rcuInfo || null == portDtlList) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "setPortIDPanel", "param is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrRemotePathDataModel remotePathModel = SJctrRemoteConnectionUtility.getRemotePathModel(dc);
        SJctrRemoteReplicationUtility remoteReplicaUty = dc.getOwner().getComUtility().getRemoteReplicationUtility();
        boolean selectTypeIscsi = remotePathModel.getSelectType() == 1;
        Map iscsiTargetPathMap = new HashMap();
        List<?> iscsiTargetPathMapList = dc.getProxy().getCache(KEY_ISCSI_TARGET_PATH_INFO_LIST);
        if (iscsiTargetPathMapList != null) {
            iscsiTargetPathMap = (Map)iscsiTargetPathMapList.get(0);
        }
        int pathCount = 0;
        for (SJmoRemoteReplicationRCUPathInfo pathInfo : rcuInfo.getPathInfoList()) {
            SJctrPulldownPortIDDataModel pathModel = SJctrRemoteConnectionUtility.getPortIDModel(dc, pathCount);
            SJmoPortDetail portDetailInfo = null;
            String dispStr = "?";
            String dispVPortStr = "?";
            int index = Collections.binarySearch(portDtlList, pathInfo);
            if (index >= 0) {
                portDetailInfo = portDtlList.get(index);
                dispStr = portDetailInfo.getStrPortDisplayName();
                dispVPortStr = 1 == portDetailInfo.getIVPortMode() ? "0" : "-";
            }
            ((SJctrDataObject)pathModel.getManageData()).setData("COM_LOCAL_PORT_ID_STR", dispStr);
            ((SJctrDataObject)pathModel.getManageData()).setData("COM_VIRTUAL_PORT_ID_STR", dispVPortStr);
            ((SJctrDataObject)pathModel.getManageData()).setData("COM_REMOTE_PORT_ID_STR", remoteReplicaUty.getPortIdString(5, pathInfo, rcuInfo));
            if (selectTypeIscsi) {
                SJctrRemoteReplicationTargetPathInfo targetPath = (SJctrRemoteReplicationTargetPathInfo)iscsiTargetPathMap.get(pathInfo.toString());
                SJctrRemoteConnectionUtility.setPortIDPanelTargetPathInfoLabel(targetPath, pathModel);
            }
            ++pathCount;
        }
        ((SJctrDataObject)remotePathModel.getManageData()).setData("COM_DISP_PATH_COUNT", pathCount);
    }

    public static int[] getSSIDListFromWizard(SJctrDataController dc) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getSSIDListFromWizard", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrRemoteStorageSysDataModel remoteSysModel = SJctrRemoteConnectionUtility.getRemoteStorageSysModel(dc);
        int ssidCount = (Integer)((SJctrDataObject)remoteSysModel.getManageData()).getData("COM_DISP_SSID_COUNT");
        ArrayList<Integer> ssidList = new ArrayList<Integer>();
        for (int sid = 0; sid < ssidCount; ++sid) {
            SJctrTextBoxDataModel ssidStrModel = SJctrRemoteConnectionUtility.getRemoteSSIDTextModel(dc, sid);
            try {
                ssidList.add(Integer.parseInt(ssidStrModel.getValue(), 16));
                continue;
            }
            catch (NumberFormatException ne) {
                SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getSSIDListFromWizard", "The error occurred at the SSID" + sid + " getting. NumberFormatException : " + ne.getMessage());
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
            }
        }
        Collections.sort(ssidList);
        int[] ssid = new int[ssidList.size()];
        for (int sidIdx = 0; sidIdx < ssidList.size(); ++sidIdx) {
            ssid[sidIdx] = (Integer)ssidList.get(sidIdx);
        }
        if (SJctrRemoteReplicationUtility.chkRemoteConSSIDDuplicate(ssid, ssidCount)) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getSSIDListFromWizard", "SSID is duplicating.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206081);
        }
        return ssid;
    }

    public static String getSSIDEnableRangeString() {
        String str = "?";
        str = "(" + SJctrComUtility.toHexString(4, 4, true) + "-" + SJctrComUtility.toHexString(65534, 4, true) + ")";
        return str;
    }

    public static int[] getTargetSSIDListFromWizard(SJctrDataController dc) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getTargetSSIDListFromWizard", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrRemoteStorageSysDataModel remoteSysModel = SJctrRemoteConnectionUtility.getRemoteStorageSysModel(dc);
        int ssidCount = (Integer)((SJctrDataObject)remoteSysModel.getManageData()).getData("COM_DISP_SSID_COUNT");
        int addedCount = (Integer)((SJctrDataObject)remoteSysModel.getManageData()).getData("COM_ADDED_SSID_COUNT");
        ArrayList<Integer> ssidList = new ArrayList<Integer>();
        for (int sid = addedCount; sid < ssidCount; ++sid) {
            SJctrTextBoxDataModel ssidStrModel = SJctrRemoteConnectionUtility.getRemoteSSIDTextModel(dc, sid);
            try {
                ssidList.add(Integer.parseInt(ssidStrModel.getValue(), 16));
                continue;
            }
            catch (NumberFormatException ne) {
                SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getSSIDListFromWizard", "The error occurred at the SSID" + sid + " getting. NumberFormatException : " + ne.getMessage());
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
            }
        }
        Collections.sort(ssidList);
        int[] setSSIDList = new int[ssidList.size()];
        for (int sidIdx = 0; sidIdx < ssidList.size(); ++sidIdx) {
            setSSIDList[sidIdx] = (Integer)ssidList.get(sidIdx);
        }
        return setSSIDList;
    }

    public static SJctrRadioButtonGroupDataModel getSelectTypeRadio(SJctrDataController dc) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getSelectTypeRadio", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        return (SJctrRadioButtonGroupDataModel)SJctrRemoteConnectionUtility.getRemotePathModel(dc).getDataModel("COM_SELECT_TYPE");
    }

    public static SJctrComboBoxDataModel getRemotePathRemoteIpAddrTypeModel(SJctrDataController dc, int index) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getRemotePathRemoteIpAddrTypeModel", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrPulldownPortIDDataModel portIDModel = SJctrRemoteConnectionUtility.getPortIDModel(dc, index);
        return (SJctrComboBoxDataModel)portIDModel.getDataModel("COM_REMOTE_IP_ADDRESS_TYPE");
    }

    public static SJctrTextBoxDataModel getRemotePathRemoteIpAddrModel(SJctrDataController dc, int index) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getRemotePathRemoteIpAddrModel", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrPulldownPortIDDataModel portIDModel = SJctrRemoteConnectionUtility.getPortIDModel(dc, index);
        return (SJctrTextBoxDataModel)portIDModel.getDataModel("COM_REMOTE_IP_ADDRESS");
    }

    public static SJctrTextBoxDataModel getRemotePathRemoteTcpPortNumber(SJctrDataController dc, int index) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getRemotePathRemoteTcpPortNumber", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrPulldownPortIDDataModel portIDModel = SJctrRemoteConnectionUtility.getPortIDModel(dc, index);
        return (SJctrTextBoxDataModel)portIDModel.getDataModel("COM_REMOTE_TCP_PORT_NUMBER");
    }

    public static SJctrTextBoxDataModel getRemoteModelPrevTextModel(SJctrDataController dc) {
        if (null == dc) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getRemoteModelPrevTextModel", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrRemoteStorageSysDataModel remoteSysModel = SJctrRemoteConnectionUtility.getRemoteStorageSysModel(dc);
        return (SJctrTextBoxDataModel)remoteSysModel.getDataModel("COM_REMOTE_MODEL_PREV_VALU");
    }

    public static List<SJmoPortDetail> getCacheSelectTypePortList(SJctrDataController dc) {
        if (dc == null) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getCacheSelectTypePortList", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        List<SJmoPortDetail> portList = null;
        SJctrRemotePathDataModel remotePathModel = SJctrRemoteConnectionUtility.getRemotePathModel(dc);
        portList = remotePathModel.getSelectType() == 0 ? dc.getProxy().getCache(KEY_AVA_LOCAL_PORT_ID_LIST) : dc.getProxy().getCache(KEY_AVA_LOCAL_ISCSI_PORT_ID_LIST);
        if (portList == null) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getCacheSelectTypePortList", "No cache data.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        return portList;
    }

    public static List<SJmoRemoteReplicationRCUInfo> getCacheSelectTypeRCUPathInfoList(SJctrDataController dc) {
        if (dc == null) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getCacheSelectTypeRCUPathInfoList", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrRemotePathDataModel remotePathModel = SJctrRemoteConnectionUtility.getRemotePathModel(dc);
        List<SJmoRemoteReplicationRCUInfo> rcuPathList = SJctrRemoteConnectionUtility.getCacheSelectTypeRCUPathInfoList(remotePathModel.getSelectType(), dc);
        return rcuPathList;
    }

    public static List<SJmoRemoteReplicationRCUInfo> getCacheSelectTypeRCUPathInfoList(int selectType, SJctrDataController dc) {
        if (dc == null) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getCacheSelectTypeRCUPathInfoList", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        List<SJmoRemoteReplicationRCUInfo> rcuPathList = null;
        rcuPathList = selectType == 0 ? dc.getProxy().getCache(KEY_FIBRE_RCU_PATH_LIST) : dc.getProxy().getCache(KEY_ISCSI_RCU_PATH_LIST);
        if (rcuPathList == null) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getCacheSelectTypeRCUPathInfoList", "No cache data.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        return rcuPathList;
    }

    public static void setEnableStatusSelectTypeRadio(List fibreList, List iscsiList, int modelId, SJctrDataController dc) {
        if (fibreList == null || iscsiList == null || dc == null) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "setEnableStatusSelectTypeRadio", "Arguments are null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrRadioButtonGroupDataModel selectTypeModel = SJctrRemoteConnectionUtility.getSelectTypeRadio(dc);
        if (fibreList.isEmpty()) {
            selectTypeModel.setEnable("COM_SELECT_TYPE_FIBRE", false);
        } else {
            selectTypeModel.setEnable("COM_SELECT_TYPE_FIBRE", true);
        }
        if (iscsiList.isEmpty()) {
            selectTypeModel.setEnable("COM_SELECT_TYPE_ISCSI", false);
        } else if (!SJctrRemoteReplicationDataMacro.REMOTE_CONNECTION_ISCSI_PORT_ENABLE_MODEL_ID.contains(modelId)) {
            selectTypeModel.setEnable("COM_SELECT_TYPE_ISCSI", false);
        } else {
            selectTypeModel.setEnable("COM_SELECT_TYPE_ISCSI", true);
        }
    }

    public static void setSelectStatusSelectTypeRadio(List fibreList, int modelId, SJctrDataController dc) {
        if (fibreList == null || dc == null) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "setSelectStatusSelectTypeRadio", "Arguments are null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrRadioButtonGroupDataModel selectTypeModel = SJctrRemoteConnectionUtility.getSelectTypeRadio(dc);
        if (fibreList.size() > 0) {
            selectTypeModel.setSelect("COM_SELECT_TYPE_FIBRE");
        } else if (!SJctrRemoteReplicationDataMacro.REMOTE_CONNECTION_ISCSI_PORT_ENABLE_MODEL_ID.contains(modelId)) {
            selectTypeModel.setSelect("COM_SELECT_TYPE_FIBRE");
        } else {
            selectTypeModel.setSelect("COM_SELECT_TYPE_ISCSI");
        }
    }

    public static Map<String, List> getPortTypeRCUPathInfoMap(SJmoRemoteReplicationRCUInfo rcuInfo, SJctrDataController dc) {
        if (rcuInfo == null || dc == null) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getPortTypeRCUPathInfoMap", "Arguments are null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        ArrayList<SJmoRemoteReplicationRCUPathInfo> rcuPathInfoList = rcuInfo.getPathInfoList();
        ArrayList<SJmoRemoteReplicationRCUPathInfo> fibreRCUPathList = new ArrayList<SJmoRemoteReplicationRCUPathInfo>(rcuPathInfoList.size());
        ArrayList<SJmoRemoteReplicationRCUPathInfo> iscsiRCUPathList = new ArrayList<SJmoRemoteReplicationRCUPathInfo>(rcuPathInfoList.size());
        List<SJmoPortDetail> portDtlList = SJctrReplicationUtility.getSJmoPortDetail(dc);
        for (SJmoRemoteReplicationRCUPathInfo rcuPathInfo : rcuPathInfoList) {
            int index = Collections.binarySearch(portDtlList, rcuPathInfo);
            if (index < 0) continue;
            SJmoPortDetail portDetail = portDtlList.get(index);
            if (SJctrIscsiUtility.isFibrePort(portDetail)) {
                fibreRCUPathList.add(rcuPathInfo);
                continue;
            }
            iscsiRCUPathList.add(rcuPathInfo);
        }
        SJmoRemoteReplicationRCUInfo fibreRCUInfo = null;
        SJmoRemoteReplicationRCUInfo iscsiRCUInfo = null;
        try {
            fibreRCUInfo = (SJmoRemoteReplicationRCUInfo)rcuInfo.clone();
            iscsiRCUInfo = (SJmoRemoteReplicationRCUInfo)rcuInfo.clone();
        }
        catch (CloneNotSupportedException e) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getPortTypeRCUPathInfoMap", "Information of SJmoRemoteReplicationRCUInfo cannot clone.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        Collections.sort(fibreRCUPathList);
        Collections.sort(iscsiRCUPathList);
        fibreRCUInfo.setPathInfoList(fibreRCUPathList);
        iscsiRCUInfo.setPathInfoList(iscsiRCUPathList);
        HashMap<String, List> rcuInfoMap = new HashMap<String, List>();
        ArrayList<SJmoRemoteReplicationRCUInfo> fibreRCUInfoList = new ArrayList<SJmoRemoteReplicationRCUInfo>(1);
        fibreRCUInfoList.add(fibreRCUInfo);
        rcuInfoMap.put(KEY_FIBRE_RCU_PATH_LIST, fibreRCUInfoList);
        ArrayList<SJmoRemoteReplicationRCUInfo> iscsiRCUInfoList = new ArrayList<SJmoRemoteReplicationRCUInfo>(1);
        iscsiRCUInfoList.add(iscsiRCUInfo);
        rcuInfoMap.put(KEY_ISCSI_RCU_PATH_LIST, iscsiRCUInfoList);
        return rcuInfoMap;
    }

    public static Map<String, SJctrRemoteReplicationTargetPathInfo> createRemoteReplicationTargetPathInfoMap(SJmoRemoteReplicationRCUInfo iscsiRCUPath, List<SJmoPortIscsiTargetPathInfo> portIscsiPathInfoList, String sn) {
        if (iscsiRCUPath == null || portIscsiPathInfoList == null || sn == null) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "createRemoteReplicationTargetPathInfoMap", "Arguments are null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        HashMap<String, SJctrRemoteReplicationTargetPathInfo> targetInfoMap = new HashMap<String, SJctrRemoteReplicationTargetPathInfo>();
        String remoteSn = iscsiRCUPath.getStrSN();
        for (SJmoRemoteReplicationRCUPathInfo rcuPathInfo : iscsiRCUPath.getPathInfoList()) {
            String searchIscsiName;
            SJctrRemoteReplicationTargetPathInfo pathInfo = SJctrRemoteConnectionUtility.getRemotePathIscsiTargetPathInfo(portIscsiPathInfoList, rcuPathInfo, searchIscsiName = SJctrRemoteConnectionUtility.createRemoteReplicationiScsiName(iscsiRCUPath.getIControllerID(), rcuPathInfo.getIRCUPortNo(), remoteSn, sn));
            if (pathInfo == null) continue;
            targetInfoMap.put(rcuPathInfo.toString(), pathInfo);
        }
        return targetInfoMap;
    }

    public static String createRemoteReplicationiScsiName(int remoteModelID, int remotePortId, String remoteSn, String sn) {
        if (remoteSn == null || sn == null) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "createRemoteReplicationiScsiName", "Arguments are null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        StringBuilder targetIscsiName = new StringBuilder();
        targetIscsiName.append("iqn.");
        targetIscsiName.append("1994-04.jp.co.hitachi:rsd.");
        String modelName = "";
        LinkedHashMap<Short, String> portIdMap = null;
        switch (SJsncProductModelUty.getProductModel()) {
            case 60: {
                modelName = "h8h";
                portIdMap = SJctrRemoteReplicationHmPortNameMapDataMacro.PortList_HM800_H_MODEL_REMOTE_RAID700_800_MAP;
                break;
            }
            case 40: {
                modelName = "h8m";
                portIdMap = SJctrRemoteReplicationHmPortNameMapDataMacro.PortList_HM800_M_MODEL_REMOTE_RAID700_800_MAP;
                break;
            }
            case 20: {
                modelName = "h8s";
                portIdMap = SJctrRemoteReplicationHmPortNameMapDataMacro.PortList_HM800_S_MODEL_REMOTE_RAID700_800_MAP;
                break;
            }
            default: {
                modelName = "h8h";
                portIdMap = SJctrRemoteReplicationHmPortNameMapDataMacro.PortList_HM800_H_MODEL_REMOTE_RAID700_800_MAP;
            }
        }
        targetIscsiName.append(modelName);
        targetIscsiName.append(".");
        targetIscsiName.append("t");
        targetIscsiName.append(".");
        targetIscsiName.append(SJctrRemoteConnectionUtility.makeIscsiNameSn(remoteModelID, remoteSn));
        targetIscsiName.append(".");
        targetIscsiName.append(SJctrRemoteConnectionUtility.makeIscsiNameSn(18, sn));
        targetIscsiName.append(".");
        String portIdName = (String)portIdMap.get((short)remotePortId);
        if (null != portIdName) {
            portIdName = portIdName.replaceAll("-", "");
            targetIscsiName.append(portIdName.toLowerCase(Locale.ENGLISH));
        }
        return targetIscsiName.toString();
    }

    private static String makeIscsiNameSn(int modelId, String sn) {
        String prefixSn1 = null;
        String prefixSn2 = null;
        int prefixSn2LowValue = 0;
        switch (modelId) {
            case 7: {
                prefixSn1 = "07";
                prefixSn2 = "17";
                prefixSn2LowValue = 65536;
                break;
            }
            case 18: {
                prefixSn1 = "12";
                prefixSn2 = "22";
                prefixSn2LowValue = 65536;
                break;
            }
            default: {
                prefixSn1 = "12";
                prefixSn2 = "22";
                prefixSn2LowValue = 65536;
            }
        }
        StringBuilder iscsiNameSn = new StringBuilder();
        String prefixSn = prefixSn1;
        try {
            int snValue = Integer.parseInt(sn);
            if ((snValue %= 100000) >= prefixSn2LowValue) {
                prefixSn = prefixSn2;
                snValue -= prefixSn2LowValue;
            }
            String snStr = SJctrComUtility.toHexString(snValue, 4, false);
            iscsiNameSn.append(prefixSn);
            iscsiNameSn.append(snStr);
        }
        catch (NumberFormatException e) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "makeIscsiNameSn", "NumberFormatException occurred. SN = " + sn);
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        return iscsiNameSn.toString();
    }

    public static SJctrRemoteReplicationTargetPathInfo getRemotePathIscsiTargetPathInfo(List<SJmoPortIscsiTargetPathInfo> portTargetPathInfoList, SJmoRemoteReplicationRCUPathInfo rcuPathInfo, String searchIscsiName) {
        if (portTargetPathInfoList == null || rcuPathInfo == null || searchIscsiName == null) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getRemotePathIscsiTargetPathInfo", "Arguments are null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrRemoteReplicationTargetPathInfo targetPathInfo = null;
        int localPathInfoIndex = Collections.binarySearch(portTargetPathInfoList, rcuPathInfo);
        if (localPathInfoIndex < 0) {
            return null;
        }
        SJmoPortIscsiTargetPathInfo portTargetPathInfo = portTargetPathInfoList.get(localPathInfoIndex);
        ArrayList<SJmoIscsiTargetPathInfo> targetPathInfoList = portTargetPathInfo.getAlPortIscsiTargetPath();
        ArrayList<SJmoIscsiTargetPathInfo> remoteReplicaTargetList = new ArrayList<SJmoIscsiTargetPathInfo>(targetPathInfoList.size());
        for (SJmoIscsiTargetPathInfo pathInfo : targetPathInfoList) {
            if (pathInfo.getIFunction() != 1) continue;
            remoteReplicaTargetList.add(pathInfo);
        }
        if (remoteReplicaTargetList.isEmpty()) {
            return null;
        }
        Collections.sort(remoteReplicaTargetList, new Comparator<SJmoIscsiTargetPathInfo>(){

            @Override
            public int compare(SJmoIscsiTargetPathInfo o1, SJmoIscsiTargetPathInfo o2) {
                return o1.getStrTargetName().compareTo(o2.getStrTargetName());
            }
        });
        int targetIndex = Collections.binarySearch(remoteReplicaTargetList, searchIscsiName, new Comparator(){

            public int compare(Object o1, Object o2) {
                SJmoIscsiTargetPathInfo target1 = (SJmoIscsiTargetPathInfo)o1;
                String target2 = (String)o2;
                return target1.getStrTargetName().compareTo(target2);
            }
        });
        if (targetIndex >= 0) {
            SJmoIscsiTargetPathInfo targetInfo = (SJmoIscsiTargetPathInfo)remoteReplicaTargetList.get(targetIndex);
            targetPathInfo = new SJctrRemoteReplicationTargetPathInfo(targetInfo, rcuPathInfo.getIRCUPortNo());
            targetPathInfo.setPortType(1);
        }
        return targetPathInfo;
    }

    private static void setPortIDPanelTargetPathInfoLabel(SJctrRemoteReplicationTargetPathInfo targetPathInfo, SJctrPulldownPortIDDataModel pathModel) {
        if (pathModel == null) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "setPortIDPanelTargetPathInfoLabel", "Arguments are null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        String ipAddr = "";
        String tcpPortNum = "";
        if (targetPathInfo != null) {
            ipAddr = targetPathInfo.getIIpType() == 0 ? SJctrPortUtility.toDispIPv4(targetPathInfo.getIIpv4Address()) : SJctrIscsiUtility.getIpv6AddrString(targetPathInfo.getIIpv6Address());
            tcpPortNum = String.valueOf(targetPathInfo.getITcpPortNumber());
        }
        ((SJctrDataObject)pathModel.getManageData()).setData("COM_REMOTE_IP_ADDRESS_STR", ipAddr);
        ((SJctrDataObject)pathModel.getManageData()).setData("COM_REMOTE_TCP_PORT_NUMBER_STR", tcpPortNum);
    }

    public static void updateTotalNumberOfPaths(int totalNumPaths, SJctrDataController dc) {
        if (dc == null) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "updateTotalNumberOfPaths", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrRemotePathDataModel remotePathModel = SJctrRemoteConnectionUtility.getRemotePathModel(dc);
        ((SJctrDataObject)remotePathModel.getManageData()).setData("COM_TOTAL_NUM_OF_PATHS_STR", totalNumPaths);
    }

    public static void incrementTotalNumberOfPaths(SJctrDataController dc) {
        Integer totalNumPaths;
        if (dc == null) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "incrementTotalNumberOfPaths", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrRemotePathDataModel remotePathModel = SJctrRemoteConnectionUtility.getRemotePathModel(dc);
        Integer n = totalNumPaths = (Integer)((SJctrDataObject)remotePathModel.getManageData()).getData("COM_TOTAL_NUM_OF_PATHS_STR");
        Integer n2 = totalNumPaths = Integer.valueOf(totalNumPaths + 1);
        ((SJctrDataObject)remotePathModel.getManageData()).setData("COM_TOTAL_NUM_OF_PATHS_STR", totalNumPaths);
    }

    public static void decrementTotalNumberOfPaths(SJctrDataController dc) {
        Integer totalNumPaths;
        if (dc == null) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "decrementTotalNumberOfPaths", "DataController is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrRemotePathDataModel remotePathModel = SJctrRemoteConnectionUtility.getRemotePathModel(dc);
        Integer n = totalNumPaths = (Integer)((SJctrDataObject)remotePathModel.getManageData()).getData("COM_TOTAL_NUM_OF_PATHS_STR");
        Integer n2 = totalNumPaths = Integer.valueOf(totalNumPaths - 1);
        ((SJctrDataObject)remotePathModel.getManageData()).setData("COM_TOTAL_NUM_OF_PATHS_STR", totalNumPaths);
    }

    public static SJctrRemoteReplicationTargetPathInfo getExistIscsiTargetPathInfo(List<Integer> indexList, int remoteModelID, String remoteSn, SJctrDataController dc) {
        if (indexList == null || remoteSn == null || dc == null) {
            SJctrLogUty.error(SJctrRemoteConnectionUtility.class.getSimpleName(), "getExistIscsiTargetPathInfo", "Arguments are null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        SJctrRemoteReplicationTargetPathInfo targetPathInfo = null;
        SJmoSubsystemInfo subsysInfo = SJctrRemoteReplicationUtility.getSJmoSubsystemInfo(dc);
        List<SJmoPortIscsiTargetPathInfo> portTargetPathInfoList = SJctrIscsiUtility.getSJmoPortIscsiTargetPathInfoList(dc);
        for (int idx : indexList) {
            SJctrComboBoxDataModel localPortCombobox = SJctrRemoteConnectionUtility.getLocalPortIDPullDownModel(dc, idx);
            int localPortId = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(localPortCombobox);
            SJctrComboBoxDataModel remotePortCombobox = SJctrRemoteConnectionUtility.getRemotePortIDPullDownModel(dc, idx);
            int remotePortId = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(remotePortCombobox);
            SJmoRemoteReplicationRCUPathInfo searchPathInfo = new SJmoRemoteReplicationRCUPathInfo();
            searchPathInfo.setSPort((short)localPortId);
            searchPathInfo.setIRCUPortNo(remotePortId);
            String iscsiName = SJctrRemoteConnectionUtility.createRemoteReplicationiScsiName(remoteModelID, remotePortId, remoteSn, subsysInfo.getDKCSNString());
            targetPathInfo = SJctrRemoteConnectionUtility.getRemotePathIscsiTargetPathInfo(portTargetPathInfoList, searchPathInfo, iscsiName);
            if (targetPathInfo == null) continue;
            break;
        }
        return targetPathInfo;
    }

    public static SJctrRemoteReplicationTargetPathInfo createSJctrRemoteReplicationTargetPathInfo(SJmoRemoteReplicationRCUPathInfo pathInfo, int portType, Map<String, SJctrRemoteReplicationTargetPathInfo> targetPathInfoMap) {
        SJctrRemoteReplicationTargetPathInfo targetPathInfo = targetPathInfoMap.get(pathInfo.toString());
        if (targetPathInfo == null) {
            targetPathInfo = new SJctrRemoteReplicationTargetPathInfo();
            targetPathInfo.setSPort(pathInfo.getSPort());
            targetPathInfo.setRemotePortId(pathInfo.getIRCUPortNo());
        }
        targetPathInfo.setPortType(portType);
        return targetPathInfo;
    }

    public static void createVirtualPortID(SJctrComboBoxDataModel listVPortID, List<SJmoPortDetail> localPortIDList) {
        listVPortID.removeAllItems();
        listVPortID.addItem("", "");
        for (SJmoPortDetail portDtl : localPortIDList) {
            if (null != portDtl) {
                if (1 == portDtl.getIVPortMode()) {
                    listVPortID.addItem(portDtl.getStrPortDisplayName(), "0");
                    continue;
                }
                listVPortID.addItem(portDtl.getStrPortDisplayName(), "-");
                continue;
            }
            listVPortID.addItem("?", "?");
        }
    }
}

