/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.assignsecondaryvolumes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import sanproject.serversx.data.RJiLDEVIndex;
import sanproject.serverux.dataimpl.MRCFgetTiPairInfo;
import sanproject.serverux.dataimpl.MRCFgetTiPairList;
import sanproject.serverux.dataimpl.MRCFgetTiPvolMu;
import sanproject.serverux.dataimpl.MRCFgetTiPvolMuPairInfo_IN;
import sanproject.serverux.dataimpl.MRCFgetTiPvolMuPairInfo_OUT;
import sanproject.serverux.dataimpl.MRCFgetTiPvolMuParam;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.replication.com.SJctrGetMRCFgetTiPvolMuParam;
import sanproject.sn2.controller.wizard.replication.local.assignsecondaryvolumes.SJctrPVolMuErrorTableModel;
import sanproject.sn2.controller.wizard.replication.local.assignsecondaryvolumes.SJctrTIPairGetExecuter;
import sanproject.sn2.controller.wizard.replication.local.createtipairs.SJctrCreateTIPairInfo;
import sanproject.sn2.controller.wizard.replication.local.createtipairs.SJctrCreateTIPairUtility;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.SJmoThroughRmiData;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolMu;

public class SJctrTIPairGetExecuter_PVolMU
extends SJctrTIPairGetExecuter {
    protected List<SJmoTiPvolMu> selectPVolMuList = Collections.emptyList();

    @Override
    public boolean checkInputData(List<?> inputDataList) {
        for (Object inputData : inputDataList) {
            if (inputData instanceof SJmoTiPvolMu) continue;
            SJctrCreateTIPairUtility.createError(107001);
        }
        this.selectPVolMuList = inputDataList;
        return true;
    }

    @Override
    public boolean checkConstractData() {
        if (this.selectPVolMuList.size() > 32768) {
            SJctrCreateTIPairUtility.createError(205159);
        }
        return true;
    }

    @Override
    protected SJmoGetKind_IF createGetInputData() {
        int getNum = this.selectPVolMuList.size();
        MRCFgetTiPvolMuParam param = new MRCFgetTiPvolMuParam();
        MRCFgetTiPvolMu[] getPVolMuArray = new MRCFgetTiPvolMu[getNum];
        for (int index = 0; index < getNum; ++index) {
            SJmoTiPvolMu pVolMu = this.selectPVolMuList.get(index);
            MRCFgetTiPvolMu getPVolMu = new MRCFgetTiPvolMu();
            RJiLDEVIndex pvol = new RJiLDEVIndex();
            pvol.setLDEVIndex(pVolMu.getSLdkc(), pVolMu.getSCu(), pVolMu.getSLdev());
            getPVolMu.setPvol(pvol);
            getPVolMu.setMu(pVolMu.getMu());
            getPVolMuArray[index] = getPVolMu;
        }
        MRCFgetTiPvolMuPairInfo_IN input = new MRCFgetTiPvolMuPairInfo_IN();
        MRCFgetTiPvolMuParam tiPVolParam = new MRCFgetTiPvolMuParam();
        tiPVolParam.setTiPvolMu(getPVolMuArray);
        input.setTiPvolMu(tiPVolParam);
        return new SJctrGetMRCFgetTiPvolMuParam(input);
    }

    @Override
    protected List<SJctrCreateTIPairInfo> getTIPair() {
        List<SJctrCreateTIPairInfo> retList = Collections.emptyList();
        SJmoThroughRmiData getInfo = this.getThroughRmiData();
        MRCFgetTiPvolMuPairInfo_OUT outPut = (MRCFgetTiPvolMuPairInfo_OUT)getInfo.getObjRmi();
        MRCFgetTiPairList tiPairInfoList = outPut.getDataInf();
        MRCFgetTiPairInfo[] tiPairInfoArray = tiPairInfoList.getTiPairInfo();
        retList = this.createAvailablePairList(tiPairInfoArray);
        return retList;
    }

    @Override
    protected boolean checkGetInfo(List<SJctrCreateTIPairInfo> tiPairList) {
        if (tiPairList == null) {
            SJctrCreateTIPairUtility.createError(206165);
        }
        Comparator<Object> pVolComp = SJctrCreateTIPairInfo.CreatePVoMuComparator();
        ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>(this.selectPVolMuList.size());
        for (SJmoTiPvolMu selectPVolMu : this.selectPVolMuList) {
            if (Collections.binarySearch(tiPairList, selectPVolMu, pVolComp) >= 0) continue;
            SJctrLogUty.error("SJctrTIPairGetExecuter_PVolMU", "checkGetInfo", "Selected pairs not found. P-VOL = " + selectPVolMu.getSLdkc() + ":" + selectPVolMu.getSCu() + ":" + selectPVolMu.getSLdev() + "  MU# = " + selectPVolMu.getMu());
            SJctrError err = new SJctrError(209, 22, 206165);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(selectPVolMu, err);
            errColumnList.add(errColumn);
        }
        if (!errColumnList.isEmpty()) {
            ArrayList<SJmoTiPvolMu> errPVolMuList = new ArrayList<SJmoTiPvolMu>(errColumnList.size());
            for (SJctrErrorColumnData errColumn : errColumnList) {
                SJmoTiPvolMu PVolMu = (SJmoTiPvolMu)errColumn.getKeyObj();
                errPVolMuList.add(PVolMu);
            }
            Collections.sort(errPVolMuList);
            SJctrPVolMuErrorTableModel errTable = new SJctrPVolMuErrorTableModel();
            errTable.setDataController(this.dc);
            errTable.initGuidance(this.dc.getOwner().getComUtility());
            errTable.createModelDirect();
            errTable.divideModelData(this.dc.getProxy().getModelDataMap());
            errTable.setTableKeyData(errPVolMuList);
            errTable.makeDataModel();
            SJctrCreateTIPairUtility.createErrorTable(this.dc, errTable, errColumnList, this.PVOLMU_COMP);
        }
        this.checkRSGInfoFromSelectedPairList(tiPairList);
        return true;
    }
}

