/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.createpairs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;

public class SJctrPortHGFilterDataModel
extends SJctrSimpleDataModel {
    private final String KEY_PTFILTER = "COM_PTFILTER";
    private final String KEY_HGFILTER = "COM_HGFILTER";
    public static final String KEY_PTTYPE = "COM_PTTYPE";
    private List<SJmoPortDetail> filterDistPortDtl = null;
    private Map<Short, List<SJmoHostGroupInfo>> portHGInfoMap = null;
    private Map<Short, List<SJmoIscsiTargetInfo>> portIscsiTargetInfoMap = null;
    private SJctrComboBoxDataModel ptFilter = new SJctrComboBoxDataModel();
    private SJctrComboBoxDataModel hgFilter = null;
    public static final short HG_ANY = -1;
    public static final String GUID_HG_ANY = "ANY";
    private SJctrPortUtility portUtil = null;
    private int ptType = 2;

    public SJctrPortHGFilterDataModel() {
        this.ptFilter.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrPortHGFilterDataModel.this.refHgFilter();
                    SJctrPortHGFilterDataModel.this.updatePortType();
                }
            }
        });
        this.addDataModel("COM_PTFILTER", this.ptFilter);
        this.hgFilter = new SJctrComboBoxDataModel();
        this.hgFilter.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrPortHGFilterDataModel.this.fireMessageEvent(CHGFILTER_MSG.CHG_HGFILTER);
                }
            }
        });
        this.addDataModel("COM_HGFILTER", this.hgFilter);
    }

    public void initPortHGFilter(List<SJmoPortDetail> portDtlList, List<SJmoPortHostGroupInfo> portHGInfoList, List<SJmoPortIscsiTargetInfo> portIscsiTargetInfoList, Map<Short, Set<Short>> portHGMap) {
        this.ptFilter.removeAllItems();
        this.hgFilter.removeAllItems();
        this.portHGInfoMap = null;
        this.portUtil = this.getComUtility().getPortUtility();
        if (portHGMap != null && !portHGMap.isEmpty()) {
            this.createFilterBaseData(portDtlList, portHGInfoList, portIscsiTargetInfoList, portHGMap);
            for (SJmoPortDetail portDtl : this.filterDistPortDtl) {
                String name = Short.toString(portDtl.getSPort());
                String label = portDtl.getStrPortDisplayName();
                this.ptFilter.addItem(name, label);
            }
            this.ptFilter.setSelectedIndex(0);
        }
    }

    private void refHgFilter() {
        this.hgFilter.removeAllItems();
        SJctrComUtility comUtil = this.getComUtility();
        this.hgFilter.addItem(Short.toString((short)-1), comUtil.getGuidance(GUID_HG_ANY));
        String selection = this.ptFilter.getSelection();
        if (selection != null) {
            short portId = Short.valueOf(selection);
            List<SJmoHostGroupInfo> hgInfoList = this.portHGInfoMap.get(portId);
            if (hgInfoList != null) {
                for (SJmoHostGroupInfo hgInfo : hgInfoList) {
                    String name = Short.toString(hgInfo.getSHostGroup());
                    String label = this.portUtil.toHostGroupNameDisplay(hgInfo);
                    this.hgFilter.addItem(name, label);
                }
            } else {
                List<SJmoIscsiTargetInfo> iscsiTargetInfoList = this.portIscsiTargetInfoMap.get(portId);
                if (iscsiTargetInfoList != null) {
                    for (SJmoIscsiTargetInfo iscsiTargetInfo : iscsiTargetInfoList) {
                        String name = Short.toString(iscsiTargetInfo.getSIscsiTarget());
                        String label = this.portUtil.toIscsiTargetAliasDisplay(iscsiTargetInfo);
                        this.hgFilter.addItem(name, label);
                    }
                }
            }
            this.hgFilter.setSelectedIndex(0);
        }
    }

    private void createFilterBaseData(List<SJmoPortDetail> portDtlList, List<SJmoPortHostGroupInfo> portHGInfoList, List<SJmoPortIscsiTargetInfo> portIscsiTargetInfoList, Map<Short, Set<Short>> portHGMap) {
        Set<Short> portIdSet = portHGMap.keySet();
        SJmoPortIndex searchPortIndex = new SJmoPortIndex();
        SJmoHostGroupInfo searchHGinfo = new SJmoHostGroupInfo();
        SJmoIscsiTargetInfo searchIscsiTargetinfo = new SJmoIscsiTargetInfo();
        this.portHGInfoMap = new HashMap<Short, List<SJmoHostGroupInfo>>(portIdSet.size());
        this.portIscsiTargetInfoMap = new HashMap<Short, List<SJmoIscsiTargetInfo>>(portIdSet.size());
        this.filterDistPortDtl = new ArrayList<SJmoPortDetail>(portIdSet.size());
        for (short portId : portIdSet) {
            int portIscsiTargetSearch;
            searchPortIndex.setSPort(portId);
            int portDtlSearch = Collections.binarySearch(portDtlList, searchPortIndex);
            if (portDtlSearch < 0) continue;
            SJmoPortDetail portDtl = portDtlList.get(portDtlSearch);
            this.filterDistPortDtl.add(portDtl);
            Set<Short> hgIdSet = portHGMap.get(portId);
            ArrayList<SJmoHostGroupInfo> hgInfoList = new ArrayList<SJmoHostGroupInfo>(hgIdSet.size());
            ArrayList<SJmoIscsiTargetInfo> iscsiTargetInfoList = new ArrayList<SJmoIscsiTargetInfo>(hgIdSet.size());
            int portHGSearch = Collections.binarySearch(portHGInfoList, searchPortIndex);
            if (portHGSearch >= 0) {
                SJmoPortHostGroupInfo portHGInfo = portHGInfoList.get(portHGSearch);
                ArrayList hgList = portHGInfo.getAlPortHostGroup();
                for (short hgId : hgIdSet) {
                    searchHGinfo.setSPort(portId);
                    searchHGinfo.setSHostGroup(hgId);
                    int hgSearch = Collections.binarySearch(hgList, searchHGinfo);
                    if (hgSearch < 0) continue;
                    SJmoHostGroupInfo hgInfo = (SJmoHostGroupInfo)hgList.get(hgSearch);
                    hgInfoList.add(hgInfo);
                }
                Collections.sort(hgInfoList);
                this.portHGInfoMap.put(portId, hgInfoList);
            }
            if ((portIscsiTargetSearch = Collections.binarySearch(portIscsiTargetInfoList, searchPortIndex)) < 0) continue;
            SJmoPortIscsiTargetInfo portIscsiTargetInfo = portIscsiTargetInfoList.get(portIscsiTargetSearch);
            ArrayList<SJmoIscsiTargetInfo> iscsiTargetList = portIscsiTargetInfo.getAlPortIscsiTarget();
            for (short iscsiTargetId : hgIdSet) {
                searchIscsiTargetinfo.setSPort(portId);
                searchIscsiTargetinfo.setSIscsiTarget(iscsiTargetId);
                int iscsiTargetSearch = Collections.binarySearch(iscsiTargetList, searchIscsiTargetinfo);
                if (iscsiTargetSearch < 0) continue;
                SJmoIscsiTargetInfo iscsiTargetInfo = (SJmoIscsiTargetInfo)iscsiTargetList.get(iscsiTargetSearch);
                iscsiTargetInfoList.add(iscsiTargetInfo);
            }
            Collections.sort(iscsiTargetInfoList);
            this.portIscsiTargetInfoMap.put(portId, iscsiTargetInfoList);
        }
        Collections.sort(this.filterDistPortDtl);
    }

    public short getPortFilter() {
        short ret = -1;
        String selection = this.ptFilter.getSelection();
        if (selection != null && selection.length() > 0) {
            ret = Short.valueOf(selection);
        }
        return ret;
    }

    public short getHGFilter() {
        short ret = -1;
        String selection = this.hgFilter.getSelection();
        if (selection != null && selection.length() > 0) {
            ret = Short.valueOf(selection);
        }
        return ret;
    }

    private void updatePortType() {
        short portId = this.getPortFilter();
        SJmoPortIndex searchPortIndex = new SJmoPortIndex();
        searchPortIndex.setSPort(portId);
        int portDtlSearch = Collections.binarySearch(this.filterDistPortDtl, searchPortIndex);
        if (portDtlSearch >= 0) {
            this.ptType = this.filterDistPortDtl.get(portDtlSearch).getByPortKindNo();
        }
    }

    @Override
    public Object getDataObject(SJctrDataObject inputObject) {
        ((SJctrDataObject)this.getManageData()).setData(KEY_PTTYPE, SJctrComUtility.toDecString(this.ptType));
        return super.getDataObject(inputObject);
    }

    public static enum CHGFILTER_MSG implements SJctrNotifyState
    {
        CHG_HGFILTER;

    }
}

