/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.createtipairs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import sanproject.serversx.data.RJiLDEVIndex;
import sanproject.serverux.dataimpl.MRCFgetTiPvolMu;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.comparator.SJctrLdevIndexComparator;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.wizard.replication.local.createpairs.SJctrCreatePairUtility;
import sanproject.sn2.controller.wizard.replication.local.createtipairs.SJctrCreateSnapshotDataInfo;
import sanproject.sn2.controller.wizard.replication.local.createtipairs.SJctrSnapshotDataNumInfo;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolMu;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolStatus;
import sanproject.sn2.model.data.replication.local.manager.SJmoLocalReplicationPairVolInfoMgr;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevStatusInfo;

public class SJctrCreateTIPairUtility {
    public static final byte SSGCONF_PVOL_STRADDLE = 0;
    public static final byte SSGCONF_PER_PVOL = 1;
    public static final byte SSGCONF_ALL = 2;
    public static final String KEY_FIBRE = "COM_FIBRE";
    public static final String KEY_ISCSI = "COM_ISCSI";
    public static final String KEY_HNAS_USER = "COM_HNAS_USER";

    public static void createError(int func, int module, int error) {
        SJctrError err = new SJctrError(func, module, error);
        SJcException exp = err.createException();
        throw exp;
    }

    public static void createError(int error) {
        SJctrCreateTIPairUtility.createError(209, 22, error);
    }

    public static void createErrorTable(SJctrDataController dc, SJctrTableDataModel table, List<SJctrErrorColumnData> errorColumnList) {
        SJctrCreateTIPairUtility.createErrorTable(dc, table, errorColumnList, null);
    }

    public static void createErrorTable(SJctrDataController dc, SJctrTableDataModel table, List<SJctrErrorColumnData> errorColumnList, Comparator<?> comp) {
        SJctrRelatedDispDataObject rel = dc.createDialog(SJctrErrorDataController.class, null);
        SJctrErrorDataController errDc = (SJctrErrorDataController)dc.getOwner().getDataController(rel);
        if (comp == null) {
            errDc.setParameter(table, errorColumnList);
        } else {
            errDc.setParameter(table, errorColumnList, comp);
        }
        SJctrError representErrorInfo = errDc.getRepresentativeError(errorColumnList);
        SJcException exp = representErrorInfo.createException();
        exp.setErrDisp(rel);
        throw exp;
    }

    public static List<SJmoLdevDetail> getAvailableSVOL(List<SJmoLdevDetail> ldevList, Set<Long> pVolCapSet, SJctrResourceGroupUtility rsgUtil, List<SJmoLdevStatusInfo> ldevStatusInfoList, Set<Integer> haRsvSet, SJmoLocalReplicationPairVolInfoMgr pairMgr, SJmoTiPvolStatus rootStatus, boolean bCascade, List<SJctrCreateSnapshotDataInfo> ssDataList) {
        SJctrLdevIndexComparator comparator = new SJctrLdevIndexComparator();
        ArrayList<SJmoLdevDetail> sVolList = new ArrayList<SJmoLdevDetail>(ldevList.size());
        List<SJmoLdevIndex> extractList = rsgUtil.extractLdev(ldevList);
        extractList = rsgUtil.extractLdevExceptSysRsg(extractList);
        if (ssDataList != null) {
            Collections.sort(ssDataList);
        }
        for (SJmoLdevDetail ldev : ldevList) {
            if (!bCascade ? !SJctrCreateTIPairUtility.chkTiAvailableSvolNotCascade(ldev) : !SJctrCreateTIPairUtility.chkTiAvailableSvolCascade(ldev)) continue;
            if (!SJctrCreateTIPairUtility.chkTiAvailableVolCommon(ldev, pVolCapSet, extractList, ldevStatusInfoList, haRsvSet) || !SJctrCreateTIPairUtility.chkTiAvailableSvolLReplica(ldev, pairMgr, rootStatus, extractList) || ssDataList != null && Collections.binarySearch(ssDataList, ldev, comparator) >= 0) continue;
            sVolList.add(ldev);
        }
        return sVolList;
    }

    public static boolean chkTiAvailableSvolNotCascade(SJmoLdevDetail ldev) {
        boolean brtn = false;
        if (!SJctrCreatePairUtility.checkLUPath(ldev)) {
            return brtn;
        }
        if (!ldev.getbQsVvol()) {
            return brtn;
        }
        brtn = true;
        return brtn;
    }

    public static boolean chkTiAvailableSvolCascade(SJmoLdevDetail ldev) {
        boolean brtn = false;
        if (!ldev.getbVvol() || !ldev.getbAouVvol()) {
            return brtn;
        }
        brtn = true;
        return brtn;
    }

    public static boolean chkTiAvailableVolCommon(SJmoLdevDetail ldev, Set<Long> pVolCapSet, List<SJmoLdevIndex> extractList, List<SJmoLdevStatusInfo> ldevStatusInfoList, Set<Integer> haRsvSet) {
        long ldevCap;
        boolean brtn = false;
        if (Collections.binarySearch(extractList, ldev) < 0) {
            return brtn;
        }
        if (!SJctrCreatePairUtility.isDSUsableEmuType(ldev)) {
            return brtn;
        }
        if (pVolCapSet != null && !pVolCapSet.contains(ldevCap = ldev.getLLDEVLBASize())) {
            return brtn;
        }
        if (ldev.getbLUPathCmdDev()) {
            return brtn;
        }
        if (ldev.getbJNLVolume()) {
            return brtn;
        }
        if (ldev.getbPoolVol()) {
            return brtn;
        }
        if (ldev.getbOdmVol()) {
            return brtn;
        }
        if (haRsvSet.contains(ldev.getIndex())) {
            return brtn;
        }
        if (ldev.getBLockVolume()) {
            return brtn;
        }
        if (ldev.getByVolumeType() == 3 && ldev.getBFPTVol()) {
            return brtn;
        }
        int iLdevStatusIndex = Collections.binarySearch(ldevStatusInfoList, ldev);
        if (iLdevStatusIndex >= 0) {
            if (!SJctrCreatePairUtility.checkCreatePiarUsableStatus(ldevStatusInfoList.get(iLdevStatusIndex))) {
                return brtn;
            }
        } else {
            return brtn;
        }
        brtn = true;
        return brtn;
    }

    private static boolean chkTiAvailableSvolLReplica(SJmoLdevDetail ldev, SJmoLocalReplicationPairVolInfoMgr pairMgr, SJmoTiPvolStatus rootStatus, List<SJmoLdevIndex> extractList) {
        boolean brtn = false;
        SJmoLocalReplicationPairVolInfo pairInfo = pairMgr.getLocalReplicationPairVolInfo(ldev);
        if (pairInfo != null) {
            if (pairInfo.isVolPos(4) || pairInfo.isVolPos(8) || pairInfo.isVolPos(128) || pairInfo.isVolPos(256) || pairInfo.isVolPos(0x400000)) {
                return brtn;
            }
            if (pairInfo.isVolPos(0x800000)) {
                SJmoLdevIndex pVolIndex = pairInfo.getPVolIndex();
                if (pVolIndex == null) {
                    return brtn;
                }
                if (Collections.binarySearch(extractList, pVolIndex) < 0) {
                    return brtn;
                }
                if (pairInfo.isBClone()) {
                    return brtn;
                }
            }
        } else {
            Object[] tiPVolArray = rootStatus.getTiPvolInfo();
            int index = Arrays.binarySearch(tiPVolArray, ldev);
            if (index >= 0) {
                return brtn;
            }
        }
        brtn = true;
        return brtn;
    }

    public static List<SJmoLdevDetail> getLdevListOfExistingLuPath(List<SJmoLdevDetail> ldevList) {
        ArrayList<SJmoLdevDetail> ldevListOfExistingLuPath = new ArrayList<SJmoLdevDetail>(ldevList.size());
        for (SJmoLdevDetail ldev : ldevList) {
            if (!SJctrCreatePairUtility.checkLUPath(ldev)) continue;
            ldevListOfExistingLuPath.add(ldev);
        }
        return ldevListOfExistingLuPath;
    }

    public static SJmoTiPvolMu createTiPVolMuInfo() {
        return SJctrCreateTIPairUtility.createTiPVolMuInfo((short)-1, (short)-1, (short)-1, (short)-1);
    }

    public static SJmoTiPvolMu createTiPVolMuInfo(short ldkc, short cu, short ldev, short mu) {
        MRCFgetTiPvolMu tipVolMu = new MRCFgetTiPvolMu();
        RJiLDEVIndex pVol = new RJiLDEVIndex();
        pVol.setLDEVIndex(ldkc, cu, ldev);
        tipVolMu.setPvol(pVol);
        tipVolMu.setMu(mu);
        return new SJmoTiPvolMu(tipVolMu);
    }

    public static SJctrSnapshotDataNumInfo getSJctrSnapshotDataNumInfoFormLdev(SJmoLdevIndex ldevIndex, List<SJctrSnapshotDataNumInfo> ssDataNumList, SJmoLocalReplicationPairVolInfoMgr pairMgr) {
        SJctrSnapshotDataNumInfo rtnInfo = null;
        SJmoLdevIndex serchIndex = null;
        SJmoLocalReplicationPairVolInfo pairInfo = pairMgr.getLocalReplicationPairVolInfo(ldevIndex);
        serchIndex = pairInfo == null || !pairInfo.isVolPos(0x800000) || pairInfo.isBClone() ? ldevIndex : pairInfo.getRootLdev();
        int i = Collections.binarySearch(ssDataNumList, serchIndex);
        if (i >= 0) {
            rtnInfo = ssDataNumList.get(i);
        }
        return rtnInfo;
    }
}

