/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.createtipairs.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.com.comparator.SJctrHGInfoComparator;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;

public class SJctrHostGroupNameColumnFromPortLunDetail
extends SJctrColumn {
    private SJmoHostGroupInfo searchHgInfo = new SJmoHostGroupInfo();
    private SJctrHGInfoComparator HGID_COMP = new SJctrHGInfoComparator();

    public SJctrHostGroupNameColumnFromPortLunDetail(String key) {
        super(key);
        this.setPartsId("HG_NAME_ISCSI_TARGET_ALIAS");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetPortLunInfo.class);
        list.add(SJmoGetPortHostGroupInfo.class);
        list.add(SJmoGetPortIscsiTargetInfo.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<SJmoHostGroupInfo> list = new ArrayList<SJmoHostGroupInfo>();
        SJmoPortLunDetail luPathInfo = (SJmoPortLunDetail)index;
        SJmoPortIndex targetData = null;
        targetData = this.getHostGroupInfo(luPathInfo, modelData);
        if (targetData == null) {
            targetData = this.getIscsiTargetInfo(luPathInfo, modelData);
        }
        list.add((SJmoHostGroupInfo)targetData);
        return list;
    }

    protected SJmoHostGroupInfo getHostGroupInfo(SJmoPortLunDetail luPathInfo, Map<Class<?>, List<?>> modelData) {
        int searchPort;
        SJmoHostGroupInfo hgInfo = null;
        List<?> portHgInfoList = modelData.get(SJmoGetPortHostGroupInfo.class);
        if (portHgInfoList != null && (searchPort = Collections.binarySearch(portHgInfoList, luPathInfo)) >= 0) {
            SJmoPortHostGroupInfo portHgInfo = (SJmoPortHostGroupInfo)portHgInfoList.get(searchPort);
            ArrayList hgInfoList = portHgInfo.getAlPortHostGroup();
            this.searchHgInfo.setSHostGroup(luPathInfo.getSHostGroup());
            int searchHg = Collections.binarySearch(hgInfoList, this.searchHgInfo, this.HGID_COMP);
            if (searchHg >= 0) {
                hgInfo = (SJmoHostGroupInfo)hgInfoList.get(searchHg);
            }
        }
        return hgInfo;
    }

    protected SJmoIscsiTargetInfo getIscsiTargetInfo(SJmoPortLunDetail luPathInfo, Map<Class<?>, List<?>> modelData) {
        int searchPort;
        SJmoIscsiTargetInfo iscsiTgInfo = null;
        List<?> iscsiTargetInfoList = modelData.get(SJmoGetPortIscsiTargetInfo.class);
        if (iscsiTargetInfoList != null && (searchPort = Collections.binarySearch(iscsiTargetInfoList, luPathInfo)) >= 0) {
            SJmoPortIscsiTargetInfo iscsiTargetInfo = (SJmoPortIscsiTargetInfo)iscsiTargetInfoList.get(searchPort);
            ArrayList<SJmoIscsiTargetInfo> iscsiTargetList = iscsiTargetInfo.getAlPortIscsiTarget();
            this.searchHgInfo.setSHostGroup(luPathInfo.getSHostGroup());
            int searchId = Collections.binarySearch(iscsiTargetList, this.searchHgInfo, this.HGID_COMP);
            if (searchId >= 0) {
                iscsiTgInfo = iscsiTargetList.get(searchId);
            }
        }
        return iscsiTgInfo;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String ret = "";
        if (!dataList.isEmpty()) {
            Object modelData = dataList.get(0);
            if (modelData == null) {
                ret = "?";
            } else {
                SJctrPortUtility util = this.getTable().getComUtility().getPortUtility();
                if (modelData instanceof SJmoHostGroupInfo) {
                    SJmoHostGroupInfo hgInfo = (SJmoHostGroupInfo)modelData;
                    ret = util.toHostGroupNameDisplay(hgInfo);
                } else {
                    SJmoIscsiTargetInfo itInfo = (SJmoIscsiTargetInfo)modelData;
                    ret = util.toIscsiTargetAliasDisplay(itInfo);
                }
            }
        }
        return ret;
    }
}

