/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.addremotepaths;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrMessageDataController;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrObjectSetListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcMessageEventListener;
import sanproject.sn2.controller.wizard.replication.com.SJctrRemoteConnectionUtility;
import sanproject.sn2.controller.wizard.replication.com.SJctrRemoteReplicationDataMacro;
import sanproject.sn2.controller.wizard.replication.remote.addremoteconn.com.SJctrRemoteReplicationTargetPathInfo;
import sanproject.sn2.controller.wizard.replication.remote.addremoteconn.com.SJctrRemoteReplicationTargetPathInfoComparator;
import sanproject.sn2.controller.wizard.replication.remote.addremoteconn.model.SJctrLocalStorageSysDataModel;
import sanproject.sn2.controller.wizard.replication.remote.addremoteconn.model.SJctrRemotePathDataModel;
import sanproject.sn2.controller.wizard.replication.remote.addremoteconn.model.SJctrRemoteStorageSysDataModel;
import sanproject.sn2.controller.wizard.replication.remote.addremotepaths.SJctrAddRemotePathConfirmData;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetPathInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetRemoteReplicationMRCUInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemInfo;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetPathInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationRCUInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationRCUPathInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoRemoteReplicationMRCUInfoMgr;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.system.SJmoSubsystemInfo;

public class SJctrAddRemotePathDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 17831297;
    private static final String DISP_TITLE = "ADD_REMOTE_PATHS";
    private static final String KEY_SELECT_INDEX_MODEL = "COM_SELECT_INDEX_MODEL";
    private static final String KEY_SELECT_INDEX = "COM_SELECT_INDEX";
    private static final String KEY_SELECTED_RCU_INFO = "COM_SELECTED_RCU_INFO";

    public SJctrAddRemotePathDC() {
        super(17831297);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    private void initDataModel() {
        SJctrLocalStorageSysDataModel localSysModel = new SJctrLocalStorageSysDataModel();
        this.addDataObjectModel("COM_LOCAL_STORAGE_SYS_PANEL", localSysModel);
        SJctrRemoteStorageSysDataModel remoteSysModel = new SJctrRemoteStorageSysDataModel();
        this.addDataObjectModel("COM_REMOTE_STORAGE_SYS_PANEL", remoteSysModel);
        SJctrRemotePathDataModel remotePathModel = new SJctrRemotePathDataModel();
        this.addDataObjectModel("COM_REMOTE_PATHS_PANEL", remotePathModel);
        SJctrSimpleDataModel selectIndexModel = new SJctrSimpleDataModel();
        selectIndexModel.addObjectSetListener(new SJctrObjectSetListener(){

            @Override
            public void doAction(Object setObject) {
                SJctrDataObject data;
                Integer index;
                if (setObject instanceof SJctrDataObject && (index = (Integer)(data = (SJctrDataObject)setObject).getData(SJctrAddRemotePathDC.KEY_SELECT_INDEX)) != null) {
                    SJctrSimpleDataModel selectIndexModel = (SJctrSimpleDataModel)SJctrAddRemotePathDC.this.getDataObjectModel(SJctrAddRemotePathDC.KEY_SELECT_INDEX_MODEL);
                    ((SJctrDataObject)selectIndexModel.getManageData()).setData(SJctrAddRemotePathDC.KEY_SELECT_INDEX, index);
                    SJctrAddRemotePathDC.this.fireMessageEvent(ADD_REMOTE_PATH_MSG.PUSH_REMOVE_PATH);
                }
            }
        });
        this.addDataObjectModel(KEY_SELECT_INDEX_MODEL, selectIndexModel);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    private void initListener() {
        this.addMessageEventListener(ADD_REMOTE_PATH_MSG.PUSH_REMOVE_PATH, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddRemotePathDC.this.removeRemotePathAction(event, dstModel);
                SJctrRemoteReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        this.addMessageEventListener(SJctrRemotePathDataModel.REMOTE_PATH_MSG.PUSH_ADD_PATH, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddRemotePathDC.this.addPathAction(event, dstModel);
            }
        });
        this.addMessageEventListener(SJctrRemotePathDataModel.REMOTE_PATH_MSG.CHANGED_RADIO_SELECT_TYPE, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddRemotePathDC.this.chgSelectTypeAction(event, dstModel);
            }
        });
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetRemoteReplicationMRCUInfoMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetSubsystemInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortAttributeInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortIscsiTargetPathInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> viewDataList = this.getProxy().getCache("KEY_REMOTE_SELECTED_CONNECTION");
        if (null == viewDataList) {
            this.logUty.putlog("checkStartData", "Inherited list data is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == viewDataList.size()) {
            this.logUty.putlog("checkStartData", "Size of inherited list data is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (null == viewDataList.get(0)) {
            this.logUty.putlog("checkStartData", "Information of selected RCU is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        try {
            SJmoRemoteReplicationMRCUInfoMgr mrcuInfoMgr = SJctrRemoteReplicationUtility.getSJmoRemoteReplicationMRCUInfoMgr(this);
            SJmoSubsystemInfo subsysInfo = SJctrRemoteReplicationUtility.getSJmoSubsystemInfo(this);
            List<SJmoPortAttributeInfo> portAtrInfoList = SJctrRemoteReplicationUtility.getSJmoPortAttributeInfo(this);
            List<SJmoPortDetail> portDtlList = SJctrReplicationUtility.getSJmoPortDetail(this);
            List<SJmoRSGgetAllRsgs> allRsgInfoList = SJctrReplicationUtility.getSJmoRSGgetAllRsgs(this);
            SJmoRSGgetAllRsgs allRsgInfo = SJctrReplicationUtility.checkSJmoRSGgetAllRsgsInfo(this, allRsgInfoList);
            List<SJmoPortIscsiTargetPathInfo> portIscsiPathInfoList = SJctrIscsiUtility.getSJmoPortIscsiTargetPathInfoList(this);
            List<SJmoRemoteReplicationRCUInfo> viewDataList = this.getProxy().getCache("KEY_REMOTE_SELECTED_CONNECTION");
            List<SJmoRemoteReplicationRCUInfo> selectedRCUInfoList = SJctrRemoteReplicationUtility.checkAndGetExistConnectionInfoSelectableClone(viewDataList, mrcuInfoMgr, false);
            SJmoRemoteReplicationRCUInfo selectedRCUInfo = selectedRCUInfoList.get(0);
            this.putCache(KEY_SELECTED_RCU_INFO, selectedRCUInfoList);
            SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), allRsgInfo);
            if (!SJctrRemoteReplicationUtility.hasRcuPortRs(selectedRCUInfo, rsgUtil)) {
                this.logUty.putlog("checkConstructData", "Can't add path because local port don't have resource authorization exist.");
                SJctrError err = new SJctrError(210, 22, 206041);
                SJcException exp = err.createException();
                throw exp;
            }
            if (selectedRCUInfo.getPathInfoList().size() >= 8) {
                this.logUty.putlog("checkConstructData", "Can't add path because max paths already has be set.");
                SJctrError err = new SJctrError(210, 22, 206055);
                SJcException exp = err.createException();
                throw exp;
            }
            List<SJmoPortDetail> localPortIDList = SJctrRemoteReplicationUtility.createLocalPortIDList(portDtlList, portAtrInfoList, rsgUtil);
            if (0 == localPortIDList.size()) {
                this.logUty.putlog("checkConstructData", "No available Local PortID.");
                SJctrError err = new SJctrError(210, 22, 206021);
                SJcException exp = err.createException();
                throw exp;
            }
            List<SJmoPortDetail> localPortFibreKindList = SJctrRemoteReplicationUtility.getTargetKindPortDetailList(localPortIDList, SJctrRemoteReplicationDataMacro.FIBRE_PORT_KIND);
            List<SJmoPortDetail> localPortIscsiKindList = SJctrRemoteReplicationUtility.getTargetKindPortDetailList(localPortIDList, SJctrRemoteReplicationDataMacro.ISCSI_PORT_KIND);
            this.putCache("COM_AVA_LOCAL_PORT_ID_LIST", localPortFibreKindList);
            this.putCache("COM_AVA_LOCAL_ISCSI_PORT_ID_LIST", localPortIscsiKindList);
            Map<String, List> rcuInfoMap = SJctrRemoteConnectionUtility.getPortTypeRCUPathInfoMap(selectedRCUInfo, this);
            this.putCachePortTypeRCUPathInfo(rcuInfoMap);
            SJmoRemoteReplicationRCUInfo fibreRCUInfo = (SJmoRemoteReplicationRCUInfo)rcuInfoMap.get("COM_FIBRE_RCU_PATH_INFO_LIST").get(0);
            ArrayList<SJmoRemoteReplicationRCUPathInfo> fibreRCUPathInfoList = fibreRCUInfo.getPathInfoList();
            SJctrRemoteConnectionUtility.setEnableStatusSelectTypeRadio(localPortFibreKindList, localPortIscsiKindList, selectedRCUInfo.getIControllerID(), this);
            SJctrRemoteConnectionUtility.setSelectStatusSelectTypeRadio(fibreRCUPathInfoList, selectedRCUInfo.getIControllerID(), this);
            SJmoRemoteReplicationRCUInfo iscsiRCUPath = (SJmoRemoteReplicationRCUInfo)rcuInfoMap.get("COM_ISCSI_RCU_PATH_INFO_LIST").get(0);
            Map<String, SJctrRemoteReplicationTargetPathInfo> targetPathInfoMap = SJctrRemoteConnectionUtility.createRemoteReplicationTargetPathInfoMap(iscsiRCUPath, portIscsiPathInfoList, subsysInfo.getDKCSNString());
            this.putCacheTargetPathInfoMap(targetPathInfoMap);
            selectedRCUInfo = SJctrRemoteConnectionUtility.getCacheSelectTypeRCUPathInfoList(this).get(0);
            SJctrRemoteConnectionUtility.setRemoteConnLocalStorageSysLabelPanel(subsysInfo, this, selectedRCUInfo, this.getComUtility());
            SJctrRemoteConnectionUtility.setRemoteConnRemoteStorageSysLabelPanel(this, selectedRCUInfo, this.getComUtility());
            this.setRemotePathPanel(selectedRCUInfo.getIControllerID(), selectedRCUInfo, portDtlList);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107002);
        }
        return true;
    }

    @Override
    public boolean checkEndData() {
        try {
            List<?> moRcuInfoList = this.getCache(KEY_SELECTED_RCU_INFO);
            SJmoRemoteReplicationRCUInfo rcuInfo = null;
            try {
                rcuInfo = (SJmoRemoteReplicationRCUInfo)((SJmoRemoteReplicationRCUInfo)moRcuInfoList.get(0)).clone();
            }
            catch (CloneNotSupportedException e) {
                this.getLogUty().putlog("checkEndData", "Information of SJmoRemoteReplicationRCUInfo cannot clone.");
                SJctrError err = new SJctrError(210, 22, 107003);
                SJcException exp = err.createException();
                throw exp;
            }
            ArrayList<Integer> portIDIdxList = this.getAddPortIDIndexList();
            ArrayList<SJmoRemoteReplicationRCUPathInfo> pathInfoList = new ArrayList<SJmoRemoteReplicationRCUPathInfo>();
            ArrayList<SJmoRemoteReplicationRCUPathInfo> allPathInfoList = rcuInfo.getPathInfoList();
            SJmoSubsystemInfo subsysInfo = SJctrRemoteReplicationUtility.getSJmoSubsystemInfo(this);
            SJctrRemotePathDataModel remotePathModel = SJctrRemoteConnectionUtility.getRemotePathModel(this);
            int selectType = remotePathModel.getSelectType();
            ArrayList<SJctrRemoteReplicationTargetPathInfo> targetPathInfoList = new ArrayList<SJctrRemoteReplicationTargetPathInfo>();
            for (int idx : portIDIdxList) {
                SJctrComboBoxDataModel localPortIDModel = SJctrRemoteConnectionUtility.getLocalPortIDPullDownModel(this, idx);
                SJctrComboBoxDataModel remotePortIDModel = SJctrRemoteConnectionUtility.getRemotePortIDPullDownModel(this, idx);
                if (localPortIDModel.getSelectedIndex() == -1 || remotePortIDModel.getSelectedIndex() == -1 || localPortIDModel.getSelectedIndex() == 0 || remotePortIDModel.getSelectedIndex() == 0) continue;
                SJmoRemoteReplicationRCUPathInfo pathInfo = new SJmoRemoteReplicationRCUPathInfo();
                pathInfo.setSPort((short)SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(localPortIDModel));
                pathInfo.setIRCUPortNo((short)SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(remotePortIDModel));
                pathInfoList.add(pathInfo);
                allPathInfoList.add(pathInfo);
                SJctrRemoteReplicationTargetPathInfo remotePathInfo = this.createRemoteTargetPathInfo(idx, selectType);
                if (selectType == 1) {
                    String name = SJctrRemoteConnectionUtility.createRemoteReplicationiScsiName(rcuInfo.getIControllerID(), SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(remotePortIDModel), rcuInfo.getStrSN(), subsysInfo.getDKCSNString());
                    remotePathInfo.setStrTargetName(name);
                }
                targetPathInfoList.add(remotePathInfo);
            }
            Collections.sort(pathInfoList);
            Collections.sort(targetPathInfoList, new SJctrRemoteReplicationTargetPathInfoComparator());
            ArrayList<SJmoRemoteReplicationRCUInfo> rcuInfoList = new ArrayList<SJmoRemoteReplicationRCUInfo>();
            rcuInfoList.add(rcuInfo);
            SJctrAddRemotePathConfirmData confirmData = new SJctrAddRemotePathConfirmData();
            confirmData.setRCUInfo(rcuInfoList);
            confirmData.setAddRCUPathInfo(pathInfoList);
            confirmData.setRemotePathInfoList(targetPathInfoList);
            ArrayList<SJctrAddRemotePathConfirmData> confirmDataList = new ArrayList<SJctrAddRemotePathConfirmData>();
            confirmDataList.add(confirmData);
            confirmData.setNeedData(this);
            this.putCache(SJctrAddRemotePathConfirmData.class, confirmDataList);
            SJctrRemoteReplicationUtility.setFinishChangeCheck(this, false);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107003);
        }
        return true;
    }

    protected void removeRemotePathAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        try {
            SJctrSimpleDataModel selectIndexModel = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_SELECT_INDEX_MODEL);
            Integer pathIndex = (Integer)((SJctrDataObject)selectIndexModel.getManageData()).getData(KEY_SELECT_INDEX);
            if (pathIndex != null) {
                SJctrRemoteConnectionUtility.removePathPanel(this, pathIndex);
                SJctrRemoteConnectionUtility.decrementTotalNumberOfPaths(this);
            }
            this.updateFooter();
            this.setDirtyAll();
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107004);
        }
    }

    protected void addPathAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        try {
            List<SJmoPortDetail> localPortIDList = SJctrRemoteConnectionUtility.getCacheSelectTypePortList(this);
            List<?> rcuInfoList = this.getCache(KEY_SELECTED_RCU_INFO);
            if (localPortIDList != null && rcuInfoList != null) {
                int modelID = ((SJmoRemoteReplicationRCUInfo)rcuInfoList.get(0)).getIControllerID();
                SJctrRemoteConnectionUtility.addPathPanel(this, modelID, localPortIDList, this.getComUtility());
                SJctrRemoteConnectionUtility.incrementTotalNumberOfPaths(this);
            }
            this.updateFooter();
            this.setDirtyAll();
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107004);
        }
    }

    private void setRemotePathPanel(int modelID, SJmoRemoteReplicationRCUInfo rcuInfo, List<SJmoPortDetail> portDtlList) {
        SJctrRemotePathDataModel remotePathModel = SJctrRemoteConnectionUtility.getRemotePathModel(this);
        if (rcuInfo.getICUFree() == 1) {
            ((SJctrDataObject)remotePathModel.getManageData()).setData("COM_PATH_GRP_ID_STR", SJctrComUtility.toHexString(rcuInfo.getIRCUID(), 2, true));
        } else {
            ((SJctrDataObject)remotePathModel.getManageData()).setData("COM_PATH_GRP_ID_STR", "-");
        }
        ((SJctrDataObject)remotePathModel.getManageData()).setData("COM_MIN_NUM_OF_PATHS_STR", SJctrComUtility.toDecString(rcuInfo.getRCUOption().getINumofMimPath()));
        this.setPortIDPanel(rcuInfo, portDtlList);
    }

    private void setPortIDPanel(SJmoRemoteReplicationRCUInfo rcuInfo, List<SJmoPortDetail> portDtlList) {
        SJctrRemoteReplicationUtility remoteReplicaUty = this.getComUtility().getRemoteReplicationUtility();
        SJctrPortUtility portUtil = this.getComUtility().getPortUtility();
        Map<Short, String> remotePortIDMap = SJctrRemoteReplicationUtility.getPortNameMap(rcuInfo.getIControllerID());
        SJctrRemotePathDataModel remotePathModel = SJctrRemoteConnectionUtility.getRemotePathModel(this);
        boolean selectTypeIscsi = remotePathModel.getSelectType() == 1;
        Map iscsiTargetPathMap = new HashMap();
        List<?> iscsiTargetPathMapList = this.getCache("COM_ISCSI_TARGET_PATH_INFO_LIST");
        if (iscsiTargetPathMapList != null) {
            iscsiTargetPathMap = (Map)iscsiTargetPathMapList.get(0);
        }
        int idx = 0;
        for (SJmoRemoteReplicationRCUPathInfo pathInfo : rcuInfo.getPathInfoList()) {
            SJctrComboBoxDataModel localPortcomboObj = SJctrRemoteConnectionUtility.getLocalPortIDPullDownModel(this, idx);
            localPortcomboObj.removeAllItems();
            SJctrComboBoxDataModel remotePortcomboObj = SJctrRemoteConnectionUtility.getRemotePortIDPullDownModel(this, idx);
            remotePortcomboObj.removeAllItems();
            SJctrComboBoxDataModel virtualPortIDModel = SJctrRemoteConnectionUtility.getVirtualPortIDListModel(this, idx);
            virtualPortIDModel.removeAllItems();
            SJmoPortDetail portDetailInfo = null;
            int index = Collections.binarySearch(portDtlList, pathInfo);
            if (index >= 0) {
                portDetailInfo = portDtlList.get(index);
                localPortcomboObj.addItem(Integer.toString(portDetailInfo.getIndex()), portUtil.toPortNameDisplay(portDetailInfo));
            }
            localPortcomboObj.setEnable(false);
            localPortcomboObj.setSelectedIndex(0);
            ArrayList<SJmoPortDetail> virtualPortIDList = new ArrayList<SJmoPortDetail>(1);
            virtualPortIDList.add(portDetailInfo);
            SJctrRemoteConnectionUtility.createVirtualPortID(virtualPortIDModel, virtualPortIDList);
            virtualPortIDModel.removeItem("");
            short portID = (short)pathInfo.getIRCUPortNo();
            remotePortcomboObj.addItem(Short.toString(portID), remoteReplicaUty.getRemotePortName(remotePortIDMap.get(portID)));
            remotePortcomboObj.setEnable(false);
            remotePortcomboObj.setSelectedIndex(0);
            if (selectTypeIscsi) {
                SJctrRemoteReplicationTargetPathInfo targetPath = (SJctrRemoteReplicationTargetPathInfo)iscsiTargetPathMap.get(pathInfo.toString());
                this.setPortIDPanelTargetPathInfo(targetPath, idx);
            }
            ++idx;
        }
        ((SJctrDataObject)remotePathModel.getManageData()).setData("COM_ADDED_PATH_COUNT", rcuInfo.getPathInfoList().size());
        ((SJctrDataObject)remotePathModel.getManageData()).setData("COM_DISP_PATH_COUNT", rcuInfo.getPathInfoList().size());
        SJmoRemoteReplicationRCUInfo fibreRCUInfo = SJctrRemoteConnectionUtility.getCacheSelectTypeRCUPathInfoList(0, this).get(0);
        SJmoRemoteReplicationRCUInfo iscsiRCUInfo = SJctrRemoteConnectionUtility.getCacheSelectTypeRCUPathInfoList(1, this).get(0);
        int totalPaths = iscsiRCUInfo.getPathInfoList().size() + fibreRCUInfo.getPathInfoList().size();
        SJctrRemoteConnectionUtility.updateTotalNumberOfPaths(totalPaths, this);
        List<SJmoPortDetail> localPortIDList = SJctrRemoteConnectionUtility.getCacheSelectTypePortList(this);
        int minPath = rcuInfo.getRCUOption().getINumofMimPath();
        if (rcuInfo.getPathInfoList().size() < minPath) {
            if (totalPaths > 0) {
                SJctrRemoteConnectionUtility.addPathPanel(this, rcuInfo.getIControllerID(), localPortIDList, this.getComUtility());
                SJctrRemoteConnectionUtility.incrementTotalNumberOfPaths(this);
            } else {
                int addCount = minPath - rcuInfo.getPathInfoList().size();
                for (int cnt = 0; cnt < addCount; ++cnt) {
                    SJctrRemoteConnectionUtility.addPathPanel(this, rcuInfo.getIControllerID(), localPortIDList, this.getComUtility());
                    SJctrRemoteConnectionUtility.incrementTotalNumberOfPaths(this);
                }
            }
        } else {
            SJctrRemoteConnectionUtility.addPathPanel(this, rcuInfo.getIControllerID(), localPortIDList, this.getComUtility());
            SJctrRemoteConnectionUtility.incrementTotalNumberOfPaths(this);
        }
    }

    private ArrayList<Integer> getAddPortIDIndexList() {
        int addedCount;
        ArrayList<Integer> portIDIdx = new ArrayList<Integer>();
        SJctrRemotePathDataModel remotePathModel = SJctrRemoteConnectionUtility.getRemotePathModel(this);
        int pathCount = (Integer)((SJctrDataObject)remotePathModel.getManageData()).getData("COM_DISP_PATH_COUNT");
        for (int pid = addedCount = ((Integer)((SJctrDataObject)remotePathModel.getManageData()).getData("COM_ADDED_PATH_COUNT")).intValue(); pid < pathCount; ++pid) {
            portIDIdx.add(pid);
        }
        return portIDIdx;
    }

    @Override
    public boolean checkFinishData(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        this.checkSettingError();
        boolean dispWarning = false;
        SJctrRemotePathDataModel remotePathModel = SJctrRemoteConnectionUtility.getRemotePathModel(this);
        if (remotePathModel.getSelectType() == 1) {
            SJmoRemoteReplicationRCUInfo rcuInfo = SJctrRemoteConnectionUtility.getCacheSelectTypeRCUPathInfoList(this).get(0);
            ArrayList<Integer> portIDIdxList = this.getAddPortIDIndexList();
            SJctrRemoteReplicationTargetPathInfo targetPathInfo = SJctrRemoteConnectionUtility.getExistIscsiTargetPathInfo(portIDIdxList, rcuInfo.getIControllerID(), rcuInfo.getStrSN(), this);
            if (targetPathInfo != null) {
                this.dispMsgDialogExistsiScsiName(event, dstModel);
                dispWarning = true;
            }
        }
        if (!dispWarning && this.isChangeMixedPortType()) {
            this.dispMsgDialogPortTypeMixed(event, dstModel);
            dispWarning = true;
        }
        return dispWarning;
    }

    private void dispMsgDialogExistsiScsiName(final SJctrMessageEvent msgEvent, final SJctrDataObjectModel<?> dstModel) {
        String strFuncID = Integer.toString(210);
        String strModuleID = Integer.toString(22);
        String strMsgID = Integer.toString(206280);
        SJcMessage msg = new SJcMessage(strFuncID, strModuleID, strMsgID);
        SJctrRelatedDispDataObject related = this.createMsgDialog(msg);
        SJctrMessageDataController msgDC = (SJctrMessageDataController)this.getOwner().getDataController(related);
        msgDC.addButton(SJctrMessageDataController.MD_OK, new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (SJctrAddRemotePathDC.this.isChangeMixedPortType()) {
                    SJctrAddRemotePathDC.this.dispMsgDialogPortTypeMixed(msgEvent, dstModel);
                } else {
                    SJctrRemotePathDataModel remotePathDataModel = (SJctrRemotePathDataModel)SJctrAddRemotePathDC.this.getDataObjectModel("COM_REMOTE_PATHS_PANEL");
                    remotePathDataModel.setDirty();
                    SJctrAddRemotePathDC.this.finishEvent(msgEvent, dstModel);
                }
            }
        });
        msgDC.addButton(SJctrMessageDataController.MD_CANCEL);
        this.addUpdateDisp(related);
    }

    private void dispMsgDialogPortTypeMixed(final SJctrMessageEvent msgEvent, final SJctrDataObjectModel<?> dstModel) {
        String strFuncID = Integer.toString(210);
        String strModuleID = Integer.toString(22);
        String strMsgID = Integer.toString(206281);
        SJcMessage msg = new SJcMessage(strFuncID, strModuleID, strMsgID);
        SJctrRelatedDispDataObject related = this.createMsgDialog(msg);
        SJctrMessageDataController msgDC = (SJctrMessageDataController)this.getOwner().getDataController(related);
        msgDC.addButton(SJctrMessageDataController.MD_OK, new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrRemotePathDataModel remotePathDataModel = (SJctrRemotePathDataModel)SJctrAddRemotePathDC.this.getDataObjectModel("COM_REMOTE_PATHS_PANEL");
                remotePathDataModel.setDirty();
                SJctrAddRemotePathDC.this.finishEvent(msgEvent, dstModel);
            }
        });
        msgDC.addButton(SJctrMessageDataController.MD_CANCEL);
        this.addUpdateDisp(related);
    }

    private void chgSelectTypeAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        try {
            SJmoRemoteReplicationRCUInfo rcuInfo = SJctrRemoteConnectionUtility.getCacheSelectTypeRCUPathInfoList(this).get(0);
            List<SJmoPortDetail> portDetailList = SJctrRemoteConnectionUtility.getCacheSelectTypePortList(this);
            this.setPortIDPanel(rcuInfo, portDetailList);
            this.updateFooter();
            this.setDirtyAll();
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107004);
        }
    }

    private void putCachePortTypeRCUPathInfo(Map<String, List> map) {
        List fibreRCUInfoList = map.get("COM_FIBRE_RCU_PATH_INFO_LIST");
        this.getProxy().putCache("COM_FIBRE_RCU_PATH_INFO_LIST", fibreRCUInfoList);
        List iscsiRCUInfoList = map.get("COM_ISCSI_RCU_PATH_INFO_LIST");
        this.getProxy().putCache("COM_ISCSI_RCU_PATH_INFO_LIST", iscsiRCUInfoList);
    }

    private void putCacheTargetPathInfoMap(Map<String, SJctrRemoteReplicationTargetPathInfo> map) {
        ArrayList<Map<String, SJctrRemoteReplicationTargetPathInfo>> mapList = new ArrayList<Map<String, SJctrRemoteReplicationTargetPathInfo>>(1);
        mapList.add(map);
        this.getProxy().putCache("COM_ISCSI_TARGET_PATH_INFO_LIST", mapList);
    }

    private void setPortIDPanelTargetPathInfo(SJctrRemoteReplicationTargetPathInfo targetPathInfo, int idx) {
        SJctrComboBoxDataModel ipAddrTypeModel = SJctrRemoteConnectionUtility.getRemotePathRemoteIpAddrTypeModel(this, idx);
        SJctrTextBoxDataModel ipAddrModel = SJctrRemoteConnectionUtility.getRemotePathRemoteIpAddrModel(this, idx);
        SJctrTextBoxDataModel tcpPortNumModel = SJctrRemoteConnectionUtility.getRemotePathRemoteTcpPortNumber(this, idx);
        String ipType = "";
        String ipAddr = "";
        String tcpPortNum = "";
        if (targetPathInfo != null) {
            if (targetPathInfo.getIIpType() == 0) {
                ipType = this.getComUtility().getGuidance("IPV4");
                ipAddr = SJctrPortUtility.toDispIPv4(targetPathInfo.getIIpv4Address());
            } else {
                ipType = this.getComUtility().getGuidance("IPV6");
                ipAddr = SJctrIscsiUtility.getIpv6AddrString(targetPathInfo.getIIpv6Address());
            }
            tcpPortNum = String.valueOf(targetPathInfo.getITcpPortNumber());
        }
        ipAddrTypeModel.removeAllItems();
        ipAddrTypeModel.addItem(ipType);
        ipAddrTypeModel.setEnable(false);
        ipAddrTypeModel.setSelectedIndex(0);
        ipAddrModel.setValue(ipAddr);
        ipAddrModel.setEnable(false);
        tcpPortNumModel.setValue(tcpPortNum);
        tcpPortNumModel.setEnable(false);
    }

    public SJctrRemoteReplicationTargetPathInfo createRemoteTargetPathInfo(int index, int selectType) {
        SJctrRemoteReplicationTargetPathInfo remotePathInfo = new SJctrRemoteReplicationTargetPathInfo();
        remotePathInfo.setPortType(selectType);
        SJctrComboBoxDataModel localPortIDModel = SJctrRemoteConnectionUtility.getLocalPortIDPullDownModel(this, index);
        SJctrComboBoxDataModel remotePortIDModel = SJctrRemoteConnectionUtility.getRemotePortIDPullDownModel(this, index);
        remotePathInfo.setSPort((short)SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(localPortIDModel));
        remotePathInfo.setRemotePortId(SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(remotePortIDModel));
        if (selectType == 1) {
            SJctrComboBoxDataModel ipAddressTypeModel = SJctrRemoteConnectionUtility.getRemotePathRemoteIpAddrTypeModel(this, index);
            SJctrTextBoxDataModel ipAddressModel = SJctrRemoteConnectionUtility.getRemotePathRemoteIpAddrModel(this, index);
            SJctrTextBoxDataModel tcpPortNumModel = SJctrRemoteConnectionUtility.getRemotePathRemoteTcpPortNumber(this, index);
            int ipType = Integer.parseInt(ipAddressTypeModel.getSelection());
            remotePathInfo.setIIpType(ipType);
            if (ipType == 0) {
                remotePathInfo.setIIpv4Address(SJctrRemoteReplicationUtility.getIpv4Address(ipAddressModel.getValue()));
            } else {
                remotePathInfo.setIIpv6Address(SJctrIscsiUtility.splitIPv6String(ipAddressModel.getValue()));
            }
            remotePathInfo.setITcpPortNumber(Integer.parseInt(tcpPortNumModel.getValue()));
        }
        return remotePathInfo;
    }

    private void checkSettingError() {
        List<?> moRcuInfoList = this.getCache(KEY_SELECTED_RCU_INFO);
        SJmoRemoteReplicationRCUInfo rcuInfo = null;
        try {
            rcuInfo = (SJmoRemoteReplicationRCUInfo)((SJmoRemoteReplicationRCUInfo)moRcuInfoList.get(0)).clone();
        }
        catch (CloneNotSupportedException e) {
            this.getLogUty().putlog("checkSettingError", "Information of SJmoRemoteReplicationRCUInfo cannot clone.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107003);
        }
        ArrayList<SJmoRemoteReplicationRCUPathInfo> allPathInfoList = rcuInfo.getPathInfoList();
        ArrayList<Integer> portIDIdxList = this.getAddPortIDIndexList();
        for (int idx : portIDIdxList) {
            SJmoRemoteReplicationRCUPathInfo pathInfo = new SJmoRemoteReplicationRCUPathInfo();
            SJctrComboBoxDataModel localPortIDModel = SJctrRemoteConnectionUtility.getLocalPortIDPullDownModel(this, idx);
            SJctrComboBoxDataModel remotePortIDModel = SJctrRemoteConnectionUtility.getRemotePortIDPullDownModel(this, idx);
            pathInfo.setSPort((short)SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(localPortIDModel));
            pathInfo.setIRCUPortNo((short)SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(remotePortIDModel));
            allPathInfoList.add(pathInfo);
        }
        int[][] portID = new int[8][2];
        for (int pid = 0; pid < allPathInfoList.size(); ++pid) {
            portID[pid][0] = allPathInfoList.get(pid).getSPort();
            portID[pid][1] = allPathInfoList.get(pid).getIRCUPortNo();
        }
        if (SJctrRemoteReplicationUtility.chkRemoteConPortIDDuplicate(portID, allPathInfoList.size())) {
            this.getLogUty().putlog("checkSettingError", "Port ID Pair is duplicating.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206080);
        }
    }

    private boolean isChangeMixedPortType() {
        boolean ret = false;
        SJmoRemoteReplicationRCUInfo fibreRCUInfo = SJctrRemoteConnectionUtility.getCacheSelectTypeRCUPathInfoList(0, this).get(0);
        ArrayList<SJmoRemoteReplicationRCUPathInfo> fibrePathInfoList = fibreRCUInfo.getPathInfoList();
        SJmoRemoteReplicationRCUInfo iscsiRCUInfo = SJctrRemoteConnectionUtility.getCacheSelectTypeRCUPathInfoList(1, this).get(0);
        ArrayList<SJmoRemoteReplicationRCUPathInfo> iscsiPathInfoList = iscsiRCUInfo.getPathInfoList();
        if (fibrePathInfoList.size() > 0 && iscsiPathInfoList.size() > 0) {
            return false;
        }
        SJctrRemotePathDataModel remotePathModel = SJctrRemoteConnectionUtility.getRemotePathModel(this);
        int selectType = remotePathModel.getSelectType();
        if (selectType == 0) {
            if (!iscsiPathInfoList.isEmpty()) {
                ret = true;
            }
        } else if (!fibrePathInfoList.isEmpty()) {
            ret = true;
        }
        return ret;
    }

    private static enum ADD_REMOTE_PATH_MSG implements SJctrNotifyState
    {
        PUSH_REMOVE_PATH;

    }
}

