/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.addssids;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrObjectSetListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcMessageEventListener;
import sanproject.sn2.controller.wizard.replication.com.SJctrRemoteConnectionUtility;
import sanproject.sn2.controller.wizard.replication.remote.addremoteconn.model.SJctrLocalStorageSysDataModel;
import sanproject.sn2.controller.wizard.replication.remote.addremoteconn.model.SJctrRemotePathDataModel;
import sanproject.sn2.controller.wizard.replication.remote.addremoteconn.model.SJctrRemoteSSIDDataModel;
import sanproject.sn2.controller.wizard.replication.remote.addremoteconn.model.SJctrRemoteStorageSysDataModel;
import sanproject.sn2.controller.wizard.replication.remote.addssids.SJctrAddSsidsConfirmData;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetRemoteReplicationMRCUInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationRCUInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoRemoteReplicationMRCUInfoMgr;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.system.SJmoSubsystemInfo;

public class SJctrAddSsidsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 0x1101601;
    private static final String DISP_TITLE = "ADD_SSIDS";
    private static final String KEY_SELECT_INDEX_MODEL = "COM_SELECT_INDEX_MODEL";
    private static final String KEY_SELECT_INDEX = "COM_SELECT_INDEX";
    private static final String KEY_SELECTED_RCU_INFO = "COM_SELECTED_RCU_INFO";

    public SJctrAddSsidsDC() {
        super(0x1101601);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    private void initDataModel() {
        SJctrLocalStorageSysDataModel localSysModel = new SJctrLocalStorageSysDataModel();
        this.addDataObjectModel("COM_LOCAL_STORAGE_SYS_PANEL", localSysModel);
        SJctrRemoteStorageSysDataModel remoteSysModel = new SJctrRemoteStorageSysDataModel();
        this.addDataObjectModel("COM_REMOTE_STORAGE_SYS_PANEL", remoteSysModel);
        SJctrRemotePathDataModel remotePathModel = new SJctrRemotePathDataModel();
        this.addDataObjectModel("COM_REMOTE_PATHS_PANEL", remotePathModel);
        SJctrSimpleDataModel selectIndexModel = new SJctrSimpleDataModel();
        selectIndexModel.addObjectSetListener(new SJctrObjectSetListener(){

            @Override
            public void doAction(Object setObject) {
                SJctrDataObject data;
                Integer index;
                if (setObject instanceof SJctrDataObject && (index = (Integer)(data = (SJctrDataObject)setObject).getData(SJctrAddSsidsDC.KEY_SELECT_INDEX)) != null) {
                    SJctrSimpleDataModel selectIndexModel = (SJctrSimpleDataModel)SJctrAddSsidsDC.this.getDataObjectModel(SJctrAddSsidsDC.KEY_SELECT_INDEX_MODEL);
                    ((SJctrDataObject)selectIndexModel.getManageData()).setData(SJctrAddSsidsDC.KEY_SELECT_INDEX, index);
                    SJctrAddSsidsDC.this.fireMessageEvent(ADD_SSID_MSG.PUSH_REMOVE_SSID);
                }
            }
        });
        this.addDataObjectModel(KEY_SELECT_INDEX_MODEL, selectIndexModel);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    private void initListener() {
        this.addMessageEventListener(ADD_SSID_MSG.PUSH_REMOVE_SSID, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrRemoteReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
                SJctrAddSsidsDC.this.removeSSIDAction(event, dstModel);
            }
        });
        this.addMessageEventListener(SJctrRemoteStorageSysDataModel.REMOTE_SYS_MSG.PUSH_ADD_SSID, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddSsidsDC.this.addSSIDAction(event, dstModel);
            }
        });
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetRemoteReplicationMRCUInfoMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetSubsystemInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> viewDataList = this.getProxy().getCache("KEY_REMOTE_SELECTED_CONNECTION");
        if (null == viewDataList) {
            this.logUty.putlog("checkStartData", "Inherited list data is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == viewDataList.size()) {
            this.logUty.putlog("checkStartData", "Size of inherited list data is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (null == viewDataList.get(0)) {
            this.logUty.putlog("checkStartData", "Information of selected RCU is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        try {
            SJmoRemoteReplicationMRCUInfoMgr mrcuInfoMgr = SJctrRemoteReplicationUtility.getSJmoRemoteReplicationMRCUInfoMgr(this);
            SJmoSubsystemInfo subsysInfo = SJctrRemoteReplicationUtility.getSJmoSubsystemInfo(this);
            List<SJmoPortDetail> portDtlList = SJctrReplicationUtility.getSJmoPortDetail(this);
            List<SJmoRSGgetAllRsgs> allRsgInfoList = SJctrReplicationUtility.getSJmoRSGgetAllRsgs(this);
            SJmoRSGgetAllRsgs allRsgInfo = SJctrReplicationUtility.checkSJmoRSGgetAllRsgsInfo(this, allRsgInfoList);
            List<SJmoRemoteReplicationRCUInfo> viewDataList = this.getProxy().getCache("KEY_REMOTE_SELECTED_CONNECTION");
            List<SJmoRemoteReplicationRCUInfo> selectedRCUInfoList = SJctrRemoteReplicationUtility.checkAndGetExistConnectionInfo(viewDataList, mrcuInfoMgr);
            SJmoRemoteReplicationRCUInfo selectedRCUInfo = selectedRCUInfoList.get(0);
            this.putCache(KEY_SELECTED_RCU_INFO, selectedRCUInfoList);
            SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), allRsgInfo);
            if (!SJctrRemoteReplicationUtility.hasRcuPortRs(selectedRCUInfo, rsgUtil)) {
                this.logUty.putlog("checkConstructData", "Can't add ssid because local port don't have resource authorization exist.");
                SJctrError err = new SJctrError(210, 22, 206041);
                SJcException exp = err.createException();
                throw exp;
            }
            if (selectedRCUInfo.getICUFree() != 0) {
                this.logUty.putlog("checkConstructData", "Can't add ssid because connection type selected connection is not cu.");
                SJctrError err = new SJctrError(210, 22, 206054);
                SJcException exp = err.createException();
                throw exp;
            }
            if (selectedRCUInfo.getINumofSSID() >= 4) {
                this.logUty.putlog("checkConstructData", "Can't add ssid because max ssids already has be set.");
                SJctrError err = new SJctrError(210, 22, 206053);
                SJcException exp = err.createException();
                throw exp;
            }
            if (selectedRCUInfo.getRCUOption().getINumofMimPath() > selectedRCUInfo.getPathInfoList().size()) {
                this.logUty.putlog("checkConstructData", "Can't add ssid because set path count under the minimum path count.");
                SJctrError err = new SJctrError(210, 22, 206147);
                SJcException exp = err.createException();
                throw exp;
            }
            SJctrRemoteConnectionUtility.setRemoteConnLocalStorageSysLabelPanel(subsysInfo, this, selectedRCUInfo, this.getComUtility());
            this.setRemoteSystemModelPanel(selectedRCUInfo);
            SJctrRemoteConnectionUtility.setRemoteConnRemotePathLabelPanel(this, selectedRCUInfo, portDtlList);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107002);
        }
        return true;
    }

    @Override
    public boolean checkEndData() {
        try {
            List<?> mrcuInfoList = this.getCache(KEY_SELECTED_RCU_INFO);
            SJmoRemoteReplicationRCUInfo rcuInfo = (SJmoRemoteReplicationRCUInfo)mrcuInfoList.get(0);
            SJctrAddSsidsConfirmData confirmData = new SJctrAddSsidsConfirmData();
            int[] dispSSIDList = SJctrRemoteConnectionUtility.getSSIDListFromWizard(this);
            rcuInfo.setISSID(dispSSIDList);
            rcuInfo.setINumofSSID(dispSSIDList.length);
            int[] addSSIDList = SJctrRemoteConnectionUtility.getTargetSSIDListFromWizard(this);
            confirmData.setAddSSIDList(addSSIDList);
            ArrayList<SJmoRemoteReplicationRCUInfo> rcuInfoList = new ArrayList<SJmoRemoteReplicationRCUInfo>();
            rcuInfoList.add(rcuInfo);
            confirmData.setRCUInfo(rcuInfoList);
            ArrayList<SJctrAddSsidsConfirmData> confirmDataList = new ArrayList<SJctrAddSsidsConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrAddSsidsConfirmData.class, confirmDataList);
            SJctrRemoteReplicationUtility.setFinishChangeCheck(this, false);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107003);
        }
        return true;
    }

    private void removeSSIDAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        try {
            SJctrSimpleDataModel selectIndexModel = (SJctrSimpleDataModel)this.getDataObjectModel(KEY_SELECT_INDEX_MODEL);
            Integer ssidIndex = (Integer)((SJctrDataObject)selectIndexModel.getManageData()).getData(KEY_SELECT_INDEX);
            if (ssidIndex != null) {
                SJctrRemoteConnectionUtility.removeSSIDPanel(this, ssidIndex);
            }
            this.updateFooter();
            this.setDirtyAll();
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107004);
        }
    }

    private void addSSIDAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        try {
            SJctrRemoteConnectionUtility.addSSIDPanel(this);
            this.updateFooter();
            this.setDirtyAll();
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107004);
        }
    }

    private void setRemoteSystemModelPanel(SJmoRemoteReplicationRCUInfo rcuInfo) {
        SJctrRemoteStorageSysDataModel remoteSysModel = SJctrRemoteConnectionUtility.getRemoteStorageSysModel(this);
        ((SJctrDataObject)remoteSysModel.getManageData()).setData("COM_REMOTE_MODEL_STR", SJctrRemoteReplicationUtility.getModelNameString(rcuInfo.getIControllerID(), this.getComUtility()));
        SJctrTextBoxDataModel serialtext = SJctrRemoteConnectionUtility.getRemoteSerialNumberTextModel(this);
        serialtext.setValue(rcuInfo.getStrSN());
        ((SJctrDataObject)remoteSysModel.getManageData()).setData("COM_REMOTE_CU_STR", SJctrComUtility.toHexString(rcuInfo.getSCu(), 2, true));
        int ssidNum = rcuInfo.getINumofSSID();
        ((SJctrDataObject)remoteSysModel.getManageData()).setData("COM_ADDED_SSID_COUNT", ssidNum);
        for (int ssidIdx = 0; ssidIdx < ssidNum; ++ssidIdx) {
            SJctrTextBoxDataModel ssidtext = SJctrRemoteConnectionUtility.getRemoteSSIDTextModel(this, ssidIdx);
            ssidtext.setValue(SJctrComUtility.toHexString(rcuInfo.getISSID()[ssidIdx], 4, true));
            ssidtext.setEnable(false);
        }
        ((SJctrDataObject)remoteSysModel.getManageData()).setData("COM_DISP_SSID_COUNT", ssidNum + 1);
        SJctrRemoteSSIDDataModel ssid = SJctrRemoteConnectionUtility.getRemoteSSIDModel(this, ssidNum);
        ((SJctrDataObject)ssid.getManageData()).setData("COM_REMOTE_TEXT_SSID_MIN_MAX", SJctrRemoteConnectionUtility.getSSIDEnableRangeString());
    }

    private static enum ADD_SSID_MSG implements SJctrNotifyState
    {
        PUSH_REMOVE_SSID;

    }
}

