/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.createjournals;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.serverux.dataimpl.HURchange1JNLGrpOption;
import sanproject.serverux.dataimpl.HURchangeJNLGrpsOption;
import sanproject.serverux.dataimpl.HURerrorDetail;
import sanproject.serverux.dataimpl.HURerrorSummary;
import sanproject.serverux.dataimpl.HURset1JNLVol;
import sanproject.serverux.dataimpl.HURsetJNLVols;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.wizard.replication.com.SJctrOperationJournalBaseAC;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcOperationErrorForJnlOpt;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcOperationErrorForJnlVol;
import sanproject.sn2.controller.wizard.replication.remote.createjournals.SJctrCreateJournalsConfirmData;
import sanproject.sn2.datasupplier.SJdsSupplierAgent;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorJnlGrp;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrCreateJournalsAC
extends SJctrOperationJournalBaseAC {
    private static final long serialVersionUID = -6502276524530219177L;
    private static final int ERROR_PART_DIGIT = 100;

    public void setApplyData(SJctrCreateJournalsConfirmData confirmData) {
        this.applyInfo = confirmData.getUrJnlGrp();
        this.jnlType = SJctrRemoteReplicationUtility.checkJnltypeForJnlInfo((SJmoUniversalReplicatorJnlGrp)this.applyInfo.get(0));
    }

    @Override
    protected void applyStart(SJdsSupplierAgent supplier) {
        if (supplier == null) {
            SJctrLogUty.info(this.title, "applyStart", "SJdsSupplierAgent is null.");
            throw new NullPointerException();
        }
        try {
            ArrayList<?> setList = this.getSetList();
            SJctrLogUty.info(this.title, "applyStart", "Apply Start!! (HURsetJNLVols)");
            Object resultObject = supplier.applyStart(this.getLockId(), setList);
            SJctrLogUty.info(this.title, "applyStart", "Apply End!! (HURsetJNLVols)");
            if (!(resultObject instanceof HURerrorSummary)) {
                SJctrLogUty.info(this.title, "applyStart", "instance of resultObject is invalid.");
                SJctrError error = new SJctrError(210, 22, 107001);
                this.setError(error);
                return;
            }
            HURerrorSummary errorSummary = (HURerrorSummary)resultObject;
            Map<Integer, List<SJctrRcOperationErrorForJnlVol>> mapJnlVolError = this.getMapJnlVolError(errorSummary);
            ArrayList<?> setOptionList = this.getSetOptionList(mapJnlVolError);
            Map<Integer, SJctrRcOperationErrorForJnlOpt> mapJnlOptError = new HashMap<Integer, SJctrRcOperationErrorForJnlOpt>();
            HURchangeJNLGrpsOption hURchangeJNLGrpsOption = (HURchangeJNLGrpsOption)setOptionList.get(0);
            if (hURchangeJNLGrpsOption.getJnlOptions().size() == 0) {
                SJctrLogUty.info(this.title, "applyStart", "Journal option do not apply.");
            } else {
                SJctrLogUty.info(this.title, "applyStart", "Apply Start!! (HURchangeJNLGrpsOption)");
                Object resultObjectOption = supplier.applyStart(this.getLockId(), setOptionList);
                SJctrLogUty.info(this.title, "applyStart", "Apply End!! (HURchangeJNLGrpsOption)");
                if (!(resultObjectOption instanceof HURerrorSummary)) {
                    SJctrLogUty.info(this.title, "applyStart", "instance of resultObjectOption is invalid.");
                    SJctrError error = new SJctrError(210, 22, 107001);
                    this.setError(error);
                    return;
                }
                HURerrorSummary errorSummaryOption = (HURerrorSummary)resultObjectOption;
                mapJnlOptError = this.getMapJnlOptError(errorSummaryOption);
            }
            this.setApplyResult(mapJnlVolError, mapJnlOptError);
        }
        catch (Exception e) {
            SJctrLogUty.info(this.title, "applyStart", "exception", e);
            SJctrError error = SJctrError.parseError(e);
            this.setError(error);
        }
    }

    private Map<Integer, List<SJctrRcOperationErrorForJnlVol>> getMapJnlVolError(HURerrorSummary errorSummary) {
        HashMap<Integer, List<SJctrRcOperationErrorForJnlVol>> mapJnlVolError = new HashMap<Integer, List<SJctrRcOperationErrorForJnlVol>>();
        ArrayList errorDetailList = errorSummary.getErrorDetail();
        if (null == errorDetailList) {
            SJctrLogUty.info(this.title, "getMapJnlVolError", "errorDetailList is null.");
        } else {
            for (HURerrorDetail errorDetail : errorDetailList) {
                if (0 == errorDetail.ErrCode) continue;
                SJctrRcOperationErrorForJnlVol jnlVolError = new SJctrRcOperationErrorForJnlVol(errorDetail.ErrPart / 100, errorDetail.ErrPart % 100, errorDetail.ErrCode, errorDetail.getJnlVol());
                List errorJnlVolList = (List)mapJnlVolError.get(errorDetail.getJnlGrp());
                if (null == errorJnlVolList) {
                    ArrayList<SJctrRcOperationErrorForJnlVol> tmpJnlVolList = new ArrayList<SJctrRcOperationErrorForJnlVol>();
                    tmpJnlVolList.add(jnlVolError);
                    mapJnlVolError.put(errorDetail.getJnlGrp(), tmpJnlVolList);
                    continue;
                }
                errorJnlVolList.add(jnlVolError);
            }
        }
        return mapJnlVolError;
    }

    private Map<Integer, SJctrRcOperationErrorForJnlOpt> getMapJnlOptError(HURerrorSummary errorSummaryOption) {
        HashMap<Integer, SJctrRcOperationErrorForJnlOpt> mapJnlOptError = new HashMap<Integer, SJctrRcOperationErrorForJnlOpt>();
        ArrayList errorDetailOptionList = errorSummaryOption.getErrorDetail();
        if (null == errorDetailOptionList) {
            SJctrLogUty.info(this.title, "getMapJnlOptError", "errorDetailList is null.");
        } else {
            for (HURerrorDetail errorDetailOption : errorDetailOptionList) {
                if (0 == errorDetailOption.ErrCode) continue;
                SJctrRcOperationErrorForJnlOpt jnlError = new SJctrRcOperationErrorForJnlOpt(errorDetailOption.ErrPart / 100, errorDetailOption.ErrPart % 100, errorDetailOption.ErrCode, errorDetailOption.getJnlGrp());
                mapJnlOptError.put(errorDetailOption.getJnlGrp(), jnlError);
            }
        }
        return mapJnlOptError;
    }

    protected void setApplyResult(Map<Integer, List<SJctrRcOperationErrorForJnlVol>> mapJnlVolError, Map<Integer, SJctrRcOperationErrorForJnlOpt> mapJnlOptError) {
        int funcErc = 210;
        int moduleErc = 22;
        int delegateErc = 0;
        SJctrError error = new SJctrError(funcErc, moduleErc, delegateErc);
        this.resultData = new ArrayList();
        for (SJmoUniversalReplicatorJnlGrp urJnlGrp : this.applyInfo) {
            int jnlId = urJnlGrp.getIndex();
            SJctrRcOperationErrorForJnlOpt jnlError = mapJnlOptError.get(jnlId);
            List<SJctrRcOperationErrorForJnlVol> jnlVolErrorList = mapJnlVolError.get(jnlId);
            if (null != jnlError) {
                if (null != jnlVolErrorList && jnlVolErrorList.size() > 0) {
                    jnlError.setErrorVolList(jnlVolErrorList);
                }
                this.resultData.add(jnlError);
                continue;
            }
            if (null == jnlVolErrorList || jnlVolErrorList.size() <= 0) continue;
            if (urJnlGrp.getJnlVols().size() == jnlVolErrorList.size()) {
                SJctrRcOperationErrorForJnlOpt allVolError = new SJctrRcOperationErrorForJnlOpt(funcErc, moduleErc, 206078, jnlId);
                allVolError.setErrorVolList(jnlVolErrorList);
                this.resultData.add(allVolError);
                continue;
            }
            SJctrRcOperationErrorForJnlOpt partVolError = new SJctrRcOperationErrorForJnlOpt(funcErc, moduleErc, 206079, jnlId);
            partVolError.setErrorVolList(jnlVolErrorList);
            this.resultData.add(partVolError);
        }
        if (this.resultData.size() > 0) {
            this.setError((SJctrError)this.resultData.get(0));
        } else {
            this.setError(error);
        }
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList<HURsetJNLVols> applyList = new ArrayList<HURsetJNLVols>(1);
        ArrayList<HURset1JNLVol> hURSet1JnlVolList = new ArrayList<HURset1JNLVol>();
        for (SJmoUniversalReplicatorJnlGrp jnlGrp : this.applyInfo) {
            ArrayList<SJmoLdevIndex> jnlVolList = jnlGrp.getJnlVols();
            for (SJmoLdevIndex jnlVol : jnlVolList) {
                HURset1JNLVol hURSet1JnlVol = new HURset1JNLVol();
                hURSet1JnlVol.setJnlGroup(jnlGrp.getIJnlGroupId());
                hURSet1JnlVol.setLdkc(jnlVol.getSLdkc());
                hURSet1JnlVol.setCuldev(jnlVol.getIndex() & this.CULDEV_MASK);
                if (1 == this.jnlType) {
                    hURSet1JnlVol.setTimerKind(1);
                } else {
                    hURSet1JnlVol.setTimerKind(jnlGrp.getTimerKind());
                }
                hURSet1JnlVol.setISite((byte)jnlGrp.getIsite());
                hURSet1JnlVol.setOwner(jnlGrp.getOwner());
                hURSet1JnlVolList.add(hURSet1JnlVol);
            }
        }
        HURsetJNLVols hURsetJNLVols = new HURsetJNLVols();
        hURsetJNLVols.setFlag(this.jnlType);
        hURsetJNLVols.setOperation(0);
        hURsetJNLVols.setJnlVol(hURSet1JnlVolList);
        applyList.add(hURsetJNLVols);
        return applyList;
    }

    private ArrayList<?> getSetOptionList(Map<Integer, List<SJctrRcOperationErrorForJnlVol>> mapJnlVolError) {
        ArrayList<HURchangeJNLGrpsOption> applyList = new ArrayList<HURchangeJNLGrpsOption>(1);
        ArrayList<HURchange1JNLGrpOption> hURchange1JNLGrpOptionList = new ArrayList<HURchange1JNLGrpOption>();
        for (SJmoUniversalReplicatorJnlGrp urJnlGrp : this.applyInfo) {
            int iJnlGroupId = urJnlGrp.getIJnlGroupId();
            List<SJctrRcOperationErrorForJnlVol> jnlVolErrorList = mapJnlVolError.get(iJnlGroupId);
            if (null != jnlVolErrorList && urJnlGrp.getJnlVols().size() == jnlVolErrorList.size()) continue;
            HURchange1JNLGrpOption hURchange1JNLGrpOption = new HURchange1JNLGrpOption();
            hURchange1JNLGrpOption.setJnlg(urJnlGrp.getIJnlGroupId());
            hURchange1JNLGrpOption.setLdkc(urJnlGrp.getLdkc());
            if (1 == this.jnlType) {
                hURchange1JNLGrpOption.setTimerKind(1);
            } else {
                hURchange1JNLGrpOption.setTimerKind(urJnlGrp.getTimerKind());
            }
            hURchange1JNLGrpOption.setShare(32);
            hURchange1JNLGrpOption.setExtent(32);
            hURchange1JNLGrpOption.setDataOverflowWatch(urJnlGrp.getDataOverFlowWatch());
            hURchange1JNLGrpOption.setIoDelay(urJnlGrp.getIoDelay());
            hURchange1JNLGrpOption.setActionMode(urJnlGrp.getActionMode());
            hURchange1JNLGrpOptionList.add(hURchange1JNLGrpOption);
        }
        HURchangeJNLGrpsOption hURchangeJNLGrpsOption = new HURchangeJNLGrpsOption();
        hURchangeJNLGrpsOption.setFlag(this.jnlType);
        hURchangeJNLGrpsOption.setJnlOptions(hURchange1JNLGrpOptionList);
        applyList.add(hURchangeJNLGrpsOption);
        return applyList;
    }
}

