/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.createjournals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrHaUtility;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.lunm.com.SJctrLdevDetailLUSEInfo;
import sanproject.sn2.controller.wizard.ownership.com.SJctrOwnerShipUtility;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcMessageEventListener;
import sanproject.sn2.controller.wizard.replication.remote.createjournals.SJctrCreateJournalsConfirmData;
import sanproject.sn2.controller.wizard.replication.remote.createjournals.SJctrCreateJournalsSelectedTableModel;
import sanproject.sn2.controller.wizard.replication.remote.journalproperties.SJctrJournalPropertiesDC;
import sanproject.sn2.controller.wizard.replication.remote.selectjournalvols.SJctrSelectJournalVolumesDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetAllDKCInfo;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetHDPRelation;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualLdev;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevLuseInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevStatusInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPoolNameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetSnapshotVvolRelation;
import sanproject.sn2.model.connector.kind.SJmoGetThinProvisioningVolumesStatus;
import sanproject.sn2.model.connector.kind.SJmoGetUniversalReplicatorJnlGrpMgr;
import sanproject.sn2.model.connector.kind.SJmoGetUniversalReplicatorPairVolInfoMgr;
import sanproject.sn2.model.data.group.SJmoHDPRelation;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualLdev;
import sanproject.sn2.model.data.ownership.SJmoAllDKCInfo;
import sanproject.sn2.model.data.ownership.SJmoDKCInfo;
import sanproject.sn2.model.data.ownership.SJmoMPBladeInfo;
import sanproject.sn2.model.data.replication.remote.SJmoUniversalReplicatorJnlGrp;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorJnlGrpMgr;
import sanproject.sn2.model.data.replication.remote.manager.SJmoUniversalReplicatorPairVolInfoMgr;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevLuseInfo;
import sanproject.sn2.model.data.volume.SJmoLdevStatusInfo;
import sanproject.sn2.model.data.volume.SJmoThinProvisioningVolumesStatus;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;

public class SJctrCreateJournalsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 16798209;
    private static final String DISP_TITLE = "CREATE_JOURNAL";
    private static final int SELECT_TOP_INDEX = 0;
    public static final String KEY_SYS_TYPE = "COM_SYS_TYPE";
    public static final String KEY_JNL_ID = "COM_JNL_ID";
    public static final String KEY_JNL_VOL_SELECTION = "COM_JNL_VOL_SELECTION";
    public static final String KEY_SELECT_JNL_VOL_BTN = "COM_SELECT_JNL_VOL_BTN";
    public static final String KEY_TOTAL_SELECTED_JNL_VOL = "COM_TOTAL_SELECTED_JNL_VOL";
    public static final String KEY_TOTAL_SELECTED_CAP = "COM_TOTAL_SELECTED_CAP";
    public static final String KEY_JNL_TYPE_OPT = "COM_JNL_TYPE_OPT";
    public static final String KEY_PROCESSOR_BLADE = "COM_PROCESSOR_BLADE";
    public static final String KEY_INFLOW_CTRL = "COM_INFLOW_CTRL";
    public static final String KEY_DATA_OVERFLOW_WATCH = "COM_DATA_OVERFLOW_WATCH";
    public static final String KEY_CACHE_MODE = "COM_CACHE_MODE";
    public static final String KEY_TIMER_TYPE = "COM_TIMER_TYPE";
    public static final String KEY_STANDARD = "COM_STANDARD";
    public static final String KEY_2DC_CASCADE = "COM_2DC_CASCADE";
    public static final String KEY_ADD = "COM_ADD";
    public static final String KEY_DETAIL = "COM_DETAIL";
    public static final String KEY_REMOVE = "COM_REMOVE";
    public static final String KEY_TABLE_SELECTED = "COM_TABLE_SELECTED";
    public static final String KEY_SYS_TYPE_OPEN = "COM_SYS_TYPE_OPEN";
    public static final String KEY_SYS_TYPE_MF = "COM_SYS_TYPE_MF";
    public static final String KEY_ENABLE = "COM_ENABLE";
    public static final String KEY_DISABLE = "COM_DISABLE";
    public static final String KEY_AVAILABLE_LDEVS = "AVAILABLE_LDEVS";
    public static final String KEY_KEEPING_JNL_VOLS = "KEEPING_JNL_VOLS";
    public static final int DEFAULT_TOTAL_SELECTED_JNL_VOL = 0;
    public static final long DEFAULT_TOTAL_SELECTED_CAP = 0L;
    private ArrayList<SJmoLdevDetail> availableLdevList = new ArrayList();
    private ArrayList<SJmoLdevDetail> keptVolsList = new ArrayList();
    private ArrayList<String> journalIdItemList = new ArrayList();
    private boolean opEnable = false;
    private boolean mfEnable = false;
    private int registeredJnlNum = 0;

    public SJctrCreateJournalsDC() {
        super(16798209);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance(DISP_TITLE);
    }

    private void initDataModel() {
        SJctrRadioButtonGroupDataModel radSystemType = new SJctrRadioButtonGroupDataModel();
        radSystemType.add(KEY_SYS_TYPE_OPEN);
        radSystemType.add(KEY_SYS_TYPE_MF);
        radSystemType.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrCreateJournalsDC.this.fireMessageEvent(CREATE_JOURNALS_MSG.SELECT_SYS_TYPE);
                }
            }
        });
        this.addDataObjectModel(KEY_SYS_TYPE, radSystemType);
        this.addDataObjectModel(KEY_JNL_ID, new SJctrComboBoxDataModel());
        this.addDataObjectModel(KEY_JNL_VOL_SELECTION, new SJctrSimpleDataModel());
        SJctrButtonDataModel selectJournalVolumesButton = new SJctrButtonDataModel();
        selectJournalVolumesButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrCreateJournalsDC.this.fireMessageEvent(CREATE_JOURNALS_MSG.SELECT_SELECT_JNL_VOLS);
                }
            }
        });
        this.addDataObjectModel(KEY_SELECT_JNL_VOL_BTN, selectJournalVolumesButton);
        SJctrRadioButtonGroupDataModel radJournalTypeOption = new SJctrRadioButtonGroupDataModel();
        radJournalTypeOption.add(KEY_STANDARD);
        radJournalTypeOption.add(KEY_2DC_CASCADE);
        this.addDataObjectModel(KEY_JNL_TYPE_OPT, radJournalTypeOption);
        this.addDataObjectModel(KEY_PROCESSOR_BLADE, new SJctrComboBoxDataModel());
        SJctrRadioButtonGroupDataModel radInflowControl = new SJctrRadioButtonGroupDataModel();
        radInflowControl.add(KEY_ENABLE);
        radInflowControl.add(KEY_DISABLE);
        radInflowControl.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrCreateJournalsDC.this.fireMessageEvent(CREATE_JOURNALS_MSG.SELECT_INFLOW_CONTROL);
                }
            }
        });
        this.addDataObjectModel(KEY_INFLOW_CTRL, radInflowControl);
        this.addDataObjectModel(KEY_DATA_OVERFLOW_WATCH, new SJctrTextBoxDataModel());
        SJctrRadioButtonGroupDataModel radCacheMode = new SJctrRadioButtonGroupDataModel();
        radCacheMode.add(KEY_ENABLE);
        radCacheMode.add(KEY_DISABLE);
        this.addDataObjectModel(KEY_CACHE_MODE, radCacheMode);
        this.addDataObjectModel(KEY_TIMER_TYPE, new SJctrComboBoxDataModel());
        SJctrButtonDataModel addButton = new SJctrButtonDataModel();
        addButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrCreateJournalsDC.this.fireMessageEvent(CREATE_JOURNALS_MSG.SELECT_ADD);
                }
            }
        });
        this.addDataObjectModel(KEY_ADD, addButton);
        this.addDataObjectModel(KEY_TABLE_SELECTED, new SJctrCreateJournalsSelectedTableModel());
        SJctrButtonDataModel detailButton = new SJctrButtonDataModel();
        detailButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrCreateJournalsDC.this.fireMessageEvent(CREATE_JOURNALS_MSG.SELECT_DETAIL);
                }
            }
        });
        this.addDataObjectModel(KEY_DETAIL, detailButton);
        SJctrButtonDataModel removeButton = new SJctrButtonDataModel();
        removeButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrCreateJournalsDC.this.fireMessageEvent(CREATE_JOURNALS_MSG.SELECT_REMOVE);
                }
            }
        });
        this.addDataObjectModel(KEY_REMOVE, removeButton);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    private void initListener() {
        this.addMessageEventListener(CREATE_JOURNALS_MSG.SELECT_SYS_TYPE, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateJournalsDC.this.radSystemTypeAction();
            }
        });
        this.addMessageEventListener(CREATE_JOURNALS_MSG.SELECT_SELECT_JNL_VOLS, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateJournalsDC.this.btnSelectJournalVolumesAction();
            }
        });
        this.addMessageEventListener(SJctrDialogDataController.DIALOG_MSG.EXIT, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                Map param = (Map)event.getNofifyObject();
                SJctrCreateJournalsDC.this.exitDialogAction(param);
            }
        });
        this.addMessageEventListener(CREATE_JOURNALS_MSG.SELECT_INFLOW_CONTROL, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateJournalsDC.this.radInflowControlAction();
            }
        });
        this.addMessageEventListener(CREATE_JOURNALS_MSG.SELECT_ADD, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateJournalsDC.this.btnAddAction();
                SJctrReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        this.addMessageEventListener(CREATE_JOURNALS_MSG.SELECT_DETAIL, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateJournalsDC.this.btnDetailAction();
            }
        });
        this.addMessageEventListener(CREATE_JOURNALS_MSG.SELECT_REMOVE, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateJournalsDC.this.btnRemoveAction();
                SJctrReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetUniversalReplicatorJnlGrpMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevNicknameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetClprInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevLuseInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetAllDKCInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetUniversalReplicatorPairVolInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevStatusInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetHDPRelation();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPoolNameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetSnapshotVvolRelation();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetHUVMVirtualLdev();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetThinProvisioningVolumesStatus();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public boolean checkConstructData() {
        try {
            SJmoUniversalReplicatorJnlGrpMgr jnlGrpMgr = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorJnlGrpMgr(this);
            List<SJmoLdevDetail> ldevDetailList = SJctrReplicationUtility.getSJmoLdevDetail(this);
            SJctrReplicationUtility.getSJmoLdevNicknameInfo(this);
            SJctrReplicationUtility.getSJmoClprInfo(this);
            SJctrReplicationUtility.getSJmoLdevLuseInfo(this);
            List<SJmoHDPRelation> hdpRelationLsit = SJctrRemoteReplicationUtility.getSJmoHDPRelation(this);
            SJctrReplicationUtility.getSJmoPoolNameInfo(this);
            SJctrRemoteReplicationUtility.getSJmoSnapshotVvolRelation(this);
            SJctrReplicationUtility.getSJmoRSGgetAllRsgs(this);
            SJctrRemoteReplicationUtility.getSJmoAllDKCInfo(this);
            SJmoUniversalReplicatorPairVolInfoMgr urPairVolInfoMgr = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorPairVolInfoMgr(this);
            List<SJmoLdevStatusInfo> ldevStatusList = SJctrRemoteReplicationUtility.getSJmoLdevStatusInfo(this);
            List<SJmoHUVMVirtualLdev> vLdevList = SJctrHaUtility.getSJmoHUVMVirtualLdev(this);
            List<SJmoThinProvisioningVolumesStatus> dpVolStatusList = SJctrRemoteReplicationUtility.getSJmoThinProvisioningVolumesStatus(this);
            ldevDetailList = SJctrRemoteReplicationUtility.getSJmoLdevDetailFilteredByAllRsg(this);
            SJctrLicenseContainer licenseContainer = this.getOwner().getAuthorizeContainer().getLisenceContainer();
            ArrayList<SJmoLdevDetail> opAvailableLdevsList = SJctrRemoteReplicationUtility.getJournalVolTargetList(ldevDetailList, ldevStatusList, urPairVolInfoMgr, vLdevList, true, hdpRelationLsit, dpVolStatusList);
            ArrayList<SJmoLdevDetail> mfAvailableLdevsList = SJctrRemoteReplicationUtility.getJournalVolTargetList(ldevDetailList, ldevStatusList, urPairVolInfoMgr, vLdevList, false, hdpRelationLsit, dpVolStatusList);
            this.opEnable = licenseContainer.checkPP(SJctrLicenseContainer.PPID_HORC) & licenseContainer.checkPP(SJctrLicenseContainer.PPID_HUR) & opAvailableLdevsList.size() > 0;
            this.mfEnable = licenseContainer.checkPP(SJctrLicenseContainer.PPID_HRC) & licenseContainer.checkPP(SJctrLicenseContainer.PPID_HURMF) & mfAvailableLdevsList.size() > 0;
            if (!this.opEnable && !this.mfEnable) {
                this.logUty.putlog("checkConstructData", "Not exist available journal volume.");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206047);
            }
            SJmoUniversalReplicatorJnlGrp[] jnlGrpList = jnlGrpMgr.getJnlGroupList();
            if (null != jnlGrpList) {
                this.registeredJnlNum = 0;
                for (int i = 0; i <= 255; ++i) {
                    if (null == jnlGrpList[i]) {
                        String jnlId = SJctrComUtility.toHexString(i, 3, true);
                        this.journalIdItemList.add(jnlId);
                        continue;
                    }
                    ++this.registeredJnlNum;
                }
            }
            if (this.registeredJnlNum >= SJmoDataMacro_IF.MAX_JNLG_NUM) {
                this.logUty.putlog("checkConstructData", "Journal is registered more than the maximum number. Number of registered Journals:" + this.registeredJnlNum);
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(205095);
            }
            if (this.journalIdItemList.size() == 0) {
                this.logUty.putlog("checkConstructData", "Not exist available journal id.");
                throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206048);
            }
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107002);
        }
        return true;
    }

    @Override
    public void makeDataModel() throws SJcException {
        SJctrRadioButtonGroupDataModel radSystemType = this.getRadSystemType();
        SJctrRadioButtonGroupDataModel radJournalTypeOption = this.getRadJournalTypeOption();
        SJctrRadioButtonGroupDataModel radInflowControl = this.getRadInflowControl();
        SJctrRadioButtonGroupDataModel radCacheMode = this.getRadCacheMode();
        radSystemType.setEnableListener(false);
        radJournalTypeOption.setEnableListener(false);
        radInflowControl.setEnableListener(false);
        radCacheMode.setEnableListener(false);
        super.makeDataModel();
        radSystemType.setEnable(KEY_SYS_TYPE_OPEN, this.opEnable);
        radSystemType.setEnable(KEY_SYS_TYPE_MF, this.mfEnable);
        if (this.opEnable) {
            radSystemType.setSelect(KEY_SYS_TYPE_OPEN);
        } else {
            radSystemType.setSelect(KEY_SYS_TYPE_MF);
        }
        this.updateAvailableLdevList();
        this.syncCmbJournalId();
        this.syncJournalVolumeSelection();
        this.setupRadJournalTypeOption();
        radJournalTypeOption.setSelect(KEY_STANDARD);
        this.initCmbProcessorBlade();
        radInflowControl.setSelect(KEY_ENABLE);
        SJctrTextBoxDataModel txtDataOverflowWatch = this.getTxtDataOverflowWatch();
        txtDataOverflowWatch.setValue(String.valueOf(this.getDefaultDataOverflowWatch(this.getRadSystemType().getSelect())));
        txtDataOverflowWatch.setMin(String.valueOf(0));
        txtDataOverflowWatch.setMax(String.valueOf(600));
        radCacheMode.setSelect(KEY_ENABLE);
        this.setupCmbTimerType();
        radSystemType.setEnableListener(true);
        radJournalTypeOption.setEnableListener(true);
        radInflowControl.setEnableListener(true);
        radCacheMode.setEnableListener(true);
    }

    @Override
    public boolean checkEndData() {
        try {
            SJctrCreateJournalsConfirmData confirmData = new SJctrCreateJournalsConfirmData();
            SJctrCreateJournalsSelectedTableModel selectedJournalsTable = this.getSelectedJournalsTable();
            List<Object> rowData = selectedJournalsTable.getAllRowData();
            confirmData.setUrJnlGrp(rowData);
            Collections.sort(confirmData.getUrJnlGrp());
            confirmData.setNeedData(this);
            ArrayList<SJctrCreateJournalsConfirmData> confirmDataList = new ArrayList<SJctrCreateJournalsConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrCreateJournalsConfirmData.class, confirmDataList);
            SJctrReplicationUtility.setFinishChangeCheck(this, false);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107003);
        }
        return true;
    }

    private void radSystemTypeAction() {
        try {
            this.updateAvailableLdevList();
            this.keptVolsList.clear();
            this.syncJournalVolumeSelection();
            this.setupRadJournalTypeOption();
            this.setupCmbTimerType();
            SJctrTextBoxDataModel txtDataOverflowWatch = this.getTxtDataOverflowWatch();
            if (txtDataOverflowWatch.isEnable()) {
                txtDataOverflowWatch.setValue(String.valueOf(this.getDefaultDataOverflowWatch(this.getRadSystemType().getSelect())));
            }
            txtDataOverflowWatch.setDirty();
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107004);
        }
    }

    private void btnSelectJournalVolumesAction() {
        ArrayList<SJmoLdevDetail> availableList = new ArrayList<SJmoLdevDetail>(this.availableLdevList);
        for (SJmoLdevDetail keptVol : this.keptVolsList) {
            availableList.remove(keptVol);
        }
        SJctrCreateJournalsSelectedTableModel selectedJournalTable = this.getSelectedJournalsTable();
        List<Object> jnlGrpList = selectedJournalTable.getAllRowData();
        for (SJmoUniversalReplicatorJnlGrp sJmoUniversalReplicatorJnlGrp : jnlGrpList) {
            ArrayList<SJmoLdevIndex> selectedIndex = sJmoUniversalReplicatorJnlGrp.getJnlVols();
            for (SJmoLdevIndex selectedLdev : selectedIndex) {
                availableList.remove(selectedLdev);
            }
        }
        if (availableList.size() == 0 && this.keptVolsList.size() == 0) {
            this.logUty.putlog("checkConstructData", "Not exist available journal volume.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206057);
        }
        this.putCache(KEY_AVAILABLE_LDEVS, availableList);
        this.putCache(KEY_KEEPING_JNL_VOLS, this.keptVolsList);
        HashMap param = new HashMap();
        SJctrRelatedDispDataObject sJctrRelatedDispDataObject = this.createDialog(SJctrSelectJournalVolumesDC.class, param);
        this.addUpdateDisp(sJctrRelatedDispDataObject);
    }

    private void exitDialogAction(Map<String, List<?>> carryMap) {
        List<?> param = carryMap.get(KEY_KEEPING_JNL_VOLS);
        this.keptVolsList.clear();
        if (param != null && param.size() > 0) {
            this.keptVolsList.addAll((ArrayList)param);
        }
        this.syncJournalVolumeSelection();
    }

    private void radInflowControlAction() {
        this.setupTxtDataOverflowWatch();
    }

    private void btnAddAction() {
        Collections.sort(this.keptVolsList);
        SJmoUniversalReplicatorJnlGrp urJnlGrp = this.getUrJnlGrp();
        ArrayList<SJmoUniversalReplicatorJnlGrp> urJnlGrpList = new ArrayList<SJmoUniversalReplicatorJnlGrp>();
        urJnlGrpList.add(urJnlGrp);
        int selectedJnlNum = this.getSelectedJournalsTable().getRowCount();
        if (selectedJnlNum + this.registeredJnlNum >= SJmoDataMacro_IF.MAX_JNLG_NUM) {
            this.logUty.putlog("btnAddAction", "The total count of selected journal and registered journal is over max count of journal.Selected Journals:" + selectedJnlNum + ",Registered Journals:" + this.registeredJnlNum + ",Max Journals:" + SJmoDataMacro_IF.MAX_JNLG_NUM);
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(205094);
        }
        this.getSelectedJournalsTable().addRowDataTop(urJnlGrpList);
        SJctrComboBoxDataModel cmbJournalId = this.getCmbJournalId();
        this.journalIdItemList.remove(cmbJournalId.getSelectedIndex());
        this.syncCmbJournalId();
        this.keptVolsList.clear();
        this.syncJournalVolumeSelection();
        this.updateFooter();
        this.setDirtyAll();
    }

    private void btnDetailAction() {
        HashMap param = new HashMap();
        SJctrCreateJournalsSelectedTableModel selectedTable = this.getSelectedJournalsTable();
        List<Object> selestedJournals = selectedTable.getSelectedRowData();
        if (selestedJournals.size() == 0) {
            this.getLogUty().putlog("btnDetailAction", "not selected");
            return;
        }
        param.put("COM_SELECTED_JOURNAL", selestedJournals);
        SJctrRelatedDispDataObject dialogRelated = this.createDialog(SJctrJournalPropertiesDC.class, param);
        this.addUpdateDisp(dialogRelated);
    }

    private void btnRemoveAction() {
        List<Object> selectedRows = this.getSelectedJournalsTable().getSelectedRowData();
        if (selectedRows.size() == 0) {
            this.getLogUty().putlog("btnRemoveAction", "not selected");
            return;
        }
        for (Object selectedRow : selectedRows) {
            SJmoUniversalReplicatorJnlGrp urJnlGrp = (SJmoUniversalReplicatorJnlGrp)selectedRow;
            String strJnlId = SJctrComUtility.toHexString(urJnlGrp.getIJnlGroupId(), 3, true);
            this.journalIdItemList.add(strJnlId);
        }
        this.keptVolsList.clear();
        this.syncJournalVolumeSelection();
        this.syncCmbJournalId();
        this.getSelectedJournalsTable().removeSelectedRowData();
        this.updateFooter();
        this.setDirtyAll();
    }

    private void syncCmbJournalId() {
        SJctrComboBoxDataModel cmbJournalId = this.getCmbJournalId();
        cmbJournalId.removeAllItems();
        Collections.sort(this.journalIdItemList);
        for (String journalId : this.journalIdItemList) {
            cmbJournalId.addItem(journalId, journalId);
        }
        cmbJournalId.setSelectedIndex(0);
    }

    private void syncJournalVolumeSelection() {
        SJctrLdevDetailLUSEInfo ldevDtlLuse = null;
        List<SJmoLdevDetail> ldevDetailList = SJctrReplicationUtility.getSJmoLdevDetail(this);
        List<SJmoLdevLuseInfo> ldevLuseList = SJctrReplicationUtility.getSJmoLdevLuseInfo(this);
        SJctrSimpleDataModel journalVolumeSelection = this.getJournalVolumeSelection();
        int totalSelectedJnlVol = 0;
        long block = 0L;
        if (null != this.keptVolsList) {
            totalSelectedJnlVol = this.keptVolsList.size();
            for (SJmoLdevDetail keepingJnlVol : this.keptVolsList) {
                ldevDtlLuse = SJctrLdevUtility.getLdevDetailLUListSEInfo(keepingJnlVol, ldevDetailList, ldevLuseList);
                block += ldevDtlLuse.getLLDEVLBASize();
            }
        }
        ((SJctrDataObject)journalVolumeSelection.getManageData()).setData(KEY_TOTAL_SELECTED_JNL_VOL, Integer.toString(totalSelectedJnlVol));
        ((SJctrDataObject)journalVolumeSelection.getManageData()).setData(KEY_TOTAL_SELECTED_CAP, this.getComUtility().getCapacityUtility().toUnitString(block));
        journalVolumeSelection.setDirty();
    }

    private void setupRadJournalTypeOption() {
        SJctrRadioButtonGroupDataModel radJournalTypeOption = this.getRadJournalTypeOption();
        String systemType = this.getRadSystemType().getSelect();
        if (KEY_SYS_TYPE_OPEN.equals(systemType)) {
            radJournalTypeOption.setEnable(KEY_2DC_CASCADE, true);
        } else {
            radJournalTypeOption.setEnable(KEY_2DC_CASCADE, false);
            if (!KEY_STANDARD.equals(radJournalTypeOption.getSelect())) {
                radJournalTypeOption.setSelect(KEY_STANDARD);
            }
        }
        radJournalTypeOption.setDirty();
    }

    private void initCmbProcessorBlade() {
        SJctrComboBoxDataModel cmbProcessorBlade = this.getCmbProcessorBlade();
        cmbProcessorBlade.addItem(String.valueOf(-1), this.getComUtility().getGuidance("AUTO"));
        List<SJmoAllDKCInfo> allDKCInfoList = SJctrRemoteReplicationUtility.getSJmoAllDKCInfo(this);
        for (SJmoAllDKCInfo allDKCInfo : allDKCInfoList) {
            ArrayList<SJmoDKCInfo> dkcInfoList = allDKCInfo.getDKCInfo();
            for (SJmoDKCInfo dkcInfo : dkcInfoList) {
                ArrayList<SJmoMPBladeInfo> mpBladeInfoList = dkcInfo.getMPBladeInfo();
                for (SJmoMPBladeInfo mpBladeInfo : mpBladeInfoList) {
                    int iMpBladeId = mpBladeInfo.getMpBladeId();
                    String strMpBladeId = SJctrOwnerShipUtility.toMpBladeIdDisplay(this.getComUtility(), iMpBladeId);
                    cmbProcessorBlade.addItem(Integer.toString(iMpBladeId), strMpBladeId);
                }
            }
        }
        cmbProcessorBlade.setSelectedIndex(0);
    }

    private void setupTxtDataOverflowWatch() {
        String inflowControl = this.getRadInflowControl().getSelect();
        SJctrTextBoxDataModel txtDataOverflowWatch = this.getTxtDataOverflowWatch();
        if (KEY_ENABLE.equals(inflowControl)) {
            txtDataOverflowWatch.setValue(String.valueOf(this.getDefaultDataOverflowWatch(this.getRadSystemType().getSelect())));
            txtDataOverflowWatch.setMin(String.valueOf(0));
            txtDataOverflowWatch.setMax(String.valueOf(600));
            txtDataOverflowWatch.setEnable(true);
        } else {
            txtDataOverflowWatch.setValue("");
            txtDataOverflowWatch.setMin("");
            txtDataOverflowWatch.setMax("");
            txtDataOverflowWatch.setEnable(false);
        }
        txtDataOverflowWatch.setDirty();
    }

    private void setupCmbTimerType() {
        SJctrComboBoxDataModel cmbTimerType = this.getCmbTimerType();
        String systemType = this.getRadSystemType().getSelect();
        cmbTimerType.removeAllItems();
        if (KEY_SYS_TYPE_OPEN.equals(systemType)) {
            cmbTimerType.addItem(Integer.toString(-1), "-");
        } else {
            cmbTimerType.addItem(Integer.toString(0), this.getComUtility().getGuidance("SYSTEM"));
            cmbTimerType.addItem(Integer.toString(1), this.getComUtility().getGuidance("LOCAL"));
            cmbTimerType.addItem(Integer.toString(2), this.getComUtility().getGuidance("NONE"));
        }
        cmbTimerType.setSelectedIndex(0);
        cmbTimerType.setEnable(KEY_SYS_TYPE_MF.equals(systemType));
        cmbTimerType.setDirty();
    }

    private SJmoUniversalReplicatorJnlGrp getUrJnlGrp() {
        SJmoUniversalReplicatorJnlGrp jnlGrp = new SJmoUniversalReplicatorJnlGrp();
        try {
            jnlGrp.setIJnlGroupId(Integer.parseInt(this.getCmbJournalId().getSelection(), 16));
        }
        catch (Exception e) {
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107004);
        }
        String systemType = this.getRadSystemType().getSelect();
        if (KEY_SYS_TYPE_OPEN.equals(systemType)) {
            jnlGrp.setValidty(1);
        } else if (KEY_SYS_TYPE_MF.equals(systemType)) {
            jnlGrp.setValidty(2);
        } else {
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107004);
        }
        String inflowControl = this.getRadInflowControl().getSelect();
        if (KEY_ENABLE.equals(inflowControl)) {
            jnlGrp.setDataOverFlowWatch(SJctrRemoteReplicationUtility.getValueTextBoxNum(this.getTxtDataOverflowWatch()));
            jnlGrp.setIoDelay(0);
        } else if (KEY_DISABLE.equals(inflowControl)) {
            jnlGrp.setDataOverFlowWatch(this.getDefaultDataOverflowWatch(systemType));
            jnlGrp.setIoDelay(1);
        } else {
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107004);
        }
        ArrayList<SJmoLdevIndex> alJnlVols = new ArrayList<SJmoLdevIndex>(this.keptVolsList);
        jnlGrp.setJnlVols(alJnlVols);
        jnlGrp.setTimerKind(SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(this.getCmbTimerType()));
        String cacheMode = this.getRadCacheMode().getSelect();
        if (KEY_ENABLE.equals(cacheMode)) {
            jnlGrp.setActionMode(1);
        } else if (KEY_DISABLE.equals(cacheMode)) {
            jnlGrp.setActionMode(0);
        } else {
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107004);
        }
        jnlGrp.setLdkc(0);
        String journalTypeOption = this.getRadJournalTypeOption().getSelect();
        if (KEY_STANDARD.equals(journalTypeOption)) {
            jnlGrp.setIsite(0);
        } else if (KEY_2DC_CASCADE.equals(journalTypeOption)) {
            jnlGrp.setIsite(1);
        } else {
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107004);
        }
        jnlGrp.setOwner((byte)SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(this.getCmbProcessorBlade()));
        jnlGrp.setMulti((byte)1);
        this.setJnlEncryption(jnlGrp, this.keptVolsList);
        return jnlGrp;
    }

    private void setJnlEncryption(SJmoUniversalReplicatorJnlGrp jnlGrp, List<SJmoLdevDetail> selectLdevList) {
        int jnlEncrypt = 0;
        for (SJmoLdevDetail ldevInfo : selectLdevList) {
            int ldevEncrypt = ldevInfo.getIDpEncrypt();
            jnlEncrypt |= ldevEncrypt;
        }
        jnlGrp.setIEncrypt(jnlEncrypt);
    }

    private void updateAvailableLdevList() {
        List<SJmoLdevDetail> ldevDetailList = SJctrRemoteReplicationUtility.getSJmoLdevDetailFilteredByAllRsg(this);
        SJmoUniversalReplicatorPairVolInfoMgr urPairVolInfoMgr = SJctrRemoteReplicationUtility.getSJmoUniversalReplicatorPairVolInfoMgr(this);
        List<SJmoLdevStatusInfo> ldevStatusList = SJctrRemoteReplicationUtility.getSJmoLdevStatusInfo(this);
        List<SJmoHUVMVirtualLdev> vLdevList = SJctrHaUtility.getSJmoHUVMVirtualLdev(this);
        List<SJmoHDPRelation> hdpRelationList = SJctrRemoteReplicationUtility.getSJmoHDPRelation(this);
        List<SJmoThinProvisioningVolumesStatus> dpVolStatusList = SJctrRemoteReplicationUtility.getSJmoThinProvisioningVolumesStatus(this);
        String systemType = this.getRadSystemType().getSelect();
        boolean isOpen = KEY_SYS_TYPE_OPEN.equals(systemType);
        this.availableLdevList = SJctrRemoteReplicationUtility.getJournalVolTargetList(ldevDetailList, ldevStatusList, urPairVolInfoMgr, vLdevList, isOpen, hdpRelationList, dpVolStatusList);
    }

    private int getDefaultDataOverflowWatch(String systemType) {
        int ret = 60;
        if (KEY_SYS_TYPE_MF.equals(systemType)) {
            ret = 20;
        }
        return ret;
    }

    private SJctrRadioButtonGroupDataModel getRadSystemType() {
        return (SJctrRadioButtonGroupDataModel)this.getDataObjectModel(KEY_SYS_TYPE);
    }

    private SJctrComboBoxDataModel getCmbJournalId() {
        return (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_JNL_ID);
    }

    private SJctrSimpleDataModel getJournalVolumeSelection() {
        return (SJctrSimpleDataModel)this.getDataObjectModel(KEY_JNL_VOL_SELECTION);
    }

    private SJctrRadioButtonGroupDataModel getRadJournalTypeOption() {
        return (SJctrRadioButtonGroupDataModel)this.getDataObjectModel(KEY_JNL_TYPE_OPT);
    }

    private SJctrComboBoxDataModel getCmbProcessorBlade() {
        return (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_PROCESSOR_BLADE);
    }

    private SJctrRadioButtonGroupDataModel getRadInflowControl() {
        return (SJctrRadioButtonGroupDataModel)this.getDataObjectModel(KEY_INFLOW_CTRL);
    }

    private SJctrTextBoxDataModel getTxtDataOverflowWatch() {
        return (SJctrTextBoxDataModel)this.getDataObjectModel(KEY_DATA_OVERFLOW_WATCH);
    }

    private SJctrRadioButtonGroupDataModel getRadCacheMode() {
        return (SJctrRadioButtonGroupDataModel)this.getDataObjectModel(KEY_CACHE_MODE);
    }

    private SJctrComboBoxDataModel getCmbTimerType() {
        return (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_TIMER_TYPE);
    }

    private SJctrCreateJournalsSelectedTableModel getSelectedJournalsTable() {
        return (SJctrCreateJournalsSelectedTableModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
    }

    public static enum CREATE_JOURNALS_MSG implements SJctrNotifyState
    {
        SELECT_SYS_TYPE,
        SELECT_SELECT_JNL_VOLS,
        SELECT_INFLOW_CONTROL,
        SELECT_ADD,
        SELECT_DETAIL,
        SELECT_REMOVE;

    }
}

