/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.createpairs.ha;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrHaUtility;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.comparator.SJctrHAPairInfoComparator;
import sanproject.sn2.controller.com.comparator.SJctrHostGroupNameComparator;
import sanproject.sn2.controller.com.comparator.SJctrIscsiTargetAliasComparator;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortLunTableKey;
import sanproject.sn2.controller.wizard.replication.com.SJctrHaCtgInfo;
import sanproject.sn2.controller.wizard.replication.com.SJctrHaDataMacro;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcMessageEventListener;
import sanproject.sn2.controller.wizard.replication.local.createpairs.SJctrCreatePairUtility;
import sanproject.sn2.controller.wizard.replication.remote.changesettings.SJctrChangeHaSettingsDC;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.SJctrCreatePairsDC;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.SJctrCreateRemotePairUtility;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.ha.SJctrCreateHaPairVolInfo;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.ha.SJctrCreateHaPairsConfirmData;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.model.SJctrBaseSecondaryVolumeDataModel;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.model.SJctrLuSelectionDataModel;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.model.SJctrLuSelectionHaDataModel;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.model.SJctrRemoteStorageSystemDataModel;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.model.SJctrRemoteStorageSystemHaDataModel;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.model.SJctrSelectionTypeDataModel;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.model.SJctrSelectionTypeHaDataModel;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.table.SJctrCreateHaPairsAvailableTableModel;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.table.SJctrCreateHaPairsSelectedPairsTableModel;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.table.SJctrCreateHaPairsSelectedTableModel;
import sanproject.sn2.controller.wizard.replication.remote.createpairs.table.SJctrCreatePairsAvailableTableModelLun;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetChaDetail;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetHAPairVolInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualDkc;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualLdev;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevStatusInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetQuorumDiskInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetRemoteReplicationMRCUInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetSsidDetail;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemInfo;
import sanproject.sn2.model.data.device.SJmoChaDetail;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualDkc;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualLdev;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoLuIndex;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoHAPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoQuorumDiskInfo;
import sanproject.sn2.model.data.replication.remote.SJmoRemoteReplicationRCUInfo;
import sanproject.sn2.model.data.replication.remote.manager.SJmoHAPairVolInfoMgr;
import sanproject.sn2.model.data.replication.remote.manager.SJmoRemoteReplicationMRCUInfoMgr;
import sanproject.sn2.model.data.system.SJmoSubsystemInfo;
import sanproject.sn2.model.data.util.SJmoChaUtility;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevStatusInfo;
import sanproject.sn2.model.data.volume.SJmoSsidDetail;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;

public class SJctrCreateHaPairsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 0x1005501;
    private static final String DISP_TITLE = "CREATE_HA_PAIR";
    private static final String KEY_TABLE_AVA = "COM_TABLE_AVAILABLE";
    private static final String KEY_TABLE_SELECTED = "COM_TABLE_SELECTED";
    private static final String KEY_HG_TG_PULLDOWN_TITLE = "COM_HG_TG_PULLDOWN_TITLE";
    private TreeMap<String, TreeSet<Integer>> cuFreeRcuInfoMap = new TreeMap();
    private List<SJmoPortLunInfo> availablePortLunList = null;
    private List<SJmoPortIndex> availablePortHgList = null;
    private List<SJmoLdevDetail> availableBasicDataList = new ArrayList<SJmoLdevDetail>();
    private List<SJmoQuorumDiskInfo> quorumDiskList = null;
    private List<SJmoHAPairVolInfo> currentHaPairVolInfoList = null;
    private int localModelId = -1;
    private List<SJctrHaCtgInfo> allCtgInfoList = null;
    private List<Integer> initialNumberOfPairsInCtg = null;

    public SJctrCreateHaPairsDC() {
        super(0x1005501);
        this.availablePortLunList = new ArrayList<SJmoPortLunInfo>();
        this.availablePortHgList = new ArrayList<SJmoPortIndex>();
        this.quorumDiskList = new ArrayList<SJmoQuorumDiskInfo>();
        this.currentHaPairVolInfoList = new ArrayList<SJmoHAPairVolInfo>();
        this.allCtgInfoList = new ArrayList<SJctrHaCtgInfo>();
        this.initialNumberOfPairsInCtg = new ArrayList<Integer>();
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    private void initDataModel() {
        this.addDataObjectModel("COM_REMOTE_STORAGE", new SJctrRemoteStorageSystemHaDataModel());
        this.addDataObjectModel("COM_LU_SELECTION", new SJctrLuSelectionHaDataModel());
        this.addDataObjectModel(KEY_TABLE_AVA, new SJctrCreateHaPairsAvailableTableModel());
        this.addDataObjectModel("COM_SVOL_SELECTION", new SJctrBaseSecondaryVolumeDataModel());
        this.addDataObjectModel("COM_SELECTION_TYPE", new SJctrSelectionTypeHaDataModel());
        SJctrComboBoxDataModel mirrorIdComboBox = new SJctrComboBoxDataModel();
        mirrorIdComboBox.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrCreateHaPairsDC.this.fireMessageEvent(CREATE_PAIRS_MSG.SELECT_MIRROR_ID);
                }
            }
        });
        this.addDataObjectModel("COM_MIRROR_ID", mirrorIdComboBox);
        SJctrComboBoxDataModel quorumDiskIdComboBox = new SJctrComboBoxDataModel();
        quorumDiskIdComboBox.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrCreateHaPairsDC.this.fireMessageEvent(CREATE_PAIRS_MSG.SELECT_QUORUM_DISK_ID);
                }
            }
        });
        this.addDataObjectModel("COM_QUORUM_DISK", quorumDiskIdComboBox);
        this.addDataObjectModel("COM_CTG_ID", new SJctrComboBoxDataModel());
        this.addDataObjectModel("COM_INITIAL_COPY_TYPE", new SJctrComboBoxDataModel());
        this.addDataObjectModel("COM_COPY_PACE_TXT", new SJctrTextBoxDataModel());
        this.addDataObjectModel("COM_ALUA_MODE", new SJctrComboBoxDataModel());
        SJctrButtonDataModel addButton = new SJctrButtonDataModel();
        addButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrCreateHaPairsDC.this.fireMessageEvent(CREATE_PAIRS_MSG.SELECT_ADD);
                }
            }
        });
        this.addDataObjectModel("COM_ADD", addButton);
        this.addDataObjectModel(KEY_TABLE_SELECTED, new SJctrCreateHaPairsSelectedPairsTableModel());
        SJctrButtonDataModel changeSettingButton = new SJctrButtonDataModel();
        changeSettingButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrCreateHaPairsDC.this.fireMessageEvent(CREATE_PAIRS_MSG.SELECT_CHANGE_SETTINGS);
                }
            }
        });
        this.addDataObjectModel("COM_CHG_SETTING", changeSettingButton);
        SJctrButtonDataModel removeButton = new SJctrButtonDataModel();
        removeButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrCreateHaPairsDC.this.fireMessageEvent(CREATE_PAIRS_MSG.SELECT_REMOVE);
                }
            }
        });
        this.addDataObjectModel("COM_REMOVE", removeButton);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    private void initListener() {
        this.addMessageEventListener(CREATE_PAIRS_MSG.SELECT_REMOTE_SYSTEM_MODEL_SN, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateHaPairsDC.this.modelSerialNumberAction();
            }
        });
        this.addMessageEventListener(CREATE_PAIRS_MSG.SELECT_SELECTION_OBJECT, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateHaPairsDC.this.selectionObjectRadioAction();
            }
        });
        this.addMessageEventListener(CREATE_PAIRS_MSG.SELECT_LU_SELECTION_PORT_ID, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateHaPairsDC.this.localPortIdAction();
            }
        });
        this.addMessageEventListener(CREATE_PAIRS_MSG.SELECT_LU_SELECTION_HOST_GROUP_NAME, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateHaPairsDC.this.localHostGroupNameAction();
            }
        });
        this.addMessageEventListener(CREATE_PAIRS_MSG.SELECT_SVOL_SELECTION_SEL_TYPE, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateHaPairsDC.this.selectionTypeRadioAction();
            }
        });
        this.addMessageEventListener(CREATE_PAIRS_MSG.SELECT_MIRROR_ID, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateHaPairsDC.this.mirrorIdAction();
            }
        });
        this.addMessageEventListener(CREATE_PAIRS_MSG.SELECT_QUORUM_DISK_ID, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateHaPairsDC.this.quorumDiskIdAction();
            }
        });
        this.addMessageEventListener(CREATE_PAIRS_MSG.SELECT_ADD, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateHaPairsDC.this.addAction();
                SJctrReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        this.addMessageEventListener(CREATE_PAIRS_MSG.SELECT_CHANGE_SETTINGS, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateHaPairsDC.this.makeChangeSettings();
            }
        });
        this.addMessageEventListener(SJctrDialogDataController.DIALOG_MSG.EXIT, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                Map param = (Map)event.getNofifyObject();
                SJctrCreateHaPairsDC.this.exitDialogAction(param);
                SJctrReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        this.addMessageEventListener(CREATE_PAIRS_MSG.SELECT_REMOVE, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrCreateHaPairsDC.this.removeAction();
                SJctrReplicationUtility.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetHAPairVolInfoMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevNicknameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetClprInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevStatusInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortLunInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortHostGroupInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortAttributeInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRemoteReplicationMRCUInfoMgr();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetSubsystemInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetQuorumDiskInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetHUVMVirtualLdev();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetHUVMVirtualDkc();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetSsidDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortIscsiTargetInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetChaDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public boolean checkConstructData() {
        try {
            this.checkCacheData();
            boolean bLicense = this.checkCrateHaLicense();
            if (!bLicense) {
                throw SJctrCreateRemotePairUtility.createRemoteReplicationException(205079);
            }
            int currentPair = this.getCurrentHaPairInfo();
            if (SJmoDataMacro_IF.MAX_RC_PAIR_NUM <= currentPair) {
                throw SJctrCreateRemotePairUtility.createRemoteReplicationException(206065);
            }
            this.createHaCtgInfoList();
            this.createCuFreeMrcuMap();
            if (this.cuFreeRcuInfoMap.isEmpty()) {
                throw SJctrCreateRemotePairUtility.createRemoteReplicationException(206154);
            }
            this.quorumDiskList = SJctrHaUtility.getQuorumDisksInfoRegisteredList(SJctrHaUtility.getSJmoQuorumDiskInfo(this), SJctrHaUtility.getSJctrResourceGroupUtility(this));
            if (this.quorumDiskList.isEmpty()) {
                throw SJctrCreateRemotePairUtility.createRemoteReplicationException(206158);
            }
            Collections.sort(this.quorumDiskList);
            this.removeCuFreeMrcuMap();
            if (this.cuFreeRcuInfoMap.isEmpty()) {
                throw SJctrCreateRemotePairUtility.createRemoteReplicationException(206159);
            }
            this.createAvilableLdevList();
            if (this.availableBasicDataList.isEmpty()) {
                throw SJctrCreateRemotePairUtility.createRemoteReplicationException(206025);
            }
            this.initPortLunInfo();
            if (this.availablePortLunList.isEmpty()) {
                throw SJctrCreateRemotePairUtility.createRemoteReplicationException(206023);
            }
        }
        catch (SJcException e) {
            throw SJctrHaUtility.convRReplicaLogicalErr(e, 107002);
        }
        return true;
    }

    private void checkCacheData() {
        try {
            SJctrHaUtility.getSJmoHAPairVolInfoMgr(this);
            SJctrReplicationUtility.getSJmoLdevDetail(this);
            SJctrReplicationUtility.getSJmoLdevNicknameInfo(this);
            SJctrReplicationUtility.getSJmoClprInfo(this);
            SJctrHaUtility.getSJmoLdevStatusInfo(this);
            SJctrReplicationUtility.getSJmoRSGgetAllRsgs(this);
            SJctrReplicationUtility.getSJmoPortLunInfo(this);
            SJctrRsgUtility.getSJmoPortHostGroupInfo(this);
            SJctrReplicationUtility.getSJmoPortDetail(this);
            SJctrHaUtility.getSJmoPortAttributeInfo(this);
            SJctrHaUtility.getSJmoRemoteReplicationMRCUInfoMgr(this);
            SJctrHaUtility.getSJmoSubsystemInfo(this);
            SJctrHaUtility.getSJmoQuorumDiskInfo(this);
            SJctrHaUtility.getSJmoHUVMVirtualLdev(this);
            SJctrHaUtility.getSJmoHUVMVirtualDkc(this);
            SJctrHaUtility.getSJmoSsidDetail(this);
            SJctrIscsiUtility.getSJmoPortIscsiTargetInfoList(this);
            SJctrRemoteReplicationUtility.getSJmoChaDetailList(this);
        }
        catch (SJcException e) {
            throw SJctrCreateRemotePairUtility.createRemoteReplicationException(107002);
        }
    }

    private boolean checkCrateHaLicense() {
        SJctrLicenseContainer lc = this.getOwner().getAuthorizeContainer().getLisenceContainer();
        boolean isEnableHa = lc.checkPP(SJctrLicenseContainer.PPID_GAD);
        return isEnableHa;
    }

    private int getCurrentHaPairInfo() {
        SJmoHAPairVolInfoMgr haPairInfoMgr = SJctrHaUtility.getSJmoHAPairVolInfoMgr(this);
        this.currentHaPairVolInfoList = SJctrHaUtility.getRemoteCopyPairVolInfoList(haPairInfoMgr.getHAPairVolInfoList());
        return this.currentHaPairVolInfoList.size();
    }

    private void createCuFreeMrcuMap() {
        SJmoRemoteReplicationMRCUInfoMgr mrcuInfoMgr = SJctrHaUtility.getSJmoRemoteReplicationMRCUInfoMgr(this);
        ArrayList<SJmoRemoteReplicationRCUInfo> sourceList = mrcuInfoMgr.getMRCUFreeInfo().getTrueCopyRCUInfoList();
        List<SJmoRemoteReplicationRCUInfo> cuFreeRcuInfoList = SJctrHaUtility.removeNoResourceRCUInfo(sourceList, SJctrHaUtility.getSJctrResourceGroupUtility(this));
        for (SJmoRemoteReplicationRCUInfo cuFreeRcuInfo : cuFreeRcuInfoList) {
            boolean canUseFlg = this.EnableUseRemoteStorageForHa(cuFreeRcuInfo);
            if (!canUseFlg) continue;
            String modelSn = this.createModelSnStr(cuFreeRcuInfo);
            TreeSet<Integer> pathGrpIdList = this.cuFreeRcuInfoMap.get(modelSn);
            if (null == pathGrpIdList) {
                pathGrpIdList = new TreeSet();
                this.cuFreeRcuInfoMap.put(modelSn, pathGrpIdList);
            }
            pathGrpIdList.add(cuFreeRcuInfo.getIRCUID());
        }
    }

    private boolean EnableUseRemoteStorageForHa(SJmoRemoteReplicationRCUInfo rcuInfo) {
        boolean ret = false;
        switch (rcuInfo.getIControllerID()) {
            case 6: 
            case 7: 
            case 19: {
                ret = false;
                break;
            }
            case 18: {
                ret = true;
                break;
            }
            default: {
                ret = true;
            }
        }
        return ret;
    }

    private void removeCuFreeMrcuMap() {
        Set<String> connectModelSn = this.cuFreeRcuInfoMap.keySet();
        HashSet<String> quorumModelSN = new HashSet<String>();
        for (SJmoQuorumDiskInfo disk : this.quorumDiskList) {
            int iSN = 0;
            try {
                iSN = Integer.valueOf(disk.getStrSN());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            String strModelSn = this.createStrModelSn(disk.getICtrlID(), iSN);
            quorumModelSN.add(strModelSn);
        }
        Iterator ite = connectModelSn.iterator();
        while (ite.hasNext()) {
            String modelSnStr = (String)ite.next();
            if (quorumModelSN.contains(modelSnStr)) continue;
            ite.remove();
        }
    }

    private String createModelSnStr(SJmoRemoteReplicationRCUInfo mrcuinfo) {
        int serialNumber = 0;
        try {
            serialNumber = Integer.valueOf(mrcuinfo.getStrSN());
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        String modelSnStr = this.createStrModelSn(mrcuinfo.getIControllerID(), serialNumber);
        return modelSnStr;
    }

    private String createStrModelSn(int ctrlID, int iSN) {
        int iModelSn = ctrlID * 1000000 + iSN;
        String strModelSn = SJctrComUtility.toPaddingZeroString(iModelSn, 9);
        return strModelSn;
    }

    @Override
    public void makeDataModel() throws SJcException {
        this.setEnableEventListner(false);
        super.makeDataModel();
        SJctrComUtility comUty = this.getOwner().getComUtility();
        SJmoSubsystemInfo sysInfo = SJctrHaUtility.getSJmoSubsystemInfo(this);
        this.localModelId = this.getComUtility().getRemoteReplicationUtility().getModelIDfromSubsysInfo(sysInfo);
        this.updateModelSnPullDown();
        this.updatePathGrpIdDataModel();
        this.updateSelectionObjectModel();
        this.updateLocalPortIdDataModel();
        this.updateAvailableLdevsTableModel();
        this.updateRemotePortId();
        SJctrBaseSecondaryVolumeDataModel baseSndaMdl = (SJctrBaseSecondaryVolumeDataModel)this.getDataObjectModel("COM_SVOL_SELECTION");
        baseSndaMdl.getHgIdModel().setSelectedIndex(0);
        baseSndaMdl.getLunIdModel().setSelectedIndex(0);
        SJctrSelectionTypeDataModel selectTypeDataMdl = (SJctrSelectionTypeDataModel)this.getDataObjectModel("COM_SELECTION_TYPE");
        selectTypeDataMdl.getSelectionTypeRadio().setSelect("COM_INTERVAL");
        this.updateIntervalValueModel();
        SJctrComboBoxDataModel mirrorId = (SJctrComboBoxDataModel)this.getDataObjectModel("COM_MIRROR_ID");
        for (int mid = 0; mid <= 3; ++mid) {
            mirrorId.addItem(String.valueOf(mid));
        }
        mirrorId.setSelectedIndex(0);
        this.updateQuorumDiskPullDown();
        this.updateCtgIdPullDown();
        SJctrComboBoxDataModel initCpyType = (SJctrComboBoxDataModel)this.getDataObjectModel("COM_INITIAL_COPY_TYPE");
        initCpyType.addItem(String.valueOf(1), comUty.getGuidance("INIT_CP_TYPE_ENTIRE_VOL"));
        initCpyType.addItem(String.valueOf(0), comUty.getGuidance("NONE"));
        initCpyType.setSelection(String.valueOf(1));
        SJctrTextBoxDataModel cpyPaceTxt = (SJctrTextBoxDataModel)this.getDataObjectModel("COM_COPY_PACE_TXT");
        cpyPaceTxt.setValue(String.valueOf(15));
        cpyPaceTxt.setMin(String.valueOf(1));
        cpyPaceTxt.setMax(String.valueOf(15));
        SJctrComboBoxDataModel aluaMode = (SJctrComboBoxDataModel)this.getDataObjectModel("COM_ALUA_MODE");
        aluaMode.addItem(String.valueOf(0), comUty.getGuidance("DEPEND_ON_PVOL_SETTINGS"));
        aluaMode.addItem(String.valueOf(1), comUty.getGuidance("ENABLE"));
        aluaMode.addItem(String.valueOf(2), comUty.getGuidance("DISABLE"));
        aluaMode.setSelection(String.valueOf(0));
        this.setEnableEventListner(true);
    }

    private void updateQuorumDiskPullDown() {
        SJctrComboBoxDataModel quorumDisk = (SJctrComboBoxDataModel)this.getDataObjectModel("COM_QUORUM_DISK");
        quorumDisk.removeAllItems();
        SJctrComboBoxDataModel modelSnModel = this.getRemoteSysModel().getModelSnModel();
        String modelSnStr = modelSnModel.getSelection();
        int imodel = this.getModelIdNumFromModelSnStr(modelSnStr);
        String strSn = this.getSerialNumberStrFromModelSnStr(imodel, modelSnStr);
        for (SJmoQuorumDiskInfo disk : this.quorumDiskList) {
            if (imodel != disk.getICtrlID() || !strSn.equals(disk.getStrSN())) continue;
            String quorumId = "?:?:?";
            this.getComUtility().getHaUtility();
            quorumId = SJctrHaUtility.isQuorumLess(disk.getIQuorumOption()) ? "-" : this.getComUtility().getLdevUtility().toLdevDisplay(disk.getQuorumLdevIndex());
            quorumDisk.addItem(String.valueOf(disk.getIQuorumDiskID()), this.getComUtility().getHaUtility().getQuorumDiskIdString(disk) + "(" + quorumId + ")");
        }
        quorumDisk.setSelectedIndex(0);
        this.setDirtyAll();
    }

    private void setEnableEventListner(boolean flg) {
        SJctrComboBoxDataModel modelSnModel = this.getRemoteSysModel().getModelSnModel();
        SJctrRadioButtonGroupDataModel radioPortKind = this.getSelectionObjectRadioButtonModel();
        SJctrComboBoxDataModel modelPortId = this.getLocalPortIdModel();
        SJctrComboBoxDataModel modelHgName = this.getLocalHgNameModel();
        SJctrSelectionTypeDataModel selectTypeDataMdl = (SJctrSelectionTypeDataModel)this.getDataObjectModel("COM_SELECTION_TYPE");
        SJctrRadioButtonGroupDataModel raioSelectionType = selectTypeDataMdl.getSelectionTypeRadio();
        modelSnModel.setEnableListener(flg);
        radioPortKind.setEnableListener(flg);
        modelPortId.setEnableListener(flg);
        modelHgName.setEnableListener(flg);
        raioSelectionType.setEnableListener(flg);
    }

    private void initPortLunInfo() {
        List<SJmoPortLunInfo> portLunList = SJctrReplicationUtility.getSJmoPortLunInfo(this);
        Collections.sort(portLunList);
        List<SJmoPortDetail> portDetailList = SJctrReplicationUtility.getSJmoPortDetail(this);
        Collections.sort(portDetailList);
        List<SJmoPortAttributeInfo> portAttributeList = SJctrHaUtility.getSJmoPortAttributeInfo(this);
        Collections.sort(portAttributeList);
        List<SJmoPortHostGroupInfo> portHgInfoList = SJctrRsgUtility.getSJmoPortHostGroupInfo(this);
        Collections.sort(portHgInfoList);
        List<SJmoPortIscsiTargetInfo> portTgInfoList = SJctrIscsiUtility.getSJmoPortIscsiTargetInfoList(this);
        Collections.sort(portTgInfoList);
        for (SJmoPortLunInfo portLun : portLunList) {
            if (!this.isAvailablePortKind(portDetailList, portLun) || !this.isAvailablePortAttribute(portAttributeList, portLun)) continue;
            this.createAvailablePortLunInfo(portLun, portHgInfoList);
            this.createAvailablePortLunInfoTgPort(portLun, portTgInfoList);
        }
        Collections.sort(this.availablePortLunList);
        Collections.sort(this.availablePortHgList);
    }

    private boolean isAvailablePortKind(List<SJmoPortDetail> portDetailList, SJmoPortIndex portIndex) {
        boolean isAvailblePort = false;
        int index = Collections.binarySearch(portDetailList, portIndex);
        SJmoPortDetail portDetail = null;
        if (index < 0) {
            SJctrLogUty.error(SJctrCreateHaPairsDC.class.getSimpleName(), "isAvailablePortKind", "Port Detail Info is not found: " + portIndex.getIndex());
            return isAvailblePort;
        }
        portDetail = portDetailList.get(index);
        isAvailblePort |= SJctrPortUtility.isFibrePort(portDetail);
        isAvailblePort |= SJctrPortUtility.isFcoePort(portDetail);
        isAvailblePort |= SJctrIscsiUtility.isIscsiPort(portDetail);
        return isAvailblePort |= SJctrPortUtility.isHnasUserPort(portDetail);
    }

    private boolean isAvailablePortAttribute(List<SJmoPortAttributeInfo> portAttributeList, SJmoPortIndex portIndex) {
        boolean isAvailablePortAttribute = false;
        int index = Collections.binarySearch(portAttributeList, portIndex);
        SJmoPortAttributeInfo portAttribute = null;
        if (index < 0) {
            SJctrLogUty.error(SJctrCreateHaPairsDC.class.getSimpleName(), "isAvailablePortAttribute", "Port Attribute Info is not found: " + portIndex.getIndex());
            return isAvailablePortAttribute;
        }
        portAttribute = portAttributeList.get(index);
        isAvailablePortAttribute |= portAttribute.getByPortKind() == 3;
        isAvailablePortAttribute |= portAttribute.getByPortKind() == 4;
        return isAvailablePortAttribute |= portAttribute.getByPortKind() == 9;
    }

    private void createAvailablePortLunInfo(SJmoPortLunInfo portLunInfo, List<SJmoPortHostGroupInfo> portHgInfoList) {
        if (null == portLunInfo || null == portHgInfoList) {
            return;
        }
        int index = Collections.binarySearch(portHgInfoList, portLunInfo);
        if (index < 0) {
            return;
        }
        SJmoPortHostGroupInfo portHgInfo = portHgInfoList.get(index);
        try {
            SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
            ArrayList hgInfoList = portHgInfo.getAlPortHostGroup();
            SJmoPortLunInfo availablePortLunInfo = (SJmoPortLunInfo)portLunInfo.clone();
            availablePortLunInfo.getAlPortLun().clear();
            ArrayList<SJmoPortLunDetail> availablePortLunDetailList = new ArrayList<SJmoPortLunDetail>();
            ArrayList<SJmoHostGroupInfo> availableHostGroupInfoList = new ArrayList<SJmoHostGroupInfo>();
            for (SJmoHostGroupInfo hgInfo : hgInfoList) {
                ArrayList portLunDetailList = portLunInfo.getAlHostGroupLun(hgInfo.getSHostGroup());
                for (SJmoPortLunDetail portLunDetail : portLunDetailList) {
                    ldevIndex.setLdevIndex(portLunDetail.getSLDKC(), portLunDetail.getSCU(), portLunDetail.getSLDEV());
                    index = Collections.binarySearch(this.availableBasicDataList, ldevIndex);
                    if (index < 0) continue;
                    availablePortLunDetailList.add(portLunDetail);
                }
                if (availablePortLunDetailList.isEmpty()) continue;
                availablePortLunInfo.getAlPortLun().addAll(availablePortLunDetailList);
                availableHostGroupInfoList.add(hgInfo);
                availablePortLunDetailList.clear();
            }
            if (!availablePortLunInfo.getAlPortLun().isEmpty()) {
                this.availablePortLunList.add(availablePortLunInfo);
                SJmoPortHostGroupInfo availablePortHostGroupInfo = (SJmoPortHostGroupInfo)portHgInfo.clone();
                availablePortHostGroupInfo.setAlPortHostGroup(availableHostGroupInfoList);
                this.availablePortHgList.add(availablePortHostGroupInfo);
            }
        }
        catch (CloneNotSupportedException e) {
            SJctrLogUty.error(this.getClass().getSimpleName(), "createAvailablePortLunInfo", "CloneNotSupportedException occured.");
            throw SJctrHaUtility.createRemoteReplicationException(107002);
        }
    }

    private void createAvailablePortLunInfoTgPort(SJmoPortLunInfo portLunInfo, List<SJmoPortIscsiTargetInfo> portTgInfoList) {
        if (null == portLunInfo || null == portTgInfoList) {
            return;
        }
        int index = Collections.binarySearch(portTgInfoList, portLunInfo);
        if (index < 0) {
            return;
        }
        SJmoPortIscsiTargetInfo portTgInfo = portTgInfoList.get(index);
        try {
            SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
            ArrayList<SJmoIscsiTargetInfo> tgInfoList = portTgInfo.getAlPortIscsiTarget();
            SJmoPortLunInfo availablePortLunInfo = (SJmoPortLunInfo)portLunInfo.clone();
            availablePortLunInfo.getAlPortLun().clear();
            ArrayList<SJmoPortLunDetail> availablePortLunDetailList = new ArrayList<SJmoPortLunDetail>();
            ArrayList<SJmoIscsiTargetInfo> availableIscsiTargetInfoList = new ArrayList<SJmoIscsiTargetInfo>();
            for (SJmoIscsiTargetInfo tgInfo : tgInfoList) {
                ArrayList portLunDetailList = portLunInfo.getAlHostGroupLun(tgInfo.getSIscsiTarget());
                for (SJmoPortLunDetail portLunDetail : portLunDetailList) {
                    ldevIndex.setLdevIndex(portLunDetail.getSLDKC(), portLunDetail.getSCU(), portLunDetail.getSLDEV());
                    index = Collections.binarySearch(this.availableBasicDataList, ldevIndex);
                    if (index < 0) continue;
                    availablePortLunDetailList.add(portLunDetail);
                }
                if (availablePortLunDetailList.isEmpty()) continue;
                availablePortLunInfo.getAlPortLun().addAll(availablePortLunDetailList);
                availableIscsiTargetInfoList.add(tgInfo);
                availablePortLunDetailList.clear();
            }
            if (!availablePortLunInfo.getAlPortLun().isEmpty()) {
                this.availablePortLunList.add(availablePortLunInfo);
                SJmoPortIscsiTargetInfo availablePortIscsiTargetInfo = (SJmoPortIscsiTargetInfo)portTgInfo.clone();
                availablePortIscsiTargetInfo.setAlPortIscsiTarget(availableIscsiTargetInfoList);
                this.availablePortHgList.add(availablePortIscsiTargetInfo);
            }
        }
        catch (CloneNotSupportedException e) {
            SJctrLogUty.error(this.getClass().getSimpleName(), "createAvailablePortLunInfo", "CloneNotSupportedException occured.");
            throw SJctrHaUtility.createRemoteReplicationException(107002);
        }
    }

    private void createAvilableLdevList() {
        List<SJmoLdevDetail> ldevDetailList = SJctrHaUtility.getSJmoLdevDetailFilteredByAllRsg(this);
        List<SJmoLdevStatusInfo> ldevStatusList = SJctrHaUtility.getSJmoLdevStatusInfo(this);
        Collections.sort(ldevStatusList);
        List<SJmoHUVMVirtualLdev> virtualLdevList = SJctrHaUtility.getSJmoHUVMVirtualLdev(this);
        List<SJmoHUVMVirtualDkc> virtualDkcList = SJctrHaUtility.getSJmoHUVMVirtualDkc(this);
        SJmoHAPairVolInfoMgr haPairVolInfoMgr = SJctrHaUtility.getSJmoHAPairVolInfoMgr(this);
        SJctrResourceGroupUtility rsgUty = SJctrHaUtility.getSJctrResourceGroupUtility(this);
        for (SJmoLdevDetail ldev : ldevDetailList) {
            SJmoHUVMVirtualLdev virtualLdev;
            int vLdevIndex;
            SJmoReplicationPairVolInfo haPairVolInfo;
            int ldevStatusIndex;
            if (rsgUty.isSelRscLdevInSysRsg(ldev) || (ldevStatusIndex = Collections.binarySearch(ldevStatusList, ldev)) < 0 || !SJctrCreatePairUtility.checkCreatePiarUsableStatus(ldevStatusList.get(ldevStatusIndex)) || ldev.getIEmulationType() != 625 || !SJctrLdevUtility.isAllocateVolume(ldev) || ldev.getbLUPathCmdDev() || ldev.getbJNLVolume() || ldev.getbPoolVol() || ldev.getbQsVvol() || ldev.getBLockVolume() || null != (haPairVolInfo = haPairVolInfoMgr.getHAPairVolInfo(ldev)) && SJctrHaUtility.checkPairVolPos(haPairVolInfo, SJctrHaDataMacro.BITMAPDATA_VOL_POS_HA) || (vLdevIndex = Collections.binarySearch(virtualLdevList, ldev)) < 0 || !(virtualLdev = virtualLdevList.get(vLdevIndex)).isValidIndexVirtualLdev() || SJctrHaUtility.isHuvmReserve(virtualLdev)) continue;
            this.availableBasicDataList.add(ldev);
        }
        Collections.sort(this.availableBasicDataList);
    }

    @Override
    public boolean checkEndData() {
        try {
            SJctrCreateHaPairsConfirmData confirmData = new SJctrCreateHaPairsConfirmData();
            SJctrCreateHaPairsSelectedTableModel tbl = (SJctrCreateHaPairsSelectedTableModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
            List<Object> pairList = tbl.getAllRowData();
            Collections.sort(pairList, new SJctrHAPairInfoComparator());
            confirmData.setPairsInfo(pairList);
            SJmoSubsystemInfo subsysInfo = SJctrRemoteReplicationUtility.getSJmoSubsystemInfo(this);
            confirmData.setLocalSN(subsysInfo.getDKCSNString());
            confirmData.setNeedData(this);
            ArrayList<SJctrCreateHaPairsConfirmData> confirmDataList = new ArrayList<SJctrCreateHaPairsConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrCreateHaPairsConfirmData.class, confirmDataList);
            SJctrReplicationUtility.setFinishChangeCheck(this, false);
        }
        catch (SJcException e) {
            throw SJctrHaUtility.convRReplicaLogicalErr(e, 107003);
        }
        return true;
    }

    private void setInitCopyTypeNoneErrInfo(List<Object> allRowData) {
        Object pairInfo;
        boolean existNone = false;
        int initCopyType = -1;
        Iterator<Object> i$ = allRowData.iterator();
        while (i$.hasNext() && !(existNone = (initCopyType = ((SJctrCreateHaPairVolInfo)(pairInfo = i$.next())).getInitCopyType()) == 0)) {
        }
        this.getManageData().setData("COM_VIEW_ALERT_EXIST", existNone);
        if (existNone) {
            this.getManageData().setData("COM_VIEW_ALERT_CODE", 0);
        }
    }

    private void modelSerialNumberAction() {
        this.setEnableEventListner(false);
        this.updatePathGrpIdDataModel();
        this.updateRemotePortId();
        this.updateQuorumDiskPullDown();
        this.updateCtgIdPullDown();
        this.setEnableEventListner(true);
    }

    private void selectionObjectRadioAction() {
        this.setEnableEventListner(false);
        this.updateLocalPortIdDataModel();
        this.updateAvailableLdevsTableModel();
        this.setEnableEventListner(true);
    }

    private void localPortIdAction() {
        this.setEnableEventListner(false);
        this.updateLocalHgNameModel();
        this.updateAvailableLdevsTableModel();
        this.setEnableEventListner(true);
    }

    private void localHostGroupNameAction() {
        this.setEnableEventListner(false);
        this.updateAvailableLdevsTableModel();
        this.setEnableEventListner(true);
    }

    private void selectionTypeRadioAction() {
        this.setEnableEventListner(false);
        this.updateIntervalValueModel();
        this.setEnableEventListner(true);
    }

    private void mirrorIdAction() {
        this.setEnableEventListner(false);
        this.updateCtgIdPullDown();
        this.setEnableEventListner(true);
    }

    private void quorumDiskIdAction() {
        this.setEnableEventListner(false);
        this.updateCtgIdPullDown();
        this.setEnableEventListner(true);
    }

    private void addAction() {
        SJctrCreatePairsAvailableTableModelLun availableTable = this.getAvailableTableLun();
        List<Object> selectedLdevs = availableTable.getSelectedRowDataOrder();
        int pvolCount = selectedLdevs.size();
        SJctrCreateHaPairsSelectedTableModel slectedTbl = (SJctrCreateHaPairsSelectedTableModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
        int selectedCount = slectedTbl.getRowCount();
        this.checkMaxPairNum(pvolCount, selectedCount);
        SJctrComboBoxDataModel ctgIdPullDown = (SJctrComboBoxDataModel)this.getDataObjectModel("COM_CTG_ID");
        int selectedCtgId = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(ctgIdPullDown);
        List<SJmoHUVMVirtualDkc> selectedLdevsVDkcInfoList = SJctrHaUtility.getVirtualDkcInfoList(selectedLdevs, this);
        this.checkHaCtgRegulation(pvolCount, selectedCtgId, selectedLdevsVDkcInfoList);
        String modelSnStr = this.getRemoteSysModel().getModelSnModel().getSelection();
        int modelId = this.getModelIdNumFromModelSnStr(modelSnStr);
        String strSn = this.getSerialNumberStrFromModelSnStr(modelId, modelSnStr);
        List<Integer> usedLuIndexList = this.getUsedLun(slectedTbl.getAllRowData(), modelId, strSn);
        SJctrSelectionTypeDataModel selectTypeDataMdl = (SJctrSelectionTypeDataModel)this.getDataObjectModel("COM_SELECTION_TYPE");
        boolean isRelative = selectTypeDataMdl.isRelative();
        SJctrComboBoxDataModel cmbInterval = (SJctrComboBoxDataModel)selectTypeDataMdl.getDataModel("COM_INTERVAL_VALUE");
        int selectedInterval = SJctrHaUtility.getSelectedComboboxKeyNum(cmbInterval);
        SJctrBaseSecondaryVolumeDataModel baseSndaMdl = (SJctrBaseSecondaryVolumeDataModel)this.getDataObjectModel("COM_SVOL_SELECTION");
        List<SJmoLuIndex> svolIndexList = SJctrCreateRemotePairUtility.getSvolLunList(selectedLdevs, usedLuIndexList, selectedLdevs.size(), modelId, baseSndaMdl, isRelative, selectedInterval);
        List<SJctrCreateHaPairVolInfo> pairVolList = this.createHaPairsList(selectedLdevs, svolIndexList);
        slectedTbl.addRowDataTop(pairVolList);
        List<SJmoLdevIndex> selectedLdevIndex = this.getLdevIndexListFromSJctrPortLunTableKey(selectedLdevs);
        this.removeSelectedLdevFromAvailableTableBasicDataList(selectedLdevIndex);
        this.updateAvailableLdevsTableModel();
        this.updateCtgInfoForAddAction(selectedCtgId, pvolCount, selectedLdevsVDkcInfoList);
        this.updateCtgIdPullDown();
        ctgIdPullDown.setSelection(String.valueOf(selectedCtgId));
        this.setInitCopyTypeNoneErrInfo(slectedTbl.getAllRowData());
        this.updateFooter();
        this.setDirtyAll();
    }

    private void updateCtgInfoForAddAction(int ctgId, int selectedLdevsNum, List<SJmoHUVMVirtualDkc> vDkcInfoList) {
        if (ctgId != -1) {
            SJctrHaCtgInfo targetCtgInfo = this.allCtgInfoList.get(ctgId);
            if (targetCtgInfo.getUsage() == 0) {
                targetCtgInfo.setUsage(1);
                SJctrComboBoxDataModel cmbMId = (SJctrComboBoxDataModel)this.getDataObjectModel("COM_MIRROR_ID");
                targetCtgInfo.setMirrorId(SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(cmbMId));
                SJctrComboBoxDataModel cmbQuourumDisk = (SJctrComboBoxDataModel)this.getDataObjectModel("COM_QUORUM_DISK");
                targetCtgInfo.setQuorumDiskId(SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(cmbQuourumDisk));
                targetCtgInfo.setQuorumDiskDisable(false);
                targetCtgInfo.setLocalPairPosition(0);
                try {
                    if (vDkcInfoList.size() > 0) {
                        SJmoHUVMVirtualDkc vdkcInfoCopy = (SJmoHUVMVirtualDkc)vDkcInfoList.get(0).clone();
                        targetCtgInfo.setVirtualDkc(vdkcInfoCopy);
                    }
                }
                catch (CloneNotSupportedException e) {
                    SJctrLogUty.error(this.getClass().getSimpleName(), "updateCtgInfoForAddAction", "CloneNotSupportedException occured.");
                    throw SJctrHaUtility.createRemoteReplicationException(107001);
                }
            }
            targetCtgInfo.setNumOfPairs(targetCtgInfo.getNumOfPairs() + selectedLdevsNum);
        }
    }

    private List<Integer> getUsedLun(List<Object> allRowData, int controllerId, String strSn) {
        ArrayList<Integer> usedLuIndexList = new ArrayList<Integer>();
        Map<Short, String> remotePtMap = SJctrHaUtility.getPortNameMap(controllerId);
        ArrayList<Short> ptIndexList = new ArrayList<Short>(remotePtMap.keySet());
        for (Object rowData : allRowData) {
            SJctrCreateHaPairVolInfo svolInfo = (SJctrCreateHaPairVolInfo)rowData;
            if (svolInfo.getIPairModel() != controllerId || !svolInfo.getStrPairSN().equals(strSn)) continue;
            SJmoLuIndex luIndex = svolInfo.getPairLU();
            int ptIndex = ptIndexList.indexOf(luIndex.getSPort());
            int ptHgLu = SJctrCreateRemotePairUtility.getPtHgLun(ptIndex, luIndex.getSHostGroup(), luIndex.getILUN());
            usedLuIndexList.add(ptHgLu);
        }
        return usedLuIndexList;
    }

    private void removeSelectedLdevFromAvailableTableBasicDataList(List<SJmoLdevIndex> selectedLdevList) {
        Collections.sort(this.availableBasicDataList);
        for (SJmoLdevIndex selLdev : selectedLdevList) {
            int index = Collections.binarySearch(this.availableBasicDataList, selLdev);
            if (index < 0) continue;
            this.availableBasicDataList.remove(index);
        }
    }

    private List<SJmoLdevIndex> getLdevIndexListFromSJctrPortLunTableKey(List<SJctrPortLunTableKey> portLunList) {
        ArrayList<SJmoLdevIndex> ldevIndexList = new ArrayList<SJmoLdevIndex>(portLunList.size());
        for (SJctrPortLunTableKey portLun : portLunList) {
            SJmoPortLunDetail portLunDetail = portLun.getPortLunDetail();
            SJmoLdevIndex index = new SJmoLdevIndex();
            index.setLdevIndex(portLunDetail.getSLDKC(), portLunDetail.getSCU(), portLunDetail.getSLDEV());
            ldevIndexList.add(index);
        }
        return ldevIndexList;
    }

    private List<SJctrCreateHaPairVolInfo> createHaPairsList(List<SJctrPortLunTableKey> pvolIndexList, List<SJmoLuIndex> svolIndexList) {
        ArrayList<SJctrCreateHaPairVolInfo> pairVolInfo = new ArrayList<SJctrCreateHaPairVolInfo>(pvolIndexList.size());
        if (pvolIndexList.size() != svolIndexList.size()) {
            throw SJctrCreateRemotePairUtility.createRemoteReplicationException(107004);
        }
        String modelSnStr = this.getRemoteSysModel().getModelSnModel().getSelection();
        int controllerId = this.getModelIdNumFromModelSnStr(modelSnStr);
        String strSn = this.getSerialNumberStrFromModelSnStr(controllerId, modelSnStr);
        List<SJmoSsidDetail> ssidList = SJctrHaUtility.getSJmoSsidDetail(this);
        List<SJmoLdevDetail> ldevDetailList = SJctrReplicationUtility.getSJmoLdevDetail(this);
        SJctrComboBoxDataModel cmbCtgId = (SJctrComboBoxDataModel)this.getDataObjectModel("COM_CTG_ID");
        int ctgId = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(cmbCtgId);
        for (int index = 0; index < pvolIndexList.size(); ++index) {
            SJmoPortLunDetail pvolIndex = pvolIndexList.get(index).getPortLunDetail();
            SJmoReplicationPairVolInfo pvol = new SJmoReplicationPairVolInfo();
            pvol.setIPairVolPos(1024);
            pvol.setLdevIndex(pvolIndex.getSLDKC(), pvolIndex.getSCU(), pvolIndex.getSLDEV());
            SJctrCreateHaPairVolInfo svol = new SJctrCreateHaPairVolInfo();
            svol.setIPairVolPos(2048);
            svol.setPairLU(svolIndexList.get(index));
            svol.setLdevIndex(pvolIndex.getSLDKC(), pvolIndex.getSCU(), pvolIndex.getSLDEV());
            svol.setLocalPortId(pvolIndex);
            svol.setIPairModel(controllerId);
            svol.setStrPairSN(strSn);
            int pathId = SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(this.getRemoteSysModel().getPathGrpModel());
            svol.setIPathGroup(pathId);
            SJctrComboBoxDataModel cmbMId = (SJctrComboBoxDataModel)this.getDataObjectModel("COM_MIRROR_ID");
            svol.setIMuNo(SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(cmbMId));
            SJctrComboBoxDataModel cmbQuourumDisk = (SJctrComboBoxDataModel)this.getDataObjectModel("COM_QUORUM_DISK");
            svol.setIQuorumID(SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(cmbQuourumDisk));
            if (ctgId == -1) {
                svol.setBHasGroup(false);
            } else {
                svol.setBHasGroup(true);
                svol.setIGroup(SJctrRemoteReplicationUtility.getSelectedComboboxKeyNum(cmbCtgId));
            }
            svol.setInitCopyType(SJctrHaUtility.getSelectedComboboxKeyNum((SJctrComboBoxDataModel)this.getDataObjectModel("COM_INITIAL_COPY_TYPE")));
            int cpyPace = SJctrHaUtility.getValueTextBoxNum((SJctrTextBoxDataModel)this.getDataObjectModel("COM_COPY_PACE_TXT"));
            svol.setICopyPace(cpyPace);
            int alua = SJctrHaUtility.getSelectedComboboxKeyNum((SJctrComboBoxDataModel)this.getDataObjectModel("COM_ALUA_MODE"));
            svol.setAluaModeSelection(alua);
            if (alua == 0) {
                SJmoLdevIndex localVol = new SJmoLdevIndex();
                localVol.setLdevIndex(pvolIndex.getSLDKC(), pvolIndex.getSCU(), pvolIndex.getSLDEV());
                int ldevIndex = Collections.binarySearch(ldevDetailList, localVol);
                if (ldevIndex >= 0) {
                    SJmoLdevDetail ldev = ldevDetailList.get(ldevIndex);
                    if (ldev.getBAluaMode()) {
                        svol.setAluaMode(1);
                    } else {
                        svol.setAluaMode(2);
                    }
                }
            } else {
                svol.setAluaMode(alua);
            }
            int localSsid = SJctrHaUtility.getLocalExistenceSsid(pvol, ssidList);
            svol.setLocalExistenceSsid(localSsid);
            ArrayList<SJctrCreateHaPairVolInfo> svolList = new ArrayList<SJctrCreateHaPairVolInfo>(1);
            svolList.add(svol);
            pvol.setAlSVolIndex(svolList);
            ArrayList<SJmoReplicationPairVolInfo> pvolList = new ArrayList<SJmoReplicationPairVolInfo>(1);
            pvolList.add(pvol);
            svol.setAlPVolIndex(pvolList);
            pairVolInfo.add(svol);
        }
        return pairVolInfo;
    }

    private void removeAction() {
        SJctrCreateHaPairsSelectedTableModel table = (SJctrCreateHaPairsSelectedTableModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
        List<Object> selectedRowList = table.removeSelectedRowData();
        List<SJmoLdevDetail> modelLdevDetail = SJctrReplicationUtility.getSJmoLdevDetail(this);
        Collections.sort(modelLdevDetail);
        for (Object rowData : selectedRowList) {
            SJctrCreateHaPairVolInfo pairInfo = (SJctrCreateHaPairVolInfo)rowData;
            SJmoLdevIndex pvol = pairInfo.getPVolIndex();
            int index = Collections.binarySearch(modelLdevDetail, pvol);
            if (index < 0) continue;
            this.availableBasicDataList.add(modelLdevDetail.get(index));
        }
        Collections.sort(this.availableBasicDataList);
        this.updateAvailableLdevsTableModel();
        this.updateCtgInfoForRemoveAction(selectedRowList);
        SJctrComboBoxDataModel ctgIdPullDown = (SJctrComboBoxDataModel)this.getDataObjectModel("COM_CTG_ID");
        int selectedCtgId = SJctrHaUtility.getSelectedComboboxKeyNum(ctgIdPullDown);
        this.updateCtgIdPullDown();
        ctgIdPullDown.setSelection(String.valueOf(selectedCtgId));
        this.setInitCopyTypeNoneErrInfo(table.getAllRowData());
        this.updateFooter();
        this.setDirtyAll();
    }

    private void updateCtgInfoForRemoveAction(List<SJctrCreateHaPairVolInfo> haPairVolInfoList) {
        for (SJctrCreateHaPairVolInfo haPairVolInfo : haPairVolInfoList) {
            if (!haPairVolInfo.hasGroup()) continue;
            int ctgId = haPairVolInfo.getIGroup();
            SJctrHaCtgInfo haCtgInfo = this.allCtgInfoList.get(ctgId);
            int numOfPairs = haCtgInfo.getNumOfPairs() - 1;
            haCtgInfo.setNumOfPairs(numOfPairs);
            if (numOfPairs > 0) continue;
            haCtgInfo.setUsage(0);
            haCtgInfo.setMirrorId(-1);
            haCtgInfo.setQuorumDiskId(-1);
            haCtgInfo.setQuorumDiskDisable(true);
            haCtgInfo.setLocalPairPosition(-1);
            haCtgInfo.setVirtualDkc(null);
        }
    }

    private void makeChangeSettings() {
        SJctrCreateHaPairsSelectedTableModel table = (SJctrCreateHaPairsSelectedTableModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
        if (null == table) {
            SJctrLogUty.error(SJctrCreateHaPairsDC.class.getSimpleName(), "makeChangeSettings", " Table Object is null.");
            throw SJctrCreateRemotePairUtility.createRemoteReplicationException(107004);
        }
        List<Object> selectedPairs = table.getSelectedRowDataOrder();
        if (selectedPairs.isEmpty()) {
            SJctrLogUty.error(SJctrCreateHaPairsDC.class.getSimpleName(), "makeChangeSettings", "Available Table Object is null.");
            throw SJctrCreateRemotePairUtility.createRemoteReplicationException(107004);
        }
        this.checkSelectedPairRcu(selectedPairs);
        ArrayList<Object> cloneSelectedPairs = new ArrayList<Object>(selectedPairs.size());
        for (Object rowData : selectedPairs) {
            SJmoReplicationPairVolInfo pairInfo = (SJmoReplicationPairVolInfo)rowData;
            try {
                cloneSelectedPairs.add(pairInfo.clone());
            }
            catch (CloneNotSupportedException e) {
                SJctrLogUty.error(this.getClass().getSimpleName(), "makeChangeSettings", "CloneNotSupportedException occured.");
                throw SJctrHaUtility.createRemoteReplicationException(107004);
            }
        }
        HashMap param = new HashMap();
        param.put("KEY_SELECTED_PAIRS", cloneSelectedPairs);
        List<Object> allRowData = table.getAllRowData();
        allRowData.removeAll(selectedPairs);
        SJctrCreateHaPairVolInfo pairInfoTop = (SJctrCreateHaPairVolInfo)selectedPairs.get(0);
        int controllerId = pairInfoTop.getIPairModel();
        String serialNum = pairInfoTop.getStrPairSN();
        List<Integer> usedSvolIndexList = this.getUsedLun(allRowData, controllerId, serialNum);
        Class<SJctrChangeHaSettingsDC> clazz = SJctrChangeHaSettingsDC.class;
        param.put("KEY_USED_SVOL_INDEX_LIST", usedSvolIndexList);
        SJctrRelatedDispDataObject dialogRelated = this.createDialog(clazz, param);
        this.addUpdateDisp(dialogRelated);
    }

    private void checkSelectedPairRcu(List<Object> selectedPairList) {
        SJctrCreateHaPairVolInfo pairInfoTop = (SJctrCreateHaPairVolInfo)selectedPairList.get(0);
        int topControllerId = pairInfoTop.getIPairModel();
        String topSerialNum = pairInfoTop.getStrPairSN();
        for (Object selectedPair : selectedPairList) {
            SJctrCreateHaPairVolInfo pairInfo = (SJctrCreateHaPairVolInfo)selectedPair;
            if (topControllerId == pairInfo.getIPairModel() && topSerialNum.equals(pairInfo.getStrPairSN())) continue;
            throw SJctrCreateRemotePairUtility.createRemoteReplicationException(206038);
        }
    }

    private void exitDialogAction(Map<String, List<?>> carryMap) {
        List<Object> pairList = carryMap.get("KEY_SELECTED_PAIRS");
        if (pairList != null && pairList.size() > 0) {
            SJctrCreateHaPairsSelectedTableModel table = (SJctrCreateHaPairsSelectedTableModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
            int[] selRowIndex = table.getSelectedRows();
            if (selRowIndex.length != pairList.size()) {
                SJctrLogUty.error(SJctrCreateHaPairsDC.class.getSimpleName(), "exitDialogAction", "Selected pair size is unmached.");
                throw SJctrCreateRemotePairUtility.createRemoteReplicationException(107004);
            }
            table.removeSelectedRowData();
            ArrayList<Object> tmpList = new ArrayList<Object>(1);
            ArrayList<Object> addList = null;
            for (int i = 0; i < pairList.size(); ++i) {
                tmpList.add(pairList.get(i));
                addList = tmpList;
                table.addRowData(addList, selRowIndex[i]);
                tmpList.clear();
            }
            table.addRowSelectionList(pairList);
            this.setInitCopyTypeNoneErrInfo(table.getAllRowData());
            this.updateFooter();
        }
    }

    private void updateModelSnPullDown() {
        SJctrComboBoxDataModel modelSnModel = this.getRemoteSysModel().getModelSnModel();
        Set<String> modelSnList = this.cuFreeRcuInfoMap.keySet();
        for (String modelSnStr : modelSnList) {
            modelSnModel.addItem(modelSnStr, this.getModelSnDisplayStr(modelSnStr));
        }
        for (String modelSnStr : modelSnList) {
            int imodel = this.getModelIdNumFromModelSnStr(modelSnStr);
            if (imodel != this.localModelId) continue;
            modelSnModel.setSelection(modelSnStr);
            break;
        }
        if (modelSnModel.getSelectedIndex() == -1) {
            modelSnModel.setSelectedIndex(0);
        }
    }

    private String getModelSnDisplayStr(String modelSnStr) {
        int controllerId = this.getModelIdNumFromModelSnStr(modelSnStr);
        String snStr = this.getSerialNumberStrFromModelSnStr(controllerId, modelSnStr);
        String dispStr = this.getComUtility().getRemoteReplicationUtility().getModelSNoString(controllerId, snStr);
        return dispStr;
    }

    private int getModelIdNumFromModelSnStr(String modelSnStr) {
        int modelId = -1;
        try {
            modelId = Integer.valueOf(modelSnStr);
        }
        catch (NumberFormatException e) {
            return modelId;
        }
        return modelId /= 1000000;
    }

    private String getSerialNumberStrFromModelSnStr(int controllerId, String modelSnStr) {
        int snLength;
        switch (controllerId) {
            case 6: 
            case 7: {
                snLength = 5;
                break;
            }
            case 18: 
            case 19: {
                snLength = 6;
                break;
            }
            default: {
                snLength = SJctrDataController.isHM() ? 6 : 5;
            }
        }
        String snStr = "?";
        if (modelSnStr.length() >= snLength) {
            snStr = modelSnStr.substring(modelSnStr.length() - snLength);
        }
        return snStr;
    }

    private void updatePathGrpIdDataModel() {
        SJctrComboBoxDataModel pathGrpModel = this.getRemoteSysModel().getPathGrpModel();
        pathGrpModel.removeAllItems();
        String selectedModelSnStr = this.getRemoteSysModel().getModelSnModel().getSelection();
        Set pathGrpIdList = this.cuFreeRcuInfoMap.get(selectedModelSnStr);
        for (Integer pathGrpId : pathGrpIdList) {
            pathGrpModel.addItem(pathGrpId.toString(), SJctrComUtility.toHexString(pathGrpId, 2, true));
        }
        pathGrpModel.setSelectedIndex(0);
        pathGrpModel.setDirtyAll();
    }

    private void updateCtgIdPullDown() {
        SJctrComboBoxDataModel ctgIdPullDown = (SJctrComboBoxDataModel)this.getDataObjectModel("COM_CTG_ID");
        ctgIdPullDown.removeAllItems();
        ctgIdPullDown.addItem(String.valueOf(-1), this.getComUtility().getGuidance("NOT_ASSIGN"));
        SJctrComboBoxDataModel mirrorIdPullDown = (SJctrComboBoxDataModel)this.getDataObjectModel("COM_MIRROR_ID");
        int selectedMirrorId = SJctrHaUtility.getSelectedComboboxKeyNum(mirrorIdPullDown);
        SJctrComboBoxDataModel quorumDiskIdPullDown = (SJctrComboBoxDataModel)this.getDataObjectModel("COM_QUORUM_DISK");
        int selectedQuorumDiskId = SJctrHaUtility.getSelectedComboboxKeyNum(quorumDiskIdPullDown);
        int initialCtgId = -1;
        for (SJctrHaCtgInfo ctgInfo : this.allCtgInfoList) {
            int ctgId = ctgInfo.getCtgId();
            int usage = ctgInfo.getUsage();
            if (usage == 1) {
                if (!this.isMatchedCtgInfo(ctgInfo, selectedMirrorId, selectedQuorumDiskId, 0)) continue;
                String usedCtgId = SJctrComUtility.toHexString(ctgId, 3, true) + " " + this.getComUtility().getGuidance("ASTERISK");
                ctgIdPullDown.addItem(String.valueOf(ctgId), usedCtgId);
                if (initialCtgId != -1) continue;
                initialCtgId = ctgId;
                continue;
            }
            if (usage == 0) {
                ctgIdPullDown.addItem(String.valueOf(ctgId), SJctrComUtility.toHexString(ctgId, 3, true));
                continue;
            }
            SJctrLogUty.warn(SJctrCreateHaPairsDC.class.getSimpleName(), "updateCtgIdPullDown", "Usage is Invalid. CTG ID = " + ctgId);
        }
        ctgIdPullDown.setSelection(String.valueOf(initialCtgId));
        ctgIdPullDown.setDirtyAll();
    }

    private void updateSelectionObjectModel() {
        SJctrRadioButtonGroupDataModel radSelectionObject = this.getSelectionObjectRadioButtonModel();
        radSelectionObject.setEnable("COM_FIBRE", false);
        radSelectionObject.setEnable("COM_ISCSI", false);
        radSelectionObject.setEnable("COM_HNAS_PLATFORM_USER", false);
        List<SJmoPortDetail> portDetailList = SJctrReplicationUtility.getSJmoPortDetail(this);
        Collections.sort(portDetailList);
        for (SJmoPortLunInfo availablePortLunInfo : this.availablePortLunList) {
            int index = Collections.binarySearch(portDetailList, availablePortLunInfo);
            if (index < 0) {
                SJctrLogUty.error(SJctrCreatePairsDC.class.getSimpleName(), "updateSelectionObjectModel", "Port Detail is not found: " + availablePortLunInfo.getIndex());
                continue;
            }
            SJmoPortDetail portDetail = portDetailList.get(index);
            if (SJctrPortUtility.isFibrePort(portDetail)) {
                radSelectionObject.setEnable("COM_FIBRE", true);
                continue;
            }
            if (SJctrIscsiUtility.isIscsiPort(portDetail)) {
                radSelectionObject.setEnable("COM_ISCSI", true);
                continue;
            }
            if (!SJctrPortUtility.isHnasUserPort(portDetail)) continue;
            radSelectionObject.setEnable("COM_HNAS_PLATFORM_USER", true);
        }
        if (radSelectionObject.isEnable("COM_FIBRE")) {
            radSelectionObject.setSelect("COM_FIBRE");
        } else if (radSelectionObject.isEnable("COM_ISCSI")) {
            radSelectionObject.setSelect("COM_ISCSI");
        } else if (radSelectionObject.isEnable("COM_HNAS_PLATFORM_USER")) {
            radSelectionObject.setSelect("COM_HNAS_PLATFORM_USER");
        } else {
            SJctrLogUty.error(SJctrCreatePairsDC.class.getSimpleName(), "updateSelectionObjectModel", "There is no active item.");
        }
        ArrayList<SJmoChaDetail> chaDetailList = SJctrRemoteReplicationUtility.getSJmoChaDetailList(this);
        boolean hfbPackInst = SJmoChaUtility.isHfbPkInstall(chaDetailList);
        SJctrDataObject selectionObjData = this.getManageData();
        selectionObjData.setData("COM_SELECTION_OBJECT_HNAS_VISIBLE", hfbPackInst);
        radSelectionObject.setDirtyAll();
    }

    private void updateLocalPortIdDataModel() {
        SJctrComboBoxDataModel localPortIdModel = this.getLocalPortIdModel();
        localPortIdModel.removeAllItems();
        List<SJmoPortDetail> portDetailList = SJctrRsgUtility.getSJmoPortDetail(this);
        Collections.sort(portDetailList);
        SJctrRadioButtonGroupDataModel selectionObject = this.getSelectionObjectRadioButtonModel();
        byte kind = -1;
        if ("COM_FIBRE".equals(selectionObject.getSelect())) {
            kind = 2;
        } else if ("COM_ISCSI".equals(selectionObject.getSelect())) {
            kind = 5;
        } else if ("COM_HNAS_PLATFORM_USER".equals(selectionObject.getSelect())) {
            kind = 7;
        } else {
            SJctrLogUty.error(SJctrCreatePairsDC.class.getSimpleName(), "updateLocalPortIdModel", "Portkind is invalid : [" + kind + "]");
        }
        for (SJmoPortLunInfo portLunInfo : this.availablePortLunList) {
            SJmoPortDetail portDetailInfo;
            int index = Collections.binarySearch(portDetailList, portLunInfo);
            if (index < 0 || (portDetailInfo = portDetailList.get(index)).getByPortKindNo() != kind) continue;
            localPortIdModel.addItem(String.valueOf(portDetailInfo.getSPort()), portDetailInfo.getStrPortDisplayName());
        }
        localPortIdModel.setSelectedIndex(0);
        localPortIdModel.setDirtyAll();
        this.updateLocalHgNameModel();
    }

    private void updateLocalHgNameModel() {
        SJmoPortIndex portIndexData;
        SJctrComboBoxDataModel localHgPulldownList = this.getLocalHgNameModel();
        localHgPulldownList.removeAllItems();
        List<? extends SJmoPortIndex> hgtgList = this.getSortedByNameHostGroupInfoList();
        if (!hgtgList.isEmpty()) {
            localHgPulldownList.addItem("ANY", this.getComUtility().getGuidance("ANY"));
        }
        if ((portIndexData = hgtgList.get(0)) instanceof SJmoIscsiTargetInfo) {
            List<? extends SJmoPortIndex> tgList = hgtgList;
            for (SJmoIscsiTargetInfo sJmoIscsiTargetInfo : tgList) {
                String tgDispStr = this.getComUtility().getIscsiUtility().getIscsiTargetAliasIdString(sJmoIscsiTargetInfo);
                localHgPulldownList.addItem(String.valueOf(sJmoIscsiTargetInfo.getSIscsiTarget()), tgDispStr);
            }
            this.getManageData().setData(KEY_HG_TG_PULLDOWN_TITLE, this.getComUtility().getGuidance("ISCSI_TARGET_ALIAS"));
        } else {
            List<? extends SJmoPortIndex> hgList = hgtgList;
            for (SJmoHostGroupInfo sJmoHostGroupInfo : hgList) {
                String hgDispStr = this.getComUtility().getPortUtility().toHostGroupNameDisplay(sJmoHostGroupInfo);
                localHgPulldownList.addItem(String.valueOf(sJmoHostGroupInfo.getSHostGroup()), hgDispStr);
            }
            this.getManageData().setData(KEY_HG_TG_PULLDOWN_TITLE, this.getComUtility().getGuidance("HG_NAME"));
        }
        localHgPulldownList.setSelectedIndex(0);
        localHgPulldownList.setDirtyAll();
    }

    private List<? extends SJmoPortIndex> getSortedByNameHostGroupInfoList() {
        int selectedPortId = SJctrHaUtility.getSelectedComboboxKeyNum(this.getLocalPortIdModel());
        SJmoPortIndex portIndex = new SJmoPortIndex();
        portIndex.setSPort((short)selectedPortId);
        Collections.sort(this.availablePortHgList);
        int index = Collections.binarySearch(this.availablePortHgList, portIndex);
        Comparator<Object> portInfoComparator = null;
        ArrayList hgInfoList = null;
        if (index >= 0) {
            SJmoPortIndex portObject = this.availablePortHgList.get(index);
            if (portObject instanceof SJmoPortIscsiTargetInfo) {
                SJmoPortIscsiTargetInfo selectedPortTgInfo = (SJmoPortIscsiTargetInfo)portObject;
                hgInfoList = selectedPortTgInfo.getAlPortIscsiTarget();
                portInfoComparator = new SJctrIscsiTargetAliasComparator();
            } else {
                SJmoPortHostGroupInfo selectedPortHgInfo = (SJmoPortHostGroupInfo)portObject;
                hgInfoList = selectedPortHgInfo.getAlPortHostGroup();
                portInfoComparator = new SJctrHostGroupNameComparator();
            }
        } else {
            SJctrLogUty.error(SJctrCreateHaPairsDC.class.getSimpleName(), "getSortedByNameHostGroupInfoList", "Host Group / ISCSI Target info is null.");
            throw SJctrCreateRemotePairUtility.createRemoteReplicationException(107004);
        }
        Collections.sort(hgInfoList, portInfoComparator);
        return hgInfoList;
    }

    private void updateAvailableLdevsTableModel() {
        int selectedPortId = SJctrHaUtility.getSelectedComboboxKeyNum(this.getLocalPortIdModel());
        SJmoPortIndex portIndex = new SJmoPortIndex();
        portIndex.setSPort((short)selectedPortId);
        String selectedLocalHgName = this.getLocalHgNameModel().getSelection();
        List<SJctrPortLunTableKey> basicDataList = null;
        if ("ANY".equals(selectedLocalHgName)) {
            basicDataList = this.getLunTableKeyListByPort(portIndex);
        } else {
            List<SJmoPortLunInfo> portLunList = this.getSelectedHostGroupLun(portIndex);
            basicDataList = SJctrPortUtility.getPortLunListFromLdevDetail(this.availableBasicDataList, portLunList, new ArrayList<Boolean>());
        }
        Collections.sort(basicDataList);
        SJctrCreatePairsAvailableTableModelLun table = this.getAvailableTableLun();
        table.setBasicDataList(basicDataList);
        table.doRefresh();
        table.setDirtyAll();
    }

    private List<SJctrPortLunTableKey> getLunTableKeyListByPort(SJmoPortIndex portIndex) {
        List<SJctrPortLunTableKey> portLunKeyList = null;
        int index = Collections.binarySearch(this.availablePortLunList, portIndex);
        if (index >= 0) {
            ArrayList<SJmoPortLunInfo> needPortList = new ArrayList<SJmoPortLunInfo>();
            needPortList.add(this.availablePortLunList.get(index));
            List<SJmoLdevIndex> ldevIndexList = this.availableBasicDataList;
            portLunKeyList = SJctrPortUtility.getPortLunListFromLdevDetail(ldevIndexList, needPortList, new ArrayList<Boolean>());
        } else {
            portLunKeyList = new ArrayList<SJctrPortLunTableKey>(0);
        }
        List<SJctrPortLunTableKey> basicDataList = this.extractPortLunTableKey(portLunKeyList);
        return basicDataList;
    }

    private List<SJctrPortLunTableKey> extractPortLunTableKey(List<SJctrPortLunTableKey> portLunList) {
        ArrayList<SJctrPortLunTableKey> basicDataList = new ArrayList<SJctrPortLunTableKey>(portLunList.size());
        for (SJctrPortLunTableKey keyPortLun : portLunList) {
            short keyLdkc = keyPortLun.getPortLunDetail().getSLDKC();
            short keyCu = keyPortLun.getPortLunDetail().getSCU();
            short keyLdev = keyPortLun.getPortLunDetail().getSLDEV();
            boolean addFlg = true;
            for (SJctrPortLunTableKey portLun : basicDataList) {
                short ldkc = portLun.getPortLunDetail().getSLDKC();
                short cu = portLun.getPortLunDetail().getSCU();
                short ldev = portLun.getPortLunDetail().getSLDEV();
                if (keyLdkc != ldkc || keyCu != cu || keyLdev != ldev) continue;
                addFlg = false;
                break;
            }
            if (!addFlg) continue;
            basicDataList.add(keyPortLun);
        }
        return basicDataList;
    }

    private List<SJmoPortLunInfo> getSelectedHostGroupLun(SJmoPortIndex portIndex) {
        ArrayList<SJmoPortLunInfo> selectedPortHgLunInfo = new ArrayList<SJmoPortLunInfo>(1);
        Collections.sort(this.availablePortLunList);
        int index = Collections.binarySearch(this.availablePortLunList, portIndex);
        if (index >= 0) {
            SJmoPortLunInfo selectedPortLun = null;
            try {
                selectedPortLun = (SJmoPortLunInfo)this.availablePortLunList.get(index).clone();
            }
            catch (CloneNotSupportedException e) {
                SJctrLogUty.error(this.getClass().getSimpleName(), "getSelectedHostGroupLun", "CloneNotSupportedException occured.");
                throw SJctrHaUtility.createRemoteReplicationException(107001);
            }
            int hgId = SJctrHaUtility.getSelectedComboboxKeyNum(this.getLocalHgNameModel());
            if (hgId >= 0) {
                selectedPortLun.setAlPortLun(selectedPortLun.getAlHostGroupLun(hgId));
                selectedPortHgLunInfo.add(selectedPortLun);
            }
        }
        return selectedPortHgLunInfo;
    }

    private void updateRemotePortId() {
        SJctrBaseSecondaryVolumeDataModel baseSndaMdl = (SJctrBaseSecondaryVolumeDataModel)this.getDataObjectModel("COM_SVOL_SELECTION");
        SJctrComboBoxDataModel remotePortIdModel = baseSndaMdl.getPortIdModel();
        remotePortIdModel.removeAllItems();
        String selectedModelSnStr = this.getRemoteSysModel().getModelSnModel().getSelection();
        int controllerId = this.getModelIdNumFromModelSnStr(selectedModelSnStr);
        SJctrHaUtility.createRemotePortID(remotePortIdModel, controllerId, this.getComUtility());
        remotePortIdModel.removeItem("");
        remotePortIdModel.setSelectedIndex(0);
        remotePortIdModel.setDirtyAll();
    }

    private void updateIntervalValueModel() {
        SJctrSelectionTypeDataModel selectTypeDataMdl = (SJctrSelectionTypeDataModel)this.getDataObjectModel("COM_SELECTION_TYPE");
        SJctrRadioButtonGroupDataModel radioDataModel = (SJctrRadioButtonGroupDataModel)selectTypeDataMdl.getDataModel("COM_SELECTION_TYPE_RADIO");
        String selectedSelectionType = radioDataModel.getSelect();
        SJctrComboBoxDataModel intervalValueListModel = (SJctrComboBoxDataModel)selectTypeDataMdl.getDataModel("COM_INTERVAL_VALUE");
        intervalValueListModel.removeAllItems();
        if ("COM_INTERVAL".equals(selectedSelectionType)) {
            for (int i = 0; i <= SJmoDataMacro_IF.NUM_MAX_LUN; ++i) {
                intervalValueListModel.addItem(String.valueOf(i));
            }
            intervalValueListModel.setSelectedIndex(0);
            intervalValueListModel.setEnable(true);
        } else if ("COM_RELATIVE_PVOL".equals(selectedSelectionType)) {
            intervalValueListModel.addItem("-");
            intervalValueListModel.setSelectedIndex(0);
            intervalValueListModel.setEnable(false);
        }
        selectTypeDataMdl.setDirtyAll();
    }

    private SJctrRemoteStorageSystemDataModel getRemoteSysModel() {
        return (SJctrRemoteStorageSystemDataModel)this.getDataObjectModel("COM_REMOTE_STORAGE");
    }

    private SJctrLuSelectionDataModel getLuSelectionDataModel() {
        return (SJctrLuSelectionDataModel)this.getDataObjectModel("COM_LU_SELECTION");
    }

    private SJctrRadioButtonGroupDataModel getSelectionObjectRadioButtonModel() {
        return (SJctrRadioButtonGroupDataModel)this.getLuSelectionDataModel().getDataModel("COM_SELECTION_OBJECT_RADIO");
    }

    private SJctrComboBoxDataModel getLocalPortIdModel() {
        return (SJctrComboBoxDataModel)this.getLuSelectionDataModel().getDataModel("COM_PORT_ID");
    }

    private SJctrComboBoxDataModel getLocalHgNameModel() {
        return (SJctrComboBoxDataModel)this.getLuSelectionDataModel().getDataModel("COM_HG_NAME");
    }

    private SJctrCreatePairsAvailableTableModelLun getAvailableTableLun() {
        return (SJctrCreatePairsAvailableTableModelLun)this.getDataObjectModel(KEY_TABLE_AVA);
    }

    private void checkMaxPairNum(int pvolCount, int selectedPairsRowCount) {
        int total = pvolCount + selectedPairsRowCount + this.currentHaPairVolInfoList.size();
        if (total > SJctrHaUtility.getMaxAddPairNumHA()) {
            throw SJctrCreateRemotePairUtility.createRemoteReplicationException(206026);
        }
    }

    private void checkHaCtgRegulation(int selectedLdevsNum, int selectedCtgId, List<SJmoHUVMVirtualDkc> selectedVdkcInfoList) {
        if (selectedCtgId != -1) {
            if (selectedVdkcInfoList == null || selectedVdkcInfoList.size() <= 0) {
                SJctrLogUty.error(SJctrCreateHaPairsDC.class.getSimpleName(), "checkHaCtgRegulation", "VDKC Info List is Invalid.");
                throw SJctrHaUtility.createRemoteReplicationException(107001);
            }
            if (this.isMixedVirtualStorageMachine(selectedVdkcInfoList)) {
                throw SJctrHaUtility.createRemoteReplicationException(206252);
            }
            SJctrHaCtgInfo ctgInfo = this.allCtgInfoList.get(selectedCtgId);
            if (ctgInfo.getUsage() == 1) {
                SJmoHUVMVirtualDkc VDkcInfoForCtg = ctgInfo.getVirtualDkc();
                if (VDkcInfoForCtg != null) {
                    if (VDkcInfoForCtg.getIVboxId() != selectedVdkcInfoList.get(0).getIVboxId()) {
                        throw SJctrHaUtility.createRemoteReplicationException(206253);
                    }
                } else {
                    SJctrLogUty.warn(SJctrCreateHaPairsDC.class.getSimpleName(), "checkHaCtgRegulation", "VDKC Info = null. CTG ID = " + selectedCtgId);
                }
            }
            if (selectedLdevsNum + ctgInfo.getNumOfPairs() > 8192) {
                throw SJctrHaUtility.createRemoteReplicationException(206254);
            }
        }
    }

    private boolean isMatchedCtgInfo(SJctrHaCtgInfo haCtgInfo, int mirrorId, int quorumDiskId, int pairPosition) {
        boolean isMatched = false;
        if (haCtgInfo.getMirrorId() == mirrorId && haCtgInfo.getQuorumDiskId() == quorumDiskId && haCtgInfo.getLocalPairPosition() == pairPosition && this.initialNumberOfPairsInCtg.get(haCtgInfo.getCtgId()) < 8192) {
            isMatched = true;
        }
        return isMatched;
    }

    private boolean isMixedVirtualStorageMachine(List<SJmoHUVMVirtualDkc> vBoxIndexList) {
        boolean isMixed = false;
        if (vBoxIndexList.size() > 0) {
            SJmoHUVMVirtualDkc firstDkcInfo = vBoxIndexList.get(0);
            for (int index = 0; index < vBoxIndexList.size() - 1; ++index) {
                SJmoHUVMVirtualDkc nextDkcInfo = vBoxIndexList.get(index + 1);
                if (firstDkcInfo.getIVboxId() == nextDkcInfo.getIVboxId()) continue;
                isMixed = true;
                break;
            }
        }
        return isMixed;
    }

    private void createHaCtgInfoList() {
        this.allCtgInfoList = SJctrHaUtility.getHaCtgInfoList(this.currentHaPairVolInfoList, SJctrHaUtility.getSJmoHUVMVirtualLdev(this), SJctrHaUtility.getSJmoHUVMVirtualDkc(this));
        for (SJctrHaCtgInfo ctgInfo : this.allCtgInfoList) {
            this.initialNumberOfPairsInCtg.add(ctgInfo.getNumOfPairs());
        }
    }

    public static enum CREATE_PAIRS_MSG implements SJctrNotifyState
    {
        SELECT_REMOTE_SYSTEM_MODEL_SN,
        SELECT_SELECTION_OBJECT,
        SELECT_LU_SELECTION_PORT_ID,
        SELECT_LU_SELECTION_HOST_GROUP_NAME,
        SELECT_SVOL_SELECTION_SEL_TYPE,
        SELECT_ADD,
        SELECT_CHANGE_SETTINGS,
        SELECT_REMOVE,
        SELECT_MIRROR_ID,
        SELECT_QUORUM_DISK_ID;

    }
}

