/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.deletemirrors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.comparator.SJctrUniversalReplicatorPairInfoComparator;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.topwindow.replication.remote.urpairs.SJctrRemoteReplicationUrPairsTopTableModel;
import sanproject.sn2.controller.wizard.replication.remote.deletemirrors.SJctrDeleteMirrorsSubWizard;
import sanproject.sn2.model.data.replication.SJmoMirrorIndex;

public class SJctrItemSelectListenerDeleteMirrors
implements SJctrItemSelectListener {
    @Override
    public void selectChanged(SJctrItemSelectEvent<?> event) {
        if (event.isSelect()) {
            SJctrDataController dc = event.getSource().getDataController();
            ArrayList<Object> param = new ArrayList();
            int dispId = dc.getDisplayId();
            if (dispId == 13314) {
                param = this.makeParamFromPairs(dc);
            } else if (dispId == 13315 || dispId == 13571) {
                param = this.makeParamFromMirrors(dc);
            } else {
                SJctrUserController uc = dc.getOwner();
                uc.getLogUty().putlog("selectChanged", "Invalid Display ID.");
                SJctrError err = new SJctrError(210, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            event.getSource().fireMessageEvent(SJctrDataController.NOTIFY_STATE.MAKE_WIZARD, param);
        }
    }

    private ArrayList<Object> makeParamFromPairs(SJctrDataController dc) {
        SJctrUserController uc = dc.getOwner();
        SJctrRemoteReplicationUrPairsTopTableModel pairsTopTable = (SJctrRemoteReplicationUrPairsTopTableModel)dc.getDataObjectModel("COM_TABLE");
        if (pairsTopTable == null) {
            uc.getLogUty().putlog("makeParamFromPairs", "SJctrRemoteReplicationUrPairsTopTableModel is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        List<Object> selectedPairsList = pairsTopTable.getSelectedRowData();
        if (selectedPairsList == null || selectedPairsList.size() == 0) {
            uc.getLogUty().putlog("makeParamFromPairs", "Selected pairs table data is invalid.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        List<SJmoMirrorIndex> MirrorList = SJctrRemoteReplicationUtility.getMirrorsListFromPair(selectedPairsList);
        List<Object> pairsList = selectedPairsList;
        ArrayList<Object> param = new ArrayList<Object>();
        HashMap<String, List<Object>> paramMap = new HashMap<String, List<Object>>();
        Collections.sort(MirrorList);
        Collections.sort(pairsList, new SJctrUniversalReplicatorPairInfoComparator());
        paramMap.put("KEY_SELECTED_MIRROR", MirrorList);
        paramMap.put("KEY_SELECTED_REMOTE_VOL", pairsList);
        param.add(SJctrDeleteMirrorsSubWizard.class);
        param.add(paramMap);
        return param;
    }

    private ArrayList<Object> makeParamFromMirrors(SJctrDataController dc) {
        SJctrUserController uc = dc.getOwner();
        SJctrTableDataModel mirrorsTable = (SJctrTableDataModel)dc.getDataObjectModel("COM_TABLE");
        if (mirrorsTable == null) {
            uc.getLogUty().putlog("makeParamFromMirrors", "SJctrTableDataModel is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        List<Object> selectedMirrorsList = mirrorsTable.getSelectedRowData();
        if (selectedMirrorsList == null || selectedMirrorsList.size() == 0) {
            uc.getLogUty().putlog("makeParamFromMirrors", "Selected Mirror table data is invalid.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        boolean attribute = SJctrRemoteReplicationUtility.checkMirrorAttributeMaster(selectedMirrorsList, false);
        if (!attribute) {
            uc.getLogUty().putlog("makeParamFromMirrors", "Mirror Attribute is invalid.");
            SJctrError err = new SJctrError(210, 22, 206007);
            SJcException exp = err.createException();
            throw exp;
        }
        boolean st = SJctrRemoteReplicationUtility.checkDeleteMirrorStatus(selectedMirrorsList);
        if (!st) {
            uc.getLogUty().putlog("makeParamFromMirrors", "Mirror Status is invalid.");
            SJctrError err = new SJctrError(210, 22, 206016);
            SJcException exp = err.createException();
            throw exp;
        }
        ArrayList<Object> param = new ArrayList<Object>();
        HashMap<String, List<Object>> paramMap = new HashMap<String, List<Object>>();
        Collections.sort(selectedMirrorsList);
        paramMap.put("KEY_SELECTED_MIRROR", selectedMirrorsList);
        param.add(SJctrDeleteMirrorsSubWizard.class);
        param.add(paramMap);
        return param;
    }
}

