/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.initializeexctgs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.replication.remote.initializeexctgs.SJctrInitializeExctgsSubWizard;

public class SJctrItemSelectListenerInitializeExctgs
implements SJctrItemSelectListener {
    @Override
    public void selectChanged(SJctrItemSelectEvent<?> event) {
        if (!event.isSelect()) {
            return;
        }
        SJctrDataController dc = event.getSource().getDataController();
        SJctrUserController uc = dc.getOwner();
        SJctrTableDataModel table = (SJctrTableDataModel)dc.getDataObjectModel("COM_TABLE");
        if (table == null) {
            uc.getLogUty().putlog("selectChanged", "SJctrTableDataModel is null.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        List<Object> selectedExctgList = table.getSelectedRowData();
        if (selectedExctgList == null || selectedExctgList.size() == 0) {
            uc.getLogUty().putlog("selectChanged", "Selected Journal table data is invalid.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(107001);
        }
        boolean exctgused = SJctrRemoteReplicationUtility.isExctgUsed(selectedExctgList);
        if (!exctgused) {
            dc.getLogUty().putlog("selectChanged", "Selected EXCTG is not used.");
            throw SJctrRemoteReplicationUtility.createRemoteReplicationException(206127);
        }
        ArrayList<Object> param = new ArrayList<Object>();
        HashMap<String, List<Object>> paramMap = new HashMap<String, List<Object>>();
        Collections.sort(selectedExctgList);
        paramMap.put("KEY_SELECTED_EXCTG", selectedExctgList);
        param.add(SJctrInitializeExctgsSubWizard.class);
        param.add(paramMap);
        event.getSource().fireMessageEvent(SJctrDataController.NOTIFY_STATE.MAKE_WIZARD, param);
    }
}

