/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.viewpairprops;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.serverux.dataimpl.RJiHAget1PairSummary;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrHaUtility;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.wizard.replication.remote.viewpairsyncrate.SJctrGetRJiHaPair;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualDkc;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualLdev;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetQuorumDiskInfo;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualDkc;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualLdev;
import sanproject.sn2.model.data.huvm.SJmoHUVMvboxIndex;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoHAPairVolInfo;
import sanproject.sn2.model.data.replication.remote.SJmoQuorumDiskInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrHaViewPairPropertiesDetailDataModel
extends SJctrSimpleDataModel {
    private List<SJmoHUVMVirtualLdev> virtualLdevList = null;
    private List<SJmoHUVMVirtualDkc> virtualDkcList = null;
    private List<SJmoQuorumDiskInfo> quorumDiskList = null;
    private List<RJiHAget1PairSummary> rmiPairList = null;
    private List<SJmoLdevDetail> ldevDetailList = null;

    @Override
    protected void makeModelDirect() {
        super.makeModelDirect();
        SJmoGetKind_IF kind = new SJmoGetHUVMVirtualLdev();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetHUVMVirtualDkc();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetQuorumDiskInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        this.directList.add(new SJctrGetDirectWrapper(direct));
    }

    @Override
    public void makeDataObject() {
        this.virtualLdevList = this.getDataController().getProxy().getCache(SJmoGetHUVMVirtualLdev.class);
        if (this.virtualLdevList == null) {
            this.logUty.putlog("makeDataObject", "Data of HUVM Virtual LDEV is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (this.virtualLdevList.size() == 0) {
            this.logUty.putlog("makeDataObject", "Size of HUVM Virtual LDEV data list is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        this.virtualDkcList = this.getDataController().getProxy().getCache(SJmoGetHUVMVirtualDkc.class);
        if (this.virtualDkcList == null) {
            this.logUty.putlog("makeDataObject", "Data of HUVM Virtual DKC is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (this.virtualDkcList.size() == 0) {
            this.logUty.putlog("makeDataObject", "Size of HUVM Virtual DKC data list is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        this.quorumDiskList = this.getDataController().getProxy().getCache(SJmoGetQuorumDiskInfo.class);
        if (this.quorumDiskList == null) {
            this.logUty.putlog("makeDataObject", "Data of Quorum Disk is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (this.quorumDiskList.size() == 0) {
            this.logUty.putlog("makeDataObject", "Size of Quorum Disk list is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        this.ldevDetailList = this.getDataController().getProxy().getCache(SJmoGetLdevDetail.class);
        if (this.ldevDetailList == null) {
            this.logUty.putlog("makeDataObject", "Data of Ldev Detail is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (this.ldevDetailList.size() == 0) {
            this.logUty.putlog("makeDataObject", "Size of Ldev Detail list is zero.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        this.rmiPairList = this.getDataController().getProxy().getCache(SJctrGetRJiHaPair.class);
    }

    public void makeSummary(SJmoHAPairVolInfo pairInfo) {
        if (pairInfo == null) {
            this.logUty.putlog("makeSummary", "Pair Informaiton is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        RJiHAget1PairSummary rmiPair = SJctrHaUtility.getRmiPairRelatedModelPair(this.rmiPairList, pairInfo);
        if (rmiPair == null) {
            this.logUty.putlog("makeSummary", "RMI Pair Information is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrComUtility comUty = this.getComUtility();
        SJctrHaUtility haUty = comUty.getHaUtility();
        SJctrLdevUtility ldevUty = comUty.getLdevUtility();
        SJctrRsgUtility rsgUty = comUty.getRsgUtility();
        String statusStr = haUty.getHaStatusStringWithSplitType(pairInfo);
        ((SJctrDataObject)this.getManageData()).setData("COM_STATUS", statusStr);
        String failureFactorStr = haUty.getFailureFactorString(pairInfo);
        ((SJctrDataObject)this.getManageData()).setData("COM_FAILURE_FACTOR", failureFactorStr);
        String quorumDiskIDStr = haUty.getQuorumDiskIdLdevIDString(pairInfo, this.quorumDiskList, ldevUty);
        ((SJctrDataObject)this.getManageData()).setData("COM_QUORUM_DISK_ID_LDEV_ID", quorumDiskIDStr);
        String ctgIdStr = haUty.getCtgIdString(pairInfo);
        ((SJctrDataObject)this.getManageData()).setData("COM_CTG_ID", ctgIdStr);
        String ctgStatusStr = haUty.getCtgStatusString(pairInfo);
        ((SJctrDataObject)this.getManageData()).setData("COM_CTG_STATUS", ctgStatusStr);
        String copyPaceStr = haUty.getCopyPaceStringWithUnit(pairInfo, comUty);
        ((SJctrDataObject)this.getManageData()).setData("COM_COPY_PACE", copyPaceStr);
        String pairedTimeStr = SJctrHaUtility.convertRmiTime(rmiPair.getCreatePairAt());
        ((SJctrDataObject)this.getManageData()).setData("COM_PAIRED_TIME", pairedTimeStr);
        String updateTimeStr = SJctrHaUtility.convertRmiTime(rmiPair.getStatusChangeAt());
        ((SJctrDataObject)this.getManageData()).setData("COM_LAST_UPDATE_TIME", updateTimeStr);
        String copyTimeStr = haUty.getPairCopyTimeString(rmiPair);
        ((SJctrDataObject)this.getManageData()).setData("COM_PAIR_COPY_TIME", copyTimeStr);
        String localIoModeStr = haUty.getLocalIoModeString(pairInfo);
        ((SJctrDataObject)this.getManageData()).setData("COM_LOCAL_VOLUME_IO_MODE", localIoModeStr);
        SJmoReplicationPairVolInfo localVol = SJctrHaUtility.getLocalVolume(pairInfo);
        SJmoLdevDetail ldevDetail = null;
        if (localVol == null) {
            this.logUty.putlog("refDataModel", "Information of SJmoReplicationPairVolInfo is null.");
        } else {
            int index = Collections.binarySearch(this.ldevDetailList, localVol);
            if (index >= 0) {
                ldevDetail = this.ldevDetailList.get(index);
            }
        }
        String localAluaModeStr = haUty.getAluaModeString(ldevDetail);
        ((SJctrDataObject)this.getManageData()).setData("COM_LOCAL_VOLUME_ALUA_MODE", localAluaModeStr);
        SJmoHUVMVirtualLdev virtualLdevInfo = this.getVirtualLdevInfo(pairInfo);
        SJmoHUVMVirtualDkc virtualDkcInfo = this.getVirtualDKCInfo(virtualLdevInfo);
        SJmoQuorumDiskInfo quorumInfo = this.getQuorumInfo(pairInfo);
        String accessModeblkQDStr = haUty.getAccessModeBlkQDString(pairInfo, quorumInfo);
        ((SJctrDataObject)this.getManageData()).setData("COM_ACCESS_MODE_BLK_QD", accessModeblkQDStr);
        String virtualModelSNStr = haUty.getVirtualModelSerialString(virtualDkcInfo, rsgUty);
        ((SJctrDataObject)this.getManageData()).setData("COM_VIRTUAL_STORAGE_MODEL_SN", virtualModelSNStr);
        String virtualLdevIDStr = haUty.getVirtualLdevIdString(virtualLdevInfo, rsgUty, comUty);
        ((SJctrDataObject)this.getManageData()).setData("COM_VIRTUAL_STORAGE_LDEV_ID", virtualLdevIDStr);
        String virtualDeviceNameStr = haUty.getVirtualDeviceNameString(virtualLdevInfo, rsgUty, ldevUty);
        ((SJctrDataObject)this.getManageData()).setData("COM_VIRTUAL_STORAGE_DEVICE_NAME", virtualDeviceNameStr);
        String virtualSSIDStr = haUty.getVirtualSSIDString(virtualLdevInfo, rsgUty);
        ((SJctrDataObject)this.getManageData()).setData("COM_VIRTUAL_STORAGE_SSID", virtualSSIDStr);
    }

    private SJmoHUVMVirtualLdev getVirtualLdevInfo(SJmoHAPairVolInfo haPairInfo) {
        SJmoHUVMVirtualLdev ret = null;
        if (null != haPairInfo) {
            if (this.virtualLdevList == null || this.virtualLdevList.size() == 0) {
                return ret;
            }
            SJmoReplicationPairVolInfo localVol = SJctrHaUtility.getLocalVolume(haPairInfo);
            Collections.sort(this.virtualLdevList);
            int index = Collections.binarySearch(this.virtualLdevList, localVol);
            if (index >= 0) {
                ret = this.virtualLdevList.get(index);
            }
        }
        return ret;
    }

    private SJmoHUVMVirtualDkc getVirtualDKCInfo(SJmoHUVMVirtualLdev virtualLdevInfo) {
        SJmoHUVMVirtualDkc ret = null;
        if (null != virtualLdevInfo) {
            if (this.virtualDkcList == null || this.virtualDkcList.size() == 0) {
                return ret;
            }
            SJmoHUVMvboxIndex vBoxIndex = virtualLdevInfo.getVBoxIndex();
            Collections.sort(this.virtualDkcList);
            int index = Collections.binarySearch(this.virtualDkcList, vBoxIndex);
            if (index >= 0) {
                ret = this.virtualDkcList.get(index);
            }
        }
        return ret;
    }

    private SJmoQuorumDiskInfo getQuorumInfo(SJmoHAPairVolInfo pairInfo) {
        SJmoQuorumDiskInfo ret = null;
        if (pairInfo != null) {
            if (this.quorumDiskList == null || this.quorumDiskList.size() == 0) {
                return ret;
            }
            ret = SJctrHaUtility.getQuorumInfoFromHaPairInfo(pairInfo, this.quorumDiskList);
        }
        return ret;
    }
}

