/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.viewhistories.remote;

import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import sanproject.serverux.dataimpl.HURgetHistory1Log;
import sanproject.serverux.dataimpl.HURgetHistoryLog;
import sanproject.serverux.dataimpl.HURgetHistoryProgress;
import sanproject.serverux.dataimpl.RJiHAgetHistory;
import sanproject.serverux.dataimpl.RJiHAgetHistoryLog;
import sanproject.serverux.dataimpl.RJiHAgetHistory_IN;
import sanproject.serverux.dataimpl.RJiHAgetHistory_OUT;
import sanproject.serverux.dataimpl.RJiInputHAHistoryParam;
import sanproject.serverux.dataimpl.RMCPHistory1Log;
import sanproject.serverux.dataimpl.RMCPgetHistoryLog;
import sanproject.serverux.dataimpl.RMCPgetHistoryProgress;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrHaUtility;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrObjectSetListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.replication.com.SJctrGetHAgetHistory;
import sanproject.sn2.controller.wizard.replication.com.SJctrGetHURgetHistoryLog;
import sanproject.sn2.controller.wizard.replication.com.SJctrGetHURgetHistoryProgress;
import sanproject.sn2.controller.wizard.replication.com.SJctrGetRMCPgetHistoryLog;
import sanproject.sn2.controller.wizard.replication.com.SJctrGetRMCPgetHistoryProgress;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcMessageEventListener;
import sanproject.sn2.controller.wizard.replication.viewhistories.SJctrHistoriesPagingComponentDataModel;
import sanproject.sn2.controller.wizard.replication.viewhistories.remote.SJctrRemoteHistoriesBaseInfo;
import sanproject.sn2.controller.wizard.replication.viewhistories.remote.SJctrRemoteHistoriesBaseTableDataModel;
import sanproject.sn2.controller.wizard.replication.viewhistories.remote.SJctrRemoteHistoriesComInfoDataModel;
import sanproject.sn2.controller.wizard.replication.viewhistories.remote.SJctrRemoteHistoriesHaInfo;
import sanproject.sn2.controller.wizard.replication.viewhistories.remote.SJctrRemoteHistoriesHaTableDataModel;
import sanproject.sn2.controller.wizard.replication.viewhistories.remote.SJctrRemoteHistoriesTcInfo;
import sanproject.sn2.controller.wizard.replication.viewhistories.remote.SJctrRemoteHistoriesTcTableDataModel;
import sanproject.sn2.controller.wizard.replication.viewhistories.remote.SJctrRemoteHistoriesUrInfo;
import sanproject.sn2.controller.wizard.replication.viewhistories.remote.SJctrRemoteHistoriesUrTableDataModel;
import sanproject.sn2.controller.wizard.replication.viewhistories.remote.SJctrRemoteHistoriesUrmfTableDataModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrRemoteHistoriesDC
extends SJctrDialogDataController {
    private static final int DISP_ID = 34664531;
    private static final String DISP_TITLE = "HISTORIES";
    private static final String KEY_HISTORIES_INFO = "COM_HISTORIES_INFO";
    private static final String KEY_COPYTYPE_COMBO = "COM_COPYTYPE_COMBO";
    private static final String KEY_PAGING_COMPO = "COM_PAGING_COMPO";
    private static final String KEY_HISTORIES_TC_TABLE = "COM_HISTORIES_TC_TABLE";
    private static final String KEY_HISTORIES_TCMF_TABLE = "COM_HISTORIES_TCMF_TABLE";
    private static final String KEY_HISTORIES_UR_TABLE = "COM_HISTORIES_UR_TABLE";
    private static final String KEY_HISTORIES_URMF_TABLE = "COM_HISTORIES_URMF_TABLE";
    private static final String KEY_HISTORIES_HA_TABLE = "COM_HISTORIES_HA_TABLE";
    private static final String KEY_HISTORIES_DUMMY_TABLE = "COM_HISTORIES_DUMMY_TABLE";
    private static final String KEY_EXPORT = "COM_EXPORT";
    private static final String KEY_ENABLE_RESOURCE_LDEV = "COM_ENABLE_RESOURCE_LDEV";
    private static final String COPYTYPE_NAME_BLANK = "NAME_BLANK";
    private static final int GET_HISTO_INFO_DEFAULT_PAGE = 1;
    private static final int GET_HISTO_INFO_MAX_TRYCOUNT = 60;
    private static final int GET_HISTO_INFO_RETRY_WAITTIME = 3000;

    public SJctrRemoteHistoriesDC() throws SJcException {
        super(34664531);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_HISTORIES_INFO, new SJctrRemoteHistoriesComInfoDataModel());
        SJctrComboBoxDataModel copyTypePullDown = new SJctrComboBoxDataModel();
        copyTypePullDown.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrRemoteHistoriesDC.this.fireMessageEvent(VIEW_REMOTE_HISTORIES_MSG.CHANGE_COPYTYPE);
                }
            }
        });
        this.addDataObjectModel(KEY_COPYTYPE_COMBO, copyTypePullDown);
        SJctrHistoriesPagingComponentDataModel pagingComp = new SJctrHistoriesPagingComponentDataModel();
        pagingComp.addObjectSetListener(new SJctrObjectSetListener(){

            @Override
            public void doAction(Object setObject) {
                SJctrRemoteHistoriesDC.this.fireMessageEvent(SJctrHistoriesPagingComponentDataModel.HISTORIES_PAGINGCOMP_MSG.PAGING_CHANGED);
            }
        });
        this.addDataObjectModel(KEY_PAGING_COMPO, pagingComp);
        SJctrRemoteHistoriesBaseTableDataModel dmytbl = new SJctrRemoteHistoriesBaseTableDataModel("");
        dmytbl.setPaging(false);
        this.addDataObjectModel(KEY_HISTORIES_DUMMY_TABLE, dmytbl);
        SJctrRemoteHistoriesTcTableDataModel tcTable = new SJctrRemoteHistoriesTcTableDataModel("TC_HISTORIES");
        tcTable.setPaging(false);
        this.addDataObjectModel(KEY_HISTORIES_TC_TABLE, tcTable);
        SJctrRemoteHistoriesTcTableDataModel tcmfTable = new SJctrRemoteHistoriesTcTableDataModel("TC_MF_HISTORIES");
        tcmfTable.setPaging(false);
        this.addDataObjectModel(KEY_HISTORIES_TCMF_TABLE, tcmfTable);
        SJctrRemoteHistoriesUrTableDataModel urTable = new SJctrRemoteHistoriesUrTableDataModel("UR_HISTORIES");
        urTable.setPaging(false);
        this.addDataObjectModel(KEY_HISTORIES_UR_TABLE, urTable);
        SJctrRemoteHistoriesUrmfTableDataModel urmfTable = new SJctrRemoteHistoriesUrmfTableDataModel("UR_MF_HISTORIES");
        urmfTable.setPaging(false);
        this.addDataObjectModel(KEY_HISTORIES_URMF_TABLE, urmfTable);
        SJctrRemoteHistoriesHaTableDataModel haTable = new SJctrRemoteHistoriesHaTableDataModel("HA_HISTORIES");
        haTable.setPaging(false);
        this.addDataObjectModel(KEY_HISTORIES_HA_TABLE, haTable);
        SJctrButtonDataModel exportButton = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_EXPORT, exportButton);
        exportButton.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrRemoteHistoriesDC.this.fireMessageEvent(VIEW_REMOTE_HISTORIES_MSG.SELECT_EXPORT);
            }
        });
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_CLOSE));
    }

    private void initListener() {
        this.addMessageEventListener(VIEW_REMOTE_HISTORIES_MSG.CHANGE_COPYTYPE, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrRemoteHistoriesDC.this.copyTypeChangedAction(event, dstModel);
            }
        });
        this.addMessageEventListener(SJctrHistoriesPagingComponentDataModel.HISTORIES_PAGINGCOMP_MSG.PAGING_CHANGED, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrRemoteHistoriesDC.this.pageChangedAction(event, dstModel);
            }
        });
        this.addMessageEventListener(VIEW_REMOTE_HISTORIES_MSG.SELECT_EXPORT, new SJctrRcMessageEventListener(){

            @Override
            public void messageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrRemoteHistoriesDC.this.makeExport(event, dstModel);
            }
        });
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetRSGgetAllRsgs kind = new SJmoGetRSGgetAllRsgs();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public boolean checkConstructData() {
        boolean ret = true;
        try {
            SJctrResourceGroupUtility rsgUty = new SJctrResourceGroupUtility(this.getOwner(), SJctrReplicationUtility.getSJmoRSGgetAllRsgs(this).get(0));
            SJctrRemoteHistoriesComInfoDataModel histriesInfo = (SJctrRemoteHistoriesComInfoDataModel)this.getDataObjectModel(KEY_HISTORIES_INFO);
            histriesInfo.setLastUpdateTime("");
            histriesInfo.setHistoriesUpdate(false);
            SJctrComboBoxDataModel copyTypeCombo = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_COPYTYPE_COMBO);
            copyTypeCombo.addItem(COPYTYPE_NAME_BLANK, "");
            copyTypeCombo.addItem("TC_COPY", this.getComUtility().getGuidance("TC_COPY"));
            if (!SJctrDataController.isHM()) {
                copyTypeCombo.addItem("TC_MF_COPY", this.getComUtility().getGuidance("TC_MF_COPY"));
            }
            copyTypeCombo.addItem("UR_COPY", this.getComUtility().getGuidance("UR_COPY"));
            if (!SJctrDataController.isHM()) {
                copyTypeCombo.addItem("UR_MF_COPY", this.getComUtility().getGuidance("UR_MF_COPY"));
            }
            copyTypeCombo.addItem("HA_COPY", this.getComUtility().getGuidance("HA_COPY"));
            copyTypeCombo.setSelection("");
            List<SJmoLdevIndex> resourceLdevs = SJctrReplicationUtility.getEnableResourceLdevList(rsgUty);
            this.getProxy().putCache(KEY_ENABLE_RESOURCE_LDEV, resourceLdevs);
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107002);
        }
        return ret;
    }

    private void copyTypeChangedAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        try {
            SJctrComboBoxDataModel copyTypeCombo = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_COPYTYPE_COMBO);
            this.getHistoriesInfoAction(true, 1, false);
            copyTypeCombo.removeItem(COPYTYPE_NAME_BLANK);
            this.setDirtyAll();
        }
        catch (SJcException e) {
            throw SJctrRemoteReplicationUtility.convRReplicaLogicalErr(e, 107004);
        }
    }

    private void pageChangedAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrHistoriesPagingComponentDataModel pagingComp = (SJctrHistoriesPagingComponentDataModel)this.getDataObjectModel(KEY_PAGING_COMPO);
        this.getHistoriesInfoAction(false, pagingComp.getCurrentPage(), true);
        this.setDirtyAll();
    }

    private void getHistoriesInfoAction(boolean isRefresh, int page, boolean isUpdateCheck) {
        SJctrRemoteHistoriesComInfoDataModel histriesInfo = (SJctrRemoteHistoriesComInfoDataModel)this.getDataObjectModel(KEY_HISTORIES_INFO);
        histriesInfo.setHistoriesUpdate(false);
        SJctrComboBoxDataModel copyTypeCombo = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_COPYTYPE_COMBO);
        String copyTypeString = copyTypeCombo.getSelection();
        if (copyTypeString == null) {
            this.logUty.putlog("getHistoriesInfoAction", "Selected CopyType is null");
            return;
        }
        if (copyTypeString.equals("TC_COPY")) {
            RMCPgetHistoryLog histLogInfo = this.getTcHistoriesInfo(1, isRefresh, page, isUpdateCheck);
            this.setTcTableInfo(histLogInfo, KEY_HISTORIES_TC_TABLE);
        } else if (copyTypeString.equals("TC_MF_COPY")) {
            RMCPgetHistoryLog histLogInfo = this.getTcHistoriesInfo(0, isRefresh, page, isUpdateCheck);
            this.setTcTableInfo(histLogInfo, KEY_HISTORIES_TCMF_TABLE);
        } else if (copyTypeString.equals("UR_COPY")) {
            HURgetHistoryLog histLogInfo = this.getUrHistoriesInfo(1, isRefresh, page, isUpdateCheck);
            this.setUrTableInfo(histLogInfo, KEY_HISTORIES_UR_TABLE);
        } else if (copyTypeString.equals("UR_MF_COPY")) {
            HURgetHistoryLog histLogInfo = this.getUrHistoriesInfo(0, isRefresh, page, isUpdateCheck);
            this.setUrTableInfo(histLogInfo, KEY_HISTORIES_URMF_TABLE);
        } else if (copyTypeString.equals("HA_COPY")) {
            RJiHAgetHistory histLogInfo = this.getHaHistoriesInfo(1, isRefresh, page, isUpdateCheck);
            this.setHaTableInfo(histLogInfo, KEY_HISTORIES_HA_TABLE);
        } else {
            this.logUty.putlog("getHistoriesInfoAction", "Selected CopyType is invalid");
            return;
        }
    }

    private void makeExport(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        SJctrComboBoxDataModel copyTypeCombo = (SJctrComboBoxDataModel)this.getDataObjectModel(KEY_COPYTYPE_COMBO);
        String copyType = copyTypeCombo.getSelection();
        SJctrRemoteHistoriesBaseTableDataModel outputTable = null;
        String tsvFileName = "";
        if (copyType != null) {
            if (copyType.equals("TC_COPY")) {
                outputTable = (SJctrRemoteHistoriesBaseTableDataModel)this.getDataObjectModel(KEY_HISTORIES_TC_TABLE);
                tsvFileName = this.getOutputFileName("TC_COPY", outputTable);
            } else if (copyType.equals("TC_MF_COPY")) {
                outputTable = (SJctrRemoteHistoriesBaseTableDataModel)this.getDataObjectModel(KEY_HISTORIES_TCMF_TABLE);
                tsvFileName = this.getOutputFileName("TC_MF_COPY", outputTable);
            } else if (copyType.equals("UR_COPY")) {
                outputTable = (SJctrRemoteHistoriesBaseTableDataModel)this.getDataObjectModel(KEY_HISTORIES_UR_TABLE);
                tsvFileName = this.getOutputFileName("UR_COPY", outputTable);
            } else if (copyType.equals("UR_MF_COPY")) {
                outputTable = (SJctrRemoteHistoriesBaseTableDataModel)this.getDataObjectModel(KEY_HISTORIES_URMF_TABLE);
                tsvFileName = this.getOutputFileName("UR_MF_COPY", outputTable);
            } else if (copyType.equals("HA_COPY")) {
                outputTable = (SJctrRemoteHistoriesBaseTableDataModel)this.getDataObjectModel(KEY_HISTORIES_HA_TABLE);
                tsvFileName = this.getOutputFileName("HA_COPY", outputTable);
            } else {
                this.logUty.putlog("makeExport", "Copy type is invalid. Copy Type = " + copyType);
            }
        }
        if (null == outputTable) {
            this.logUty.putlog("makeExport", "Oupput table is not exist.");
            SJctrError err = new SJctrError(210, 22, 107004);
            SJcException exp = err.createException();
            throw exp;
        }
        ArrayList<Object> param = new ArrayList<Object>();
        param.add(outputTable);
        param.add(tsvFileName);
        this.fireMessageEvent(SJctrDataController.NOTIFY_STATE.MAKE_EXPORT, param);
    }

    private String getOutputFileName(String copyTypeGuidKey, SJctrRemoteHistoriesBaseTableDataModel outputTable) {
        String workName = this.getComUtility().getGuidance(DISP_TITLE) + "_";
        workName = workName + this.getComUtility().getGuidance(copyTypeGuidKey);
        if (!SJctrRemoteHistoriesDC.isHM()) {
            workName = workName + SJctrComUtility.toPaddingZeroString(outputTable.getCurrentPageNum(), 2);
        }
        workName = workName + "Export";
        String tsvFileName = SJctrComUtility.getTsvFileName(workName);
        return tsvFileName;
    }

    private boolean isEnableHistories(List<SJmoLdevIndex> enableResources, SJctrRemoteHistoriesBaseInfo histInfo) {
        boolean ret = false;
        SJmoLdevIndex localLdev = histInfo.getLocalLdevIndex();
        if (Collections.binarySearch(enableResources, (Object)localLdev) >= 0) {
            ret = true;
        }
        return ret;
    }

    private void updateHistInfo(String lastUpdateTime, int lastPageNum) {
        SJctrRemoteHistoriesComInfoDataModel histInfo = (SJctrRemoteHistoriesComInfoDataModel)this.getDataObjectModel(KEY_HISTORIES_INFO);
        histInfo.setLastUpdateTime(lastUpdateTime);
        SJctrHistoriesPagingComponentDataModel pagingComp = (SJctrHistoriesPagingComponentDataModel)this.getDataObjectModel(KEY_PAGING_COMPO);
        pagingComp.setCurrentPage(1);
        pagingComp.setLastPageLabel(lastPageNum);
    }

    private int getLastPageNumber(int numOfAllLogs, int maxCount) {
        int ret = 1;
        if (numOfAllLogs > 0) {
            ret = (numOfAllLogs + (maxCount - 1)) / maxCount;
        }
        return ret;
    }

    private RMCPgetHistoryLog getTcHistoriesInfo(int copyType, boolean logRefresh, int page, boolean upDateCheck) {
        RMCPgetHistoryLog histLogInfo = null;
        if (SJctrDataController.isHM()) {
            histLogInfo = this.getTcHistoriesLog(copyType, page);
        } else {
            boolean isRefreshing = true;
            try {
                if (logRefresh) {
                    this.getTcHistoriesProgress(copyType, true);
                    Thread.sleep(3000L);
                }
                for (int count = 0; count <= 60; ++count) {
                    RMCPgetHistoryProgress histProgInfo = this.getTcHistoriesProgress(copyType, false);
                    int histoProgStatus = histProgInfo.Status;
                    if (histoProgStatus == 2) {
                        isRefreshing = false;
                        break;
                    }
                    if (histoProgStatus != 1) {
                        this.logUty.putlog("getTcHistoriesInfo", "The error occurred at the time of history information acquisition.");
                        SJctrError err = new SJctrError(60, 5, histoProgStatus);
                        SJcException exp = err.createException();
                        throw exp;
                    }
                    Thread.sleep(3000L);
                }
            }
            catch (InterruptedException ie) {
                this.logUty.putlog("getTcHistoriesInfo", ie.getMessage());
            }
            if (isRefreshing) {
                this.logUty.putlog("getTcHistoriesInfo", "Timeout occurred at the time of history information acquisition.");
                SJctrError err = new SJctrError(210, 22, 206066);
                SJcException exp = err.createException();
                throw exp;
            }
            histLogInfo = this.getTcHistoriesLog(copyType, page);
            SJctrRemoteHistoriesComInfoDataModel histInfo = (SJctrRemoteHistoriesComInfoDataModel)this.getDataObjectModel(KEY_HISTORIES_INFO);
            if (logRefresh) {
                this.updateHistInfo(histLogInfo);
            } else if (upDateCheck && !histInfo.getLastUpdateTime().equals(histLogInfo.TimeStump)) {
                histInfo.setHistoriesUpdate(true);
                histLogInfo = this.getTcHistoriesInfo(copyType, false, 1, false);
                this.updateHistInfo(histLogInfo);
            }
        }
        return histLogInfo;
    }

    private RMCPgetHistoryProgress getTcHistoriesProgress(int copyType, boolean refreshFlg) {
        int refresh = refreshFlg ? 1 : 0;
        this.logUty.putlog("getTcHistoriesProgress", "Kind Class = " + SJctrGetRMCPgetHistoryProgress.class.getSimpleName() + ", Copy Type = " + copyType + ", isRefresh = " + Boolean.toString(refreshFlg));
        SJctrGetRMCPgetHistoryProgress kind = new SJctrGetRMCPgetHistoryProgress(copyType, refresh);
        RMCPgetHistoryProgress histProgInfo = (RMCPgetHistoryProgress)SJctrRemoteReplicationUtility.getRmiObject(this, kind).getObjRmi();
        if (null == histProgInfo) {
            this.logUty.putlog("getTcHistoriesProgress", "RMCPgetHistoryProgress data is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return histProgInfo;
    }

    private RMCPgetHistoryLog getTcHistoriesLog(int copyType, int page) {
        int start = 65535 * (page - 1);
        int maxCount = 65535;
        if (SJctrRemoteHistoriesDC.isHM()) {
            start = -1;
            maxCount = 8192;
        }
        SJctrGetRMCPgetHistoryLog kind = new SJctrGetRMCPgetHistoryLog(copyType, start, maxCount);
        this.logUty.putlog("getTcHistoriesLog", "Kind Class = " + SJctrGetRMCPgetHistoryLog.class.getSimpleName() + ", Copy Type = " + copyType + ", Start = " + start + ", MaxCount = " + maxCount);
        RMCPgetHistoryLog histLogInfo = (RMCPgetHistoryLog)SJctrRemoteReplicationUtility.getRmiObject(this, kind).getObjRmi();
        if (null == histLogInfo) {
            this.logUty.putlog("getTcHistoriesLog", "RMCPgetHistoryLog is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return histLogInfo;
    }

    private void updateHistInfo(RMCPgetHistoryLog histLogInfo) {
        String lastUpdateTime = histLogInfo.TimeStump;
        int lastPageNum = this.getLastPageNumber(histLogInfo.NumOfAllLog, 65535);
        this.updateHistInfo(lastUpdateTime, lastPageNum);
    }

    private void setTcTableInfo(RMCPgetHistoryLog histLogInfo, String tableKey) {
        RMCPHistory1Log[] histLogArray = histLogInfo.History1Log;
        int numOfLogs = histLogInfo.NumOfGetLog;
        ArrayList<SJctrRemoteHistoriesTcInfo> histInfoList = new ArrayList<SJctrRemoteHistoriesTcInfo>(numOfLogs);
        List<SJmoLdevIndex> enableResourceList = this.getProxy().getCache(KEY_ENABLE_RESOURCE_LDEV);
        for (int index = 0; index < numOfLogs; ++index) {
            SJctrRemoteHistoriesTcInfo histInfo = new SJctrRemoteHistoriesTcInfo(histLogArray[index]);
            if (!this.isEnableHistories(enableResourceList, histInfo)) continue;
            histInfoList.add(histInfo);
        }
        SJctrRemoteHistoriesTcTableDataModel tcTable = (SJctrRemoteHistoriesTcTableDataModel)this.getDataObjectModel(tableKey);
        tcTable.setBasicDataList(histInfoList);
        SJctrHistoriesPagingComponentDataModel pagingComp = (SJctrHistoriesPagingComponentDataModel)this.getDataObjectModel(KEY_PAGING_COMPO);
        tcTable.setCurrentPageNum(pagingComp.getCurrentPage());
        tcTable.doRefresh();
    }

    private HURgetHistoryLog getUrHistoriesInfo(int copyType, boolean logRefresh, int page, boolean upDateCheck) {
        HURgetHistoryLog histLogInfo = null;
        if (SJctrDataController.isHM()) {
            histLogInfo = this.getUrHistoriesLog(copyType, page);
        } else {
            SJctrRemoteHistoriesComInfoDataModel histInfo;
            boolean isRefreshing = true;
            try {
                if (logRefresh) {
                    this.getUrHistoriesProgress(copyType, true);
                    Thread.sleep(3000L);
                }
                for (int count = 0; count <= 60; ++count) {
                    HURgetHistoryProgress histProgInfo = this.getUrHistoriesProgress(copyType, false);
                    int histoProgStatus = histProgInfo.Status;
                    if (histoProgStatus == 2) {
                        isRefreshing = false;
                        break;
                    }
                    if (histoProgStatus != 1) {
                        this.logUty.putlog("getUrHistoriesInfo", "The error occurred at the time of history information acquisition.");
                        SJctrError err = new SJctrError(65, 5, histoProgStatus);
                        SJcException exp = err.createException();
                        throw exp;
                    }
                    Thread.sleep(3000L);
                }
            }
            catch (InterruptedException ie) {
                this.logUty.putlog("getUrHistoriesInfo", ie.getMessage());
            }
            if (isRefreshing) {
                this.logUty.putlog("getUrHistoriesInfo", "Timeout occurred at the time of history information acquisition.");
                SJctrError err = new SJctrError(210, 22, 206066);
                SJcException exp = err.createException();
                throw exp;
            }
            histLogInfo = this.getUrHistoriesLog(copyType, page);
            if (logRefresh) {
                this.updateHistInfo(histLogInfo);
            } else if (upDateCheck && !(histInfo = (SJctrRemoteHistoriesComInfoDataModel)this.getDataObjectModel(KEY_HISTORIES_INFO)).getLastUpdateTime().equals(histLogInfo.timeStump)) {
                histInfo.setHistoriesUpdate(true);
                histLogInfo = this.getUrHistoriesInfo(copyType, false, 1, false);
                this.updateHistInfo(histLogInfo);
            }
        }
        return histLogInfo;
    }

    private HURgetHistoryProgress getUrHistoriesProgress(int copyType, boolean refreshFlg) {
        int refresh = refreshFlg ? 1 : 0;
        this.logUty.putlog("getUrHistoriesProgress", "Kind Class = " + SJctrGetHURgetHistoryProgress.class.getSimpleName() + ", Copy Type = " + copyType + ", isRefresh = " + Boolean.toString(refreshFlg));
        SJctrGetHURgetHistoryProgress kind = new SJctrGetHURgetHistoryProgress(copyType, refresh);
        HURgetHistoryProgress histProgInfo = (HURgetHistoryProgress)SJctrRemoteReplicationUtility.getRmiObject(this, kind).getObjRmi();
        if (null == histProgInfo) {
            this.logUty.putlog("getUrHistoriesProgress", "HURgetHistoryProgress data is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return histProgInfo;
    }

    private HURgetHistoryLog getUrHistoriesLog(int copyType, int page) {
        int start = 16384 * (page - 1);
        int maxCount = 16384;
        if (SJctrRemoteHistoriesDC.isHM()) {
            start = 0;
            maxCount = 8192;
        }
        SJctrGetHURgetHistoryLog kind = new SJctrGetHURgetHistoryLog(copyType, start, maxCount);
        this.logUty.putlog("getUrHistoriesLog", "Kind Class = " + SJctrGetHURgetHistoryLog.class.getSimpleName() + ", Copy Type = " + copyType + ", Start = " + start + ", MaxCount = " + maxCount);
        HURgetHistoryLog histLogInfo = (HURgetHistoryLog)SJctrRemoteReplicationUtility.getRmiObject(this, kind).getObjRmi();
        if (null == histLogInfo) {
            this.logUty.putlog("getUrHistoriesLog", "HURgetHistoryLog is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return histLogInfo;
    }

    private void updateHistInfo(HURgetHistoryLog histLogInfo) {
        String lastUpdateTime = histLogInfo.timeStump;
        int lastPageNum = this.getLastPageNumber(histLogInfo.numOfAllLog, 16384);
        this.updateHistInfo(lastUpdateTime, lastPageNum);
    }

    private void setUrTableInfo(HURgetHistoryLog histLogInfo, String tableKey) {
        ArrayList histLogArray = histLogInfo.history;
        ArrayList<SJctrRemoteHistoriesUrInfo> histInfoList = new ArrayList<SJctrRemoteHistoriesUrInfo>(histLogArray.size());
        List<SJmoLdevIndex> enableResourceList = this.getProxy().getCache(KEY_ENABLE_RESOURCE_LDEV);
        for (HURgetHistory1Log histLog : histLogArray) {
            SJctrRemoteHistoriesUrInfo histInfo = new SJctrRemoteHistoriesUrInfo(histLog);
            if (!this.isEnableHistories(enableResourceList, histInfo)) continue;
            histInfoList.add(histInfo);
        }
        SJctrRemoteHistoriesUrTableDataModel urTable = (SJctrRemoteHistoriesUrTableDataModel)this.getDataObjectModel(tableKey);
        urTable.setBasicDataList(histInfoList);
        SJctrHistoriesPagingComponentDataModel pagingComp = (SJctrHistoriesPagingComponentDataModel)this.getDataObjectModel(KEY_PAGING_COMPO);
        urTable.setCurrentPageNum(pagingComp.getCurrentPage());
        urTable.doRefresh();
    }

    private RJiHAgetHistory getHaHistoriesInfo(int copyType, boolean logRefresh, int page, boolean upDateCheck) {
        RJiHAgetHistory histLogInfo = null;
        if (SJctrDataController.isHM()) {
            histLogInfo = this.getHaHistories(copyType, logRefresh, page);
        } else {
            histLogInfo = this.getHaHistories(copyType, logRefresh, page);
            SJctrRemoteHistoriesComInfoDataModel histInfo = (SJctrRemoteHistoriesComInfoDataModel)this.getDataObjectModel(KEY_HISTORIES_INFO);
            if (logRefresh) {
                this.updateHistInfo(histLogInfo);
            } else if (upDateCheck && !histInfo.getLastUpdateTime().equals(histLogInfo.getRenewDate())) {
                histInfo.setHistoriesUpdate(true);
                histLogInfo = this.getHaHistoriesInfo(copyType, false, 1, false);
                this.updateHistInfo(histLogInfo);
            }
        }
        return histLogInfo;
    }

    private RJiHAgetHistory getHaHistories(int copyType, boolean logRefresh, int page) {
        int start = 16384 * (page - 1);
        int maxCount = 16384;
        int mode = 1;
        if (SJctrRemoteHistoriesDC.isHM()) {
            start = 0;
            maxCount = 8192;
        }
        RJiInputHAHistoryParam inputParam = new RJiInputHAHistoryParam();
        inputParam.setPP(copyType);
        inputParam.setStartIndex(start);
        inputParam.setMaxCount(maxCount);
        mode = logRefresh ? 1 : 0;
        inputParam.setMode(mode);
        RJiHAgetHistory_IN hist_in = new RJiHAgetHistory_IN(inputParam);
        SJctrGetHAgetHistory kind = new SJctrGetHAgetHistory(hist_in);
        this.logUty.putlog("getHaHistories", "Kind Class = " + SJctrGetRMCPgetHistoryLog.class.getSimpleName() + ", Copy Type = " + copyType + ", Start = " + start + ", MaxCount = " + maxCount + ", Mode = " + mode);
        RJiHAgetHistory_OUT hist_out = (RJiHAgetHistory_OUT)SJctrRemoteReplicationUtility.getRmiObject(this, kind).getObjRmi();
        if (null == hist_out) {
            this.getLogUty().putlog("getHaHistories", "RMI output data is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        RJiHAgetHistory histLogInfo = (RJiHAgetHistory)hist_out.getDataObject();
        if (null == histLogInfo) {
            this.getLogUty().putlog("getHaHistories", "Hirotries info is null.");
            SJctrError err = new SJctrError(210, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return histLogInfo;
    }

    private void updateHistInfo(RJiHAgetHistory histLogInfo) {
        String lastUpdateTime = histLogInfo.getRenewDate();
        int lastPageNum = this.getLastPageNumber(histLogInfo.getAllCount(), 16384);
        this.updateHistInfo(lastUpdateTime, lastPageNum);
    }

    private void setHaTableInfo(RJiHAgetHistory histLogInfo, String tableKey) {
        RJiHAgetHistoryLog[] histLogArray = (RJiHAgetHistoryLog[])histLogInfo.getLog();
        int logCount = histLogInfo.getCount();
        ArrayList<SJctrRemoteHistoriesHaInfo> histInfoList = new ArrayList<SJctrRemoteHistoriesHaInfo>(logCount);
        List<SJmoLdevIndex> enableResourceList = this.getProxy().getCache(KEY_ENABLE_RESOURCE_LDEV);
        for (int index = 0; index < logCount; ++index) {
            SJctrRemoteHistoriesHaInfo histInfo = new SJctrRemoteHistoriesHaInfo(histLogArray[index]);
            if (SJctrHaUtility.isCTGCode(histInfo)) {
                histInfoList.add(histInfo);
                continue;
            }
            if (SJctrHaUtility.isQuorumLessFromHist(histInfo)) {
                histInfoList.add(histInfo);
                continue;
            }
            if (!this.isEnableHistories(enableResourceList, histInfo)) continue;
            histInfoList.add(histInfo);
        }
        SJctrRemoteHistoriesHaTableDataModel haTable = (SJctrRemoteHistoriesHaTableDataModel)this.getDataObjectModel(tableKey);
        haTable.setBasicDataList(histInfoList);
        SJctrHistoriesPagingComponentDataModel pagingComp = (SJctrHistoriesPagingComponentDataModel)this.getDataObjectModel(KEY_PAGING_COMPO);
        haTable.setCurrentPageNum(pagingComp.getCurrentPage());
        haTable.doRefresh();
    }

    public static enum VIEW_REMOTE_HISTORIES_MSG implements SJctrNotifyState
    {
        CHANGE_COPYTYPE,
        SELECT_EXPORT;

    }
}

