/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.addextvols;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.serverux.dataimpl.EXDExternalDevice;
import sanproject.serverux.dataimpl.EXDExternalVolumeEx;
import sanproject.serverux.dataimpl.EXDLDEVInfoDetail;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComCVSUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorTableModel;
import sanproject.sn2.controller.com.comparator.SJctrErrorColumnDataComparator;
import sanproject.sn2.controller.com.comparator.uvm.SJctrPgIndexComparator;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.SJctrConfirmDataController;
import sanproject.sn2.controller.wizard.uvm.addextvols.SJctrAddExtPathGrpsConfirmTableModel;
import sanproject.sn2.controller.wizard.uvm.addextvols.SJctrAddExtPathsConfirmTableModel;
import sanproject.sn2.controller.wizard.uvm.addextvols.SJctrAddExtVolError;
import sanproject.sn2.controller.wizard.uvm.addextvols.SJctrAddExtVolsConfirmData;
import sanproject.sn2.controller.wizard.uvm.addextvols.SJctrAddExtVolsConfirmTableModel;
import sanproject.sn2.controller.wizard.uvm.addextvols.SJctrAddExtVolsSubWizard;
import sanproject.sn2.controller.wizard.uvm.comdialog.externalldevproperties.SJctrExternalLDEVPropertiesDC;
import sanproject.sn2.model.data.exdevice.SJmoExdVolumeInfo;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualDkc;
import sanproject.sn2.model.data.huvm.SJmoHUVMVirtualLdev;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;
import sanproject.sn2.model.data.volume.SJmoSsidDetail;
import sanproject.sn2.modelrc.util.SJmoRscUtil;
import sanproject.sn2.modelrc.util.SJmoRscUtilExPathGrp;
import sanproject.sn2.modelrc.util.SJmoRscUtilLdev;
import sanproject.sn2.modelrc.util.SJmoRscUtilPg;
import sanproject.sn2.modelrc.util.SJmoRscUtilSsid;

public class SJctrAddExtVolsConfirmDC
extends SJctrConfirmDataController {
    private static final int DISP_ID = 16793871;
    private static final String KEY_EXTPATHGRPS_TABLE = "COM_EXTPATHGRP_TBL";
    private static final String KEY_EXTPATHS_TABLE = "COM_EXTPATHS_TBL";
    private static final String KEY_EXTVOLS_TABLE = "COM_EXTVOL_TBL";
    private static final String KEY_DETAIL_BTN = "COM_DETAIL_BTN";

    public SJctrAddExtVolsConfirmDC() throws SJcException {
        super(16793871);
        this.initDataModel();
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> confirmDataList = this.getCache("ADD_EXT_VOLS_CONFIRMDATA");
        if (confirmDataList != null && confirmDataList.size() == 1) {
            Object obj = confirmDataList.get(0);
            if (!(obj instanceof SJctrAddExtVolsConfirmData)) {
                this.logUty.putlog("checkStartData", "Is not SJctrAddExtVolsConfirmData.");
                SJctrError err = new SJctrError(6, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            SJctrAddExtVolsConfirmData confirmData = (SJctrAddExtVolsConfirmData)confirmDataList.get(0);
            List<Object> list = confirmData.getPathInfo();
            if (list == null || list.size() <= 0) {
                this.logUty.putlog("checkStartData", "There is no ExdPathGroupInfo.");
                SJctrError err = new SJctrError(6, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            list = confirmData.getExdVolInfo();
            if (list == null || list.size() <= 0) {
                this.logUty.putlog("checkStartData", "There is no ExdVolInfo.");
                SJctrError err = new SJctrError(6, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            list = confirmData.getClprInfo();
            if (list == null || list.size() <= 0) {
                this.logUty.putlog("checkStartData", "There is no ClprInfo.");
                SJctrError err = new SJctrError(6, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            list = confirmData.getPortDtlInfo();
            if (list == null || list.size() <= 0) {
                this.logUty.putlog("checkStartData", "There is no PortDetail.");
                SJctrError err = new SJctrError(6, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            list = confirmData.getTargetPortMgr();
            if (list == null || list.size() <= 0) {
                this.logUty.putlog("checkStartData", "There is no TargetPortManager.");
                SJctrError err = new SJctrError(6, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            list = confirmData.getSubsystemMgr();
            if (list == null || list.size() <= 0) {
                this.logUty.putlog("checkStartData", "There is no SubsystemPortManager.");
                SJctrError err = new SJctrError(6, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            list = confirmData.getVpgInfo();
            if (list == null || list.size() <= 0) {
                this.logUty.putlog("checkStartData", "There is no VpgManager.");
                SJctrError err = new SJctrError(6, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            list = confirmData.getSsidDetail();
            if (list == null) {
                this.logUty.putlog("checkStartData", "There is no SsidManager.");
                SJctrError err = new SJctrError(6, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            list = confirmData.getMappingLdevInfo();
            if (list == null || list.size() <= 0) {
                this.logUty.putlog("checkStartData", "There is no MappingLdevInfo.");
                SJctrError err = new SJctrError(6, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            list = confirmData.getLdevNameInfo();
            if (list == null) {
                this.logUty.putlog("checkStartData", "There is no LdevNameInfo.");
                SJctrError err = new SJctrError(6, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
            list = confirmData.getiSCSITargetPathInfo();
            if (list == null) {
                this.logUty.putlog("checkStartData", "There is no PortiSCSITargetPathInfo.");
                SJctrError err = new SJctrError(6, 22, 107001);
                SJcException exp = err.createException();
                throw exp;
            }
        } else {
            this.logUty.putlog("checkStartData", "There is no ConfirmData.");
            SJctrError err = new SJctrError(6, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    private void initDataModel() {
        SJctrTableDataModel confirmTable = new SJctrAddExtPathGrpsConfirmTableModel();
        confirmTable.setPaging(false);
        this.addDataObjectModel(KEY_EXTPATHGRPS_TABLE, confirmTable);
        confirmTable = new SJctrAddExtPathsConfirmTableModel();
        confirmTable.setPaging(false);
        this.addDataObjectModel(KEY_EXTPATHS_TABLE, confirmTable);
        confirmTable = new SJctrAddExtVolsConfirmTableModel();
        confirmTable.setPaging(false);
        this.addDataObjectModel(KEY_EXTVOLS_TABLE, confirmTable);
        SJctrButtonDataModel btn = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_DETAIL_BTN, btn);
        btn.setReceiveOnly();
        btn.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrTableDataModel table = (SJctrTableDataModel)SJctrAddExtVolsConfirmDC.this.getDataObjectModel(SJctrAddExtVolsConfirmDC.KEY_EXTVOLS_TABLE);
                List<Object> selectList = table.getSelectedRowDataOrder();
                SJctrAddExtVolsConfirmDC.this.detailAction(selectList);
            }
        });
    }

    @Override
    public Map<String, List<?>> getConfirmData() {
        HashMap retMap = new HashMap();
        retMap.put("ADD_EXT_VOLS_CONFIRMDATA", this.getCache("ADD_EXT_VOLS_CONFIRMDATA"));
        return retMap;
    }

    @Override
    public void getConfirmWithStatus(List<Object> destErrorList) throws SJcException {
        SJctrPgIndexComparator pgCmp = new SJctrPgIndexComparator();
        SJctrAddExtVolsConfirmData confirmData = (SJctrAddExtVolsConfirmData)this.getCache("ADD_EXT_VOLS_CONFIRMDATA").get(0);
        SJctrAddExtPathGrpsConfirmTableModel extPathGrpTable = (SJctrAddExtPathGrpsConfirmTableModel)this.getDataObjectModel(KEY_EXTPATHGRPS_TABLE);
        SJctrAddExtPathsConfirmTableModel extPathTable = (SJctrAddExtPathsConfirmTableModel)this.getDataObjectModel(KEY_EXTPATHS_TABLE);
        SJctrAddExtVolsConfirmTableModel extVolTable = (SJctrAddExtVolsConfirmTableModel)this.getDataObjectModel(KEY_EXTVOLS_TABLE);
        extPathGrpTable.setConfirmData(confirmData);
        extPathTable.setConfirmData(confirmData);
        extVolTable.setConfirmData(confirmData);
        extPathGrpTable.makeDataModel();
        extPathTable.makeDataModel();
        extVolTable.makeDataModel();
        List tempList = (List)destErrorList.get(0);
        List errorList = (List)tempList.get(0);
        ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>(errorList.size());
        List<Object> rowData = extVolTable.getAllRowData();
        Collections.sort(rowData, pgCmp);
        for (SJctrAddExtVolError errInfo : errorList) {
            int index = Collections.binarySearch(rowData, errInfo.getKeyObj(), pgCmp);
            if (index < 0) continue;
            SJmoExdVolumeInfo volInfo = (SJmoExdVolumeInfo)rowData.get(index);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(volInfo, errInfo);
            errList.add(errColumn);
        }
        SJctrErrorTableModel errTable = new SJctrErrorTableModel();
        this.addDataObjectModel(KEY_EXTPATHGRPS_TABLE, errTable);
        errTable.initialize(extPathGrpTable, null, null);
        errTable = new SJctrErrorTableModel();
        this.addDataObjectModel(KEY_EXTPATHS_TABLE, errTable);
        errTable.initialize(extPathTable, null, null);
        errTable = new SJctrErrorTableModel();
        this.addDataObjectModel(KEY_EXTVOLS_TABLE, errTable);
        errTable.initialize(extVolTable, errList, new SJctrErrorColumnDataComparator());
    }

    @Override
    public List<SJmoRscUtil> getRscUtil() {
        ArrayList<SJmoRscUtil> rscUtilList = new ArrayList<SJmoRscUtil>(4);
        SJmoRscUtilExPathGrp pathGrpRscUtil = (SJmoRscUtilExPathGrp)this.getCache(SJctrAddExtVolsSubWizard.KEY_PATHGRP_UTIL_DATA).get(0);
        rscUtilList.add(pathGrpRscUtil);
        SJmoRscUtilLdev ldevRscUtil = (SJmoRscUtilLdev)this.getCache(SJctrAddExtVolsSubWizard.KEY_LDEV_UTIL_DATA).get(0);
        rscUtilList.add(ldevRscUtil);
        SJmoRscUtilPg pgRscUtil = (SJmoRscUtilPg)this.getCache(SJctrAddExtVolsSubWizard.KEY_PG_UTIL_DATA).get(0);
        rscUtilList.add(pgRscUtil);
        SJmoRscUtilSsid ssidRscUtil = (SJmoRscUtilSsid)this.getCache(SJctrAddExtVolsSubWizard.KEY_SSID_UTIL_DATA).get(0);
        rscUtilList.add(ssidRscUtil);
        return rscUtilList;
    }

    private void detailAction(List<Object> selectList) {
        List<SJmoHUVMVirtualLdev> vldevlist;
        List<SJmoHUVMVirtualDkc> vdkclist;
        SJctrComCVSUtility cvsUtil = this.getComUtility().getCVSUtility();
        if (selectList == null || selectList.size() == 0) {
            SJctrError err = new SJctrError(6, 22, 105235);
            SJcException exp = err.createException();
            throw exp;
        }
        List<?> confirmDataList = this.getCache("ADD_EXT_VOLS_CONFIRMDATA");
        SJctrAddExtVolsConfirmData confirmData = (SJctrAddExtVolsConfirmData)confirmDataList.get(0);
        List<Map<String, List<EXDLDEVInfoDetail>>> list = confirmData.getMappingLdevInfo();
        Map<String, List<EXDLDEVInfoDetail>> mapLdev = list.get(0);
        ArrayList<SJmoLdevDetail> ldevDtllist = new ArrayList<SJmoLdevDetail>(mapLdev.size() * 2048);
        for (Object selObj : selectList) {
            SJmoExdVolumeInfo selectVol = (SJmoExdVolumeInfo)selObj;
            EXDExternalVolumeEx exdVol = (EXDExternalVolumeEx)selectVol.getRmiExdVolumeInfo();
            EXDExternalDevice extDev = exdVol.getExternalDeviceInfo();
            List<EXDLDEVInfoDetail> ldevList = mapLdev.get(extDev.getIdentity2());
            if (ldevList == null) continue;
            int emutype = exdVol.getIBaseEmulationType();
            byte emuflg = (byte)cvsUtil.getEmuFlg(cvsUtil.getEmulationTypeName(emutype));
            for (EXDLDEVInfoDetail ldev : ldevList) {
                SJmoLdevDetail ldevDtl = new SJmoLdevDetail();
                ldevDtl.setIFB4(exdVol.getIFB4());
                ldevDtl.setIPG(exdVol.getIPG());
                ldevDtl.setSLdkc(ldev.getSLDKC());
                ldevDtl.setSCu(ldev.getSCU());
                ldevDtl.setSLdev(ldev.getSLDEV());
                ldevDtl.setLLDEVLBASize(ldev.getLLDEVLBASize());
                ldevDtl.setIEmulationType(emutype);
                ldevDtl.setbCacheMode(exdVol.getCacheMode());
                ldevDtl.setByVolumeFlag(emuflg);
                if (exdVol.isDDMAttribute()) {
                    ldevDtl.setBDM(true);
                    ldevDtl.setBPoolOnlyLDEV(true);
                }
                ldevDtl.setByCurrentMPBladeID((byte)exdVol.getOwnership());
                ldevDtllist.add(ldevDtl);
            }
        }
        ldevDtllist.trimToSize();
        List<SJmoLdevNicknameInfo> ldevNamelist = confirmData.getLdevNameInfo();
        List<SJmoSsidDetail> ssidlist = confirmData.getSsidDetail();
        List<SJmoRSGgetAllRsgs> rsglist = confirmData.getAllRsgInfo();
        if (rsglist == null) {
            rsglist = new ArrayList<SJmoRSGgetAllRsgs>();
        }
        if ((vdkclist = confirmData.getHuvmVDKCInfo()) == null) {
            vdkclist = new ArrayList<SJmoHUVMVirtualDkc>();
        }
        if ((vldevlist = confirmData.getHuvmVldevInfo()) == null) {
            vldevlist = new ArrayList<SJmoHUVMVirtualLdev>();
        }
        HashMap map = new HashMap();
        map.put("KEY_P28_LDEV", ldevDtllist);
        map.put("KEY_P28_MAPLDEVNAME", ldevNamelist);
        map.put("KEY_P28_SSID", ssidlist);
        map.put("KEY_P28_RSG", rsglist);
        map.put("KEY_P28_VDKC", vdkclist);
        map.put("KEY_P28_VLDEV", vldevlist);
        SJctrRelatedDispDataObject relatedObj = this.createDialog(SJctrExternalLDEVPropertiesDC.class, map);
        this.addUpdateDisp(relatedObj);
    }
}

