/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.uvm.com;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.model.SJmoDataChange;

public class SJctrEmulationTypeInfo {
    private static final BigInteger SLOT_OF_CYL = BigInteger.valueOf(15L);
    private static final BigInteger SLOT_MAX_VDEV = BigInteger.valueOf(0x1000000L);
    private static final BigInteger CYL_MIN_EMULATION = BigInteger.valueOf(50L);
    private static final int DIVIDE_MAX_VDEV = 2048;
    private static final Set<String> TYPE_OPENV;
    private static final Set<String> TYPE_WITHOUTCV;
    private static final Set<String> TYPE_3390A;
    private static final Set<String> TYPE_3390V;
    private final String emulationName;
    private int emulationKind;
    private int emulationId;
    private int emulationGroup;
    protected BigInteger lbaOfSlot;
    protected BigInteger lbaOfCyl;
    protected BigInteger capacitySizeMax;
    protected BigInteger ctrlCylSize;
    protected BigInteger hdevDivideSize;
    protected BigInteger hdevDivideSizeMin;
    protected BigInteger vdevSizeMax;

    private static boolean isSupport(Set<String> type, String emuTypeName) {
        return type.contains(emuTypeName);
    }

    private static boolean isOpen(int kind) {
        return kind == 3;
    }

    private static boolean isMF(int kind) {
        return kind == 1;
    }

    public static SJctrEmulationTypeInfo createEmulationTypeInfo(String emuTypeName, int emuKind) {
        SJctrEmulationTypeInfo info = null;
        info = SJctrEmulationTypeInfo.isSupport(TYPE_WITHOUTCV, emuTypeName) ? new EmulationTypeInfoWithoutCV(emuTypeName, emuKind) : (SJctrEmulationTypeInfo.isSupport(TYPE_OPENV, emuTypeName) ? new EmulationTypeInfoOpenV(emuTypeName, emuKind) : (SJctrEmulationTypeInfo.isSupport(TYPE_3390A, emuTypeName) ? new EmulationTypeInfo3390A(emuTypeName, emuKind) : (SJctrEmulationTypeInfo.isSupport(TYPE_3390V, emuTypeName) ? new EmulationTypeInfo3390V(emuTypeName, emuKind) : (SJctrEmulationTypeInfo.isOpen(emuKind) ? new EmulationTypeInfoOpen(emuTypeName, emuKind) : (SJctrEmulationTypeInfo.isMF(emuKind) ? new EmulationTypeInfoMF(emuTypeName, emuKind) : new SJctrEmulationTypeInfo(emuTypeName, emuKind))))));
        return info;
    }

    public static SJctrEmulationTypeInfo createDirectMappingEmulationTypeInfo(SJctrComUtility util) {
        SJmoDataChange dataChange = util.getDataChangeTable();
        int emuKind = dataChange.getEmuFlg("OPEN-V");
        EmulationTypeInfoOpenV_DirectMap info = new EmulationTypeInfoOpenV_DirectMap("OPEN-V", emuKind);
        info.initInfo(util);
        return info;
    }

    private SJctrEmulationTypeInfo(String emuTypeName, int emuKind) {
        this.emulationName = emuTypeName;
        this.emulationKind = emuKind;
    }

    public String getEmulationName() {
        return this.emulationName;
    }

    public int getEmulationKind() {
        return this.emulationKind;
    }

    public int getEmulationId() {
        return this.emulationId;
    }

    public int getEmulationGroup() {
        return this.emulationGroup;
    }

    public void initInfo(SJctrComUtility util) {
        SJmoDataChange dataChange = util.getDataChangeTable();
        this.emulationGroup = dataChange.getEmuGroup(this.emulationName);
        int slotSize = dataChange.getEmuSlotSize(this.emulationName);
        this.lbaOfSlot = this.kibToLba(slotSize);
        this.lbaOfCyl = this.lbaOfSlot.multiply(SLOT_OF_CYL);
        long maxCapacity = dataChange.getMaxCapacity(this.emulationName);
        int controlCyl = dataChange.getControlCyl(this.emulationName);
        this.initCapacity(maxCapacity, controlCyl);
        this.initHdev(this.ctrlCylSize);
        this.initVdev(this.lbaOfSlot);
    }

    protected void initCapacity(long maxCapacity, int controlCyl) {
        this.capacitySizeMax = BigInteger.valueOf(maxCapacity);
        this.capacitySizeMax = this.capacitySizeMax.multiply(this.lbaOfCyl);
        this.ctrlCylSize = BigInteger.valueOf(controlCyl);
        this.ctrlCylSize = this.ctrlCylSize.multiply(this.lbaOfCyl);
    }

    protected void initHdev(BigInteger cylSize) {
        this.hdevDivideSize = this.capacitySizeMax.add(cylSize);
        this.hdevDivideSizeMin = this.cylToLba(CYL_MIN_EMULATION);
        this.hdevDivideSizeMin = this.hdevDivideSizeMin.add(cylSize);
    }

    protected void initVdev(BigInteger slot) {
        this.vdevSizeMax = SLOT_MAX_VDEV.multiply(slot);
    }

    public void setEmulationId(int emuId) {
        this.emulationId = emuId;
    }

    public boolean isInheritEmulation(String emuName) {
        boolean result = false;
        if (emuName != null) {
            result = emuName.startsWith(this.getEmulationName());
        }
        return result;
    }

    public boolean isOpenType() {
        return false;
    }

    public boolean isOpenV() {
        return false;
    }

    public BigInteger kibToLba(long kib) {
        BigInteger lba = BigInteger.valueOf(kib);
        lba = lba.shiftLeft(1);
        return lba;
    }

    public BigInteger cylToLba(BigInteger cyl) {
        BigInteger ret = BigInteger.ZERO;
        if (cyl != null) {
            ret = cyl.multiply(this.lbaOfCyl);
        }
        return ret;
    }

    public BigInteger lbaToCyl(BigInteger lba) {
        BigInteger ret = BigInteger.ZERO;
        if (lba != null) {
            BigInteger slotCnt = lba.divide(this.lbaOfSlot);
            ret = slotCnt.divide(SLOT_OF_CYL);
        }
        return ret;
    }

    public BigInteger correctCapacity(BigInteger capacity) {
        BigInteger ret = BigInteger.ZERO;
        if (capacity != null) {
            BigInteger cylCnt = this.lbaToCyl(capacity);
            ret = cylCnt.multiply(this.lbaOfCyl);
        }
        return ret;
    }

    public List<BigInteger> getHdevCapacityList(BigInteger luCapacity) {
        ArrayList<BigInteger> ret = new ArrayList<BigInteger>();
        if (luCapacity != null) {
            if (luCapacity.compareTo(this.hdevDivideSize) < 0) {
                BigInteger hdevLba = luCapacity.subtract(this.ctrlCylSize);
                if ((hdevLba = this.correctCapacity(hdevLba)).compareTo(BigInteger.ZERO) > 0) {
                    ret.add(hdevLba);
                }
            } else {
                int hdevCnt = this.getDivideHdev(luCapacity);
                for (int i = 0; i < hdevCnt; ++i) {
                    ret.add(this.capacitySizeMax);
                }
            }
        }
        return ret;
    }

    public int getDivideHdev(BigInteger lba) {
        int ret = 0;
        if (lba != null && (ret = lba.divide(this.hdevDivideSize).intValue()) > 2048) {
            ret = 2048;
        }
        return ret;
    }

    public boolean isAdaptive(BigInteger luCapacity) {
        boolean ret = false;
        if (luCapacity != null && luCapacity.compareTo(this.hdevDivideSizeMin) >= 0) {
            ret = true;
        }
        return ret;
    }

    protected BigInteger getDivide_ROUND_UP(BigInteger value1, BigInteger value2) {
        BigInteger[] divide = value1.divideAndRemainder(value2);
        BigInteger ret = divide[0];
        if (divide[1].compareTo(BigInteger.ZERO) > 0) {
            ret = ret.add(BigInteger.ONE);
        }
        return ret;
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add("OPEN-V");
        TYPE_OPENV = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add("OPEN-L");
        set.add("OPEN-M");
        TYPE_WITHOUTCV = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add("3390-A");
        TYPE_3390A = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add("3390-V");
        TYPE_3390V = Collections.unmodifiableSet(set);
    }

    public static class EmulationTypeInfoWithoutCV
    extends EmulationTypeInfoOpen {
        private EmulationTypeInfoWithoutCV(String emuTypeName, int emuKind) {
            super(emuTypeName, emuKind);
        }

        @Override
        public int getDivideHdev(BigInteger lba) {
            int ret = 0;
            if (lba != null) {
                if (lba.compareTo(this.vdevSizeMax) > 0) {
                    lba = this.vdevSizeMax;
                }
                if ((ret = lba.divide(this.hdevDivideSize).intValue()) > 2048) {
                    ret = 2048;
                }
            }
            return ret;
        }

        @Override
        public List<BigInteger> getHdevCapacityList(BigInteger luCapacity) {
            int hdevCnt;
            ArrayList<BigInteger> ret = new ArrayList<BigInteger>();
            if (luCapacity != null && (hdevCnt = this.getDivideHdev(luCapacity)) >= 1) {
                for (int i = 0; i < hdevCnt; ++i) {
                    ret.add(this.capacitySizeMax);
                }
            }
            return ret;
        }
    }

    public static class EmulationTypeInfo3390V
    extends SJctrEmulationTypeInfo {
        private static final BigInteger MAX_USER_SIZE = BigInteger.valueOf(1117760L);
        private static final BigInteger ONE_PAGE_SIZE = BigInteger.valueOf(77952L);

        private EmulationTypeInfo3390V(String emuTypeName, int emuKind) {
            super(emuTypeName, emuKind);
        }

        @Override
        protected void initCapacity(long maxCapacity, int controlCyl) {
            super.initCapacity(maxCapacity, controlCyl);
            this.capacitySizeMax = MAX_USER_SIZE;
            this.capacitySizeMax = this.cylToLba(this.capacitySizeMax);
        }

        @Override
        public BigInteger correctCapacity(BigInteger capacity) {
            BigInteger pagenum;
            BigInteger pagesize;
            BigInteger ret = BigInteger.ZERO;
            if (capacity != null && (pagesize = (pagenum = capacity.divide(ONE_PAGE_SIZE)).multiply(ONE_PAGE_SIZE)).compareTo(CYL_MIN_EMULATION.multiply(this.lbaOfCyl)) >= 0) {
                ret = pagesize;
            }
            return ret;
        }
    }

    static class EmulationTypeInfo3390A
    extends SJctrEmulationTypeInfo {
        private static final BigInteger CYL_MIN_EMULATION = BigInteger.valueOf(1113L);
        private static final BigInteger CTR_CYL = BigInteger.valueOf(7L);
        private BigInteger ctrcyl_max;
        private BigInteger cylgrp;

        private EmulationTypeInfo3390A(String emuTypeName, int emuKind) {
            super(emuTypeName, emuKind);
        }

        @Override
        protected void initHdev(BigInteger cylSize) {
            super.initHdev(cylSize);
            this.hdevDivideSize = this.capacitySizeMax.add(this.ctrcyl_max);
            this.hdevDivideSizeMin = this.cylToLba(CYL_MIN_EMULATION);
            this.cylgrp = this.hdevDivideSizeMin.add(this.ctrlCylSize);
        }

        @Override
        public BigInteger correctCapacity(BigInteger capacity) {
            BigInteger ret = BigInteger.ZERO;
            if (capacity != null) {
                BigInteger div = capacity.divide(this.cylgrp);
                ret = this.hdevDivideSizeMin.multiply(div);
            }
            return ret;
        }

        @Override
        public List<BigInteger> getHdevCapacityList(BigInteger luCapacity) {
            ArrayList<BigInteger> ret = new ArrayList<BigInteger>();
            if (luCapacity != null) {
                if (luCapacity.compareTo(this.hdevDivideSize) < 0) {
                    BigInteger hdevLba = luCapacity;
                    if ((hdevLba = this.correctCapacity(hdevLba)).compareTo(BigInteger.ZERO) > 0) {
                        ret.add(hdevLba);
                    }
                } else {
                    int hdevCnt = this.getDivideHdev(luCapacity);
                    for (int i = 0; i < hdevCnt; ++i) {
                        ret.add(this.capacitySizeMax);
                    }
                }
            }
            return ret;
        }

        @Override
        protected void initCapacity(long maxCapacity, int controlCyl) {
            super.initCapacity(maxCapacity, controlCyl);
            this.ctrcyl_max = this.cylToLba(BigInteger.valueOf(controlCyl));
            this.capacitySizeMax = BigInteger.valueOf(maxCapacity);
            this.capacitySizeMax = this.cylToLba(this.capacitySizeMax);
            this.ctrlCylSize = this.cylToLba(CTR_CYL);
        }

        @Override
        public boolean isAdaptive(BigInteger luCapacity) {
            boolean ret = false;
            if (luCapacity != null && luCapacity.compareTo(this.cylgrp) >= 0) {
                ret = true;
            }
            return ret;
        }
    }

    public static class EmulationTypeInfoOpenV_DirectMap
    extends EmulationTypeInfoOpenV {
        protected static final BigInteger MIN_POOLVOL_ADAPTIVE_CAP = BigInteger.valueOf(0x1000000L);

        private EmulationTypeInfoOpenV_DirectMap(String emuTypeName, int emuKind) {
            super(emuTypeName, emuKind);
        }

        @Override
        protected void setCapacitySizeMax() {
            this.capacitySizeMax = new BigInteger("8000000000", 16);
        }

        @Override
        public List<BigInteger> getHdevCapacityList(BigInteger luCapacity) {
            ArrayList<BigInteger> ret = new ArrayList<BigInteger>();
            if (luCapacity != null) {
                if (luCapacity.compareTo(this.hdevDivideSize) >= 0) {
                    ret.add(this.capacitySizeMax);
                } else {
                    ret.add(luCapacity);
                }
            }
            ret.trimToSize();
            return ret;
        }

        public boolean isDirectMappingAdaptive(BigInteger luCapacity) {
            boolean ret = false;
            if (luCapacity != null && luCapacity.compareTo(MIN_POOLVOL_ADAPTIVE_CAP) >= 0) {
                ret = true;
            }
            return ret;
        }
    }

    public static class EmulationTypeInfoOpenV
    extends EmulationTypeInfoOpen {
        private static final BigInteger MIN_HDEV_DIVIDE_SIZE = BigInteger.valueOf(96000L);

        private EmulationTypeInfoOpenV(String emuTypeName, int emuKind) {
            super(emuTypeName, emuKind);
        }

        @Override
        protected void initHdev(BigInteger cylSize) {
            super.initHdev(cylSize);
            this.hdevDivideSizeMin = MIN_HDEV_DIVIDE_SIZE;
        }

        @Override
        protected void initCapacity(long maxCapacity, int controlCyl) {
            super.initCapacity(maxCapacity, controlCyl);
            this.setCapacitySizeMax();
        }

        protected void setCapacitySizeMax() {
            this.capacitySizeMax = new BigInteger("200000000", 16);
        }

        @Override
        public boolean isOpenV() {
            return true;
        }

        @Override
        public BigInteger correctCapacity(BigInteger capacity) {
            BigInteger ret = BigInteger.ZERO;
            if (capacity != null) {
                BigInteger[] slotCnt = capacity.divideAndRemainder(this.lbaOfSlot);
                if (slotCnt[1].compareTo(BigInteger.ZERO) > 0) {
                    slotCnt[0] = slotCnt[0].add(BigInteger.ONE);
                }
                ret = slotCnt[0].multiply(this.lbaOfSlot);
            }
            return ret;
        }

        @Override
        public List<BigInteger> getHdevCapacityList(BigInteger luCapacity) {
            ArrayList<BigInteger> ret = new ArrayList<BigInteger>();
            if (luCapacity != null) {
                int hdevCnt = this.getDivideHdev(luCapacity);
                ret.ensureCapacity(hdevCnt + 1);
                for (int i = 0; i < hdevCnt; ++i) {
                    ret.add(this.capacitySizeMax);
                }
                BigInteger freespace = luCapacity.subtract(this.capacitySizeMax.multiply(BigInteger.valueOf(hdevCnt)));
                if (freespace.compareTo(this.hdevDivideSizeMin) >= 0) {
                    ret.add(freespace);
                }
            }
            ret.trimToSize();
            return ret;
        }

        @Override
        public BigInteger lbaToCyl(BigInteger lba) {
            BigInteger ret = BigInteger.ZERO;
            if (lba != null) {
                BigInteger[] slotCnt = lba.divideAndRemainder(this.lbaOfSlot);
                if (slotCnt[1].compareTo(BigInteger.ZERO) > 0) {
                    slotCnt[0] = slotCnt[0].add(BigInteger.ONE);
                }
                BigInteger[] cylCnt = slotCnt[0].divideAndRemainder(SLOT_OF_CYL);
                ret = cylCnt[0];
                if (cylCnt[1].compareTo(BigInteger.ZERO) > 0) {
                    ret = ret.add(BigInteger.ONE);
                }
            }
            return ret;
        }
    }

    public static class EmulationTypeInfoMF
    extends SJctrEmulationTypeInfo {
        private static final BigInteger CG_SLOT_LBA = BigInteger.valueOf(116L);
        private static final BigInteger CG_USER_CYL = BigInteger.valueOf(1113L);
        private static final BigInteger CG_CTR_CYL = BigInteger.valueOf(7L);
        private static final BigInteger CG_1CYL_LBA = SJctrEmulationTypeInfo.access$100().multiply(CG_SLOT_LBA);
        private static final BigInteger CG_USER_CAPA_LBA = CG_USER_CYL.multiply(CG_1CYL_LBA);
        private static final BigInteger CG_CTR_CAPA_LBA = CG_CTR_CYL.multiply(CG_1CYL_LBA);
        private static final BigInteger SLOT_OF_PAGE = BigInteger.valueOf(672L);
        private BigInteger cgEmulationNeedSize = BigInteger.ZERO;
        private BigInteger emuCtrlCyl_CGFMT = BigInteger.ZERO;

        private EmulationTypeInfoMF(String emuTypeName, int emuKind) {
            super(emuTypeName, emuKind);
        }

        @Override
        protected void initCapacity(long maxCapacity, int controlCyl) {
            super.initCapacity(maxCapacity, controlCyl);
            BigInteger needSize_CYL = BigInteger.valueOf(maxCapacity);
            needSize_CYL = needSize_CYL.add(BigInteger.valueOf(controlCyl));
            BigInteger cgCtr_Capa = this.getDivide_ROUND_UP(needSize_CYL, CG_USER_CYL);
            cgCtr_Capa = cgCtr_Capa.multiply(CG_CTR_CYL);
            needSize_CYL = needSize_CYL.add(cgCtr_Capa);
            BigInteger needSize_LBA = needSize_CYL.multiply(SLOT_OF_CYL);
            needSize_LBA = this.getDivide_ROUND_UP(needSize_LBA, SLOT_OF_PAGE);
            needSize_LBA = needSize_LBA.multiply(CG_SLOT_LBA);
            this.cgEmulationNeedSize = needSize_LBA = needSize_LBA.multiply(SLOT_OF_PAGE);
            this.emuCtrlCyl_CGFMT = BigInteger.valueOf(controlCyl);
            this.emuCtrlCyl_CGFMT = this.emuCtrlCyl_CGFMT.multiply(CG_1CYL_LBA);
        }

        @Override
        public BigInteger correctCapacity(BigInteger capacity) {
            BigInteger ret = BigInteger.ZERO;
            if (capacity != null) {
                BigInteger correctCapacity = capacity;
                correctCapacity = correctCapacity.divide(CG_SLOT_LBA);
                correctCapacity = correctCapacity.divide(SLOT_OF_PAGE);
                correctCapacity = correctCapacity.multiply(CG_SLOT_LBA);
                ret = correctCapacity = correctCapacity.multiply(SLOT_OF_PAGE);
            }
            return ret;
        }

        private BigInteger getLdevSize(BigInteger capacity) {
            BigInteger cgCapa = CG_USER_CAPA_LBA.add(CG_CTR_CAPA_LBA);
            BigInteger capacity_CylCorrect = capacity.divide(CG_1CYL_LBA);
            capacity_CylCorrect = capacity_CylCorrect.multiply(CG_1CYL_LBA);
            BigInteger cgNum = this.getDivide_ROUND_UP(capacity_CylCorrect, cgCapa);
            BigInteger ctrCyl = CG_CTR_CAPA_LBA.multiply(cgNum);
            BigInteger ldevCap_CG = capacity_CylCorrect;
            ldevCap_CG = ldevCap_CG.subtract(ctrCyl);
            ldevCap_CG = ldevCap_CG.subtract(this.emuCtrlCyl_CGFMT);
            BigInteger ldevCap = ldevCap_CG.divide(CG_SLOT_LBA);
            ldevCap = ldevCap.multiply(this.lbaOfSlot);
            return ldevCap;
        }

        @Override
        public List<BigInteger> getHdevCapacityList(BigInteger luCapacity) {
            ArrayList<BigInteger> ret = new ArrayList<BigInteger>();
            if (luCapacity != null) {
                if (luCapacity.compareTo(this.hdevDivideSize) < 0) {
                    BigInteger hdevLba = luCapacity;
                    if ((hdevLba = this.correctCapacity(hdevLba)).compareTo(BigInteger.ZERO) > 0) {
                        BigInteger ldevSize = this.getLdevSize(hdevLba);
                        ret.add(ldevSize);
                    }
                } else {
                    int hdevCnt = this.getDivideHdev(luCapacity);
                    for (int i = 0; i < hdevCnt; ++i) {
                        ret.add(this.capacitySizeMax);
                    }
                }
            }
            return ret;
        }

        @Override
        protected void initHdev(BigInteger cylSize) {
            this.hdevDivideSize = this.cgEmulationNeedSize;
            this.hdevDivideSizeMin = CYL_MIN_EMULATION.multiply(CG_1CYL_LBA);
            this.hdevDivideSizeMin = this.hdevDivideSizeMin.add(CG_CTR_CAPA_LBA);
            this.hdevDivideSizeMin = this.hdevDivideSizeMin.add(this.emuCtrlCyl_CGFMT);
            this.hdevDivideSizeMin = this.hdevDivideSizeMin.divide(CG_SLOT_LBA);
            this.hdevDivideSizeMin = this.getDivide_ROUND_UP(this.hdevDivideSizeMin, SLOT_OF_PAGE);
            this.hdevDivideSizeMin = this.hdevDivideSizeMin.multiply(CG_SLOT_LBA);
            this.hdevDivideSizeMin = this.hdevDivideSizeMin.multiply(SLOT_OF_PAGE);
        }
    }

    public static class EmulationTypeInfoOpen
    extends SJctrEmulationTypeInfo {
        private EmulationTypeInfoOpen(String emuTypeName, int emuKind) {
            super(emuTypeName, emuKind);
        }

        @Override
        protected void initCapacity(long maxCapacity, int controlCyl) {
            this.capacitySizeMax = this.kibToLba(maxCapacity);
            this.ctrlCylSize = this.kibToLba(controlCyl);
        }

        @Override
        public boolean isOpenType() {
            return true;
        }
    }
}

