/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.vpm.comdialog.clprproperty;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrVpmUtility;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.wizard.cvs.createldevs.basic.data.SJctrPGDetail;
import sanproject.sn2.controller.wizard.vpm.comdialog.clprproperty.SJctrClprPropertyDialogDC;
import sanproject.sn2.model.data.system.SJmoClprInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoPgDetail;

public class SJctrClprPropertyDialogSummaryModel
extends SJctrSimpleDataModel {
    public static final String KEY_CLPR = "COM_CLPR";
    public static final String KEY_GENERAL = "COM_GENERAL";
    public static final String KEY_RESIDENT = "COM_RESIDENT";
    public static final String KEY_TOTAL_SIZE = "COM_TOTAL_SIZE";
    public static final String KEY_PG_NUM = "COM_PG_NUM";
    public static final String KEY_VVOL_NUM = "COM_VVOL_NUM";
    public static final String KEY_TOTAL_RSC = "COM_TOTAL_RSC";
    public static final String KEY_NUM_OF_RESIDENT = "COM_NUM_OF_RESIDENT";
    private SJmoClprInfo afterClprInfo = null;
    private SJmoClprInfo beforClprInfo = null;
    List<SJmoPgDetail> pgList = null;
    List<SJmoLdevDetail> ldevList = null;

    @Override
    public void makeDataModel() {
        SJctrDataController dc = this.getDataController();
        if (dc instanceof SJctrClprPropertyDialogDC) {
            SJctrClprPropertyDialogDC clprPropDc = (SJctrClprPropertyDialogDC)dc;
            this.beforClprInfo = (SJmoClprInfo)clprPropDc.getCache("KEY_SELECT_CLPR_INDEX").get(0);
            if (clprPropDc.getCache("KEY_DETAIL_CLPR_DETAIL") != null) {
                List<?> clprList = clprPropDc.getCache("KEY_DETAIL_CLPR_DETAIL");
                this.afterClprInfo = (SJmoClprInfo)clprList.get(Collections.binarySearch(clprList, this.beforClprInfo));
            } else {
                this.afterClprInfo = this.beforClprInfo;
            }
            this.pgList = new ArrayList<SJmoPgDetail>();
            List<?> ctrPgList = clprPropDc.getCache("KEY_DETAIL_PG_DETAIL");
            for (SJctrPGDetail pgIdx : ctrPgList) {
                this.pgList.add(pgIdx);
                if (!pgIdx.isScTopPG()) continue;
                this.pgList.addAll(pgIdx.getPGScatteredList());
            }
            this.ldevList = clprPropDc.getCache("KEY_DETAIL_LDEV_DETAIL");
        }
        this.makeSummary();
    }

    public void makeSummary() {
        Object summaryData = this.getManageData();
        ((SJctrDataObject)summaryData).setData(KEY_CLPR, this.getClprNameId(this.beforClprInfo));
        ((SJctrDataObject)summaryData).setData(KEY_GENERAL, this.getGeneral(this.afterClprInfo, this.beforClprInfo));
        ((SJctrDataObject)summaryData).setData(KEY_RESIDENT, this.getResident(this.afterClprInfo, this.beforClprInfo));
        ((SJctrDataObject)summaryData).setData(KEY_TOTAL_SIZE, this.getTotalSize(this.afterClprInfo, this.beforClprInfo));
        ((SJctrDataObject)summaryData).setData(KEY_PG_NUM, this.getPgNum(this.afterClprInfo, this.beforClprInfo));
        ((SJctrDataObject)summaryData).setData(KEY_VVOL_NUM, this.getVvolnum(this.afterClprInfo, this.beforClprInfo));
        ((SJctrDataObject)summaryData).setData(KEY_TOTAL_RSC, this.getTotalRscNum(this.afterClprInfo, this.beforClprInfo));
        ((SJctrDataObject)summaryData).setData(KEY_NUM_OF_RESIDENT, this.getResidentExtNum(this.afterClprInfo, this.beforClprInfo));
    }

    private String getClprNameId(SJmoClprInfo clprInfo) {
        String strRet = "?:?";
        if (clprInfo != null) {
            strRet = SJctrVpmUtility.toClprNameIdDisplay(clprInfo);
        }
        return strRet;
    }

    private String getGeneral(SJmoClprInfo afterClprInfo, SJmoClprInfo beforClprInfo) {
        String strRet = "?";
        if (afterClprInfo != null && beforClprInfo != null) {
            SJctrCapacityUtility capaUtil = this.getComUtility().getCapacityUtility();
            long lBlockSize = capaUtil.valueOf((long)(afterClprInfo.getICacheCapacity() - afterClprInfo.getIDCRCapacity()), SJctrCapacityUtility.UNIT.MB);
            String strAfter = capaUtil.toUnitString(lBlockSize);
            long lBefBlockSize = capaUtil.valueOf((long)(beforClprInfo.getICacheCapacity() - beforClprInfo.getIDCRCapacity()), SJctrCapacityUtility.UNIT.MB);
            String strBefor = capaUtil.toUnitString(lBefBlockSize);
            strRet = SJctrVpmUtility.toDiffParamDisplay(strBefor, strAfter);
        }
        return strRet;
    }

    private String getResident(SJmoClprInfo afterClprInfo, SJmoClprInfo beforClprInfo) {
        String strRet = "?";
        if (afterClprInfo != null && beforClprInfo != null) {
            SJctrCapacityUtility capaUtil = this.getComUtility().getCapacityUtility();
            long lBlockSize = capaUtil.valueOf((long)afterClprInfo.getIDCRCapacity(), SJctrCapacityUtility.UNIT.MB);
            String strAfter = capaUtil.toUnitString(lBlockSize);
            long lBefBlockSize = capaUtil.valueOf((long)beforClprInfo.getIDCRCapacity(), SJctrCapacityUtility.UNIT.MB);
            String strBefor = capaUtil.toUnitString(lBefBlockSize);
            strRet = SJctrVpmUtility.toDiffParamDisplay(strBefor, strAfter);
        }
        return strRet;
    }

    private String getTotalSize(SJmoClprInfo afterClprInfo, SJmoClprInfo beforClprInfo) {
        String strRet = "?";
        if (afterClprInfo != null && beforClprInfo != null) {
            SJctrCapacityUtility capaUtil = this.getComUtility().getCapacityUtility();
            long lBlockSize = capaUtil.valueOf((long)afterClprInfo.getICacheCapacity(), SJctrCapacityUtility.UNIT.MB);
            String strAfter = capaUtil.toUnitString(lBlockSize);
            long lBefBlockSize = capaUtil.valueOf((long)beforClprInfo.getICacheCapacity(), SJctrCapacityUtility.UNIT.MB);
            String strBefor = capaUtil.toUnitString(lBefBlockSize);
            strRet = SJctrVpmUtility.toDiffParamDisplay(strBefor, strAfter);
        }
        return strRet;
    }

    private String getPgNum(SJmoClprInfo afterClprInfo, SJmoClprInfo beforClprInfo) {
        String strRet = "?";
        if (afterClprInfo != null && beforClprInfo != null && this.pgList != null) {
            strRet = SJctrVpmUtility.toDiffParamDisplay(SJctrVpmUtility.getPgList(beforClprInfo, this.pgList).size(), SJctrVpmUtility.getPgList(afterClprInfo, this.pgList).size());
        }
        return strRet;
    }

    private String getVvolnum(SJmoClprInfo afterClprInfo, SJmoClprInfo beforClprInfo) {
        String strRet = "?";
        if (afterClprInfo != null && beforClprInfo != null && this.ldevList != null) {
            strRet = SJctrVpmUtility.toDiffParamDisplay(SJctrVpmUtility.getVVolList(beforClprInfo, this.ldevList).size(), SJctrVpmUtility.getVVolList(afterClprInfo, this.ldevList).size());
        }
        return strRet;
    }

    private String getTotalRscNum(SJmoClprInfo afterClprInfo, SJmoClprInfo beforClprInfo) {
        String strRet = "?";
        if (afterClprInfo != null && beforClprInfo != null && this.pgList != null && this.ldevList != null) {
            strRet = SJctrVpmUtility.toDiffParamDisplay(SJctrVpmUtility.getPgList(beforClprInfo, this.pgList).size() + SJctrVpmUtility.getVVolList(beforClprInfo, this.ldevList).size(), SJctrVpmUtility.getPgList(afterClprInfo, this.pgList).size() + SJctrVpmUtility.getVVolList(afterClprInfo, this.ldevList).size());
        }
        return strRet;
    }

    private String getResidentExtNum(SJmoClprInfo afterClprInfo, SJmoClprInfo beforClprInfo) {
        String strRet = "?";
        if (afterClprInfo != null && beforClprInfo != null) {
            strRet = SJctrVpmUtility.toDiffParamDisplay(beforClprInfo.getIDCRExtentLimit(), afterClprInfo.getIDCRExtentLimit());
        }
        return strRet;
    }
}

