/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.vpm.deleteclpr;

import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.List;
import sanproject.serverux.dataimpl.PRMIDClass;
import sanproject.serverux.dataimpl.PRMProgressStatus;
import sanproject.serverux.dataimpl.PRMsetSendClass_IN;
import sanproject.serverux.dataimpl.PRMsetSendClass_OUT;
import sanproject.serverux.dataimpl.SetPRMResult;
import sanproject.serverux.dataimpl.SetPRMSendClass;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrVpmUtility;
import sanproject.sn2.model.SJmoException;
import sanproject.sn2.model.SJmoGetAgent;
import sanproject.sn2.model.SJmoModelMgr;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetThroughRmiData;
import sanproject.sn2.model.data.SJmoThroughRmiData;
import sanproject.sn2.model.data.system.SJmoClprInfo;

public class SJctrDeleteClprAC
extends SJctrApplyController {
    List<SJmoClprInfo> clprlInfoList = null;
    private String strPRMProgressStatus = "getPRMProgressStatus";
    private int WATCH_WAIT_INTERVAL = 15000;

    public void setApplyList(List<SJmoClprInfo> setClprList) {
        this.clprlInfoList = setClprList;
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList<PRMIDClass> delClprList = new ArrayList<PRMIDClass>();
        Collections.sort(this.clprlInfoList);
        for (SJmoClprInfo clprInfo : this.clprlInfoList) {
            PRMIDClass applyClprInfo = new PRMIDClass();
            applyClprInfo.nID = clprInfo.getSClpr();
            delClprList.add(applyClprInfo);
        }
        SetPRMSendClass applySet = new SetPRMSendClass(Collections.emptyList(), delClprList, Collections.emptyList());
        PRMsetSendClass_IN applyData = new PRMsetSendClass_IN();
        applyData.setParam(applySet);
        ArrayList<PRMsetSendClass_IN> applyDataList = new ArrayList<PRMsetSendClass_IN>();
        applyDataList.add(applyData);
        return applyDataList;
    }

    @Override
    protected void setApplyResult(Object resultObject) {
        SJctrError result = null;
        if (resultObject instanceof PRMsetSendClass_OUT) {
            PRMsetSendClass_OUT out = (PRMsetSendClass_OUT)resultObject;
            SetPRMResult setPrmRet = (SetPRMResult)out.getPRMResult();
            result = SJctrVpmUtility.createErrorInfo(setPrmRet.nDetect, setPrmRet.nErrorCode);
            if (setPrmRet.prmResultDetail.length != 0) {
                result.setMsgArgument(setPrmRet.prmResultDetail[0].strSubInfo);
            }
        } else {
            result = new SJctrError(85, 22, 107002);
        }
        this.setError(result);
    }

    @Override
    public int getLeadTime() {
        int leadTime = 15;
        int iCacheSize = 0;
        for (SJmoClprInfo clpr : this.clprlInfoList) {
            iCacheSize += clpr.getICacheCapacity();
            iCacheSize += clpr.getIDCRCapacity();
        }
        return leadTime += iCacheSize / 1024 * 60;
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public SJctrError monitorBackground() {
        SJctrError result;
        block7: {
            SJcMessage msg = null;
            boolean bResult = true;
            result = new SJctrError(85, 22, 0);
            SJctrLogUty.warn(this.getClass().getSimpleName(), "monitorBackground", "Delete CLPR Async Watch Start!!");
            this.changeDispApplyResult(false);
            SJmoGetDirect direct = this.createRmiData(this.strPRMProgressStatus, new Class[0], new Object[0]);
            ArrayList<SJmoGetDirect> directList = new ArrayList<SJmoGetDirect>();
            directList.add(direct);
            List getDataList = new ArrayList();
            while (true) {
                if (this.isPauseMonitor()) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "monitorBackground", "StopMonitor publish");
                    result = new SJctrError(85, 22, -1);
                    break block7;
                }
                try {
                    Thread.sleep(this.WATCH_WAIT_INTERVAL);
                }
                catch (Exception ex) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "monitorBackground", "Sleep failed");
                    result = new SJctrError(85, 22, 107002);
                    break block7;
                }
                try {
                    getDataList = this.getRmiDataList(directList);
                }
                catch (SJmoException modelExcep) {
                    msg = modelExcep.getMsg();
                    bResult = SJctrComUtility.checkSVPException(modelExcep);
                    if (bResult || (bResult = SJctrVpmUtility.checkConnectError(msg.getFunctionID(), msg.getModuleID(), msg.getMsgID()))) continue;
                    throw modelExcep;
                }
                PRMProgressStatus progress = (PRMProgressStatus)getDataList.get(0);
                short sStatus = progress.nStatus;
                if (sStatus == 1) {
                    this.setProgress(progress.nProgress);
                    continue;
                }
                if (sStatus == 0) break;
            }
            this.setProgress(100);
        }
        SJctrLogUty.warn(this.getClass().getSimpleName(), "monitorBackground", "Delete CLPR Async Watch End!!");
        return result;
    }

    public List getRmiDataList(List directList) {
        ArrayList<Object> rmiDataList = new ArrayList<Object>();
        SJmoGetAgent agent = SJmoModelMgr.getModelMgr().getDataAgent();
        List throughRmiDataList = (List)agent.getDataInf(directList).get(0);
        for (Object objThroughRmiData : throughRmiDataList) {
            SJmoThroughRmiData throughRmi = (SJmoThroughRmiData)objThroughRmiData;
            Object rmiDataObj = throughRmi.getObjRmi();
            rmiDataList.add(rmiDataObj);
        }
        return rmiDataList;
    }

    public SJmoGetDirect createRmiData(String getStr, Class[] refArgs, Object[] refParam) {
        SJmoGetDirect direct = null;
        SJmoGetThroughRmiData kind = new SJmoGetThroughRmiData(getStr, refArgs, refParam);
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        return direct;
    }
}

