/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.httpcli.com;

import java.util.Map;
import java.util.Properties;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcInstanceCreateUty;
import sanproject.sn2.httpcli.com.SJhtclHttpCliUty;
import sanproject.sn2.httpcli.com.SJhtclParameterUty;
import sanproject.sn2.httpcli.exec.inf.SJhtclExecInterface;
import sanproject.sn2.httpcli.request.inf.SJhtclRequestInterface;
import sanproject.sn2.httpcli.response.inf.SJhtclResponseInterface;

public class SJhtclPluginUty {
    private static final String LOG_FUNCTION = "HTTP_CLI";
    private static final String LOG_TITLE = SJhtclPluginUty.class.getSimpleName();
    private static Properties requestProps = null;
    private static Properties responseProps = null;
    private static Properties execProps = null;

    public static SJhtclRequestInterface getRequestPlugin(String act) {
        String LOG_SUBTITLE = "getRequestPlugin";
        SJhtclRequestInterface reqCls = null;
        String className = SJhtclPluginUty.getRequestPluginName(act);
        try {
            reqCls = (SJhtclRequestInterface)SJcInstanceCreateUty.newInstance(className);
        }
        catch (SJcException sjce) {
            SJhtclHttpCliUty.getHtclLogger().error(LOG_FUNCTION, LOG_TITLE, "getRequestPlugin", "Failed to create request plugin instance.", sjce);
        }
        catch (ClassCastException cce) {
            SJhtclHttpCliUty.getHtclLogger().error(LOG_FUNCTION, LOG_TITLE, "getRequestPlugin", "ClassCastException is occurred.");
        }
        return reqCls;
    }

    public static String getRequestPluginName(String act) {
        String LOG_SUBTITLE = "getRequestPluginName";
        String value = "";
        if (requestProps == null) {
            String filePath = SJcEnvUty.getProperty("SN_HTCL_REQUEST_PLUGIN_FILE_PATH", "HTTPCLI_Request_Plugin.properties");
            try {
                requestProps = SJcFileUty.loadProperties(SJhtclPluginUty.getHttpCliDirPath(), filePath);
            }
            catch (SJcException e) {
                SJhtclHttpCliUty.getHtclLogger().error(LOG_FUNCTION, LOG_TITLE, "getRequestPluginName", "Failed to load property.", e);
            }
        }
        if (requestProps != null) {
            value = requestProps.getProperty(act + ".class", value);
        }
        return value;
    }

    public static SJhtclResponseInterface getResponsePlugin(String responseType) {
        String LOG_SUBTITLE = "getResponsePlugin";
        SJhtclResponseInterface resCls = null;
        String className = SJhtclPluginUty.getResponsePluginName(responseType);
        try {
            resCls = (SJhtclResponseInterface)SJcInstanceCreateUty.newInstance(className);
        }
        catch (SJcException sjce) {
            SJhtclHttpCliUty.getHtclLogger().error(LOG_FUNCTION, LOG_TITLE, "getResponsePlugin", "Failed to create request plugin instance.", sjce);
        }
        catch (ClassCastException cce) {
            SJhtclHttpCliUty.getHtclLogger().error(LOG_FUNCTION, LOG_TITLE, "getResponsePlugin", "ClassCastException is occurred.");
        }
        return resCls;
    }

    public static String getResponsePluginName(String responseType) {
        String LOG_SUBTITLE = "getResponsePluginName";
        String value = "";
        if (responseProps == null) {
            String filePath = SJcEnvUty.getProperty("SN_HTCL_RESPOINSE_PLUGIN_FILE_PATH", "HTTPCLI_Response_Plugin.properties");
            try {
                responseProps = SJcFileUty.loadProperties(SJhtclPluginUty.getHttpCliDirPath(), filePath);
            }
            catch (SJcException e) {
                SJhtclHttpCliUty.getHtclLogger().error(LOG_FUNCTION, LOG_TITLE, "getResponsePluginName", "Failed to load property.", e);
            }
        }
        if (responseProps != null) {
            value = responseProps.getProperty(responseType + ".class", value);
        }
        return value;
    }

    public static SJhtclExecInterface getExecPlugin(Map map) {
        String LOG_SUBTITLE = "getExecPlugin";
        SJhtclExecInterface exeCls = null;
        String act = SJhtclParameterUty.getStrFromMap(map, "act");
        String obj = SJhtclParameterUty.getStrFromMap(map, "obj");
        String className = SJhtclPluginUty.getExecPluginName(act, obj);
        String sessionId = SJhtclParameterUty.getStrFromMap(map, "GlobalSessionID");
        SJbaseUserSessionInterface session = SJhtclHttpCliUty.getUserSession(sessionId);
        try {
            exeCls = (SJhtclExecInterface)SJcInstanceCreateUty.newInstance(className, new Class[]{SJbaseUserSessionInterface.class, Map.class}, new Object[]{session, map});
        }
        catch (SJcException sjce) {
            SJhtclHttpCliUty.getHtclLogger().error(LOG_FUNCTION, LOG_TITLE, "getExecPlugin", "Failed to create execute plugin instance.", sjce);
        }
        catch (ClassCastException cce) {
            SJhtclHttpCliUty.getHtclLogger().error(LOG_FUNCTION, LOG_TITLE, "getExecPlugin", "ClassCastException has occurred.");
        }
        return exeCls;
    }

    public static String getExecPluginName(String act, String obj) {
        String LOG_SUBTITLE = "getExecPluginName";
        String value = "";
        if (execProps == null) {
            String filePath = SJcEnvUty.getProperty("SN_HTCL_EXECUTE_PLUGIN_FILE_PATH", "HTTPCLI_Execute_Plugin.properties");
            try {
                execProps = SJcFileUty.loadProperties(SJhtclPluginUty.getHttpCliDirPath(), filePath);
            }
            catch (SJcException e) {
                SJhtclHttpCliUty.getHtclLogger().error(LOG_FUNCTION, LOG_TITLE, "getExecPluginName", "Failed to load property.", e);
            }
        }
        if (execProps != null) {
            value = execProps.getProperty(act + "." + obj + ".class", value);
        }
        return value;
    }

    private static String getHttpCliDirPath() {
        String path = SJcEnvUty.getProperty("SN_HTCL_DIR_PATH", "httpcli");
        return path;
    }
}

