/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.httpcli.com;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import sanproject.serverux.dataimpl.REPORTReportInfo;
import sanproject.serverux.dataimpl.REPORTgetReportHistory;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.utility.SJcSecureUty;
import sanproject.sn2.com.utility.guidance.inf.SJcGuidanceHandleInterface;
import sanproject.sn2.httpcli.com.SJhtclDef;
import sanproject.sn2.httpcli.com.SJhtclStringUty;

public class SJhtclReportUty {
    private static final String SPACE = " ";
    private static final String CHANGE_LINE = "\n";
    private static final int REPORT_ID_LENGTH = 4;

    public static String getReportId(REPORTReportInfo reportInfo) {
        String result = "";
        if (reportInfo != null) {
            byte[] hashByte = SJcSecureUty.getHashValueString(reportInfo.getOutputDir());
            long tmpDigi = 0L;
            for (int rad = 0; rad < hashByte.length; ++rad) {
                tmpDigi = tmpDigi << 8 | (long)hashByte[rad];
                if (rad % 8 != 7) continue;
                tmpDigi = Math.abs(tmpDigi);
                int index = (int)(tmpDigi % (long)SJhtclDef.HashConvList.length);
                result = result + SJhtclDef.HashConvList[index];
                tmpDigi = 0L;
            }
            while (result.length() < 4) {
                result = result + SJhtclDef.HashConvList[0];
            }
        }
        return result;
    }

    public static boolean checkMaxCount(REPORTgetReportHistory reportHistory) {
        int iCnt = reportHistory.getIResult();
        return 20 > iCnt;
    }

    public static String reportListFormmat(List<REPORTReportInfo> reportList, SJbaseUserSessionInterface session, boolean idFlg) {
        String reportID = "";
        SJcGuidanceHandleInterface guidHandler = session.getGuidanceInfo();
        String guidReportName = guidHandler.getGuidance("XPDT_CLI_REPORT_NAME");
        String guidUserName = guidHandler.getGuidance("XPDT_CLI_USER_NAME");
        String guidCreateTime = guidHandler.getGuidance("XPDT_CLI_CREATE_TIME");
        String guidReportID = guidHandler.getGuidance("XPDT_CLI_REPORT_ID");
        String result = SJhtclStringUty.treatString(guidReportName, 32) + SPACE + SJhtclStringUty.treatString(guidUserName, 16) + SPACE + SJhtclStringUty.treatString(guidCreateTime, 19);
        if (idFlg) {
            result = result + SPACE + SJhtclStringUty.treatString(guidReportID, 4);
        }
        result = result + CHANGE_LINE;
        reportList = SJhtclReportUty.sortReportAtCreateTime(reportList);
        for (int i = 0; i < reportList.size(); ++i) {
            String reportName = reportList.get(i).getSzReportName();
            String createUser = reportList.get(i).getSzUserName();
            String createTime = reportList.get(i).getSzStartTime();
            if (idFlg) {
                reportID = SJhtclReportUty.getReportId(reportList.get(i));
            }
            result = result + SJhtclStringUty.treatString(reportName, 32) + SPACE + SJhtclStringUty.treatString(createUser, 16) + SPACE + SJhtclStringUty.treatString(SJhtclStringUty.cnvTimeStr(createTime), 19);
            if (idFlg) {
                result = result + SPACE + SJhtclStringUty.treatString(reportID, 4);
            }
            result = result + CHANGE_LINE;
        }
        return result;
    }

    public static List<REPORTReportInfo> sortReportAtCreateTime(List<REPORTReportInfo> reportList) {
        TreeMap reportMap = new TreeMap();
        if (reportList != null) {
            for (REPORTReportInfo reportInfo : reportList) {
                String createTime = reportInfo.getSzStartTime();
                if (reportMap.get(createTime) == null) {
                    reportMap.put(createTime, new ArrayList());
                }
                ((ArrayList)reportMap.get(createTime)).add(reportInfo);
            }
        }
        ArrayList<REPORTReportInfo> resultList = new ArrayList<REPORTReportInfo>();
        for (String createTime : reportMap.keySet()) {
            for (REPORTReportInfo report : (ArrayList)reportMap.get(createTime)) {
                resultList.add(0, report);
            }
        }
        return resultList;
    }

    public static List<REPORTReportInfo> sortReportAtCreateTimeASC(List<REPORTReportInfo> reportList) {
        TreeMap reportMap = new TreeMap();
        if (reportList != null) {
            for (REPORTReportInfo reportInfo : reportList) {
                String createTime = reportInfo.getSzStartTime();
                if (reportMap.get(createTime) == null) {
                    reportMap.put(createTime, new ArrayList());
                }
                ((ArrayList)reportMap.get(createTime)).add(reportInfo);
            }
        }
        ArrayList<REPORTReportInfo> resultList = new ArrayList<REPORTReportInfo>();
        for (String createTime : reportMap.keySet()) {
            for (REPORTReportInfo report : (ArrayList)reportMap.get(createTime)) {
                resultList.add(report);
            }
        }
        return resultList;
    }

    public static List<REPORTReportInfo> getReportListByID(List<REPORTReportInfo> reportList, String reportID) {
        ArrayList<REPORTReportInfo> resultList = new ArrayList<REPORTReportInfo>();
        if (reportList != null && reportID != null) {
            for (REPORTReportInfo reportInfo : reportList) {
                if (!reportID.equals(SJhtclReportUty.getReportId(reportInfo))) continue;
                resultList.add(reportInfo);
            }
        }
        return resultList;
    }

    public static List<REPORTReportInfo> getReportListByName(List<REPORTReportInfo> reportList, String reportName) {
        ArrayList<REPORTReportInfo> resultList = new ArrayList<REPORTReportInfo>();
        if (reportList != null && reportName != null) {
            for (REPORTReportInfo reportInfo : reportList) {
                if (!reportName.equals(reportInfo.getSzReportName())) continue;
                resultList.add(reportInfo);
            }
        }
        return resultList;
    }

    public static REPORTReportInfo getRepCreatedBySessionUser(List<REPORTReportInfo> reportList, SJbaseUserSessionInterface session) {
        REPORTReportInfo result = null;
        if (reportList != null && session != null) {
            String userName = session.getUserName();
            for (REPORTReportInfo reportInfo : reportList) {
                if (!userName.equals(reportInfo.getSzUserName())) continue;
                result = reportInfo;
                break;
            }
        }
        return result;
    }
}

