/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.httpcli.exec;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.serverux.dataimpl.REPORTReportInfo;
import sanproject.serverux.dataimpl.REPORTgetReportHistory;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.httpcli.com.SJhtclHttpCliUty;
import sanproject.sn2.httpcli.com.SJhtclParameterUty;
import sanproject.sn2.httpcli.com.SJhtclReportUty;
import sanproject.sn2.httpcli.com.SJhtclStringUty;
import sanproject.sn2.httpcli.exec.SJhtclExecBase;
import sanproject.sn2.httpcli.exec.com.SJhtclReportRMIUtility;

public class SJhtclReportDelete
extends SJhtclExecBase {
    private static final String LOG_FUNCTION = "HTTP_CLI";
    private static final String LOG_TITLE = SJhtclReportDelete.class.getSimpleName();

    public SJhtclReportDelete(SJbaseUserSessionInterface session, Map requestMap) {
        super(session, requestMap);
        htclLogger = SJhtclHttpCliUty.getHtclLogger();
    }

    @Override
    protected boolean checkParameters() {
        boolean res = true;
        String reportID = SJhtclParameterUty.getStrFromMap(this.requestMap, "report_id");
        String reportName = SJhtclParameterUty.getStrFromMap(this.requestMap, "report");
        String chkFill = SJhtclParameterUty.getStrFromMap(this.requestMap, "fill");
        if (!(reportID != null && reportID.trim().length() > 0 || reportName != null && reportName.trim().length() > 0)) {
            res = false;
        }
        if (chkFill != null && chkFill.trim().length() > 0) {
            res = false;
        }
        return res;
    }

    @Override
    protected boolean checkRole() {
        boolean res = true;
        SJcRoleResourceContainer resourceContainer = this.session.getRoleResourceInfo();
        if (!resourceContainer.checkAuthority(32)) {
            res = false;
        }
        return res;
    }

    @Override
    protected boolean checkPP() {
        boolean res = true;
        if (!this.isEnablePP(SJctrLicenseContainer.PPID_SN)) {
            res = false;
        }
        return res;
    }

    @Override
    protected HashMap<String, Object> executeCommand() {
        String LOG_SUBTITLE = "executeCommand";
        htclLogger.info(LOG_FUNCTION, LOG_TITLE, "executeCommand", "Start.");
        HashMap<String, Object> responseMap = new HashMap();
        try {
            String reportID = SJhtclParameterUty.getStrFromMap(this.requestMap, "report_id");
            String reportName = SJhtclParameterUty.getStrFromMap(this.requestMap, "report");
            String chkFill = SJhtclParameterUty.getStrFromMap(this.requestMap, "fill");
            REPORTgetReportHistory reportHistory = SJhtclReportRMIUtility.getReportList();
            if (chkFill != null && SJhtclReportUty.checkMaxCount(reportHistory)) {
                htclLogger.error(LOG_FUNCTION, LOG_TITLE, "executeCommand", "MAX_COUNT_ERROR");
                SJcMessage msg = SJhtclHttpCliUty.getMessageObjCmd("107011");
                String msgStr = SJhtclStringUty.formatErrorMessage(msg);
                responseMap = SJhtclHttpCliUty.getTextMap(msgStr);
                return responseMap;
            }
            REPORTReportInfo[] reportArray = reportHistory.getReportList();
            List<REPORTReportInfo> reportList = Arrays.asList(reportArray);
            boolean role = this.checkDelRole();
            REPORTReportInfo delReport = null;
            if ((reportID == null || reportID.length() <= 0) && "LatestReport".equals(reportName)) {
                if (reportList.size() == 0) {
                    htclLogger.error(LOG_FUNCTION, LOG_TITLE, "executeCommand", "reportList is nothing");
                    responseMap = SJhtclHttpCliUty.getErrorMapCmd("107012");
                    return responseMap;
                }
                reportList = SJhtclReportUty.sortReportAtCreateTime(reportList);
                if (!role) {
                    delReport = SJhtclReportUty.getRepCreatedBySessionUser(reportList, this.session);
                    if (delReport == null) {
                        htclLogger.error(LOG_FUNCTION, LOG_TITLE, "executeCommand", "deletdable report is nothing");
                        responseMap = SJhtclHttpCliUty.getErrorMapCmd("107017");
                        return responseMap;
                    }
                } else {
                    delReport = reportList.get(0);
                }
            } else {
                reportList = reportID != null && reportID.length() > 0 ? SJhtclReportUty.getReportListByID(reportList, reportID) : SJhtclReportUty.getReportListByName(reportList, reportName);
                if (reportList.size() == 0) {
                    htclLogger.error(LOG_FUNCTION, LOG_TITLE, "executeCommand", "Not found report.");
                    responseMap = SJhtclHttpCliUty.getErrorMapCmd("107001");
                    return responseMap;
                }
                reportList = SJhtclReportUty.sortReportAtCreateTimeASC(reportList);
                if (!role) {
                    delReport = SJhtclReportUty.getRepCreatedBySessionUser(reportList, this.session);
                    if (delReport == null) {
                        htclLogger.error(LOG_FUNCTION, LOG_TITLE, "executeCommand", "Authority is insufficient");
                        responseMap = SJhtclHttpCliUty.getErrorMapCmd("107018");
                        return responseMap;
                    }
                } else {
                    delReport = reportList.get(0);
                }
            }
            ArrayList<REPORTReportInfo> delList = new ArrayList<REPORTReportInfo>();
            delList.add(delReport);
            String taskName = delReport.getSzReportName();
            SJhtclReportRMIUtility.removeReport(taskName, this.session, delList);
            String result = SJhtclReportUty.reportListFormmat(delList, this.session, true);
            responseMap.put("ResponseKeyType", "TXT");
            responseMap.put("Text", result);
        }
        catch (SJcException ex) {
            htclLogger.error(LOG_FUNCTION, LOG_TITLE, "executeCommand", "Catch SJceException ex:" + ex);
            responseMap = SJhtclHttpCliUty.getErrorMap(ex.getMsg());
            return responseMap;
        }
        htclLogger.info(LOG_FUNCTION, LOG_TITLE, "executeCommand", "End.");
        return responseMap;
    }

    private boolean checkDelRole() {
        String LOG_SUBTITLE = "checkDelRole";
        boolean snInitializeIs = false;
        SJcRoleResourceContainer role = this.session.getRoleResourceInfo();
        snInitializeIs = role.checkAuthority(33);
        htclLogger.info(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "role : " + snInitializeIs);
        return snInitializeIs;
    }
}

