/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.kms.kmip.client.convert;

import java.util.ArrayList;
import java.util.HashMap;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.kms.kmip.client.convert.Converter;
import sanproject.sn2.kms.kmip.client.exception.KeyInfoBlankException;
import sanproject.sn2.kms.kmip.client.exception.RequestCommandException;
import sanproject.sn2.kms.kmip.client.exception.ResponseException;
import sanproject.sn2.kms.kmip.client.info.InputInfo;
import sanproject.sn2.kms.kmip.client.info.KeyInfo;
import sanproject.sn2.kms.kmip.client.info.OutputInfo;
import sanproject.sn2.kms.kmip.client.info.common.CryptographicParameters;
import sanproject.sn2.kms.kmip.client.info.common.Name;
import sanproject.sn2.kms.kmip.client.info.common.RequestHeaderContents;
import sanproject.sn2.kms.kmip.client.ttlv.TTLV;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVDateTime;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVEnumeration;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVStructure;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVTextString;
import sanproject.sn2.kms.util.SJkmsLogUtil;

public class ConverterAddAttribute
extends Converter {
    private static final String module = "ConverterAddAttribute";

    @Override
    public TTLV makeSendTTLV(KeyInfo ki) throws RequestCommandException, KeyInfoBlankException {
        String method = "parseBatchItemList";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        InputInfo ii = ki.getInputInfo();
        String uniqueIdentifier = ii.getUniqueIdentifier();
        if (uniqueIdentifier == null || uniqueIdentifier.length() == 0) {
            STD_LOGGER.info(module, method, " - check UUID", " - No UUID");
            throw new KeyInfoBlankException();
        }
        String og = ii.getSortOfData();
        ArrayList<String> attrName = new ArrayList<String>();
        String[] attrValue = new String[6];
        if (og != null && og.length() > 0) {
            if (og.compareToIgnoreCase("R800:KEKdynamic") != 0 && og.compareToIgnoreCase("HUS_VM:KEKdynamic") != 0) {
                STD_LOGGER.info(module, method, " - check sortOfData ", " - invalid");
                throw new KeyInfoBlankException();
            }
            attrName.add("Object Group");
            attrName.add("x-KeyMaterialFormatID");
            attrName.add("x-ProductID");
            attrName.add("x-AddAttributeDate");
            attrName.add("x-HashAlgorithm");
            attrName.add("x-Hash");
            attrValue[0] = og;
            attrValue[1] = Integer.toHexString(ii.getKeyMaterialFormatID());
            attrValue[2] = ii.getProductID();
            attrValue[3] = ii.getAddAttributeDate();
            attrValue[4] = Integer.toHexString(ii.getHashAlgrithm());
            attrValue[5] = ii.getHash();
        }
        if (ii.getAttrNeedsMap() != null) {
            String[] attributeNameArray = ii.getAttrNeedsMap().keySet().toArray(new String[0]);
            for (int i = 0; i < attributeNameArray.length; ++i) {
                attrName.add(attributeNameArray[i]);
            }
        }
        HashMap<String, Long> dateValue = new HashMap<String, Long>();
        dateValue.put("Activation Date", ii.getActivationDate());
        dateValue.put("Deactivation Date", ii.getDeactivationDate());
        dateValue.put("Process Start Date", ii.getProcessStartDate());
        dateValue.put("Protect Stop Date", ii.getProtectStopDate());
        TTLVStructure tReq = new TTLVStructure(120);
        RequestHeaderContents rhc = ii.getRequestHeaderContents();
        if (rhc != null) {
            rhc.setBatchCount(attrName.size());
        }
        tReq.addValue(this.getRequestHeader(rhc, attrName.size()));
        block7: for (int i = 0; i < attrName.size(); ++i) {
            TTLVStructure tBI = this.getBatchItem(13, i + 1);
            tReq.addValue(tBI);
            TTLVStructure tPay = new TTLVStructure(121);
            tBI.addValue(tPay);
            tPay.addValue(new TTLVTextString(-108, uniqueIdentifier));
            TTLVStructure ta = new TTLVStructure(8);
            int mode = this.getMode(i, attrName);
            switch (mode) {
                case 1: {
                    if (attrValue[i] == null || attrValue[i].length() == 0) {
                        throw new KeyInfoBlankException();
                    }
                    ta.addValue(new TTLVTextString(10, attrName.get(i)));
                    ta.addValue(new TTLVTextString(11, attrValue[i]));
                    tPay.addValue(ta);
                    continue block7;
                }
                case 2: {
                    Name name = ii.getNameList().get(0);
                    if (name.getNameValue() == null || name.getNameValue().length() == 0) {
                        throw new KeyInfoBlankException();
                    }
                    if (name.getNameType() == 0) {
                        throw new KeyInfoBlankException();
                    }
                    ta.addValue(new TTLVTextString(10, attrName.get(i)));
                    TTLVStructure tAttrName = new TTLVStructure(83);
                    ta.addValue(tAttrName);
                    tAttrName.addValue(new TTLVTextString(85, name.getNameValue()));
                    tAttrName.addValue(new TTLVEnumeration(84, name.getNameType()));
                    tPay.addValue(ta);
                    continue block7;
                }
                case 3: {
                    ta.addValue(new TTLVTextString(10, attrName.get(i)));
                    TTLVStructure tAttrValue = new TTLVStructure(11);
                    ta.addValue(tAttrValue);
                    CryptographicParameters cp = ii.getCryptographicParameters();
                    if (ii.getCryptographicParameters().getAttrNeeds(0)) {
                        tAttrValue.addValue(new TTLVEnumeration(17, cp.getBlockCipherMode()));
                    }
                    if (ii.getCryptographicParameters().getAttrNeeds(1)) {
                        tAttrValue.addValue(new TTLVEnumeration(95, cp.getPaddingMethod()));
                    }
                    if (ii.getCryptographicParameters().getAttrNeeds(2)) {
                        tAttrValue.addValue(new TTLVEnumeration(56, cp.getHashingAlgorithm()));
                    }
                    if (ii.getCryptographicParameters().getAttrNeeds(3)) {
                        tAttrValue.addValue(new TTLVEnumeration(-125, cp.getKeyRoleType()));
                    }
                    tPay.addValue(ta);
                    continue block7;
                }
                case 4: {
                    ta.addValue(new TTLVTextString(10, attrName.get(i)));
                    ta.addValue(new TTLVDateTime(11, (Long)dateValue.get(attrName.get(i))));
                    tPay.addValue(ta);
                }
            }
        }
        STD_LOGGER.info(module, method, " - ", " - end");
        return tReq;
    }

    private int getMode(int i, ArrayList<String> attrName) {
        String method = "getMode";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        if (attrName.get(i).equalsIgnoreCase("Object Group") || attrName.get(i).equalsIgnoreCase("x-KeyMaterialFormatID") || attrName.get(i).equalsIgnoreCase("x-ProductID") || attrName.get(i).equalsIgnoreCase("x-AddAttributeDate") || attrName.get(i).equalsIgnoreCase("x-HashAlgorithm") || attrName.get(i).equalsIgnoreCase("x-Hash")) {
            STD_LOGGER.info(module, method, " - ", " - end");
            return 1;
        }
        if (attrName.get(i).equalsIgnoreCase("Name")) {
            STD_LOGGER.info(module, method, " - ", " - end");
            return 2;
        }
        if (attrName.get(i).equalsIgnoreCase("Cryptographic Parameters")) {
            STD_LOGGER.info(module, method, " - ", " - end");
            return 3;
        }
        if (attrName.get(i).indexOf("Date") > 0) {
            STD_LOGGER.info(module, method, " - ", " - end");
            return 4;
        }
        STD_LOGGER.info(module, method, " - ", " - end");
        return 0;
    }

    @Override
    public void parseBatchItemList(TTLVStructure resvTTLV, KeyInfo ki) throws ResponseException {
        String method = "parseBatchItemList";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        ArrayList<OutputInfo> oiList = ki.getOutputInfoList();
        if (resvTTLV.getValueSize((byte)15) < 0) {
            return;
        }
        ArrayList<TTLV> al = resvTTLV.getValueList((byte)15);
        for (int i = 0; i < al.size(); ++i) {
            OutputInfo oi = new OutputInfo();
            if (al.get(i).getType() != 1) {
                STD_LOGGER.info(module, method, " - check Type of Batch Item", " - invalid");
                throw new ResponseException();
            }
            TTLVStructure tRP = this.checkBatchItem((TTLVStructure)al.get(i), oi);
            if (tRP != null) {
                this.checkValue(tRP, (byte)-108, (byte)7, 1);
                TTLVTextString tUI = (TTLVTextString)tRP.getValueList((byte)-108).get(0);
                ArrayList<String> uniqueIdentifierList = new ArrayList<String>();
                uniqueIdentifierList.add(tUI.getValue());
                oi.setUniqueIdentifierList(uniqueIdentifierList);
            }
            oiList.add(oi);
        }
        ki.setOutputInfo(oiList);
        STD_LOGGER.info(module, method, " - ", " - end");
    }
}

