/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.kms.kmip.client.convert;

import java.util.ArrayList;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.kms.kmip.client.convert.Converter;
import sanproject.sn2.kms.kmip.client.exception.KeyInfoBlankException;
import sanproject.sn2.kms.kmip.client.exception.RequestCommandException;
import sanproject.sn2.kms.kmip.client.exception.ResponseException;
import sanproject.sn2.kms.kmip.client.info.InputInfo;
import sanproject.sn2.kms.kmip.client.info.KeyInfo;
import sanproject.sn2.kms.kmip.client.info.OutputInfo;
import sanproject.sn2.kms.kmip.client.info.common.RequestHeaderContents;
import sanproject.sn2.kms.kmip.client.ttlv.TTLV;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVByteString;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVEnumeration;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVInteger;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVStructure;
import sanproject.sn2.kms.kmip.client.ttlv.TTLVTextString;
import sanproject.sn2.kms.util.SJkmsLogUtil;

public class ConverterGet
extends Converter {
    private static final String module = "ConverterGet";

    @Override
    public TTLV makeSendTTLV(KeyInfo ki) throws RequestCommandException, KeyInfoBlankException {
        String method = "makeSendTTLV";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        InputInfo ii = ki.getInputInfo();
        TTLVStructure tReq = new TTLVStructure(120);
        RequestHeaderContents rhc = ii.getRequestHeaderContents();
        if (rhc != null) {
            rhc.setBatchCount(1);
        }
        tReq.addValue(this.getRequestHeader(rhc, 1));
        TTLVStructure tBI = this.getBatchItem(10);
        tReq.addValue(tBI);
        TTLVStructure tPay = new TTLVStructure(121);
        tBI.addValue(tPay);
        String s = ii.getUniqueIdentifier();
        if (s == null || s.length() == 0) {
            STD_LOGGER.info(module, method, " - check UUID", " - invalid");
            throw new KeyInfoBlankException();
        }
        tPay.addValue(new TTLVTextString(-108, s));
        STD_LOGGER.info(module, method, " - ", " - end");
        return tReq;
    }

    @Override
    public void parseBatchItemList(TTLVStructure resvTTLV, KeyInfo ki) throws ResponseException {
        String method = "parseBatchItemList";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        if (this.responseBatchCount != 1) {
            throw new ResponseException();
        }
        ArrayList<OutputInfo> oiList = ki.getOutputInfoList();
        OutputInfo oi = new OutputInfo();
        if (resvTTLV.getValueSize((byte)15) < 0) {
            return;
        }
        ArrayList<TTLV> al = resvTTLV.getValueList((byte)15);
        if (al.get(0).getType() != 1) {
            STD_LOGGER.info(module, method, " - check Type of Batch Item", " - invalid");
            throw new ResponseException();
        }
        TTLVStructure tRP = this.checkBatchItem((TTLVStructure)al.get(0), oi);
        if (tRP != null) {
            TTLV tKM;
            this.checkValue(tRP, (byte)-108, (byte)7, 1);
            TTLVTextString tUI = (TTLVTextString)tRP.getValueList((byte)-108).get(0);
            String ui = tUI.getValue();
            if (ui.compareToIgnoreCase(ki.getInputInfo().getUniqueIdentifier()) != 0) {
                STD_LOGGER.info(module, method, " - check UUID", " - invalid(mismatch)");
                throw new ResponseException();
            }
            ArrayList<String> uiList = new ArrayList<String>();
            uiList.add(ui);
            oi.setUniqueIdentifierList(uiList);
            this.checkValue(tRP, (byte)87, (byte)5, 1);
            TTLVEnumeration tOT = (TTLVEnumeration)tRP.getValueList((byte)87).get(0);
            TTLVStructure tKB = null;
            switch (tOT.getValue()) {
                case 2: {
                    this.checkValue(tRP, (byte)-113, (byte)1, 1);
                    TTLVStructure tSK = (TTLVStructure)tRP.getValueList((byte)-113).get(0);
                    this.checkValue(tSK, (byte)64, (byte)1, 1);
                    tKB = (TTLVStructure)tSK.getValueList((byte)64).get(0);
                    this.checkValue(tKB, (byte)40, (byte)5, 1);
                    TTLVEnumeration tCA = (TTLVEnumeration)tKB.getValueList((byte)40).get(0);
                    oi.setCryptographicAlgorithm(tCA.getValue());
                    this.checkValue(tKB, (byte)42, (byte)2, 1);
                    TTLVInteger tCL = (TTLVInteger)tKB.getValueList((byte)42).get(0);
                    oi.setCryptographicLength(tCL.getValue());
                    break;
                }
                case 7: {
                    this.checkValue(tRP, (byte)-123, (byte)1, 1);
                    TTLVStructure tSD = (TTLVStructure)tRP.getValueList((byte)-123).get(0);
                    this.checkValue(tSD, (byte)64, (byte)1, 1);
                    tKB = (TTLVStructure)tSD.getValueList((byte)64).get(0);
                    break;
                }
                default: {
                    throw new ResponseException();
                }
            }
            this.checkValue(tKB, (byte)69, (byte)1, 1);
            TTLVStructure tKV = (TTLVStructure)tKB.getValueList((byte)69).get(0);
            this.checkValue(tKB, (byte)66, (byte)5, 1);
            TTLVEnumeration tKFT = (TTLVEnumeration)tKB.getValueList((byte)66).get(0);
            int keyFormatType = tKFT.getValue();
            if (keyFormatType == 7) {
                this.checkValue(tKV, (byte)67, (byte)1, 1);
                tKM = (TTLVStructure)tKV.getValueList((byte)67).get(0);
                this.checkValue((TTLVStructure)tKM, (byte)63, (byte)8, 1);
                TTLVByteString tK = (TTLVByteString)((TTLVStructure)tKM).getValueList((byte)63).get(0);
                oi.setBackupData(tK.getValueByString());
            } else if (keyFormatType == 2 || keyFormatType == 1) {
                this.checkValue(tKV, (byte)67, (byte)8, 1);
                tKM = (TTLVByteString)tKV.getValueList((byte)67).get(0);
                oi.setBackupData(((TTLVByteString)tKM).getValueByString());
            } else {
                throw new ResponseException();
            }
        }
        oiList.add(oi);
        ki.setOutputInfo(oiList);
        STD_LOGGER.info(module, method, " - ", " - end");
    }
}

