/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.kms.kmip.client.factory;

import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.kms.kmip.client.communicate.Connector;
import sanproject.sn2.kms.kmip.client.convert.Converter;
import sanproject.sn2.kms.kmip.client.convert.ConverterActivate;
import sanproject.sn2.kms.kmip.client.convert.ConverterAddAttribute;
import sanproject.sn2.kms.kmip.client.convert.ConverterCheck;
import sanproject.sn2.kms.kmip.client.convert.ConverterCreate;
import sanproject.sn2.kms.kmip.client.convert.ConverterDeleteAttribute;
import sanproject.sn2.kms.kmip.client.convert.ConverterDestroy;
import sanproject.sn2.kms.kmip.client.convert.ConverterDiscoverVersions;
import sanproject.sn2.kms.kmip.client.convert.ConverterGet;
import sanproject.sn2.kms.kmip.client.convert.ConverterGetAttributeList;
import sanproject.sn2.kms.kmip.client.convert.ConverterGetAttributes;
import sanproject.sn2.kms.kmip.client.convert.ConverterLocate;
import sanproject.sn2.kms.kmip.client.convert.ConverterModifyAttribute;
import sanproject.sn2.kms.kmip.client.convert.ConverterQuery;
import sanproject.sn2.kms.kmip.client.convert.ConverterRegister;
import sanproject.sn2.kms.kmip.client.convert.ConverterRevoke;
import sanproject.sn2.kms.kmip.client.exception.KMSConfigException;
import sanproject.sn2.kms.kmip.client.exception.KeyInfoBlankException;
import sanproject.sn2.kms.kmip.client.exception.KmsCommunicationException;
import sanproject.sn2.kms.kmip.client.exception.KmsTimeoutException;
import sanproject.sn2.kms.kmip.client.exception.NotSupportedFunctionException;
import sanproject.sn2.kms.kmip.client.exception.ReadPropertyFileException;
import sanproject.sn2.kms.kmip.client.exception.RequestCommandException;
import sanproject.sn2.kms.kmip.client.info.KeyInfo;
import sanproject.sn2.kms.kmip.client.ttlv.TTLV;
import sanproject.sn2.kms.util.SJkmsLogUtil;

public class KmipKeyManagementInterface {
    private static final String module = "KmipKeyManagementInterface";

    public KeyInfo execute(String function, KeyInfo keyInfo) throws NotSupportedFunctionException, KeyInfoBlankException, ReadPropertyFileException, RequestCommandException, KMSConfigException, KmsCommunicationException, KmsTimeoutException {
        String method = "execute";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        if (function == null || function.length() == 0) {
            STD_LOGGER.info(module, method, " - check the function", " - improper function is selected");
            throw new NotSupportedFunctionException();
        }
        Converter converter = this.makeConverterOperation(function);
        if (converter == null) {
            STD_LOGGER.info(module, method, " - check the function", " - improper function is selected");
            throw new NotSupportedFunctionException();
        }
        Connector connector = new Connector();
        TTLV ttlv_send = converter.makeSendTTLV(keyInfo);
        TTLV ttlv_recv = connector.sendMessageToKMS(keyInfo, ttlv_send);
        if (ttlv_recv != null) {
            converter.parseResvTTLV(ttlv_recv, keyInfo);
        }
        return keyInfo;
    }

    private Converter makeConverterOperation(String function) {
        String method = "makeConverterOperation";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(module, method, " - ", " - start");
        Converter converter = null;
        int func = 0;
        try {
            func = Integer.decode(function);
        }
        catch (NumberFormatException e) {
            STD_LOGGER.info(module, method, " - check the String of Number", " - improper Number Format");
            throw new NumberFormatException();
        }
        switch (func) {
            case 1: {
                STD_LOGGER.info(module, method, " - check the function", " - Create");
                converter = new ConverterCreate();
                break;
            }
            case 3: {
                STD_LOGGER.info(module, method, " - check the function", " - Register");
                converter = new ConverterRegister();
                break;
            }
            case 8: {
                STD_LOGGER.info(module, method, " - check the function", " - Locate");
                converter = new ConverterLocate();
                break;
            }
            case 10: {
                STD_LOGGER.info(module, method, " - check the function", " - Get");
                converter = new ConverterGet();
                break;
            }
            case 20: {
                STD_LOGGER.info(module, method, " - check the function", " - Destroy");
                converter = new ConverterDestroy();
                break;
            }
            case 11: {
                STD_LOGGER.info(module, method, " - check the function", " - GetAttributes");
                converter = new ConverterGetAttributes();
                break;
            }
            case 12: {
                STD_LOGGER.info(module, method, " - check the function", " - GetAttributeList");
                converter = new ConverterGetAttributeList();
                break;
            }
            case 13: {
                STD_LOGGER.info(module, method, " - check the function", " - AddAttribute");
                converter = new ConverterAddAttribute();
                break;
            }
            case 15: {
                STD_LOGGER.info(module, method, " - check the function", " - DeleteAttribute");
                converter = new ConverterDeleteAttribute();
                break;
            }
            case 24: {
                STD_LOGGER.info(module, method, " - check the function", " - Query");
                converter = new ConverterQuery();
                break;
            }
            case 14: {
                STD_LOGGER.info(module, method, " - check the function", " - ModifyAttribute");
                converter = new ConverterModifyAttribute();
                break;
            }
            case 9: {
                STD_LOGGER.info(module, method, " - check the function", " - Check");
                converter = new ConverterCheck();
                break;
            }
            case 18: {
                STD_LOGGER.info(module, method, " - check the function", " - Activate");
                converter = new ConverterActivate();
                break;
            }
            case 19: {
                STD_LOGGER.info(module, method, " - check the function", " - Revoke");
                converter = new ConverterRevoke();
                break;
            }
            case 30: {
                STD_LOGGER.info(module, method, " - check the function", " - DiscoverVersions");
                converter = new ConverterDiscoverVersions();
            }
        }
        STD_LOGGER.info(module, method, " - ", " - end");
        return converter;
    }
}

