/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.kms.util;

import java.io.ByteArrayOutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import sanproject.sn2.base.property.SJbaseSystemPropertiesManager;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcSecureUty;
import sanproject.sn2.com.utility.SJcStringUty;
import sanproject.sn2.kms.common.SJkmsBackupInfo;
import sanproject.sn2.kms.common.SJkmsCreateInfo;
import sanproject.sn2.kms.common.SJkmsDeleteInfo;
import sanproject.sn2.kms.common.SJkmsReferInfo;
import sanproject.sn2.kms.common.SJkmsRestoreInfo;
import sanproject.sn2.kms.exception.SJkmsCommunicationException;
import sanproject.sn2.kms.exception.SJkmsKeystoreUtyException;
import sanproject.sn2.kms.kmip.SJkmsKmipConst;
import sanproject.sn2.kms.kmip.client.exception.KMSConfigException;
import sanproject.sn2.kms.kmip.client.exception.KeyInfoBlankException;
import sanproject.sn2.kms.kmip.client.exception.KmsTimeoutException;
import sanproject.sn2.kms.kmip.client.exception.NotSupportedFunctionException;
import sanproject.sn2.kms.kmip.client.exception.ReadPropertyFileException;
import sanproject.sn2.kms.kmip.client.exception.RequestCommandException;
import sanproject.sn2.kms.kmip.client.factory.KmipKeyManagementInterface;
import sanproject.sn2.kms.kmip.client.info.InputInfo;
import sanproject.sn2.kms.kmip.client.info.KeyInfo;
import sanproject.sn2.kms.kmip.client.info.OutputInfo;
import sanproject.sn2.kms.kmip.client.info.common.Revocation;
import sanproject.sn2.kms.kmip.client.util.KmsConfiguration;
import sanproject.sn2.kms.kmip.client.util.KmsConfigurationFactory;
import sanproject.sn2.kms.util.SJkmsConfigUty;
import sanproject.sn2.kms.util.SJkmsConfigUtyCom;
import sanproject.sn2.kms.util.SJkmsKeystoreUty;
import sanproject.sn2.kms.util.SJkmsLogUtil;

public class SJkmsCommunicationUty {
    private static final String LOG_FUNCTION = "Kms";
    private static final String LOG_TITLE = "SJkmsCommunicationUty";
    public static final String KEK_MODE = "KEK_MODE";
    public static final String DEK_MODE = "DEK_MODE";
    private SJbaseSystemPropertiesManager sysPropMgr = null;

    private SJkmsCommunicationUty() {
    }

    public void initialize() {
        System.setProperty("SN_LogPath", "KMS");
        String basePath = SJcEnvUty.getSnBasePath();
        String dataPath = System.getProperty("SN_DataPath");
        String envPath = System.getProperty("SN_EnvFile");
        String envvPath = System.getProperty("SN_EnvFileV");
        if (null == dataPath || null != dataPath && 0 >= dataPath.length()) {
            System.setProperty("SN_DataPath", basePath + "san\\SN2\\SN2Files");
        }
        if (null == envPath || null != envPath && 0 >= envPath.length()) {
            System.setProperty("SN_EnvFile", basePath + "san\\SN2\\SN2Files\\data\\base\\setting\\system\\properties\\SN2_Startup.properties");
        }
        if (null == envvPath || null != envvPath && 0 >= envvPath.length()) {
            System.setProperty("SN_EnvFileV", basePath + "san\\SN2\\SN2Files\\data\\base\\setting\\system\\properties\\SN2_StartupV.properties");
        }
        this.sysPropMgr = new SJbaseSystemPropertiesManager();
        this.sysPropMgr.initialize(0);
    }

    public static SJkmsCreateInfo create(String productID) throws SJkmsCommunicationException {
        return SJkmsCommunicationUty.create(productID, 1, SJkmsCommunicationUty.getKekKeyStr()).get(0);
    }

    public static List<SJkmsCreateInfo> create(String productID, int keynum) throws SJkmsCommunicationException {
        return SJkmsCommunicationUty.create(productID, keynum, SJkmsCommunicationUty.getDekKeyStr());
    }

    private static List<SJkmsCreateInfo> create(String productID, int keynum, String sortofData) throws SJkmsCommunicationException {
        String LOG_SUBTITLE = "create";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "create", "start");
        if (productID == null || productID.length() == 0 || keynum == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "create", "Parameter is null");
            throw new SJkmsCommunicationException("107001");
        }
        productID = SJkmsConfigUtyCom.convertProductID(productID);
        String type = null;
        ArrayList<SJkmsCreateInfo> ret = new ArrayList<SJkmsCreateInfo>();
        SJkmsCreateInfo createInfo = null;
        type = SJkmsConfigUty.getType();
        if ("kmip".equals(type)) {
            KeyInfo keyinfo = null;
            keyinfo = SJkmsCommunicationUty.getKmsSettings(STD_LOGGER, "create");
            STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "create", "Create Keys on Server start");
            int splitLoop = 0;
            int keynumLoop = 0;
            int keynumLast = 0;
            if (keynum > 64) {
                if (keynum % 64 == 0) {
                    splitLoop = keynum / 64;
                    keynumLast = 64;
                } else {
                    splitLoop = keynum / 64 + 1;
                    keynumLast = keynum - 64 * (splitLoop - 1);
                }
            } else {
                splitLoop = 1;
                keynumLast = keynum;
            }
            for (int loopcnt = 0; loopcnt < splitLoop; ++loopcnt) {
                keynumLoop = loopcnt == splitLoop - 1 ? keynumLast : 64;
                STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "create", "Create Keys loopcnt:" + loopcnt + " keynum:" + keynumLoop);
                InputInfo inputinfo = new InputInfo();
                inputinfo.setRequiredKeyNum(keynumLoop);
                inputinfo.setSortOfData(sortofData);
                inputinfo.setProductID(SJkmsCommunicationUty.getModelStr() + productID);
                keyinfo.setInputInfo(inputinfo);
                keyinfo.setOutputInfo(null);
                String function = "0x00000001";
                SJkmsCommunicationException e = null;
                try {
                    keyinfo = SJkmsCommunicationUty.runConnection(function, keyinfo, STD_LOGGER, "create");
                }
                catch (SJkmsCommunicationException ex) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "create", "Create Keys on Server failed");
                    e = ex;
                }
                STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "create", "Create Keys on Server end");
                boolean createSuccess = true;
                ArrayList<OutputInfo> outputInfoList = keyinfo.getOutputInfoList();
                if (outputInfoList == null || outputInfoList.size() != keynumLoop) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "create", "Created key number does not match with expectation");
                    createSuccess = false;
                }
                ArrayList<String> uuidList = new ArrayList<String>();
                if (createSuccess) {
                    for (OutputInfo outputInfo : outputInfoList) {
                        if (!"0:Success".equals(outputInfo.getResultStatus())) {
                            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "create", "Failed status exists");
                            createSuccess = false;
                            continue;
                        }
                        String uuid = outputInfo.getUniqueIdentifierList().get(0);
                        if (uuid == null || uuid.length() == 0) {
                            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "create", "UUID is null");
                            createSuccess = false;
                            continue;
                        }
                        uuidList.add(uuid);
                    }
                }
                if (createSuccess) {
                    STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "create", "Get Keys from Server start");
                    for (String uuid : uuidList) {
                        inputinfo = new InputInfo();
                        inputinfo.setUniqueIndetifier(uuid);
                        keyinfo.setInputInfo(inputinfo);
                        keyinfo.setOutputInfo(null);
                        function = "0x0000000A";
                        try {
                            keyinfo = SJkmsCommunicationUty.runConnection(function, keyinfo, STD_LOGGER, "create");
                        }
                        catch (SJkmsCommunicationException ex) {
                            e = ex;
                        }
                        ArrayList<OutputInfo> outputCheck = keyinfo.getOutputInfoList();
                        if (outputCheck == null) {
                            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "create", "OutputInfo is null");
                            createSuccess = false;
                        }
                        if (createSuccess) {
                            String strdek = keyinfo.getOutputInfoList().get(0).getBackupData();
                            if (strdek == null || strdek.length() == 0) {
                                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "create", "Key Data is null");
                                createSuccess = false;
                            } else {
                                createInfo = new SJkmsCreateInfo();
                                createInfo.setUUID(uuid);
                                createInfo.setCreateDataDEK(SJcStringUty.hexStringToByte(strdek));
                                ret.add(createInfo);
                            }
                        }
                        if (createSuccess) continue;
                        break;
                    }
                    STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "create", "Get Keys from Server end");
                }
                STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "create", "Destroy Keys on Server start");
                ArrayList<OutputInfo> deleteKekResultInfoList = SJkmsCommunicationUty.deleteKek(uuidList);
                STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "create", "Destroy Keys on Server end");
                if (createSuccess && e == null) continue;
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "create", "Create Key failed");
                if (e != null) {
                    throw e;
                }
                throw new SJkmsCommunicationException("105005");
            }
        } else {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "create", "Illigal Server Type");
            throw new SJkmsCommunicationException("105018");
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "create", "end");
        return ret;
    }

    public static SJkmsBackupInfo backup(String productID, SJkmsBackupInfo backupinfo) throws SJkmsCommunicationException {
        String uuidDEK;
        String LOG_SUBTITLE = "backup";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "backup", "start");
        if (productID == null || productID.length() == 0 || backupinfo == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "backup", "Parameter is null");
            throw new SJkmsCommunicationException("107001");
        }
        if (backupinfo.getBackupComment() == null || backupinfo.getBackupDataDEK() == null || backupinfo.getBackupDataDEK().length == 0 || backupinfo.getBackupDataPASSWD() == null || backupinfo.getBackupDataPASSWD().length == 0 || backupinfo.getBackupTaskname() == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "backup", "Parameter Error in SJkmsBackupInfo");
            throw new SJkmsCommunicationException("107001");
        }
        productID = SJkmsConfigUtyCom.convertProductID(productID);
        if (!backupinfo.getRegularBackup()) {
            ArrayList<String> alreadyList = SJkmsCommunicationUty.getKeyList(productID, DEK_MODE, false);
            int maxNum = SJcEnvUty.getProperty2int("KMS_NUM_MAXREGIST", 256);
            if (alreadyList.size() >= maxNum) {
                throw new SJkmsCommunicationException("105001");
            }
        }
        String type = null;
        SJkmsBackupInfo ret = backupinfo;
        type = SJkmsConfigUty.getType();
        if ("kmip".equals(type)) {
            KeyInfo keyinfo = null;
            keyinfo = SJkmsCommunicationUty.getKmsSettings(STD_LOGGER, "backup");
            STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "backup", "Register KEK start");
            byte[] passwd = null;
            String passwdhash = null;
            try {
                passwd = backupinfo.getBackupDataPASSWD();
                passwdhash = SJcSecureUty.getHashValueByteHex(passwd);
            }
            catch (SJcException ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "backup", "Unable to get Hash code");
                throw new SJkmsCommunicationException(ex, "107001");
            }
            String password = null;
            try {
                password = SJcStringUty.byteToHexString(passwd);
            }
            catch (SJcException ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "backup", "Unable to encrypt password");
                throw new SJkmsCommunicationException(ex, "107001");
            }
            String strdate = null;
            try {
                Date date = new Date();
                ret.setBackupDate(date);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                strdate = sdf.format(date);
            }
            catch (Exception ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "backup", "Unable to get Current Date and Time");
                throw new SJkmsCommunicationException(ex, "107001");
            }
            InputInfo inputinfo = new InputInfo();
            inputinfo.setSortOfData(SJkmsCommunicationUty.getKekKeyStr());
            inputinfo.setProductID(SJkmsCommunicationUty.getModelStr() + productID);
            inputinfo.setBackupData(password);
            inputinfo.setBackupDate(strdate);
            inputinfo.setBackupTaskName(backupinfo.getBackupTaskname());
            inputinfo.setHashAlgrithm(0);
            inputinfo.setHash(String.valueOf(passwdhash));
            inputinfo.setKeyMaterialFormatID(11);
            inputinfo.setRegularBackup(backupinfo.getRegularBackup());
            keyinfo.setInputInfo(inputinfo);
            keyinfo.setOutputInfo(null);
            String function = "0x00000003";
            keyinfo = SJkmsCommunicationUty.runConnection(function, keyinfo, STD_LOGGER, "backup");
            STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "backup", "Register KEK end");
            ArrayList<String> uiList = keyinfo.getOutputInfoList().get(0).getUniqueIdentifierList();
            keyinfo = SJkmsCommunicationUty.stateActivate(uiList, keyinfo);
            STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "backup", "Register DEK start");
            String uuidKEK = keyinfo.getOutputInfoList().get(0).getUniqueIdentifierList().get(0);
            byte[] dek = backupinfo.getBackupDataDEK();
            ArrayList<byte[]> spDek = null;
            STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "backup", "splitDEK executed. Original DEK size = " + dek.length + " byte");
            spDek = SJkmsCommunicationUty.splitDEK(dek);
            if (spDek == null) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "backup", "Illegal split DEK.");
                throw new SJkmsCommunicationException("107001");
            }
            STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "backup", "splitDEK executed. Reduced split DEK num = " + spDek.size());
            uuidDEK = null;
            for (int sCnt = 0; sCnt < spDek.size(); ++sCnt) {
                String dekhash = null;
                String strdek = null;
                try {
                    dekhash = SJcSecureUty.getHashValueByteHex(spDek.get(sCnt));
                    strdek = SJcStringUty.byteToHexString(spDek.get(sCnt));
                }
                catch (SJcException ex) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "backup", "Unable to get Hash code");
                    throw new SJkmsCommunicationException(ex, "107001");
                }
                inputinfo = new InputInfo();
                inputinfo.setSortOfData(SJkmsCommunicationUty.getDekKeyStr());
                inputinfo.setProductID(SJkmsCommunicationUty.getModelStr() + productID);
                inputinfo.setBackupData(strdek);
                inputinfo.setBackupDataSize(spDek.get(sCnt).length);
                inputinfo.setBackupDate(strdate);
                inputinfo.setBackupTaskName(backupinfo.getBackupTaskname());
                inputinfo.setBackupComment(backupinfo.getBackupComment());
                inputinfo.setHashAlgrithm(0);
                inputinfo.setHash(dekhash);
                inputinfo.setUniqueIndetifier(uuidKEK);
                inputinfo.setAddAttributeDate(strdate);
                inputinfo.setSplitFlag(false);
                inputinfo.setSplitNum(spDek.size());
                inputinfo.setSplitID(sCnt);
                inputinfo.setKeyMaterialFormatID(10);
                inputinfo.setRegularBackup(backupinfo.getRegularBackup());
                keyinfo.setInputInfo(inputinfo);
                keyinfo.setOutputInfo(null);
                function = "0x00000003";
                keyinfo = SJkmsCommunicationUty.runConnection(function, keyinfo, STD_LOGGER, "backup");
                uiList = keyinfo.getOutputInfoList().get(0).getUniqueIdentifierList();
                keyinfo = SJkmsCommunicationUty.stateActivate(uiList, keyinfo);
                if (sCnt != 0) continue;
                uuidDEK = keyinfo.getOutputInfoList().get(0).getUniqueIdentifierList().get(0);
            }
        } else {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "backup", "Illigal Server Type");
            throw new SJkmsCommunicationException("105018");
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "backup", "Register DEK end");
        ret.setUUID(uuidDEK);
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "backup", "end");
        return ret;
    }

    public static List<SJkmsReferInfo> refer(String productID) throws SJkmsCommunicationException {
        String LOG_SUBTITLE = "refer";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "refer", "start");
        if (productID == null || productID.length() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "refer", "Parameter is null");
            throw new SJkmsCommunicationException("107001");
        }
        productID = SJkmsConfigUtyCom.convertProductID(productID);
        String type = null;
        ArrayList<SJkmsReferInfo> ret = new ArrayList<SJkmsReferInfo>();
        type = SJkmsConfigUty.getType();
        if ("kmip".equals(type)) {
            KeyInfo keyinfo = null;
            keyinfo = SJkmsCommunicationUty.getKmsSettings(STD_LOGGER, "refer");
            ArrayList<String> uuidlist = SJkmsCommunicationUty.getKeyList(productID, DEK_MODE, true);
            if (uuidlist.size() > 0) {
                STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "refer", "GetAttributes DEK start");
                int partingNum = SJcEnvUty.getProperty2int("KMS_NUM_GETA_REFER", 34);
                int partingCnt = 0;
                partingCnt = uuidlist.size() > partingNum ? (uuidlist.size() % partingNum == 0 ? uuidlist.size() / partingNum : uuidlist.size() / partingNum + 1) : 1;
                for (int i = 0; i < partingCnt; ++i) {
                    ArrayList<String> inputuuidlist = new ArrayList<String>();
                    for (int j = i * partingNum; j < (i + 1) * partingNum; ++j) {
                        if (j >= uuidlist.size()) continue;
                        inputuuidlist.add(uuidlist.get(j));
                    }
                    if (inputuuidlist.size() > partingNum) {
                        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "refer", "GetAttributes Error");
                        throw new SJkmsCommunicationException("107001");
                    }
                    InputInfo inputinfo = new InputInfo();
                    inputinfo.setLocatedUniqueIdentifierList(inputuuidlist);
                    inputinfo.setInfo("ReferData");
                    keyinfo.setInputInfo(inputinfo);
                    keyinfo.setOutputInfo(null);
                    String function = "0x0000000B";
                    keyinfo = SJkmsCommunicationUty.runConnection(function, keyinfo, STD_LOGGER, "refer");
                    ArrayList<OutputInfo> outputInfoList = keyinfo.getOutputInfoList();
                    if (outputInfoList == null || outputInfoList.size() != inputuuidlist.size()) {
                        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "refer", "refer key number does not match with expectation");
                        throw new SJkmsCommunicationException("105004");
                    }
                    SJkmsCommunicationUty.checkGetAttributes(outputInfoList);
                    for (OutputInfo outinfo : keyinfo.getOutputInfoList()) {
                        Date date;
                        if (outinfo.getUniqueIdentifierList() == null || outinfo.getUniqueIdentifierList().get(0) == null) continue;
                        SJkmsReferInfo info = new SJkmsReferInfo();
                        info.setUUID(outinfo.getUniqueIdentifierList().get(0));
                        String comment = outinfo.getBackupComment();
                        if (comment == null) {
                            comment = "";
                        }
                        info.setBackupComment(outinfo.getBackupComment());
                        info.setBackupComment(comment);
                        String strdate = outinfo.getBackupDate();
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                        try {
                            date = sdf.parse(strdate);
                        }
                        catch (ParseException e) {
                            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "refer", "get Backup Date Failed");
                            throw new SJkmsCommunicationException("107001");
                        }
                        info.setBackupDate(date);
                        info.setRegularBackup(outinfo.getRegularBackup());
                        ret.add(info);
                    }
                }
                STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "refer", "GetAttributes DEK end");
            } else {
                STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "refer", "GetAttributes Skipped");
            }
        } else {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "refer", "Illigal Server Type");
            throw new SJkmsCommunicationException("105018");
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "refer", "end");
        return ret;
    }

    public static void check(String type, String productID, Properties properties, HashMap<String, KeyManager[]> keymanager, boolean keyStoreUpdate, HashMap<String, TrustManager[]> trustmanager, boolean trustStoreUpdate, String password) throws SJkmsCommunicationException {
        String LOG_SUBTITLE = "check";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "check", "start");
        if (productID == null || productID.length() == 0 || properties == null || keymanager == null || trustmanager == null || keymanager.size() == 0 || trustmanager.size() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "check", "Parameter is null");
            throw new SJkmsCommunicationException("107001");
        }
        productID = SJkmsConfigUtyCom.convertProductID(productID);
        if ("kmip".equals(type)) {
            KeyInfo keyinfo = new KeyInfo();
            keyinfo.setProperties(properties);
            keyinfo.setKeyManager(keymanager);
            keyinfo.setTrustManager(trustmanager);
            keyinfo.setKeyStoreUpdateMode(keyStoreUpdate);
            keyinfo.setTrustStoreUpdateMode(trustStoreUpdate);
            keyinfo.setPassword(password);
            STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "check", "Test Locate start");
            InputInfo inputinfo = new InputInfo();
            inputinfo.setSortOfData(SJkmsCommunicationUty.getDekKeyStr());
            inputinfo.setProductID(SJkmsCommunicationUty.getModelStr() + productID);
            inputinfo.setSplitFlag(true);
            keyinfo.setInputInfo(inputinfo);
            keyinfo.setOutputInfo(null);
            String function = "0x00000008";
            keyinfo = SJkmsCommunicationUty.runConnection(function, keyinfo, STD_LOGGER, "check");
        } else {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "check", "Illigal Server Type");
            throw new SJkmsCommunicationException("105018");
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "check", "Test Locate end");
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "check", "end");
    }

    public static SJkmsRestoreInfo restore(String productID, String uuid) throws SJkmsCommunicationException {
        byte[] password;
        String LOG_SUBTITLE = "restore";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "restore", "start");
        if (productID == null || productID.length() == 0 || uuid == null || uuid.length() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "restore", "Parameter is null");
            throw new SJkmsCommunicationException("107001");
        }
        productID = SJkmsConfigUtyCom.convertProductID(productID);
        String type = null;
        SJkmsRestoreInfo ret = new SJkmsRestoreInfo();
        type = SJkmsConfigUty.getType();
        if ("kmip".equals(type)) {
            KeyInfo keyinfo = null;
            keyinfo = SJkmsCommunicationUty.getKmsSettings(STD_LOGGER, "restore");
            STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "restore", "Getattributes DEK start");
            InputInfo inputinfo = new InputInfo();
            ArrayList<String> uuidlist = new ArrayList<String>();
            uuidlist.add(uuid);
            inputinfo.setLocatedUniqueIdentifierList(uuidlist);
            inputinfo.setInfo("GetSplitInfo");
            keyinfo.setInputInfo(inputinfo);
            keyinfo.setOutputInfo(null);
            String function = "0x0000000B";
            keyinfo = SJkmsCommunicationUty.runConnection(function, keyinfo, STD_LOGGER, "restore");
            STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "restore", "Getattributes DEK end");
            ArrayList<OutputInfo> outputInfoList = keyinfo.getOutputInfoList();
            if (outputInfoList == null || outputInfoList.size() == 0) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "restore", "restore UUID does not match with expectation");
                throw new SJkmsCommunicationException("107001");
            }
            SJkmsCommunicationUty.checkGetAttributes(outputInfoList);
            OutputInfo outinfo = (OutputInfo)outputInfoList.get(0);
            int split_num = outinfo.getSplitNum();
            String kekuuid = outinfo.getBackupKEKUID();
            if (kekuuid == null || kekuuid.length() == 0) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "restore", "KEK UUID is null");
                throw new SJkmsCommunicationException("107001");
            }
            STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "restore", "locate DEK start");
            inputinfo = new InputInfo();
            inputinfo.setSortOfData(SJkmsCommunicationUty.getDekKeyStr());
            inputinfo.setProductID(SJkmsCommunicationUty.getModelStr() + productID);
            inputinfo.setSplitFlag(false);
            inputinfo.setUniqueIdentifier(kekuuid);
            keyinfo.setInputInfo(inputinfo);
            keyinfo.setOutputInfo(null);
            function = "0x00000008";
            keyinfo = SJkmsCommunicationUty.runConnection(function, keyinfo, STD_LOGGER, "restore");
            STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "restore", "locate DEK end");
            uuidlist = keyinfo.getOutputInfoList().get(0).getUniqueIdentifierList();
            if (split_num != uuidlist.size()) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "restore", "restore split_num does not match with expectation");
                throw new SJkmsCommunicationException("107001");
            }
            ArrayList<String> alStrdek = new ArrayList<String>();
            ArrayList<byte[]> alDek = new ArrayList<byte[]>();
            ArrayList<Integer> alSplitId = new ArrayList<Integer>();
            int backupDataSize = 0;
            for (int i = 0; i < uuidlist.size(); ++i) {
                STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "restore", "Get DEK start");
                inputinfo = new InputInfo();
                inputinfo.setUniqueIndetifier(uuidlist.get(i));
                keyinfo.setInputInfo(inputinfo);
                keyinfo.setOutputInfo(null);
                function = "0x0000000A";
                keyinfo = SJkmsCommunicationUty.runConnection(function, keyinfo, STD_LOGGER, "restore");
                STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "restore", "Get DEK end");
                alStrdek.add(keyinfo.getOutputInfoList().get(0).getBackupData());
                if (alStrdek.get(i) == null || ((String)alStrdek.get(i)).length() == 0) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "restore", "DEK is null");
                    throw new SJkmsCommunicationException("107001");
                }
                STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "restore", "GetAttributes DEK start");
                inputinfo = new InputInfo();
                ArrayList<String> tmpuuidlist = new ArrayList<String>();
                tmpuuidlist.add(uuidlist.get(i));
                inputinfo.setLocatedUniqueIdentifierList(tmpuuidlist);
                inputinfo.setInfo("GetDEKData");
                keyinfo.setInputInfo(inputinfo);
                keyinfo.setOutputInfo(null);
                function = "0x0000000B";
                keyinfo = SJkmsCommunicationUty.runConnection(function, keyinfo, STD_LOGGER, "restore");
                STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "restore", "GetAttributes DEK end");
                outputInfoList = keyinfo.getOutputInfoList();
                if (outputInfoList == null || outputInfoList.size() == 0) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "restore", "restore GETDEK does not match with expectation");
                    throw new SJkmsCommunicationException("107001");
                }
                SJkmsCommunicationUty.checkGetAttributes(outputInfoList);
                OutputInfo wkInfo = keyinfo.getOutputInfoList().get(0);
                byte[] byDek = null;
                if (0 == wkInfo.getHashAlgrithm()) {
                    String dekhash = wkInfo.getHash();
                    String ndekhash = null;
                    try {
                        byDek = SJcStringUty.hexStringToByte((String)alStrdek.get(i));
                        ndekhash = SJcSecureUty.getHashValueByteHex(byDek);
                    }
                    catch (SJcException ex) {
                        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "restore", "Unable to get Hash code");
                        throw new SJkmsCommunicationException(ex, "107001");
                    }
                    if (!dekhash.equals(ndekhash)) {
                        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "restore", "DEK Hash Comparation Error");
                        throw new SJkmsCommunicationException("105007");
                    }
                } else {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "restore", "Illigal Hash Algorithm");
                    throw new SJkmsCommunicationException("107001");
                }
                alDek.add(byDek);
                backupDataSize += wkInfo.getBackupDataSize();
                STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "restore", "GetSplitInfo DEK start");
                inputinfo = new InputInfo();
                inputinfo.setLocatedUniqueIdentifierList(tmpuuidlist);
                inputinfo.setInfo("GetSplitInfo");
                keyinfo.setInputInfo(inputinfo);
                keyinfo.setOutputInfo(null);
                function = "0x0000000B";
                keyinfo = SJkmsCommunicationUty.runConnection(function, keyinfo, STD_LOGGER, "restore");
                STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "restore", "GetSplitInfo DEK end");
                outputInfoList = keyinfo.getOutputInfoList();
                if (outputInfoList == null || outputInfoList.size() == 0) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "restore", "restore GetSplitInfo DEK does not match with expectation");
                    throw new SJkmsCommunicationException("107001");
                }
                SJkmsCommunicationUty.checkGetAttributes(outputInfoList);
                wkInfo = keyinfo.getOutputInfoList().get(0);
                alSplitId.add(wkInfo.getSplitID());
            }
            byte[] dek = null;
            dek = SJkmsCommunicationUty.concatenateDEK(alDek, alSplitId);
            if (dek == null) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "restore", "Illegal DEK split. split_num = " + split_num + ".");
                throw new SJkmsCommunicationException("107001");
            }
            if (dek.length != backupDataSize) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "restore", "Illegal DEK format(cannot be decompressed normaly). BackupDataSize = " + backupDataSize + " byte");
                throw new SJkmsCommunicationException("107001");
            }
            ret.setBackupDataDEK(dek);
            STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "restore", "Get KEK start");
            inputinfo = new InputInfo();
            inputinfo.setUniqueIndetifier(kekuuid);
            keyinfo.setInputInfo(inputinfo);
            keyinfo.setOutputInfo(null);
            function = "0x0000000A";
            keyinfo = SJkmsCommunicationUty.runConnection(function, keyinfo, STD_LOGGER, "restore");
            STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "restore", "Get KEK end");
            String strkek = keyinfo.getOutputInfoList().get(0).getBackupData();
            if (strkek == null || strkek.length() == 0) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "restore", "KEK was empty");
                throw new SJkmsCommunicationException("107001");
            }
            STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "restore", "GetAttributes KEK start");
            inputinfo = new InputInfo();
            ArrayList<String> kekuuidlist = new ArrayList<String>();
            kekuuidlist.add(kekuuid);
            inputinfo.setLocatedUniqueIdentifierList(kekuuidlist);
            inputinfo.setInfo("GetKEKData");
            keyinfo.setInputInfo(inputinfo);
            keyinfo.setOutputInfo(null);
            function = "0x0000000B";
            keyinfo = SJkmsCommunicationUty.runConnection(function, keyinfo, STD_LOGGER, "restore");
            STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "restore", "GetAttributes KEK end");
            outputInfoList = keyinfo.getOutputInfoList();
            if (outputInfoList == null || outputInfoList.size() == 0) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "restore", "restore GetSplitInfo DEK does not match with expectation");
                throw new SJkmsCommunicationException("107001");
            }
            SJkmsCommunicationUty.checkGetAttributes(outputInfoList);
            OutputInfo info = keyinfo.getOutputInfoList().get(0);
            if (info == null || info.getHash() == null) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "restore", "restore OutputInfo does not match with expectation");
                throw new SJkmsCommunicationException("107001");
            }
            if (0 == info.getHashAlgrithm()) {
                String kekhash = info.getHash();
                byte[] kek = null;
                String ndekhash = null;
                try {
                    kek = SJcStringUty.hexStringToByte(strkek);
                    ndekhash = SJcSecureUty.getHashValueByteHex(kek);
                }
                catch (SJcException ex) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "restore", "Unable to get Hash code");
                    throw new SJkmsCommunicationException(ex, "107001");
                }
                if (!kekhash.equals(ndekhash)) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "restore", "KEK Hash Comparation Error");
                    throw new SJkmsCommunicationException("105008");
                }
                password = null;
                try {
                    password = kek;
                }
                catch (SJcException ex) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "restore", "Unable to decrypt password");
                    throw new SJkmsCommunicationException(ex, "107001");
                }
            }
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "restore", "Illigal Hash Algorithm");
            throw new SJkmsCommunicationException("107001");
        }
        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "restore", "Illigal Server Type");
        throw new SJkmsCommunicationException("105018");
        ret.setBackupDataPASSWD(password);
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "restore", "end");
        return ret;
    }

    public static List<SJkmsDeleteInfo> delete(String productID, List<String> uuidlist) throws SJkmsCommunicationException {
        String LOG_SUBTITLE = "delete";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "delete", "start");
        if (productID == null || productID.length() == 0 || uuidlist == null || uuidlist.size() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "delete", "Parameter is null");
            throw new SJkmsCommunicationException("107001");
        }
        productID = SJkmsConfigUtyCom.convertProductID(productID);
        String type = null;
        ArrayList<SJkmsDeleteInfo> ret = new ArrayList<SJkmsDeleteInfo>();
        type = SJkmsConfigUty.getType();
        if ("kmip".equals(type)) {
            SJkmsCommunicationException ex;
            SJcException resultException;
            String result;
            HashMap<String, SJcMessage> resultmap = new HashMap<String, SJcMessage>();
            ArrayList<String> getAttrDEK_UUIDList = new ArrayList<String>();
            ArrayList<String> alreadyDekList = SJkmsCommunicationUty.getKeyList(productID, DEK_MODE, true);
            for (String uuid : uuidlist) {
                if (alreadyDekList.contains(uuid)) {
                    getAttrDEK_UUIDList.add(uuid);
                    continue;
                }
                STD_LOGGER.warn(LOG_FUNCTION, LOG_TITLE, "delete", "DEK was not found (DEK=" + uuid + ")");
                SJkmsCommunicationException ex2 = new SJkmsCommunicationException("105009");
                resultmap.put(uuid, ex2.getMsg());
            }
            HashMap<String, String> dekkek_map = new HashMap<String, String>();
            HashMap<String, String> kekdek_map = new HashMap<String, String>();
            SJkmsCommunicationUty.getRelationDEK_KEK(getAttrDEK_UUIDList, dekkek_map, kekdek_map);
            ArrayList<String> deldeklist = new ArrayList<String>();
            ArrayList<String> delkeklist = new ArrayList<String>();
            ArrayList<String> chkKekUUIDList = new ArrayList<String>();
            for (String uuid : getAttrDEK_UUIDList) {
                String kekuuid = dekkek_map.get(uuid);
                Object resultmsg = null;
                if (kekuuid == null || kekuuid.length() == 0) {
                    STD_LOGGER.warn(LOG_FUNCTION, LOG_TITLE, "delete", "Empty DEK was found (DEK=" + uuid + ")");
                    deldeklist.add(uuid);
                } else {
                    chkKekUUIDList.add(kekuuid);
                }
                resultmap.put(uuid, (SJcMessage)resultmsg);
            }
            if (chkKekUUIDList.size() > 0) {
                ArrayList<String> alreadyKekList = SJkmsCommunicationUty.getKeyList(productID, KEK_MODE, true);
                for (String uuid : chkKekUUIDList) {
                    if (alreadyKekList.contains(uuid)) {
                        delkeklist.add(uuid);
                        continue;
                    }
                    STD_LOGGER.warn(LOG_FUNCTION, LOG_TITLE, "delete", "KEK was not found (KEK=" + uuid + ")");
                    String dekuuid = kekdek_map.get(uuid);
                    deldeklist.add(dekuuid);
                }
            }
            KeyInfo keyinfo = new KeyInfo();
            keyinfo = SJkmsCommunicationUty.getKmsSettings(STD_LOGGER, "delete");
            keyinfo = SJkmsCommunicationUty.stateRevoke(delkeklist, keyinfo);
            ArrayList<OutputInfo> deleteKekResultInfoList = SJkmsCommunicationUty.deleteKek(delkeklist);
            for (String kekid : delkeklist) {
                OutputInfo info = null;
                for (OutputInfo infoBuf : deleteKekResultInfoList) {
                    if (!SJkmsCommunicationUty.equalUniqueIdentifier(kekid, infoBuf)) continue;
                    info = infoBuf;
                    break;
                }
                SJcMessage resultmsg = null;
                String dekuuid = kekdek_map.get(kekid);
                if (info != null) {
                    String kekuuid = info.getUniqueIdentifierList().get(0);
                    result = info.getResultStatus();
                    resultException = info.getResultException();
                    if ("0:Success".equals(result)) {
                        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "delete", "Delete KEK (DEK=" + dekuuid + " KEK=" + kekuuid + ")");
                        deldeklist.add(dekuuid);
                    } else if (resultException != null) {
                        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "delete", "Undeleted KEK was found Ex(DEK=" + dekuuid + " KEK=" + kekuuid + ")");
                        resultmsg = resultException.getMsg();
                    } else {
                        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "delete", "Undeleted KEK was found (DEK=" + dekuuid + " KEK=" + kekuuid + ")");
                        resultmsg = SJkmsCommunicationUty.configureMessageFromOutputInfo(info, "105011");
                        if (info != null) {
                            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "delete", "Server Reply:" + info.getResultStatus() + " " + SJkmsCommunicationUty.createServerReplyReasonMsg(info) + " " + info.getResultMessage());
                        }
                    }
                } else {
                    STD_LOGGER.warn(LOG_FUNCTION, LOG_TITLE, "delete", "Logic Error (Delete KEK was found (KEK=" + kekid + " DEK=" + dekuuid + ")");
                    ex = new SJkmsCommunicationException("107002");
                    resultmsg = ex.getMsg();
                }
                resultmap.put(dekuuid, resultmsg);
            }
            keyinfo = SJkmsCommunicationUty.stateRevoke(deldeklist, keyinfo);
            ArrayList<OutputInfo> deleteDekResultInfoList = SJkmsCommunicationUty.deleteDek(deldeklist);
            for (String dekid : deldeklist) {
                OutputInfo info = null;
                for (OutputInfo infoBuf : deleteDekResultInfoList) {
                    if (!SJkmsCommunicationUty.equalUniqueIdentifier(dekid, infoBuf)) continue;
                    info = infoBuf;
                    break;
                }
                SJcMessage resultmsg = null;
                if (info != null) {
                    String dekuuid = info.getUniqueIdentifierList().get(0);
                    result = info.getResultStatus();
                    resultException = info.getResultException();
                    if ("0:Success".equals(result)) {
                        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "delete", "Delete DEK(DEK=" + dekuuid + ")");
                        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "delete", "locate DEK start");
                        InputInfo inputinfo = new InputInfo();
                        inputinfo.setSortOfData(SJkmsCommunicationUty.getDekKeyStr());
                        inputinfo.setProductID(SJkmsCommunicationUty.getModelStr() + productID);
                        inputinfo.setSplitFlag(false);
                        inputinfo.setUniqueIdentifier(dekkek_map.get(dekuuid));
                        keyinfo.setInputInfo(inputinfo);
                        keyinfo.setOutputInfo(null);
                        String function = "0x00000008";
                        keyinfo = SJkmsCommunicationUty.runConnection(function, keyinfo, STD_LOGGER, "delete");
                        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "delete", "locate DEK end");
                        ArrayList<String> splituuidlist = keyinfo.getOutputInfoList().get(0).getUniqueIdentifierList();
                        keyinfo = SJkmsCommunicationUty.stateRevoke(splituuidlist, keyinfo);
                        ArrayList<OutputInfo> deleteSplitList = SJkmsCommunicationUty.deleteDek(splituuidlist);
                    } else if (resultException != null) {
                        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "delete", "Undeleted DEK was found Ex(DEK=" + dekuuid + ")");
                        resultmsg = resultException.getMsg();
                    } else {
                        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "delete", "Undeleted DEK was found (DEK=" + dekuuid + ")");
                        resultmsg = SJkmsCommunicationUty.configureMessageFromOutputInfo(info, "105010");
                    }
                } else {
                    STD_LOGGER.warn(LOG_FUNCTION, LOG_TITLE, "delete", "Logic Error (Delete DEK (DEK=" + dekid + "))");
                    ex = new SJkmsCommunicationException("107003");
                    resultmsg = ex.getMsg();
                }
                resultmap.put(dekid, resultmsg);
            }
            for (String uuid : uuidlist) {
                SJkmsDeleteInfo delinfo = new SJkmsDeleteInfo();
                delinfo.setUUID(uuid);
                delinfo.setMsg((SJcMessage)resultmap.get(uuid));
                ret.add(delinfo);
            }
        } else {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "delete", "Illigal Server Type");
            throw new SJkmsCommunicationException("105018");
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "delete", "end");
        return ret;
    }

    public static List<SJkmsDeleteInfo> deleteRegularBackup(String productID, SJkmsBackupInfo backupinfo) throws SJkmsCommunicationException {
        String LOG_SUBTITLE = "deleteRegularBackup";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "deleteRegularBackup", "start");
        if (productID == null || productID.length() == 0 || backupinfo == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "deleteRegularBackup", "Parameter is null");
            throw new SJkmsCommunicationException("107001");
        }
        List<SJkmsDeleteInfo> ret = new ArrayList<SJkmsDeleteInfo>();
        List<SJkmsReferInfo> referList = SJkmsCommunicationUty.refer(productID);
        if (referList == null || referList.size() == 0) {
            return ret;
        }
        if (backupinfo.getUUID() == null || backupinfo.getUUID().length() == 0) {
            return ret;
        }
        ArrayList<String> chkUUIDList = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String strinfodate = null;
        String strbackupinfodate = null;
        try {
            strbackupinfodate = sdf.format(backupinfo.getBackupDate());
        }
        catch (Exception ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "deleteRegularBackup", "Unable to get Current Date and Time");
            throw new SJkmsCommunicationException(ex, "107001");
        }
        for (int i = 0; i < referList.size(); ++i) {
            SJkmsReferInfo info = referList.get(i);
            try {
                strinfodate = sdf.format(info.getBackupDate());
            }
            catch (Exception ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "deleteRegularBackup", "Unable to get Current Date and Time");
                throw new SJkmsCommunicationException(ex, "107001");
            }
            if (!info.getRegularBackup() || strinfodate.compareTo(strbackupinfodate) == 0) continue;
            chkUUIDList.add(info.getUUID());
        }
        if (chkUUIDList.size() == 0) {
            return ret;
        }
        if (chkUUIDList.size() > 0) {
            ret = SJkmsCommunicationUty.delete(productID, chkUUIDList);
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "deleteRegularBackup", "end");
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static KeyInfo runConnection(String function, KeyInfo keyinfo, SJcLoggerInterface STD_LOGGER, String LOG_SUBTITLE) throws SJkmsCommunicationException {
        KmipKeyManagementInterface keyman = new KmipKeyManagementInterface();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "KMIP Communication start");
        try {
            keyinfo = keyman.execute(function, keyinfo);
        }
        catch (NotSupportedFunctionException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Internal Logical Error");
            throw new SJkmsCommunicationException(ex, "107001");
        }
        catch (KeyInfoBlankException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Internal Logical Error");
            throw new SJkmsCommunicationException(ex, "107001");
        }
        catch (ReadPropertyFileException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Property file load Error");
            throw new SJkmsCommunicationException(ex, "107004");
        }
        catch (RequestCommandException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Internal Logical Error");
            throw new SJkmsCommunicationException(ex, "107001");
        }
        catch (KMSConfigException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Property file load Error");
            throw new SJkmsCommunicationException(ex, "107004");
        }
        catch (KmsTimeoutException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "KMS Timout Error");
            throw new SJkmsCommunicationException(ex, "105021");
        }
        catch (Exception ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Unknown Error");
            throw new SJkmsCommunicationException(ex, "107001");
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "KMIP Communication end");
        if ("0x0000000B".equals(function)) return keyinfo;
        if ("0x00000014".equals(function)) return keyinfo;
        if ("0x00000001".equals(function)) return keyinfo;
        if ("0x00000012".equals(function)) return keyinfo;
        if ("0x00000013".equals(function)) return keyinfo;
        if ("0x0000000D".equals(function)) {
            return keyinfo;
        }
        OutputInfo outinfo = keyinfo.getOutputInfoList().get(0);
        if (outinfo == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Communication failed Unknown Error");
            throw new SJkmsCommunicationException("105006");
        }
        String resultstatus = outinfo.getResultStatus();
        if ("0:Success".equals(resultstatus)) {
            STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "KMIP Communication Success");
            return keyinfo;
        }
        if ("Read Property File Exception".equals(resultstatus)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Property file Error");
            throw new SJkmsCommunicationException("107004");
        }
        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Communication failed");
        SJkmsCommunicationException ex = null;
        if (!("1:Operation Failed".equals(resultstatus) || "2:Operation Pending".equals(resultstatus) || "3:Operation Undone".equals(resultstatus))) {
            ex = new SJkmsCommunicationException("105005");
            throw ex;
        }
        ex = new SJkmsCommunicationException("105004");
        SJcMessage sjcmsg = ex.getMsg();
        String[] kmsmsg = null;
        kmsmsg = new String[]{resultstatus, SJkmsCommunicationUty.createServerReplyReasonMsg(outinfo), outinfo.getResultMessage()};
        sjcmsg.setMeansure_argument(kmsmsg);
        ex.setMsg(sjcmsg);
        ex.setKmsMsg(kmsmsg);
        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Server Reply:" + kmsmsg[0] + " " + kmsmsg[1] + " " + kmsmsg[2]);
        throw ex;
    }

    private static KeyInfo getKmsSettings(SJcLoggerInterface STD_LOGGER, String LOG_SUBTITLE) throws SJkmsCommunicationException {
        List<String> servernames = null;
        Properties properties = null;
        try {
            properties = SJkmsConfigUtyCom.loadProperties();
        }
        catch (SJcException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Propety file load error");
            throw new SJkmsCommunicationException(ex, "105016");
        }
        if (properties == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Propety file is null");
            throw new SJkmsCommunicationException("105016");
        }
        KmsConfiguration[] conflist = null;
        try {
            conflist = KmsConfigurationFactory.getConfigrations(properties);
        }
        catch (SJcException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Propety file convert error");
            throw new SJkmsCommunicationException(ex, "105019");
        }
        if (conflist == null || conflist.length == 0 || conflist[0] == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Propety file convert result error");
            throw new SJkmsCommunicationException("105017");
        }
        if (!conflist[0].getEnabled()) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Propety file is disabled");
            throw new SJkmsCommunicationException("105020");
        }
        try {
            servernames = KmsConfigurationFactory.getServerNames(properties);
        }
        catch (SJcException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Propety file load error");
            throw new SJkmsCommunicationException(ex, "107001");
        }
        HashMap<String, KeyManager[]> keymanager = null;
        try {
            SJkmsKeystoreUty.getKeyManager(servernames, false, null);
        }
        catch (SJkmsKeystoreUtyException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Client Certification/Keystore load error");
            throw new SJkmsCommunicationException(ex, "105002");
        }
        catch (SJcException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Parameter Error");
            throw new SJkmsCommunicationException(ex, "107001");
        }
        HashMap<String, TrustManager[]> trustmanager = null;
        try {
            SJkmsKeystoreUty.getTrustManager(servernames, false);
        }
        catch (SJkmsKeystoreUtyException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Server Certification/Keystore load error");
            throw new SJkmsCommunicationException(ex, "105003");
        }
        catch (SJcException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Parameter Error");
            throw new SJkmsCommunicationException(ex, "107001");
        }
        KeyInfo keyinfo = new KeyInfo();
        keyinfo.setProperties(properties);
        keyinfo.setKeyManager(keymanager);
        keyinfo.setTrustManager(trustmanager);
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, LOG_SUBTITLE, "Read and set Server Properties OK");
        return keyinfo;
    }

    public static void getRelationDEK_KEK(List<String> dekUUIDList, HashMap<String, String> dekkek_map, HashMap<String, String> kekdek_map) throws SJkmsCommunicationException {
        String LOG_SUBTITLE = "getRelationDEK_KEK";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getRelationDEK_KEK", "start");
        String type = SJkmsConfigUty.getType();
        if ("kmip".equals(type)) {
            KeyInfo keyinfo = null;
            boolean secondaryMode = false;
            if (dekUUIDList.size() == 0) {
                return;
            }
            ArrayList<OutputInfo> kekInfoList = new ArrayList<OutputInfo>();
            STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getRelationDEK_KEK", "GetAttribute KEKuid start");
            int partingNum_KEKGET = SJcEnvUty.getProperty2int("KMS_NUM_GETA_UUID", 81);
            int partingCnt = 0;
            partingCnt = dekUUIDList.size() > partingNum_KEKGET ? (dekUUIDList.size() % partingNum_KEKGET == 0 ? dekUUIDList.size() / partingNum_KEKGET : dekUUIDList.size() / partingNum_KEKGET + 1) : 1;
            for (int i = 0; i < partingCnt; ++i) {
                ArrayList<String> inputuuidlist = new ArrayList<String>();
                for (int j = i * partingNum_KEKGET; j < (i + 1) * partingNum_KEKGET; ++j) {
                    if (j >= dekUUIDList.size()) continue;
                    inputuuidlist.add(dekUUIDList.get(j));
                }
                if (inputuuidlist.size() > partingNum_KEKGET) {
                    STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getRelationDEK_KEK", "GetAttributes Error");
                    throw new SJkmsCommunicationException("107001");
                }
                if (keyinfo != null) {
                    secondaryMode = keyinfo.isSecondaryMode();
                }
                keyinfo = SJkmsCommunicationUty.getKmsSettings(STD_LOGGER, "getRelationDEK_KEK");
                keyinfo.setSecondaryMode(secondaryMode);
                InputInfo inputinfo = new InputInfo();
                inputinfo.setLocatedUniqueIdentifierList(inputuuidlist);
                inputinfo.setInfo("GetKEKUID");
                keyinfo.setInputInfo(inputinfo);
                keyinfo.setOutputInfo(null);
                String function = "0x0000000B";
                keyinfo = SJkmsCommunicationUty.runConnection(function, keyinfo, STD_LOGGER, "getRelationDEK_KEK");
                ArrayList<OutputInfo> outputInfoList = keyinfo.getOutputInfoList();
                if (outputInfoList == null || outputInfoList.size() == 0) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getRelationDEK_KEK", "restore GetSplitInfo DEK does not match with expectation");
                    throw new SJkmsCommunicationException("107001");
                }
                SJkmsCommunicationUty.checkGetAttributes(outputInfoList);
                for (OutputInfo info : keyinfo.getOutputInfoList()) {
                    kekInfoList.add(info);
                }
            }
            block7: for (String dekID : dekUUIDList) {
                for (OutputInfo info : kekInfoList) {
                    if (!SJkmsCommunicationUty.equalUniqueIdentifier(dekID, info) || info.getBackupKEKUID() == null) continue;
                    dekkek_map.put(dekID, info.getBackupKEKUID());
                    kekdek_map.put(info.getBackupKEKUID(), dekID);
                    continue block7;
                }
            }
        } else {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getRelationDEK_KEK", "Illigal Server Type");
            throw new SJkmsCommunicationException("105018");
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getRelationDEK_KEK", "GetAttribute KEKuid end");
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getRelationDEK_KEK", "end");
    }

    public static ArrayList<OutputInfo> deleteKek(ArrayList<String> delkeklist) throws SJkmsCommunicationException {
        String LOG_SUBTITLE = "deleteKek";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "deleteKek", "start");
        ArrayList<OutputInfo> resultInfoList = new ArrayList<OutputInfo>();
        if (delkeklist.size() == 0) {
            STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "deleteKek", "NonKEK");
            return resultInfoList;
        }
        String type = SJkmsConfigUty.getType();
        if ("kmip".equals(type)) {
            KeyInfo keyinfo = null;
            boolean secondaryMode = false;
            int partingNum = SJcEnvUty.getProperty2int("KMS_NUM_DESTROY", 135);
            STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "deleteKek", "Destroy KEK start");
            int partingCnt = 0;
            partingCnt = delkeklist.size() > partingNum ? (delkeklist.size() % partingNum == 0 ? delkeklist.size() / partingNum : delkeklist.size() / partingNum + 1) : 1;
            for (int i = 0; i < partingCnt; ++i) {
                ArrayList<String> inputuuidlist = new ArrayList<String>();
                for (int j = i * partingNum; j < (i + 1) * partingNum; ++j) {
                    if (j >= delkeklist.size()) continue;
                    inputuuidlist.add(delkeklist.get(j));
                }
                if (inputuuidlist.size() > partingNum) {
                    STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "deleteKek", "Destroy Error");
                    throw new SJkmsCommunicationException("107001");
                }
                if (keyinfo != null) {
                    secondaryMode = keyinfo.isSecondaryMode();
                }
                keyinfo = SJkmsCommunicationUty.getKmsSettings(STD_LOGGER, "deleteKek");
                keyinfo.setSecondaryMode(secondaryMode);
                InputInfo deleteKekinfo = new InputInfo();
                deleteKekinfo.setLocatedUniqueIdentifierList(inputuuidlist);
                keyinfo.setInputInfo(deleteKekinfo);
                keyinfo.setOutputInfo(null);
                String function = "0x00000014";
                SJkmsCommunicationException execException = null;
                try {
                    keyinfo = SJkmsCommunicationUty.runConnection(function, keyinfo, STD_LOGGER, "deleteKek");
                }
                catch (SJkmsCommunicationException ex) {
                    execException = ex;
                }
                resultInfoList = SJkmsCommunicationUty.createDelResult(inputuuidlist, keyinfo, execException, resultInfoList, "105013", "105015");
            }
        } else {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "deleteKek", "Illigal Server Type");
            throw new SJkmsCommunicationException("105018");
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "deleteKek", "Destroy KEK end");
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "deleteKek", "end");
        return resultInfoList;
    }

    public static ArrayList<OutputInfo> deleteDek(ArrayList<String> deldeklist) throws SJkmsCommunicationException {
        String LOG_SUBTITLE = "deleteDek";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "deleteDek", "start");
        ArrayList<OutputInfo> resultInfoList = new ArrayList<OutputInfo>();
        if (deldeklist.size() == 0) {
            STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "deleteDek", "NonDEK");
            return resultInfoList;
        }
        String type = SJkmsConfigUty.getType();
        if ("kmip".equals(type)) {
            KeyInfo keyinfo = null;
            boolean secondaryMode = false;
            int partingNum = SJcEnvUty.getProperty2int("KMS_NUM_DESTROY", 135);
            STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "deleteDek", "Destroy DEK start");
            int partingCnt = 0;
            partingCnt = deldeklist.size() > partingNum ? (deldeklist.size() % partingNum == 0 ? deldeklist.size() / partingNum : deldeklist.size() / partingNum + 1) : 1;
            for (int i = 0; i < partingCnt; ++i) {
                ArrayList<String> inputuuidlist = new ArrayList<String>();
                for (int j = i * partingNum; j < (i + 1) * partingNum; ++j) {
                    if (j >= deldeklist.size()) continue;
                    inputuuidlist.add(deldeklist.get(j));
                }
                if (inputuuidlist.size() > partingNum) {
                    STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "deleteDek", "Destroy Error");
                    throw new SJkmsCommunicationException("105018");
                }
                if (keyinfo != null) {
                    secondaryMode = keyinfo.isSecondaryMode();
                }
                keyinfo = SJkmsCommunicationUty.getKmsSettings(STD_LOGGER, "deleteDek");
                keyinfo.setSecondaryMode(secondaryMode);
                InputInfo deleteDekinfo = new InputInfo();
                deleteDekinfo.setLocatedUniqueIdentifierList(inputuuidlist);
                keyinfo.setInputInfo(deleteDekinfo);
                keyinfo.setOutputInfo(null);
                String function = "0x00000014";
                SJkmsCommunicationException execException = null;
                try {
                    keyinfo = SJkmsCommunicationUty.runConnection(function, keyinfo, STD_LOGGER, "deleteDek");
                }
                catch (SJkmsCommunicationException ex) {
                    STD_LOGGER.warn(LOG_FUNCTION, LOG_TITLE, "deleteDek", "Communication Error was occured", ex);
                    execException = ex;
                }
                resultInfoList = SJkmsCommunicationUty.createDelResult(inputuuidlist, keyinfo, execException, resultInfoList, "105012", "105014");
            }
        } else {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "deleteDek", "Illigal Server Type");
            throw new SJkmsCommunicationException("105018");
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "deleteDek", "Destroy DEK end");
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "deleteDek", "end");
        return resultInfoList;
    }

    public static ArrayList<OutputInfo> createDelResult(ArrayList<String> inputuuidlist, KeyInfo keyinfo, SJkmsCommunicationException execException, ArrayList<OutputInfo> resultInfoList, String errorReturnErrorID, String noReturnErrorID) {
        String LOG_SUBTITLE = "createDelResult";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        if (execException == null && keyinfo.getOutputInfoList().size() == 1 && keyinfo.getOutputInfoList().get(0).getUniqueIdentifierList() == null) {
            STD_LOGGER.warn(LOG_FUNCTION, LOG_TITLE, "createDelResult", "Error Message From Server");
            OutputInfo baseInfo = keyinfo.getOutputInfoList().get(0);
            if (baseInfo != null) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "createDelResult", "Server Reply:" + baseInfo.getResultStatus() + " " + SJkmsCommunicationUty.createServerReplyReasonMsg(baseInfo) + " " + baseInfo.getResultMessage());
            }
            for (String uuid : inputuuidlist) {
                OutputInfo info = SJkmsCommunicationUty.createOutputErrorInfo(uuid, "response error", "");
                info.setResultStatus(baseInfo.getResultStatus());
                info.setResultReason(baseInfo.getResultReason());
                info.setResultMessage(baseInfo.getResultMessage());
                SJcException ex = baseInfo.getResultException();
                SJkmsCommunicationException comuEx = null;
                comuEx = ex != null && ex.getMsg() != null ? new SJkmsCommunicationException(ex, ex.getMsg().getMsgID()) : new SJkmsCommunicationException(errorReturnErrorID);
                SJcMessage sjcmsg = comuEx.getMsg();
                String resultstatus = baseInfo.getResultStatus();
                String[] kmsmsg = null;
                if ("1:Operation Failed".equals(resultstatus) || "2:Operation Pending".equals(resultstatus) || "3:Operation Undone".equals(resultstatus)) {
                    kmsmsg = new String[]{resultstatus, SJkmsCommunicationUty.createServerReplyReasonMsg(info), info.getResultMessage()};
                    sjcmsg.setMeansure_argument(kmsmsg);
                }
                comuEx.setMsg(sjcmsg);
                comuEx.setKmsMsg(kmsmsg);
                info.setResultException(comuEx);
                resultInfoList.add(info);
            }
        } else if (execException == null) {
            for (String uuid : inputuuidlist) {
                OutputInfo info = null;
                for (OutputInfo infoBuf : keyinfo.getOutputInfoList()) {
                    if (!SJkmsCommunicationUty.equalUniqueIdentifier(uuid, infoBuf)) continue;
                    info = infoBuf;
                    break;
                }
                if (info != null) {
                    resultInfoList.add(info);
                    if (info.getResultStatus() == "0:Success") continue;
                    STD_LOGGER.warn(LOG_FUNCTION, LOG_TITLE, "createDelResult", "Error Responce:" + info.getResultStatus() + " Reason:" + info.getResultReason() + " Message:" + info.getResultMessage() + " UUID:" + uuid);
                    continue;
                }
                STD_LOGGER.warn(LOG_FUNCTION, LOG_TITLE, "createDelResult", "Non Information is included: " + uuid);
                info = SJkmsCommunicationUty.createOutputErrorInfo(uuid, "response error", noReturnErrorID);
                resultInfoList.add(info);
            }
        } else {
            STD_LOGGER.warn(LOG_FUNCTION, LOG_TITLE, "createDelResult", "Communication Error Set");
            for (String uuid : inputuuidlist) {
                OutputInfo info = SJkmsCommunicationUty.createOutputErrorInfo(uuid, "Connection Failed", execException);
                resultInfoList.add(info);
            }
        }
        return resultInfoList;
    }

    public static ArrayList<String> getKeyList(String productID, String keyType, boolean regularBackup) throws SJkmsCommunicationException {
        KeyInfo keyinfo;
        String LOG_SUBTITLE = "refer";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "refer", "start");
        ArrayList<String> uuidlist = new ArrayList();
        if (productID == null || productID.length() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "refer", "Parameter is null");
            throw new SJkmsCommunicationException("105018");
        }
        productID = SJkmsConfigUtyCom.convertProductID(productID);
        String type = null;
        ArrayList ret = new ArrayList();
        type = SJkmsConfigUty.getType();
        if ("kmip".equals(type)) {
            keyinfo = null;
            keyinfo = SJkmsCommunicationUty.getKmsSettings(STD_LOGGER, "refer");
            STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "refer", "Locate DEK start");
            InputInfo inputinfo = new InputInfo();
            if (KEK_MODE.equals(keyType)) {
                inputinfo.setSortOfData(SJkmsCommunicationUty.getKekKeyStr());
                inputinfo.setProductID(SJkmsCommunicationUty.getModelStr() + productID);
            } else {
                inputinfo.setSortOfData(SJkmsCommunicationUty.getDekKeyStr());
                inputinfo.setProductID(SJkmsCommunicationUty.getModelStr() + productID);
                inputinfo.setSplitFlag(true);
                inputinfo.setSplitID(0);
                inputinfo.setRegularBackup(regularBackup);
            }
            keyinfo.setInputInfo(inputinfo);
            keyinfo.setOutputInfo(null);
            String function = "0x00000008";
            keyinfo = SJkmsCommunicationUty.runConnection(function, keyinfo, STD_LOGGER, "refer");
        }
        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "refer", "Illigal Server Type");
        throw new SJkmsCommunicationException("105018");
        uuidlist = keyinfo.getOutputInfoList().get(0).getUniqueIdentifierList();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "refer", "Locate DEK end");
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "refer", "end");
        return uuidlist;
    }

    private static SJcMessage configureMessageFromOutputInfo(OutputInfo info, String deleteErrorMsgId) {
        SJkmsCommunicationException ex = new SJkmsCommunicationException(deleteErrorMsgId);
        SJcMessage sjcmsg = ex.getMsg();
        if (info != null) {
            String resultstatus = info.getResultStatus();
            String[] kmsmsg = null;
            if ("1:Operation Failed".equals(resultstatus) || "2:Operation Pending".equals(resultstatus) || "3:Operation Undone".equals(resultstatus)) {
                kmsmsg = new String[]{resultstatus, SJkmsCommunicationUty.createServerReplyReasonMsg(info), info.getResultMessage()};
                sjcmsg.setMeansure_argument(kmsmsg);
            }
            ex.setMsg(sjcmsg);
            ex.setKmsMsg(kmsmsg);
        }
        return sjcmsg;
    }

    private static boolean equalUniqueIdentifier(String uuid, OutputInfo info) {
        return info.getUniqueIdentifierList() != null && info.getUniqueIdentifierList().size() > 0 && uuid.equals(info.getUniqueIdentifierList().get(0));
    }

    public static OutputInfo createOutputErrorInfo(String uuid, String resultStatus, SJkmsCommunicationException ex) {
        OutputInfo info = new OutputInfo();
        info.setResultStatus(resultStatus);
        info.setResultException(ex);
        ArrayList<String> delidList = new ArrayList<String>();
        delidList.add(uuid);
        info.setUniqueIdentifierList(delidList);
        return info;
    }

    public static OutputInfo createOutputErrorInfo(String uuid, String resultStatus, String msgID) {
        return SJkmsCommunicationUty.createOutputErrorInfo(uuid, resultStatus, new SJkmsCommunicationException(msgID));
    }

    private static String getModelStr() {
        return "R800";
    }

    private static String getKekKeyStr() {
        return SJkmsCommunicationUty.getModelStr() + ":" + "KEK";
    }

    private static String getDekKeyStr() {
        return SJkmsCommunicationUty.getModelStr() + ":" + "DEK";
    }

    private static String getKekDynamicKeyStr() {
        return SJkmsCommunicationUty.getModelStr() + ":" + "KEKdynamic";
    }

    private static String createServerReplyReasonMsg(OutputInfo info) {
        String reason = info.getResultReason();
        String reasonMsg = null;
        if (reason != null && reason.indexOf("8") == 0 && reason.length() == 8) {
            reasonMsg = reason + ":Extensions";
        } else {
            for (int i = 0; i < SJkmsKmipConst.RESULT_REASON_ARRAY.length; ++i) {
                if (!SJkmsKmipConst.RESULT_REASON_ARRAY[i][0].equals(reason)) continue;
                reasonMsg = SJkmsKmipConst.RESULT_REASON_ARRAY[i][1];
                break;
            }
        }
        if (reasonMsg == null) {
            reasonMsg = reason + ":Unknown Response";
        }
        return reasonMsg;
    }

    private static byte[] compressDEK(byte[] dek) {
        int i;
        int endIndex;
        String LOG_SUBTITLE = "compressDEK";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "compressDEK", "start");
        int startIndex = endIndex = dek.length - 32;
        byte dat = 0;
        while ((dat = dek[--startIndex]) == 0) {
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (i = 0; i <= startIndex; ++i) {
            baos.write(dek[i]);
        }
        for (i = endIndex; i < dek.length; ++i) {
            baos.write(dek[i]);
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "compressDEK", "end");
        return baos.toByteArray();
    }

    private static byte[] decompressDEK(byte[] dek, int originalSize) {
        int i;
        String LOG_SUBTITLE = "decompressDEK";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "decompressDEK", "start");
        int availableSize = dek.length - 32;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (i = 0; i < availableSize; ++i) {
            baos.write(dek[i]);
        }
        for (i = 0; i < originalSize - dek.length; ++i) {
            baos.write(0);
        }
        for (i = 0; i < 32; ++i) {
            baos.write(dek[availableSize + i]);
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "decompressDEK", "end");
        return baos.toByteArray();
    }

    public static SJkmsCreateInfo createKEKDynamic(String productID) throws SJkmsCommunicationException {
        String LOG_SUBTITLE = "createKEKDynamic";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "createKEKDynamic", "start");
        if (productID == null || productID.length() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "createKEKDynamic", "Parameter is null");
            throw new SJkmsCommunicationException("107001");
        }
        productID = SJkmsConfigUtyCom.convertProductID(productID);
        SJkmsCreateInfo ret = new SJkmsCreateInfo();
        String type = SJkmsConfigUty.getType();
        if ("kmip".equals(type)) {
            KeyInfo keyinfo = null;
            keyinfo = SJkmsCommunicationUty.getKmsSettings(STD_LOGGER, "createKEKDynamic");
            STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "createKEKDynamic", "create KEK Dynamic on Server start");
            InputInfo inputinfo = new InputInfo();
            inputinfo.setRequiredKeyNum(1);
            inputinfo.setSortOfData(SJkmsCommunicationUty.getKekDynamicKeyStr());
            inputinfo.setProductID(SJkmsCommunicationUty.getModelStr() + productID);
            keyinfo.setInputInfo(inputinfo);
            keyinfo.setOutputInfo(null);
            String function = "0x00000001";
            SJkmsCommunicationException e = null;
            try {
                keyinfo = SJkmsCommunicationUty.runConnection(function, keyinfo, STD_LOGGER, "createKEKDynamic");
            }
            catch (SJkmsCommunicationException ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "createKEKDynamic", "create KEK Dynamic on Server failed");
                e = ex;
            }
            STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "createKEKDynamic", "create KEK Dynamic on Server end");
            boolean createSuccess = true;
            ArrayList<OutputInfo> outputInfoList = keyinfo.getOutputInfoList();
            if (outputInfoList == null || outputInfoList.size() != 1) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "createKEKDynamic", "create KEK Dynamic number does not match with expectation");
                createSuccess = false;
            }
            ArrayList<String> uuidList = new ArrayList<String>();
            if (createSuccess) {
                for (OutputInfo outputInfo : outputInfoList) {
                    if (!"0:Success".equals(outputInfo.getResultStatus())) {
                        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "createKEKDynamic", "Failed status exists");
                        createSuccess = false;
                        continue;
                    }
                    String uuid = outputInfo.getUniqueIdentifierList().get(0);
                    if (uuid == null || uuid.length() == 0) {
                        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "createKEKDynamic", "UUID is null");
                        createSuccess = false;
                        continue;
                    }
                    uuidList.add(uuid);
                }
            }
            if (createSuccess) {
                STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "createKEKDynamic", "Get KEK Dynamic from Server start");
                for (String uuid : uuidList) {
                    inputinfo = new InputInfo();
                    inputinfo.setUniqueIndetifier(uuid);
                    keyinfo.setInputInfo(inputinfo);
                    keyinfo.setOutputInfo(null);
                    function = "0x0000000A";
                    try {
                        keyinfo = SJkmsCommunicationUty.runConnection(function, keyinfo, STD_LOGGER, "createKEKDynamic");
                    }
                    catch (SJkmsCommunicationException ex) {
                        e = ex;
                    }
                    ArrayList<OutputInfo> outputCheck = keyinfo.getOutputInfoList();
                    if (outputCheck == null) {
                        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "createKEKDynamic", "OutputInfo is null");
                        createSuccess = false;
                    }
                    if (createSuccess) {
                        String strdek = keyinfo.getOutputInfoList().get(0).getBackupData();
                        if (strdek == null || strdek.length() == 0) {
                            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "createKEKDynamic", "KEK Dynamic Data is null");
                            createSuccess = false;
                        } else {
                            SJkmsCreateInfo createInfo = new SJkmsCreateInfo();
                            createInfo.setUUID(uuid);
                            createInfo.setCreateDataDEK(SJcStringUty.hexStringToByte(strdek));
                            ret = createInfo;
                        }
                    }
                    if (createSuccess) continue;
                    break;
                }
                STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "createKEKDynamic", "Get Keys KEK Dynamic Server end");
            }
            if (createSuccess && e == null) {
                STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "createKEKDynamic", "end");
                return ret;
            }
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "createKEKDynamic", "Create KEK Dynamic failed");
            if (e != null) {
                throw e;
            }
            throw new SJkmsCommunicationException("105005");
        }
        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "createKEKDynamic", "Illigal Server Type");
        throw new SJkmsCommunicationException("105018");
    }

    public static void registKEKDynamicHash(String productID, String UUID2, String HASH) throws SJkmsCommunicationException {
        String LOG_SUBTITLE = "registKEKDynamicHash";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "registKEKDynamicHash", "start");
        long activationDate = 0L;
        if (UUID2 == null || UUID2.length() == 0 || HASH == null || HASH.length() == 0 || productID == null || productID.length() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "registKEKDynamicHash", "Parameter is null");
            throw new SJkmsCommunicationException("107001");
        }
        String type = SJkmsConfigUty.getType();
        if ("kmip".equals(type)) {
            KeyInfo keyinfo = null;
            keyinfo = SJkmsCommunicationUty.getKmsSettings(STD_LOGGER, "registKEKDynamicHash");
            if (SJkmsCommunicationUty.stateCheck(UUID2, keyinfo) == 1) {
                ArrayList<String> uiList = new ArrayList<String>();
                uiList.add(UUID2);
                keyinfo = SJkmsCommunicationUty.stateActivate(uiList, keyinfo);
            }
            keyinfo = SJkmsCommunicationUty.getAttrNeeds(UUID2, keyinfo, "Activation Date");
            activationDate = keyinfo.getOutputInfoList().get(0).getActivationDate();
            String strdate = null;
            try {
                Date date = new Date();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                strdate = sdf.format(date);
            }
            catch (Exception ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "registKEKDynamicHash", "Unable to get Current Date and Time");
                throw new SJkmsCommunicationException(ex, "107001");
            }
            STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "registKEKDynamicHash", "regist KEK Dynamic Hash on Server start");
            InputInfo inputinfo = new InputInfo();
            inputinfo.setProductID(SJkmsCommunicationUty.getModelStr() + productID);
            inputinfo.setHash(HASH);
            inputinfo.setUniqueIndetifier(UUID2);
            inputinfo.setSortOfData(SJkmsCommunicationUty.getKekDynamicKeyStr());
            inputinfo.setAddAttributeDate(strdate);
            inputinfo.setKeyMaterialFormatID(12);
            inputinfo.setHashAlgrithm(0);
            inputinfo.setProcessStartDate(activationDate);
            keyinfo.setInputInfo(inputinfo);
            keyinfo.setOutputInfo(null);
            String function = "0x0000000D";
            SJkmsCommunicationException e = null;
            try {
                keyinfo = SJkmsCommunicationUty.runConnection(function, keyinfo, STD_LOGGER, "registKEKDynamicHash");
            }
            catch (SJkmsCommunicationException ex) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "registKEKDynamicHash", "regist KEK Dynamic Hash on Server failed");
                e = ex;
            }
            STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "registKEKDynamicHash", "regist KEK Dynamic Hash on Server end");
            boolean createSuccess = true;
            ArrayList<OutputInfo> outputInfoList = keyinfo.getOutputInfoList();
            if (outputInfoList == null || outputInfoList.size() == 0) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "registKEKDynamicHash", "regist KEK Dynamic number does not match with expectation");
                createSuccess = false;
            }
            ArrayList<String> uuidList = new ArrayList<String>();
            if (createSuccess) {
                for (OutputInfo outputInfo : outputInfoList) {
                    if (!"0:Success".equals(outputInfo.getResultStatus())) {
                        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "registKEKDynamicHash", "Failed status exists");
                        createSuccess = false;
                        continue;
                    }
                    String uuid = outputInfo.getUniqueIdentifierList().get(0);
                    if (uuid == null || uuid.length() == 0) {
                        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "registKEKDynamicHash", "UUID is null");
                        createSuccess = false;
                        continue;
                    }
                    uuidList.add(uuid);
                }
            }
            if (createSuccess) {
                STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "registKEKDynamicHash", "end");
                return;
            }
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "registKEKDynamicHash", "regist KEK Dynamic Hash failed");
            if (e != null) {
                throw e;
            }
            throw new SJkmsCommunicationException("105005");
        }
        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "registKEKDynamicHash", "Illigal Server Type");
        throw new SJkmsCommunicationException("105018");
    }

    public static SJkmsCreateInfo getKEKDynamic(String UUID2) throws SJkmsCommunicationException {
        String LOG_SUBTITLE = "getKEKDynamic";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getKEKDynamic", "start");
        if (UUID2 == null || UUID2.length() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getKEKDynamic", "Parameter is null");
            throw new SJkmsCommunicationException("107001");
        }
        SJkmsCreateInfo ret = new SJkmsCreateInfo();
        String type = SJkmsConfigUty.getType();
        if ("kmip".equals(type)) {
            KeyInfo keyinfo = null;
            keyinfo = SJkmsCommunicationUty.getKmsSettings(STD_LOGGER, "getKEKDynamic");
            STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getKEKDynamic", "get KEK Dynamic on Server start");
            InputInfo inputinfo = new InputInfo();
            inputinfo.setUniqueIndetifier(UUID2);
            keyinfo.setInputInfo(inputinfo);
            keyinfo.setOutputInfo(null);
            String function = "0x0000000A";
            SJkmsCommunicationException e = null;
            try {
                keyinfo = SJkmsCommunicationUty.runConnection(function, keyinfo, STD_LOGGER, "getKEKDynamic");
            }
            catch (SJkmsCommunicationException ex) {
                e = ex;
            }
            boolean createSuccess = true;
            ArrayList<OutputInfo> outputCheck = keyinfo.getOutputInfoList();
            if (outputCheck == null) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getKEKDynamic", "OutputInfo is null");
                createSuccess = false;
            }
            if (createSuccess) {
                String strdek = keyinfo.getOutputInfoList().get(0).getBackupData();
                if (strdek == null || strdek.length() == 0) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getKEKDynamic", "KEK Dynamic Data is null");
                    createSuccess = false;
                } else {
                    ret.setUUID(UUID2);
                    ret.setCreateDataDEK(SJcStringUty.hexStringToByte(strdek));
                }
            }
            if (createSuccess) {
                STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getKEKDynamic", "Get KEK Dynamic Hash from Server start");
                inputinfo = new InputInfo();
                ArrayList<String> uuidlist = new ArrayList<String>();
                uuidlist.add(UUID2);
                inputinfo.setLocatedUniqueIdentifierList(uuidlist);
                inputinfo.setInfo("GetKEKdynData");
                keyinfo.setInputInfo(inputinfo);
                keyinfo.setOutputInfo(null);
                function = "0x0000000B";
                try {
                    keyinfo = SJkmsCommunicationUty.runConnection(function, keyinfo, STD_LOGGER, "getKEKDynamic");
                }
                catch (SJkmsCommunicationException ex) {
                    e = ex;
                }
                outputCheck = keyinfo.getOutputInfoList();
                if (outputCheck == null) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getKEKDynamic", "OutputInfo is null");
                    createSuccess = false;
                }
                if (createSuccess) {
                    String strHash = keyinfo.getOutputInfoList().get(0).getHash();
                    if (strHash == null || strHash.length() == 0) {
                        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getKEKDynamic", "KEK Dynamic Hash is null");
                        createSuccess = false;
                    } else {
                        ret.setHASH(strHash);
                    }
                }
                STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getKEKDynamic", "Get KEK Dynamic Hash from Server end");
            }
            STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "getKEKDynamic", "get KEK Dynamic on Server end");
            if (createSuccess && e == null) {
                STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getKEKDynamic", "end");
                return ret;
            }
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getKEKDynamic", "get KEK Dynamic failed");
            if (e != null) {
                throw e;
            }
            throw new SJkmsCommunicationException("105005");
        }
        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getKEKDynamic", "Illigal Server Type");
        throw new SJkmsCommunicationException("105018");
    }

    public static SJkmsCreateInfo deleteKEKDynamic(String UUID2) throws SJkmsCommunicationException {
        String LOG_SUBTITLE = "deleteKEKDynamic";
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "deleteKEKDynamic", "start");
        if (UUID2 == null || UUID2.length() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "deleteKEKDynamic", "Parameter is null");
            throw new SJkmsCommunicationException("107001");
        }
        SJkmsCreateInfo ret = new SJkmsCreateInfo();
        String type = SJkmsConfigUty.getType();
        if ("kmip".equals(type)) {
            KeyInfo keyinfo = null;
            keyinfo = SJkmsCommunicationUty.getKmsSettings(STD_LOGGER, "deleteKEKDynamic");
            ArrayList<String> uuidlist = new ArrayList<String>();
            uuidlist.add(UUID2);
            keyinfo = SJkmsCommunicationUty.getAttrNeeds(UUID2, keyinfo, "Protect Stop Date");
            if (keyinfo.getOutputInfoList().get(0).getProtectStopDate() == 0L) {
                keyinfo = SJkmsCommunicationUty.addProtectStopDate(UUID2, keyinfo);
            }
            keyinfo = SJkmsCommunicationUty.stateRevoke(uuidlist, keyinfo);
            STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "deleteKEKDynamic", "delete KEK Dynamic on Server start");
            InputInfo inputinfo = new InputInfo();
            inputinfo.setLocatedUniqueIdentifierList(uuidlist);
            keyinfo.setInputInfo(inputinfo);
            keyinfo.setOutputInfo(null);
            String function = "0x00000014";
            SJkmsCommunicationException e = null;
            boolean createSuccess = true;
            try {
                keyinfo = SJkmsCommunicationUty.runConnection(function, keyinfo, STD_LOGGER, "deleteKEKDynamic");
            }
            catch (SJkmsCommunicationException ex) {
                createSuccess = false;
                e = ex;
            }
            STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "deleteKEKDynamic", "delete KEK Dynamic on Server end");
            if (createSuccess && e == null) {
                STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "deleteKEKDynamic", "end");
                SJkmsCreateInfo createInfo = new SJkmsCreateInfo();
                createInfo.setUUID(UUID2);
                ret = createInfo;
                return ret;
            }
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "deleteKEKDynamic", "delete KEK Dynamic failed");
            if (e != null) {
                throw e;
            }
            throw new SJkmsCommunicationException("105005");
        }
        STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "deleteKEKDynamic", "Illigal Server Type");
        throw new SJkmsCommunicationException("105018");
    }

    public static ArrayList<byte[]> splitDEK(byte[] dek) {
        ArrayList<byte[]> sData = null;
        byte[] byWork = null;
        int sCnt = 0;
        int sPoint = 0;
        if (dek == null || dek.length == 0) {
            return sData;
        }
        sCnt = dek.length > 4096 ? (dek.length % 4096 == 0 ? dek.length / 4096 : dek.length / 4096 + 1) : 1;
        sData = new ArrayList<byte[]>();
        for (int i = 0; i < sCnt; ++i) {
            if (dek.length - sPoint >= 4096) {
                byWork = new byte[4096];
                System.arraycopy(dek, sPoint, byWork, 0, 4096);
                sData.add(byWork);
                sPoint += 4096;
                continue;
            }
            byWork = new byte[dek.length - sPoint];
            System.arraycopy(dek, sPoint, byWork, 0, dek.length - sPoint);
            sData.add(byWork);
            break;
        }
        return sData;
    }

    public static byte[] concatenateDEK(ArrayList<byte[]> dek, ArrayList<Integer> id) {
        byte[] sData = null;
        int sCnt = 0;
        int sPoint = 0;
        if (dek == null || dek.size() == 0 || id == null || id.size() == 0) {
            return sData;
        }
        for (int i = 0; i < dek.size(); ++i) {
            sCnt += dek.get(i).length;
        }
        sData = new byte[sCnt];
        for (int j = 0; j < dek.size(); ++j) {
            int split_cnt = -1;
            for (int k = 0; k < id.size(); ++k) {
                if (id.get(k) != j) continue;
                split_cnt = k;
                break;
            }
            if (split_cnt == -1) {
                return null;
            }
            System.arraycopy(dek.get(split_cnt), 0, sData, sPoint, dek.get(split_cnt).length);
            sPoint += dek.get(split_cnt).length;
        }
        return sData;
    }

    private static void checkGetAttributes(List<OutputInfo> outputInfoList) {
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        String LOG_SUBTITLE = "checkGetAttributes";
        for (OutputInfo outputInfo : outputInfoList) {
            if ("0:Success".equals(outputInfo.getResultStatus())) continue;
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "checkGetAttributes", "Failed status exists");
            String resultstatus = outputInfo.getResultStatus();
            SJkmsCommunicationException ex = null;
            if ("1:Operation Failed".equals(resultstatus) || "2:Operation Pending".equals(resultstatus) || "3:Operation Undone".equals(resultstatus)) {
                ex = new SJkmsCommunicationException("105004");
                SJcMessage sjcmsg = ex.getMsg();
                String[] kmsmsg = null;
                kmsmsg = new String[]{resultstatus, SJkmsCommunicationUty.createServerReplyReasonMsg(outputInfo), outputInfo.getResultMessage()};
                sjcmsg.setMeansure_argument(kmsmsg);
                ex.setMsg(sjcmsg);
                ex.setKmsMsg(kmsmsg);
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "checkGetAttributes", "Server Reply:" + kmsmsg[0] + " " + kmsmsg[1] + " " + kmsmsg[2]);
            } else {
                ex = new SJkmsCommunicationException("105005");
            }
            throw ex;
        }
    }

    private static KeyInfo stateActivate(ArrayList<String> uuidlist, KeyInfo keyinfo) {
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        String LOG_SUBTITLE = "stateActivate";
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "stateActivate", "stateActivate start");
        if (uuidlist == null || uuidlist.size() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "stateActivate", "stateActivate uuid null");
            return keyinfo;
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "stateActivate", "Activate KEK start");
        InputInfo inputinfo = new InputInfo();
        inputinfo.setLocatedUniqueIdentifierList(uuidlist);
        keyinfo.setInputInfo(inputinfo);
        keyinfo.setOutputInfo(null);
        String function = "0x00000012";
        keyinfo = SJkmsCommunicationUty.runConnection(function, keyinfo, STD_LOGGER, "stateActivate");
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "stateActivate", "Activate KEK end");
        ArrayList<OutputInfo> outputInfoList = keyinfo.getOutputInfoList();
        if (outputInfoList == null || outputInfoList.size() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "stateActivate", "Get State does not match with expectation");
            throw new SJkmsCommunicationException("107001");
        }
        SJkmsCommunicationUty.checkStateSupport(outputInfoList);
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "stateActivate", "stateActivate end");
        return keyinfo;
    }

    private static KeyInfo stateRevoke(ArrayList<String> uuidlist, KeyInfo keyinfo) {
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        String LOG_SUBTITLE = "stateRevoke";
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "stateRevoke", "stateRevoke start");
        if (uuidlist == null || uuidlist.size() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "stateRevoke", "stateRevoke uuid null");
            return keyinfo;
        }
        for (String uuid : uuidlist) {
            if (SJkmsCommunicationUty.stateCheck(uuid, keyinfo) != 2) continue;
            STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "stateRevoke", "Revoke KEK start");
            InputInfo inputinfoState = new InputInfo();
            ArrayList<Revocation> revocationList = new ArrayList<Revocation>();
            revocationList.add(new Revocation(uuid, 6, "", ""));
            inputinfoState.setRevocationList(revocationList);
            keyinfo.setInputInfo(inputinfoState);
            keyinfo.setOutputInfo(null);
            String functionState = "0x00000013";
            keyinfo = SJkmsCommunicationUty.runConnection(functionState, keyinfo, STD_LOGGER, "stateRevoke");
            STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "stateRevoke", "Revoke KEK end");
            ArrayList<OutputInfo> outputInfoList = keyinfo.getOutputInfoList();
            if (outputInfoList == null || outputInfoList.size() == 0) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "stateRevoke", "Get State does not match with expectation");
                throw new SJkmsCommunicationException("107001");
            }
            SJkmsCommunicationUty.checkStateSupport(outputInfoList);
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "stateRevoke", "stateRevoke end");
        return keyinfo;
    }

    private static int stateCheck(String uuid, KeyInfo keyinfo) {
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        String LOG_SUBTITLE = "stateCheck";
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "stateCheck", "stateCheck start");
        if (uuid == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "stateCheck", "stateCheck uuid null");
            return -1;
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "stateCheck", "Get State start");
        ArrayList<String> ulist = new ArrayList<String>();
        ulist.add(uuid);
        InputInfo inputinfoState = new InputInfo();
        inputinfoState.setLocatedUniqueIdentifierList(ulist);
        inputinfoState.setInfo("GetSpecifiedAttr");
        inputinfoState.getAttrNeedsMap().clear();
        inputinfoState.getAttrNeedsMap().put("State", true);
        keyinfo.setInputInfo(inputinfoState);
        keyinfo.setOutputInfo(null);
        String functionState = "0x0000000B";
        keyinfo = SJkmsCommunicationUty.runConnection(functionState, keyinfo, STD_LOGGER, "stateCheck");
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "stateCheck", "Get State end");
        ArrayList<OutputInfo> outputInfoList = keyinfo.getOutputInfoList();
        if (outputInfoList == null || outputInfoList.size() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "stateCheck", "Get State does not match with expectation");
            throw new SJkmsCommunicationException("107001");
        }
        SJkmsCommunicationUty.checkGetAttributes(outputInfoList);
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "stateCheck", "stateCheck end");
        return ((OutputInfo)outputInfoList.get(0)).getState();
    }

    private static KeyInfo getAttrNeeds(String uuid, KeyInfo keyinfo, String attribute_name) {
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        String LOG_SUBTITLE = "getAttrNeeds";
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getAttrNeeds", "getAttrNeeds start");
        if (uuid == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getAttrNeeds", "getAttrNeeds uuid null");
            return keyinfo;
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getAttrNeeds", "Get Attribute start");
        InputInfo inputinfo = new InputInfo();
        ArrayList<String> uiList = new ArrayList<String>();
        uiList.add(uuid);
        inputinfo.setLocatedUniqueIdentifierList(uiList);
        inputinfo.setInfo("GetSpecifiedAttr");
        inputinfo.getAttrNeedsMap().clear();
        inputinfo.getAttrNeedsMap().put(attribute_name, true);
        keyinfo.setInputInfo(inputinfo);
        keyinfo.setOutputInfo(null);
        String function = "0x0000000B";
        keyinfo = SJkmsCommunicationUty.runConnection(function, keyinfo, STD_LOGGER, "getAttrNeeds");
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getAttrNeeds", "Get Attribute end");
        ArrayList<OutputInfo> outputInfoList = keyinfo.getOutputInfoList();
        if (outputInfoList == null || outputInfoList.size() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "getAttrNeeds", "Get Attribute does not match with expectation");
            throw new SJkmsCommunicationException("107001");
        }
        SJkmsCommunicationUty.checkGetAttributes(outputInfoList);
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "getAttrNeeds", "getAttrNeeds end");
        return keyinfo;
    }

    private static KeyInfo addProtectStopDate(String uuid, KeyInfo keyinfo) {
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        String LOG_SUBTITLE = "addProtectStopDate";
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "addProtectStopDate", "addProtectStopDate start");
        if (uuid == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "addProtectStopDate", "addProtectStopDate uuid null");
            return keyinfo;
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "addProtectStopDate", "add attribute start");
        InputInfo inputinfo = new InputInfo();
        inputinfo.setUniqueIndetifier(uuid);
        inputinfo.setProtectStopDate(keyinfo.getKmsTimeStamp());
        keyinfo.setInputInfo(inputinfo);
        keyinfo.setOutputInfo(null);
        String function = "0x0000000D";
        keyinfo = SJkmsCommunicationUty.runConnection(function, keyinfo, STD_LOGGER, "addProtectStopDate");
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "addProtectStopDate", "add attribute end");
        ArrayList<OutputInfo> outputInfoList = keyinfo.getOutputInfoList();
        if (outputInfoList == null || outputInfoList.size() == 0) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "addProtectStopDate", "Get State does not match with expectation");
            throw new SJkmsCommunicationException("107001");
        }
        SJkmsCommunicationUty.checkStateSupport(outputInfoList);
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "addProtectStopDate", "addProtectStopDate end");
        return keyinfo;
    }

    private static void checkStateSupport(List<OutputInfo> outputInfoList) {
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        String LOG_SUBTITLE = "checkStateSupport";
        for (OutputInfo outputInfo : outputInfoList) {
            if ("0:Success".equals(outputInfo.getResultStatus())) continue;
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "checkStateSupport", "Failed status exists");
            String resultstatus = outputInfo.getResultStatus();
            SJkmsCommunicationException ex = null;
            if ("1:Operation Failed".equals(resultstatus) || "2:Operation Pending".equals(resultstatus) || "3:Operation Undone".equals(resultstatus)) {
                if (SJkmsCommunicationUty.isOperationNotSupported(outputInfo).booleanValue()) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "checkStateSupport", "StateOperation NotSupport NormalEnd");
                    throw new SJkmsCommunicationException("105022");
                }
                if (SJkmsCommunicationUty.isAttributeNotSupported(outputInfo).booleanValue()) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "checkStateSupport", "The specified attribute is not supported NormalEnd");
                    throw new SJkmsCommunicationException("105022");
                }
                ex = new SJkmsCommunicationException("105004");
                SJcMessage sjcmsg = ex.getMsg();
                String[] kmsmsg = null;
                kmsmsg = new String[]{resultstatus, SJkmsCommunicationUty.createServerReplyReasonMsg(outputInfo), outputInfo.getResultMessage()};
                sjcmsg.setMeansure_argument(kmsmsg);
                ex.setMsg(sjcmsg);
                ex.setKmsMsg(kmsmsg);
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "checkStateSupport", "Server Reply:" + kmsmsg[0] + " " + kmsmsg[1] + " " + kmsmsg[2]);
            } else {
                ex = new SJkmsCommunicationException("105005");
            }
            throw ex;
        }
    }

    private static Boolean isOperationNotSupported(OutputInfo info) {
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        String LOG_SUBTITLE = "isOperationNotSupported";
        String reason = info.getResultReason();
        if (reason != null && reason.indexOf("8") == 0 && reason.length() == 8) {
            return false;
        }
        if (SJkmsKmipConst.RESULT_REASON_ARRAY[4][0].equals(reason)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "isOperationNotSupported", "Server Reply:5:Operation Not Supported");
            return true;
        }
        return false;
    }

    private static Boolean isAttributeNotSupported(OutputInfo info) {
        SJcLoggerInterface STD_LOGGER = SJkmsLogUtil.getLogger();
        String LOG_SUBTITLE = "isAttributeNotSupported";
        String reason = info.getResultReason();
        if (reason != null && reason.indexOf("8") == 0 && reason.length() == 8) {
            return false;
        }
        if (SJkmsKmipConst.RESULT_REASON_ARRAY[6][0].equals(reason)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "isAttributeNotSupported", "Server Reply:7:The specified attribute is not supported");
            return true;
        }
        return false;
    }
}

