/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model;

import java.util.ArrayList;
import sanproject.sn2.datasupplier.SJdsSupplierMgr;
import sanproject.sn2.model.SJmoException;
import sanproject.sn2.model.SJmoModelMgr;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.data.SJmoModelDataMgr;
import sanproject.sn2.model.update.SJmoDataUpdate;

public class SJmoRefreshMgr
extends Thread {
    private SJmoModelMgr m_ModelMgr = null;
    private SJmoModelDataMgr m_DataMgrBak = null;
    private ArrayList m_UpdateList = null;
    private boolean m_bUpdflag = false;
    private int m_iUpdType = -1;
    private boolean m_bStopThread = false;

    public SJmoRefreshMgr(SJmoModelMgr modelMgr, SJmoModelDataMgr dataMgrBak, ArrayList updateList, int iUpdType) {
        this.m_ModelMgr = modelMgr;
        this.m_bUpdflag = true;
        this.m_DataMgrBak = dataMgrBak;
        this.m_UpdateList = updateList;
        this.m_iUpdType = iUpdType;
    }

    @Override
    public void run() {
        SJmoException mdExp = null;
        if (null != this.m_UpdateList && 0 != this.m_UpdateList.size()) {
            for (int iUpdCnt = 0; iUpdCnt < this.m_UpdateList.size(); ++iUpdCnt) {
                try {
                    if (this.m_bUpdflag) {
                        Object objDataTmp = this.m_UpdateList.get(iUpdCnt);
                        if (objDataTmp instanceof SJmoDataUpdate) {
                            SJmoDataUpdate objUpdate = (SJmoDataUpdate)objDataTmp;
                            boolean bUpdResult = true;
                            if (3 == this.m_iUpdType && !objUpdate.isBCallbyApplyRefresh()) {
                                SJmoUtility.putLogDetail("SJmoRefreshMgr", "run", "SJmoDataupdate.update() is Skip(Apply Refresh)");
                            } else {
                                bUpdResult = objUpdate.update(this.m_DataMgrBak);
                            }
                            if (bUpdResult) continue;
                            SJmoUtility.putLogDetail("SJmoRefreshMgr", "run", "Now RefMgr run!! bUpdResult = false.");
                            mdExp = this.checkErrLevel(201, 23, 107006, mdExp);
                            continue;
                        }
                        SJmoUtility.putLogDetail("SJmoRefreshMgr", "run", "Now RefMgr run!! It is not an instance of the SJmoDataUpdate.");
                        mdExp = this.checkErrLevel(201, 23, 107000, mdExp);
                        continue;
                    }
                    if (this.m_bStopThread) break;
                    SJmoUtility.putLogDetail("SJmoRefreshMgr", "run", "Now RefMgr run!! It is not possible to continue.");
                    mdExp = this.checkErrLevel(201, 23, 107006, mdExp);
                    continue;
                }
                catch (SJmoException mdCatchExp) {
                    String strFuncID = mdCatchExp.getMsg().getFunctionID();
                    String strModuleID = mdCatchExp.getMsg().getModuleID();
                    String strMsgID = mdCatchExp.getMsg().getMsgID();
                    SJmoUtility.putLogDetail("SJmoRefreshMgr", "run", "SJmoException FuncID=" + strFuncID + " ModuleID=" + strModuleID + " MsgID=" + strMsgID);
                    mdExp = this.checkErrLevel(Integer.parseInt(strFuncID), Integer.parseInt(strModuleID), Integer.parseInt(strMsgID), mdExp);
                    continue;
                }
                catch (Exception jvExp) {
                    SJmoUtility.putLogDetail("SJmoRefreshMgr", "run", "JavaException FuncID=201 ModuleID=23 MsgID=107003");
                    jvExp.printStackTrace();
                    mdExp = this.checkErrLevel(201, 23, 107003, mdExp);
                }
            }
            if (null == mdExp && !this.m_bStopThread && this.m_bUpdflag) {
                if (null != this.m_DataMgrBak) {
                    SJmoUtility.putLogDetail("SJmoRefreshMgr", "run", "editModelData Execute");
                    this.m_DataMgrBak.editModelData();
                } else {
                    SJmoUtility.putLogDetail("SJmoRefreshMgr", "run", "editModelData Not Execute(m_DataMgrBak is null)");
                }
            } else {
                SJmoUtility.putLogDetail("SJmoRefreshMgr", "run", "editModelData Not Execute(Update Filed)" + mdExp + "," + this.m_bStopThread + "," + this.m_bUpdflag);
            }
        } else {
            SJmoUtility.putLogDetail("SJmoRefreshMgr", "run", "Now RefMgr run!! m_UpdateList = null or m_UpdateList.size = 0.");
            mdExp = this.checkErrLevel(201, 23, 107000, mdExp);
        }
        this.m_ModelMgr.endModelUpdate(mdExp, this.m_bStopThread, this.m_iUpdType);
    }

    public void stopThread() {
        this.m_bUpdflag = false;
    }

    public void stopThreadWithWait() throws SJmoException {
        this.m_bStopThread = true;
        this.m_bUpdflag = false;
        int iWatchTime = 0;
        if (this.m_ModelMgr != null) {
            while (1 != this.m_ModelMgr.getVersionMgr().getVerStatus()) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException intExp) {
                    SJmoUtility.putLogDetail("SJmoRefreshMgr", "stopThreadWithWait", "Thread Interrupt");
                }
                if (900000 > (iWatchTime += 5000)) continue;
                throw SJmoUtility.getException(201, 23, 107013, "SJmoRefreshMgr", "stopThreadWithWait");
            }
        } else {
            throw SJmoUtility.getException(201, 23, 107003, "SJmoRefreshMgr", "stopThreadWithWait");
        }
        SJmoUtility.putLogDetail("SJmoRefreshMgr", "stopThreadWithWait", "stopThread Complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SJmoException checkErrLevel(int iFuncID, int iModuleID, int iMsgID, SJmoException saveMdlExp) {
        SJmoException mdlExp = null;
        int iErrLv = -1;
        SJdsSupplierMgr SupMgr = this.m_ModelMgr.getSupplierMgr();
        if (null != SupMgr) {
            iErrLv = SJmoUtility.getErrLevel(iFuncID, iModuleID, iMsgID);
            if (iErrLv == 0) {
                iErrLv = 7;
            }
            if (null == saveMdlExp) {
                mdlExp = SJmoUtility.getException(iFuncID, iModuleID, iMsgID, "SJmoRefreshMgr", "checkErrLevel");
                this.m_ModelMgr.setModelException(iFuncID, iModuleID, iMsgID);
            } else {
                SJmoException tmpExp;
                SJmoException sJmoException = tmpExp = this.m_ModelMgr.getModelException();
                synchronized (sJmoException) {
                    int iSaveErrLv = SJmoUtility.getModelErrLevel(tmpExp, SupMgr);
                    if (-1 == iSaveErrLv || iSaveErrLv >= iErrLv) {
                        mdlExp = SJmoUtility.getException(iFuncID, iModuleID, iMsgID, "SJmoRefreshMgr", "checkErrLevel");
                        this.m_ModelMgr.setModelException(iFuncID, iModuleID, iMsgID);
                    } else {
                        iErrLv = iSaveErrLv;
                        mdlExp = this.m_ModelMgr.getModelException();
                    }
                }
            }
        } else {
            mdlExp = SJmoUtility.getException(iFuncID, iModuleID, iMsgID, "SJmoRefreshMgr", "checkErrLevel");
            this.m_ModelMgr.setModelException(iFuncID, iModuleID, iMsgID);
        }
        switch (iErrLv) {
            case 1: {
                this.stopThread();
                this.m_ModelMgr.getVersionMgr().getVerPoller().canselScadule();
                this.m_DataMgrBak = null;
                break;
            }
            case 2: {
                this.stopThread();
                this.m_DataMgrBak = null;
                break;
            }
        }
        return mdlExp;
    }
}

