/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.data.exdevice;

import sanproject.serverux.dataimpl.EXDVpg;
import sanproject.sn2.model.SJmoException;
import sanproject.sn2.model.SJmoUtility;
import sanproject.sn2.model.data.inf.SJmoData_IF;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoPgIndex;

public class SJmoExDPgInfo
extends SJmoPgIndex
implements SJmoData_IF {
    static final long serialVersionUID = -8679597785897691394L;
    private static final int MIN_FICON = 16641;
    private static final int MAX_FICON = 17152;
    private int iMid = -1;
    private short sNumOfLdev = (short)-1;
    private SJmoLdevIndex startLdevId = new SJmoLdevIndex();
    private int iPathGroupId = -1;

    public void setIMid(int iID) {
        this.iMid = iID;
    }

    public void setSNumOfLdev(short sLdevNum) {
        this.sNumOfLdev = sLdevNum;
    }

    public void setStartLdevId(SJmoLdevIndex startLdev) {
        this.startLdevId = startLdev;
    }

    public void setIPathGroupId(int iGroupId) {
        this.iPathGroupId = iGroupId;
    }

    public int getIMid() {
        return this.iMid;
    }

    public short getSNumOfLdev() {
        return this.sNumOfLdev;
    }

    public SJmoLdevIndex getStartLdevId() {
        return this.startLdevId;
    }

    public int getIPathGroupId() {
        return this.iPathGroupId;
    }

    public boolean isFicon() {
        boolean bRet = false;
        if (16641 <= this.iFB4 && 17152 >= this.iFB4) {
            bRet = true;
        }
        return bRet;
    }

    public SJmoExDPgInfo() {
    }

    public SJmoExDPgInfo(EXDVpg pgInfo) throws SJmoException {
        if (null == pgInfo) {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoExDPgInfo", "SJmoExDPgInfo");
        }
        this.setAllData(pgInfo);
    }

    public SJmoExDPgInfo(byte byDataMode) {
        this.setIDataMode(byDataMode);
    }

    public void setAllData(EXDVpg pgInfo) throws SJmoException {
        if (null != pgInfo) {
            this.setFB4(pgInfo.getIFB4());
            this.setPG(pgInfo.getIPG());
            this.setIMid(pgInfo.getId());
            this.setSNumOfLdev(pgInfo.getNumOfLdev());
            if (null != pgInfo.getStartLdevId()) {
                this.startLdevId.setSLdkc(pgInfo.getStartLdevId().getSLDKC());
                this.startLdevId.setSCu(pgInfo.getStartLdevId().getSCU());
                this.startLdevId.setSLdev(pgInfo.getStartLdevId().getSLDEV());
            }
        } else {
            throw SJmoUtility.getException(201, 23, 107000, "SJmoExDPgInfo", "setAllData");
        }
        this.setIPathGroupId(pgInfo.referPathGroupId());
    }

    @Override
    public int compareTo(Object keyObj) {
        int iCompRet = 0;
        if (keyObj instanceof SJmoPgIndex) {
            iCompRet = this.iFB4 - ((SJmoPgIndex)keyObj).getFB4();
            if (iCompRet == 0) {
                iCompRet = this.iPG - ((SJmoPgIndex)keyObj).getPG();
            }
        } else {
            iCompRet = super.compareTo(keyObj);
            SJmoUtility.putLogDetail("SJmoExDPgInfo", "compareTo", "The instance is illegal of keyObj.");
        }
        return iCompRet;
    }

    @Override
    public String toString() {
        if (this.strPgIndexKey.length() == 0) {
            StringBuffer strPgBuf = new StringBuffer();
            strPgBuf.append(SJmoUtility.itoh(this.getFB4(), 8));
            strPgBuf.append(SJmoUtility.itoh(this.getPG(), 8));
            this.strPgIndexKey = strPgBuf.toString();
        }
        return this.strPgIndexKey;
    }
}

