/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.model.update;

import java.util.ArrayList;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.serversx.data.RJiCUIndex;
import sanproject.serversx.data.RJiLDEVIndex;
import sanproject.serverux.dataimpl.RJiHURget1PairInfo;
import sanproject.serverux.dataimpl.RJiHURgetPairsInfo;
import sanproject.serverux.dataimpl.RJiHURgetPairsInfo_IN;
import sanproject.serverux.dataimpl.RJiHURgetPairsInfo_OUT;
import sanproject.serverux.dataimpl.RJiInputHurPairParam;
import sanproject.sn2.model.SJmoException;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.data.SJmoModelDataMgr;
import sanproject.sn2.model.data.inf.SJmoDataIndex_IF;
import sanproject.sn2.model.data.util.SJmoLdevUtility;
import sanproject.sn2.model.data.util.SJmoRemoteReplicationUtility;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.inf.SJmoDataMacro_IF;
import sanproject.sn2.model.update.SJmoDataUpDateByPairVolInf;

public class SJmoUniversalReplicatorPairUpdate
extends SJmoDataUpDateByPairVolInf {
    private RJiHURgetPairsInfo rmiURSummary = null;

    @Override
    protected Object getRmiData() throws SJmoException {
        ArrayList retRmi = new ArrayList();
        ArrayList<Object> rmiURData = new ArrayList();
        ArrayList<Object> rmiURMFData = new ArrayList();
        this.m_CUIndex = this.getDiffCuIndex();
        super.getVolPosInf();
        boolean bSummary = true;
        ArrayList<RJiLDEVIndex> alURPairLdevIndex = this.getNeedOpenLdevIndex();
        ArrayList<RJiLDEVIndex> alURMFPairLdevIndex = this.getNeedMfLdevIndex();
        if (alURPairLdevIndex != null && alURPairLdevIndex.size() != 0) {
            rmiURData = this.getRmiDataPairInfo(alURPairLdevIndex.toArray(new RJiLDEVIndex[alURPairLdevIndex.size()]), (short)1, bSummary);
            bSummary = false;
        }
        if (alURMFPairLdevIndex != null && alURMFPairLdevIndex.size() != 0) {
            rmiURMFData = this.getRmiDataPairInfo(alURMFPairLdevIndex.toArray(new RJiLDEVIndex[alURMFPairLdevIndex.size()]), (short)0, bSummary);
            bSummary = false;
        }
        if (rmiURData == null || rmiURMFData == null) {
            this.m_strLog = "[SJmoUniversalReplicatorPairUpdate]getRmi:rmiURData or rmiURMFData is null";
            this.putLog(this.m_strLog);
            throw this.throwExp("SJmoUniversalReplicatorPairUpdate", "getRmiData");
        }
        retRmi.addAll(rmiURData);
        retRmi.addAll(rmiURMFData);
        if (bSummary) {
            SJmoDataIndex_IF[] ldevDetail;
            for (SJmoDataIndex_IF getLdevDtl : ldevDetail = (SJmoDataIndex_IF[])this.m_DataMgr.getCloneHash().get(SJmoGetLdevDetail.class.getName())) {
                if (getLdevDtl == null) continue;
                SJmoLdevDetail ldevDtl = (SJmoLdevDetail)getLdevDtl;
                RJiLDEVIndex[] ldevindex = new RJiLDEVIndex[]{new RJiLDEVIndex()};
                ldevindex[0].setLDEVIndex((short)0, ldevDtl.getSCu(), ldevDtl.getSLdev());
                this.getRmiDataPairInfo(ldevindex, (short)0, bSummary);
                bSummary = false;
                break;
            }
        }
        return retRmi;
    }

    @Override
    protected boolean setModelData(SJmoModelDataMgr dataMgr, Object objRmi) throws SJmoException {
        boolean bRet = true;
        ArrayList rmiPairInfoList = null;
        if (!(objRmi instanceof ArrayList)) {
            this.m_strLog = "[SJmoUniversalReplicatorPairUpdate]setModelData:objRmi not cast ArrayList";
            this.putLog(this.m_strLog);
            throw this.throwExp("SJmoUniversalReplicatorPairUpdate", "setModelData");
        }
        rmiPairInfoList = (ArrayList)objRmi;
        dataMgr.setRenewUniversalReplicatorPairVolInfo(rmiPairInfoList, this.m_CUIndex, this.volPosInf);
        dataMgr.setRenewUniversalReplicatorSummary(this.rmiURSummary);
        return bRet;
    }

    private ArrayList<RJiLDEVIndex> getNeedOpenLdevIndex() {
        ArrayList<RJiLDEVIndex> alPairInfLdevIndex = new ArrayList<RJiLDEVIndex>();
        Object objLdevDtl = this.m_DataMgr.getCloneHash().get(SJmoGetLdevDetail.class.getName());
        if (objLdevDtl == null || this.m_CUIndex == null) {
            this.m_strLog = "[SJmoUniversalReplicatorPairUpdate]getNeedOpenLdevIndex:objLdevDtl or m_CUIndex is null";
            this.putLog(this.m_strLog);
            throw this.throwExp("SJmoUniversalReplicatorPairUpdate", "getNeedOpenLdevIndex");
        }
        if (!(objLdevDtl instanceof SJmoDataIndex_IF[])) {
            this.m_strLog = "[SJmoUniversalReplicatorPairUpdate]getNeedOpenLdevIndex:objLdevDtl not cast SJmoDataIndex_IF[]";
            this.putLog(this.m_strLog);
            throw this.throwExp("SJmoUniversalReplicatorPairUpdate", "getNeedOpenLdevIndex");
        }
        SJmoDataIndex_IF[] ldevDetail = (SJmoDataIndex_IF[])objLdevDtl;
        for (int iCuCnt = 0; iCuCnt < this.m_CUIndex.length; ++iCuCnt) {
            RJiCUIndex cuIndex = this.m_CUIndex[iCuCnt];
            for (int iLdevCnt = 0; iLdevCnt < SJmoDataMacro_IF.MAX_LDEV_CU; ++iLdevCnt) {
                int iLdevIndex = SJmoLdevUtility.getLdevIndex((short)0, cuIndex.getSCU(), (short)iLdevCnt);
                int iVolPosinfo = this.volPosInf.getIVolPosBitMap(iLdevIndex);
                if (!SJmoRemoteReplicationUtility.isURPair(iVolPosinfo)) continue;
                RJiLDEVIndex ldldx = new RJiLDEVIndex();
                ldldx.setLDEVIndex((short)0, cuIndex.getSCU(), (short)iLdevCnt);
                if (ldevDetail[iLdevIndex] == null || !SJmoLdevUtility.isTopVolume((SJmoLdevDetail)ldevDetail[iLdevIndex])) continue;
                alPairInfLdevIndex.add(ldldx);
            }
        }
        return alPairInfLdevIndex;
    }

    private ArrayList<RJiLDEVIndex> getNeedMfLdevIndex() {
        ArrayList<RJiLDEVIndex> alPairInfLdevIndex = new ArrayList<RJiLDEVIndex>();
        Object objLdevDtl = this.m_DataMgr.getCloneHash().get(SJmoGetLdevDetail.class.getName());
        if (objLdevDtl == null || this.m_CUIndex == null) {
            this.m_strLog = "[SJmoUniversalReplicatorPairUpdate]getNeedMfLdevIndex:objLdevDtl or m_CUIndex is null";
            this.putLog(this.m_strLog);
            throw this.throwExp("SJmoUniversalReplicatorPairUpdate", "getNeedMfLdevIndex");
        }
        if (!(objLdevDtl instanceof SJmoDataIndex_IF[])) {
            this.m_strLog = "[SJmoUniversalReplicatorPairUpdate]getNeedMfLdevIndex:objLdevDtl not cast SJmoDataIndex_IF[]";
            this.putLog(this.m_strLog);
            throw this.throwExp("SJmoUniversalReplicatorPairUpdate", "getNeedMfLdevIndex");
        }
        SJmoDataIndex_IF[] ldevDetail = (SJmoDataIndex_IF[])objLdevDtl;
        for (int iCuCnt = 0; iCuCnt < this.m_CUIndex.length; ++iCuCnt) {
            RJiCUIndex cuIndex = this.m_CUIndex[iCuCnt];
            for (int iLdevCnt = 0; iLdevCnt < SJmoDataMacro_IF.MAX_LDEV_CU; ++iLdevCnt) {
                int iLdevIndex = SJmoLdevUtility.getLdevIndex((short)0, cuIndex.getSCU(), (short)iLdevCnt);
                int iVolPosinfo = this.volPosInf.getIVolPosBitMap(iLdevIndex);
                if (!SJmoRemoteReplicationUtility.isURMFPair(iVolPosinfo)) continue;
                RJiLDEVIndex ldldx = new RJiLDEVIndex();
                ldldx.setLDEVIndex((short)0, cuIndex.getSCU(), (short)iLdevCnt);
                if (ldevDetail[iLdevIndex] == null || !SJmoLdevUtility.isTopVolume((SJmoLdevDetail)ldevDetail[iLdevIndex])) continue;
                alPairInfLdevIndex.add(ldldx);
            }
        }
        return alPairInfLdevIndex;
    }

    private ArrayList<RJiHURget1PairInfo> getRmiDataPairInfo(RJiLDEVIndex[] alPairLdevIndex, short sPP, boolean bSummary) throws SJmoException {
        ArrayList<RJiHURget1PairInfo> retRmiList = new ArrayList<RJiHURget1PairInfo>();
        RJiHURgetPairsInfo_IN input = null;
        RJiHURgetPairsInfo_OUT output = null;
        int iLdevIndexSize = 0;
        int iGetLdevCnt = 0;
        int iStart = 0;
        if (alPairLdevIndex == null || sPP != 0 && sPP != 1) {
            this.m_strLog = "[SJmoUniversalReplicatorPairUpdate]getRmiDataPairInfo:alPairLdevIndex is null or sPP is Invalid";
            this.putLog(this.m_strLog);
            throw this.throwExp("SJmoUniversalReplicatorPairUpdate", "getRmiDataPairInfo");
        }
        RJiInputHurPairParam inPrm = new RJiInputHurPairParam();
        inPrm.setPP(sPP);
        while (alPairLdevIndex.length > iGetLdevCnt) {
            int iRemainderIndex = alPairLdevIndex.length - iStart;
            iLdevIndexSize = iRemainderIndex > 2048 ? 2048 : iRemainderIndex;
            Robj_interface_RJiLDEVIndex[] getPairLdevIndex = SJmoRemoteReplicationUtility.getLdevArrangement(alPairLdevIndex, iStart, iLdevIndexSize);
            inPrm.setLDEVs(getPairLdevIndex);
            input = new RJiHURgetPairsInfo_IN(inPrm);
            output = (RJiHURgetPairsInfo_OUT)this.m_supAgnt.getDataInf(input, false);
            if (output == null || output.getDataObject() == null) {
                this.m_strLog = "[SJmoUniversalReplicatorPairUpdate]getRmi:getRmiDataPairInfo return is null";
                this.putLog(this.m_strLog);
                throw this.throwExp("SJmoUniversalReplicatorPairUpdate", "getRmiDataPairInfo");
            }
            retRmiList.addAll(output.getDataObject().getPairInfo());
            iStart = iGetLdevCnt += iLdevIndexSize;
            if (!bSummary) continue;
            this.rmiURSummary = (RJiHURgetPairsInfo)output.getDataObject();
            bSummary = false;
        }
        return retRmiList;
    }
}

