/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.rptdt.csv.wrapper;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import sanproject.sn2.rptdt.csv.wrapper.SJdtCSVWrapperBase;

public class SJdtLunInfoCSVWrapper
extends SJdtCSVWrapperBase {
    private static final String csvName = "LunInfo";

    @Override
    public String getCsvName() {
        return csvName;
    }

    public List<String> getLdevSet(List<String[]> targetCsvDataList, SJdtCSVWrapperBase luseInfo) {
        LinkedHashMap map = new LinkedHashMap();
        for (String[] record : targetCsvDataList) {
            String numberOfLdevsStr = this.getValue(record, "Number of LDEVs");
            if (StringUtils.isEmpty((String)numberOfLdevsStr)) continue;
            int numberOfLdevs = Integer.parseInt(numberOfLdevsStr);
            String ldev = this.getValue(record, "LDEV#");
            if (numberOfLdevs == 1) {
                if (!StringUtils.isNotEmpty((String)ldev)) continue;
                map.put(ldev, null);
                continue;
            }
            String[] luseInfoRecord = luseInfo.getKeyRecord(ldev);
            for (int i = 0; i < numberOfLdevs; ++i) {
                String columnName = "LDKC:CU:LDEV(" + i + ")";
                String luseInfoLdev = luseInfo.getValue(luseInfoRecord, columnName);
                if (!StringUtils.isNotEmpty((String)luseInfoLdev)) continue;
                map.put(luseInfoLdev, null);
            }
        }
        return new ArrayList<String>(map.keySet());
    }

    public List<String> getLdevSet(List<String[]> targetCsvDataList) {
        LinkedHashMap map = new LinkedHashMap();
        for (String[] record : targetCsvDataList) {
            String ldev = this.getValue(record, "LDEV#");
            if (!StringUtils.isNotEmpty((String)ldev)) continue;
            map.put(ldev, null);
        }
        return new ArrayList<String>(map.keySet());
    }

    public List<String[]> getLunsRecordList(String portSearchStr) {
        ArrayList<String[]> lunsRecordList = new ArrayList<String[]>();
        for (String[] record : this.csvDataList) {
            String port = this.getValue(record, "Port");
            String lun = this.getValue(record, "LUN#");
            if (!port.equals(portSearchStr) || !StringUtils.isNotEmpty((String)lun)) continue;
            lunsRecordList.add(record);
        }
        return lunsRecordList;
    }

    public List<String[]> getLunsRecordList(String portSearchStr, String hostGroupSearchStr) {
        ArrayList<String[]> lunsRecordList = new ArrayList<String[]>();
        for (String[] record : this.csvDataList) {
            String port = this.getValue(record, "Port");
            String hostGroup = this.getValue(record, "Host Group");
            String lun = this.getValue(record, "LUN#");
            if (!port.equals(portSearchStr) || !hostGroup.equals(hostGroupSearchStr) || !StringUtils.isNotEmpty((String)lun)) continue;
            lunsRecordList.add(record);
        }
        return lunsRecordList;
    }
}

