/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.rptdt.report.generator;

import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.rptdt.csv.SJdtCSVWrapperManager;
import sanproject.sn2.rptdt.csv.wrapper.SJdtLdevInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtLuseInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtPdevInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtSsidInfoCSVWrapper;
import sanproject.sn2.rptdt.report.generator.SJdtTableReportGenerator;

public class SJdtLuseReportGenerator
extends SJdtTableReportGenerator {
    private static final String REPORT_NAME = "Luse";
    private static final boolean IS_GRAPHIC_REPORT = false;
    private static final boolean USE_TABLE_SORT = true;
    private static final boolean USE_CONTENTS_FOOTER = false;
    private static final String[] HEADER_KEY_ARRAY = new String[]{"topLdev", "memberLdevs", "emulationType", "totalLdevCapacity", "individualLdevCapacity", "numberOfMemberLdevs", "pg", "raidLevel", "driveTypeCode", "driveCapacity", "ssid", "cmdDev"};
    private static final int COLUMN_LENGTH = SJdtLuseReportGenerator.getColumnLengthForKeySort(HEADER_KEY_ARRAY.length);
    private static final String MENU_LINK_VIEW_KEY = "Common.menu.Luse";
    private static final String EXPLANATION_KEY = "Common.explanation.Luse";
    private static final String TABLE_HEADER_BASE_KEY = "Luse.table.header";
    private static final String REPORT_FRAMESET_HTML_FILE_NAME = "Luse.html";
    private static final String MENU_FRAMESET_HTML_FILE_NAME = "menuFrameset_Luse.html";
    private static final String MENU_BODY_HTML_FILE_NAME = "menuBody_Luse.html";
    private static final String CONTENTS_FRAMESET_HTML_FILE_NAME = "contentsFrameset_Luse.html";
    private static final String CONTENTS_TITLE_HTML_FILE_NAME = "contentsTitle_Luse.html";
    private static final String CONTENTS_BODY_HTML_FILE_NAME = "contentsBody_Luse.html";

    @Override
    public String getReportName() {
        return REPORT_NAME;
    }

    @Override
    public boolean isGraphicReport() {
        return false;
    }

    @Override
    public boolean useTableSort() {
        return true;
    }

    @Override
    public boolean useContentsFooter() {
        return false;
    }

    @Override
    public String[] getTableHeaderKeyArray() {
        return HEADER_KEY_ARRAY;
    }

    @Override
    public String getMenuLinkViewKey() {
        return MENU_LINK_VIEW_KEY;
    }

    @Override
    public String getExplanationKey() {
        return EXPLANATION_KEY;
    }

    @Override
    public String getTableHeaderBaseKey() {
        return TABLE_HEADER_BASE_KEY;
    }

    @Override
    public String getReportFramesetHtmlFileName() {
        return REPORT_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getMenuFramesetHtmlFileName() {
        return MENU_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getMenuBodyHtmlFileName() {
        return MENU_BODY_HTML_FILE_NAME;
    }

    @Override
    public String getContentsFramesetHtmlFileName() {
        return CONTENTS_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getContentsTitleHtmlFileName() {
        return CONTENTS_TITLE_HTML_FILE_NAME;
    }

    @Override
    public String getContentsBodyHtmlFileName() {
        return CONTENTS_BODY_HTML_FILE_NAME;
    }

    @Override
    public boolean isEnableSortKey() {
        return true;
    }

    @Override
    public List<String[]> getTableDataList() {
        ArrayList<String[]> tableDataList = new ArrayList<String[]>();
        SJdtSsidInfoCSVWrapper ssidInfo = (SJdtSsidInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("SsidInfo.csv");
        SJdtLdevInfoCSVWrapper ldevInfo = (SJdtLdevInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("LdevInfo.csv");
        SJdtPdevInfoCSVWrapper pdevInfo = (SJdtPdevInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("PdevInfo.csv");
        SJdtLuseInfoCSVWrapper luseInfo = (SJdtLuseInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("LuseInfo.csv");
        List<String[]> csvDataList = luseInfo.getCsvDataList();
        for (String[] luseInfoRecord : csvDataList) {
            int numberOfLdevs = Integer.parseInt(luseInfo.getValue(luseInfoRecord, "Number of LDEVs"));
            if (numberOfLdevs < 2) continue;
            for (int i = 0; i < numberOfLdevs; ++i) {
                String cmdDev;
                String[] oneRecord = new String[COLUMN_LENGTH];
                String topLdev = luseInfo.getValue(luseInfoRecord, "LDKC:CU:LDEV(0)");
                oneRecord[((Integer)SJdtLuseReportGenerator.headerMap.get((Object)"topLdev")).intValue()] = topLdev.toUpperCase();
                String memberLdevColumn = "LDKC:CU:LDEV(" + i + ")";
                String memberLdev = luseInfo.getValue(luseInfoRecord, memberLdevColumn);
                oneRecord[((Integer)SJdtLuseReportGenerator.headerMap.get((Object)"memberLdevs")).intValue()] = memberLdev.toUpperCase();
                oneRecord[((Integer)SJdtLuseReportGenerator.headerMap.get((Object)"emulationType")).intValue()] = luseInfo.getValue(luseInfoRecord, "LDEV Emulation");
                oneRecord[((Integer)SJdtLuseReportGenerator.headerMap.get((Object)"totalLdevCapacity")).intValue()] = luseInfo.getValue(luseInfoRecord, "Volume Size(MB)");
                oneRecord[((Integer)SJdtLuseReportGenerator.headerMap.get((Object)"numberOfMemberLdevs")).intValue()] = luseInfo.getValue(luseInfoRecord, "Number of LDEVs");
                String eccGroup = "";
                String ldevAttribute = "";
                String[] ldevInfoeRecord = ldevInfo.getKeyRecord(memberLdev);
                oneRecord[((Integer)SJdtLuseReportGenerator.headerMap.get((Object)"individualLdevCapacity")).intValue()] = ldevInfo.getValue(ldevInfoeRecord, "Volume Size(MB)");
                eccGroup = ldevInfo.getValue(ldevInfoeRecord, "ECC Group");
                ldevAttribute = ldevInfo.getKeyRecordColumnValue(topLdev, "LDEV Attribute");
                oneRecord[((Integer)SJdtLuseReportGenerator.headerMap.get((Object)"pg")).intValue()] = eccGroup;
                String[] pdevInfoRecord = pdevInfo.getMatchedOneRecord(eccGroup, "ECC Group");
                oneRecord[((Integer)SJdtLuseReportGenerator.headerMap.get((Object)"raidLevel")).intValue()] = pdevInfo.getValue(pdevInfoRecord, "RAID Level");
                oneRecord[((Integer)SJdtLuseReportGenerator.headerMap.get((Object)"driveTypeCode")).intValue()] = pdevInfo.getValue(pdevInfoRecord, "Device Type-Code");
                oneRecord[((Integer)SJdtLuseReportGenerator.headerMap.get((Object)"driveCapacity")).intValue()] = pdevInfo.getValue(pdevInfoRecord, "Device Capacity");
                String ssid = ssidInfo.getSsid(memberLdev);
                oneRecord[((Integer)SJdtLuseReportGenerator.headerMap.get((Object)"ssid")).intValue()] = ssid.toUpperCase();
                oneRecord[((Integer)SJdtLuseReportGenerator.headerMap.get((Object)"cmdDev")).intValue()] = cmdDev = this.getCmdDevAsDisplayStr(ldevAttribute);
                tableDataList.add(oneRecord);
            }
        }
        return tableDataList;
    }

    private String getCmdDevAsDisplayStr(String ldevAttribute) {
        String result = null;
        result = "CMDDEV".equals(ldevAttribute) || "CMDDEV*".equals(ldevAttribute) ? "Y" : "N";
        return result;
    }
}

