/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.servlet.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sanproject.sn2.base.session.SJbaseUserSessionManager;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.SJcConst;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcSingletonManagerUty;

public class SJsvlFileDownloadServlet
extends HttpServlet {
    private static final long serialVersionUID = 0L;
    private static final String ENCODE_UTF8 = "UTF-8";
    private static final String LOG_FUNCTION = "FileDownloadUtility";
    private static final String LOG_TITLE = "SJsvlFileDownloadServlet";
    private static final String KEY_SPECIALFILELIST_ITEMS = "fileList";
    private static final String VAL_SPECIALFILELIST_ITEMS_REGEX = ",";
    private static final String KEY_SPECIALFILELIST_FILEPATH_SUFFIX = ".filePath";
    private static final String KEY_SPECIALFILELIST_AUTHENTICATION_SUFFIX = ".authentication";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String LOG_SUBTITLE = "doGet";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "doGet", "Start.");
        this.doPost(request, response);
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "doGet", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String LOG_SUBTITLE = "doPost";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "doPost", "Start.");
        request.setCharacterEncoding(ENCODE_UTF8);
        String sessionID = request.getParameter("GlobalSessionID");
        String userName = request.getParameter("UserName");
        String fileName = request.getParameter("FileName");
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "doPost", "sessionID:" + sessionID + ", userName:" + userName + ", fileName:" + fileName);
        if (fileName == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "doPost", "fileName:" + fileName);
            response.sendError(404);
            return;
        }
        SJsvlFileDownLoadInfo downloadInfo = this.decisionDownLoadType(fileName);
        if (downloadInfo == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "doPost", "fileName:" + fileName);
            response.sendError(404);
            return;
        }
        if (downloadInfo.isAuthentication() && (sessionID == null || userName == null)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "doPost", "sessionID:" + sessionID + "userName:" + userName);
            try {
                this.deleteFile(downloadInfo.getDownloadType(), fileName);
            }
            catch (SJcException e) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "doPost", "SJcException:" + e);
            }
            finally {
                response.sendError(404);
            }
            return;
        }
        String path = downloadInfo.getFilePath();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "doPost", "pathTo:" + path);
        if (downloadInfo.isAuthentication()) {
            SJbaseUserSessionManager sessionManager = (SJbaseUserSessionManager)SJcSingletonManagerUty.getInstance(SJbaseUserSessionManager.class);
            SJbaseUserSessionInterface userSession = sessionManager.getUserSession(sessionID);
            STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "doPost", "userSession:" + userSession);
            if (userSession == null) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "doPost", "UserSession is null.");
                try {
                    this.deleteFile(downloadInfo.getDownloadType(), fileName);
                }
                catch (SJcException e) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "doPost", "SJcException:" + e);
                }
                response.sendError(404);
                return;
            }
            String usUserName = userSession.getUserName();
            String usSessionID = userSession.getSessionID();
            STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "doPost", "usUserName:" + usUserName + ", usSessionID:" + usSessionID);
            if (!userName.equals(usUserName) || !sessionID.equals(usSessionID)) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "doPost", "userName:" + userName + "!= usUserName:" + usUserName + ", sessionID:" + sessionID + "!= usSessionID:" + usSessionID);
                try {
                    this.deleteFile(downloadInfo.getDownloadType(), fileName);
                }
                catch (SJcException e) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "doPost", "SJcException:" + e);
                }
                response.sendError(404);
                return;
            }
        }
        int bufSize = SJcEnvUty.getProperty2int("SN_SVL_FileDownloadLimitBufferSize", 4096);
        byte[] buffer = new byte[bufSize];
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "doPost", "bufSize:" + bufSize);
        ServletOutputStream out = null;
        InputStream inStream = null;
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + new File(path).getName() + "\"");
        try {
            out = response.getOutputStream();
            inStream = SJcFileUty.getInStream(path);
            int size = 0;
            while ((size = inStream.read(buffer)) != -1) {
                out.write(buffer, 0, size);
            }
        }
        catch (Exception ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "doPost", "Exception:" + ex);
            try {
                this.deleteFile(downloadInfo.getDownloadType(), fileName);
            }
            catch (SJcException e) {
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "doPost", "Exception:" + e);
            }
            response.sendError(404);
            return;
        }
        finally {
            if (null != inStream) {
                try {
                    inStream.close();
                }
                catch (Exception e) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "doPost", "Failed to inStream close.", e);
                }
            }
            if (null != out) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "doPost", "Failed to outStream close.", e);
                }
            }
        }
        try {
            this.deleteFile(downloadInfo.getDownloadType(), fileName);
        }
        catch (SJcException e) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "doPost", "Exception:" + e);
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "doPost", "End.");
    }

    private SJsvlFileDownLoadInfo decisionDownLoadType(String key) {
        SJsvlFileDownLoadInfo downloadInfo = null;
        downloadInfo = this.searchDownLoadDir(key);
        if (downloadInfo != null) {
            return downloadInfo;
        }
        downloadInfo = this.searchDownLoadTable(key);
        if (downloadInfo != null) {
            return downloadInfo;
        }
        downloadInfo = this.searchDownLoadFileList(key);
        if (downloadInfo != null) {
            return downloadInfo;
        }
        return downloadInfo;
    }

    private SJsvlFileDownLoadInfo searchDownLoadDir(String key) {
        SJsvlFileDownLoadInfo downloadInfo = null;
        String dataPath = SJcFileUty.concatFolderPath(SJcEnvUty.getProperty("SN_DataPath"), "data");
        String downLoadDirPath = SJcFileUty.concatFolderPath(dataPath, SJcConst.FILE_DOWNLOAD_DIRECTORY);
        String downLoadPath = downLoadDirPath + key;
        boolean exist_flg = SJcFileUty.existsAbsolutePath(downLoadPath);
        if (exist_flg) {
            downloadInfo = new SJsvlFileDownLoadInfo();
            downloadInfo.setDownloadKey(key);
            downloadInfo.setDownloadType(SJsvlFileDownloadType.DOWNLOAD_DIRECTORY);
            downloadInfo.setAuthentication(true);
            downloadInfo.setFilePath(downLoadPath);
        }
        return downloadInfo;
    }

    private SJsvlFileDownLoadInfo searchDownLoadTable(String key) {
        SJsvlFileDownLoadInfo downloadInfo = null;
        String path = SJcFileUty.getDownloadFile(key);
        if (path == null) {
            return downloadInfo;
        }
        boolean exist_flg = SJcFileUty.existsAbsolutePath(path);
        if (exist_flg) {
            downloadInfo = new SJsvlFileDownLoadInfo();
            downloadInfo.setDownloadKey(key);
            downloadInfo.setDownloadType(SJsvlFileDownloadType.DOWNLOAD_TABLE);
            downloadInfo.setAuthentication(true);
            downloadInfo.setFilePath(path);
        }
        return downloadInfo;
    }

    private SJsvlFileDownLoadInfo searchDownLoadFileList(String key) {
        SJsvlFileDownLoadInfo downloadInfo = null;
        String settingFile = SJcEnvUty.getProperty("SN_Com_FileReadList");
        if (settingFile == null) {
            return downloadInfo;
        }
        Properties props = null;
        try {
            props = SJcFileUty.loadProperties("", settingFile);
        }
        catch (SJcException ex) {
            return downloadInfo;
        }
        List<SJsvlFileDownLoadInfo> fileList = this.initDownLoadFileList(props);
        if (fileList == null) {
            return downloadInfo;
        }
        for (SJsvlFileDownLoadInfo fileInfo : fileList) {
            if (!key.equals(fileInfo.getDownloadKey())) continue;
            boolean exist_flg = SJcFileUty.existsAbsolutePath(fileInfo.getFilePath());
            if (!exist_flg) break;
            downloadInfo = fileInfo;
            break;
        }
        return downloadInfo;
    }

    private List<SJsvlFileDownLoadInfo> initDownLoadFileList(Properties props) {
        ArrayList<SJsvlFileDownLoadInfo> list = new ArrayList<SJsvlFileDownLoadInfo>();
        if (props == null) {
            return list;
        }
        String fileList = props.getProperty(KEY_SPECIALFILELIST_ITEMS);
        if (fileList == null) {
            return list;
        }
        String dataPath = SJcFileUty.concatFolderPath(SJcEnvUty.getProperty("SN_DataPath"), "data");
        String[] files = fileList.split(VAL_SPECIALFILELIST_ITEMS_REGEX);
        for (int i = 0; i < files.length; ++i) {
            String key = files[i].trim();
            String pathKey = key + KEY_SPECIALFILELIST_FILEPATH_SUFFIX;
            String filePath = props.getProperty(pathKey);
            if (filePath == null) continue;
            boolean absoPathFlg = SJcFileUty.isAbsolutePath(filePath);
            if (!absoPathFlg) {
                filePath = dataPath + filePath;
            }
            String authenticationKey = key + KEY_SPECIALFILELIST_AUTHENTICATION_SUFFIX;
            boolean authenticationFlg = false;
            try {
                authenticationFlg = Boolean.valueOf(props.getProperty(authenticationKey));
            }
            catch (Exception ex) {
                // empty catch block
            }
            SJsvlFileDownLoadInfo fileInfo = new SJsvlFileDownLoadInfo();
            fileInfo.setDownloadKey(key);
            fileInfo.setDownloadType(SJsvlFileDownloadType.DOWNLOAD_FILELIST);
            fileInfo.setFilePath(filePath);
            fileInfo.setAuthentication(authenticationFlg);
            list.add(fileInfo);
        }
        return list;
    }

    private void deleteFile(SJsvlFileDownloadType downloadType, String fileName) throws SJcException {
        switch (downloadType) {
            case DOWNLOAD_DIRECTORY: {
                SJcFileUty.deleteFile(SJcConst.FILE_DOWNLOAD_DIRECTORY, fileName);
                break;
            }
            case DOWNLOAD_TABLE: {
                SJcFileUty.deleteDownloadFile(fileName);
                break;
            }
        }
    }

    private class SJsvlFileDownLoadInfo {
        private String downloadKey;
        private SJsvlFileDownloadType downloadType = SJsvlFileDownloadType.DOWNLOAD_DIRECTORY;
        private String filePath;
        private boolean authentication = false;

        private SJsvlFileDownLoadInfo() {
        }

        public void setDownloadKey(String key) {
            this.downloadKey = key;
        }

        public String getDownloadKey() {
            return this.downloadKey;
        }

        public void setDownloadType(SJsvlFileDownloadType downloadType) {
            this.downloadType = downloadType;
        }

        public SJsvlFileDownloadType getDownloadType() {
            return this.downloadType;
        }

        public void setFilePath(String path) {
            this.filePath = path;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public void setAuthentication(boolean authentication) {
            this.authentication = authentication;
        }

        public boolean isAuthentication() {
            return this.authentication;
        }
    }

    private static enum SJsvlFileDownloadType {
        DOWNLOAD_DIRECTORY,
        DOWNLOAD_TABLE,
        DOWNLOAD_FILELIST;

    }
}

