/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.servlet.verifyreport;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.UUID;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import sanproject.sn2.base.session.SJbaseUserSessionManager;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcProductUty;
import sanproject.sn2.com.utility.SJcSingletonManagerUty;

public class SJsvlVerifyReportAccessCtrlServlet
extends HttpServlet
implements Servlet {
    private static final long serialVersionUID = -3720913347442851011L;
    private static final String LOG_FUNCTION = "VerifyReport";
    private static final String LOG_TITLE = "SJsvlVerifyReportAccessCtrlServlet";
    private static final String path = SJcEnvUty.getSnDataPath() + "data";
    private static final String TEXT = "TEXT";
    private static final String BINARY = "BIN";
    private static final String GLOBALSESSIONID = "GlobalSessionID";
    private static final String MS932 = "MS932";
    private static final String S_KEY = "sKEY";
    private static final String S_VALUE = "sVALUE";
    private static final String DOT = "\\.";
    private static final String ENCODE_TYPE = "UTF-8";
    private static final String CONTENT_TYPE = "text/html; charset=UTF-8";
    private static final String USER_FAILED_JA = "\u30e6\u30fc\u30b6\u306e\u8a8d\u8a3c\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
    private static final String USER_FAILED_EN = "Failed in the certification of the user.";
    private static final String FILEINFO_FAILED_JA = "\u30d5\u30a1\u30a4\u30eb\u60c5\u5831\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
    private static final String FILEINFO_FAILED_EN = "Failed in the acquisition of the file information.";
    private static final String FILELOAD_FAILED_JA = "\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002";
    private static final String FILELOAD_FAILED_EN = "An error occurred while reading a file.";
    private static final int COK_NOWAIT = -1;
    private static final int COK_WAIT3600 = 3600;
    private static final String USER_AGENT = "user-agent";
    private static final String BRWZR_MSIE = "MSIE";
    private static final String[][] cnvList = new String[][]{{"", "", "BIN"}, {"jpeg", "image/jpeg", "BIN"}, {"jpg", "image/jpeg", "BIN"}, {"gif", "image/gif", "BIN"}, {"txt", "text/plain; charset=UTF-8", "TEXT"}, {"htm", "text/html; charset=UTF-8", "TEXT"}, {"html", "text/html; charset=UTF-8", "TEXT"}, {"css", "text/css; charset=UTF-8", "TEXT"}, {"png", "image/png", "BIN"}, {"xml", "text/xml; charset=UTF-8", "TEXT"}, {"js", "application/x-javascript; charset=UTF-8", "TEXT"}, {"csv", "text/plain; charset=UTF-8", "TEXT"}, {"swf", "application/x-shockwave-flash", "BIN"}};
    String gid = "";
    String cValue = null;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String LOG_SUBTITLE = "doGet";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "doGet", "Start. request.getPathInfo() = " + request.getPathInfo());
        this.doPost(request, response);
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "doGet", "End.");
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String LOG_SUBTITLE = "doPost";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "doPost", "Start. request.getPathInfo() = " + request.getPathInfo());
        Enumeration e = request.getHeaders("Accept-Language");
        String lng = (String)e.nextElement();
        if (!this.authenticate(request, response)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "doPost", "Authentication failed.");
            response.setContentType(CONTENT_TYPE);
            PrintWriter out = response.getWriter();
            out.println(this.getMessage(0, lng));
            out.close();
            return;
        }
        String pathInfo = request.getPathInfo();
        if (pathInfo == null || "".equals(pathInfo)) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "doPost", "pathInfo:" + pathInfo);
            response.setContentType(CONTENT_TYPE);
            PrintWriter out = response.getWriter();
            out.println(this.getMessage(1, lng));
            out.close();
            return;
        }
        String[] infoBuf = pathInfo.split(DOT);
        String extension = "";
        if (infoBuf.length > 1) {
            extension = infoBuf[infoBuf.length - 1].toUpperCase();
        }
        String contentType = cnvList[0][1];
        String fileType = cnvList[0][2];
        for (int i = 0; i < cnvList.length; ++i) {
            if (!extension.equals(cnvList[i][0].toUpperCase())) continue;
            contentType = cnvList[i][1];
            fileType = cnvList[i][2];
        }
        if ("".equals(contentType) || "".equals(fileType)) {
            response.setContentType(CONTENT_TYPE);
            PrintWriter out = response.getWriter();
            out.println(this.getMessage(2, lng));
            out.close();
            return;
        }
        response.setContentType(contentType);
        if (!this.outFile(request, response, fileType)) {
            response.setContentType(CONTENT_TYPE);
            PrintWriter out = response.getWriter();
            out.println(this.getMessage(2, lng));
            out.close();
            return;
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "doPost", "End.");
    }

    private boolean authenticate(HttpServletRequest request, HttpServletResponse response) {
        String LOG_SUBTITLE = "authenticate";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "authenticate", "Start.");
        boolean rtn = false;
        HttpSession session = request.getSession(true);
        this.gid = "";
        Cookie[] cookies2 = request.getCookies();
        if (cookies2 != null) {
            for (int i = 0; i < cookies2.length; ++i) {
                if (!GLOBALSESSIONID.equals(cookies2[i].getName())) continue;
                String ckData = cookies2[i].getValue();
                if (ckData == null || ckData.equals("")) break;
                this.gid = ckData;
                cookies2[i].setPath("/");
                cookies2[i].setValue("");
                cookies2[i].setMaxAge(0);
                response.addCookie(cookies2[i]);
                break;
            }
        }
        if (this.gid != null && !"".equals(this.gid)) {
            SJbaseUserSessionManager sessionManager = (SJbaseUserSessionManager)SJcSingletonManagerUty.getInstance(SJbaseUserSessionManager.class);
            SJbaseUserSessionInterface userSession = sessionManager.getUserSession(this.gid);
            if (userSession == null) {
                this.cValue = null;
            } else {
                String sKey = UUID.nameUUIDFromBytes(this.gid.getBytes()).toString();
                String sValue = UUID.randomUUID().toString();
                session.setAttribute(S_KEY, (Object)sKey);
                session.setAttribute(S_VALUE, (Object)sValue);
                try {
                    this.cValue = sValue = URLEncoder.encode(sValue, ENCODE_TYPE);
                }
                catch (UnsupportedEncodingException e) {
                    this.cValue = null;
                    e.printStackTrace();
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "authenticate", "URL encoding error: message = " + e.getMessage());
                }
                if (this.cValue != null) {
                    Cookie cookie = new Cookie(sKey, sValue);
                    if (request.getHeader(USER_AGENT).indexOf(BRWZR_MSIE) >= 0) {
                        cookie.setMaxAge(-1);
                        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "authenticate", "Browzer:IE");
                    } else {
                        cookie.setMaxAge(3600);
                        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "authenticate", "Browzer:other than IE");
                    }
                    cookie.setPath(request.getContextPath() + request.getServletPath());
                    response.addCookie(cookie);
                }
            }
        } else {
            String sValue;
            Cookie[] cookies = request.getCookies();
            String sKey = (String)session.getAttribute(S_KEY);
            Cookie helloCookie = null;
            if (cookies != null) {
                for (int i = 0; i < cookies.length; ++i) {
                    if (!cookies[i].getName().equals(sKey)) continue;
                    helloCookie = cookies[i];
                    break;
                }
            }
            if (helloCookie != null) {
                try {
                    this.cValue = URLDecoder.decode(helloCookie.getValue(), ENCODE_TYPE);
                }
                catch (UnsupportedEncodingException e) {
                    this.cValue = null;
                    e.printStackTrace();
                    STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "authenticate", "URL decoding error: message = " + e.getMessage());
                }
            }
            if ((sValue = (String)session.getAttribute(S_VALUE)) == null || !sValue.equals(this.cValue)) {
                this.cValue = null;
            }
        }
        if (this.cValue != null && !"".equals(this.cValue)) {
            rtn = true;
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "authenticate", "End.");
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean outFile(HttpServletRequest request, HttpServletResponse response, String fileType) throws ServletException, IOException {
        SJcLoggerInterface STD_LOGGER;
        boolean ret;
        block22: {
            ret = true;
            String LOG_SUBTITLE = "outFile";
            STD_LOGGER = SJcLogUty.getLogger();
            STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "outFile", "Start.");
            PrintWriter out = null;
            FileInputStream fis = null;
            String path_all = path + request.getServletPath() + request.getPathInfo();
            try {
                fis = new FileInputStream(path_all);
                if (fileType.endsWith(TEXT)) {
                    InputStreamReader isr = null;
                    BufferedReader br = null;
                    try {
                        String msg;
                        isr = new InputStreamReader((InputStream)fis, MS932);
                        br = new BufferedReader(isr);
                        while ((msg = br.readLine()) != null) {
                            if (out == null) {
                                out = response.getWriter();
                            }
                            out.println(msg);
                        }
                        break block22;
                    }
                    finally {
                        br.close();
                        isr.close();
                    }
                }
                BufferedInputStream in = null;
                try {
                    int b;
                    in = new BufferedInputStream(fis);
                    while ((b = in.read()) != -1) {
                        if (out == null) {
                            out = response.getWriter();
                        }
                        out.write(b);
                    }
                }
                finally {
                    in.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "outFile", "path_all:" + path_all);
                ret = false;
            }
            finally {
                try {
                    fis.close();
                }
                catch (Exception ex) {}
            }
        }
        STD_LOGGER.info(LOG_FUNCTION, LOG_TITLE, "outFile", "End.");
        return ret;
    }

    private String getMessage(int errorType, String sAccLang) {
        String venderID = SJcProductUty.getVenderID();
        String ret = null;
        if ((venderID.equals("HIJ") || venderID.equals("HPJ")) && sAccLang.indexOf("ja") != -1) {
            switch (errorType) {
                case 0: {
                    ret = USER_FAILED_JA;
                    break;
                }
                case 1: {
                    ret = FILEINFO_FAILED_JA;
                    break;
                }
                case 2: {
                    ret = FILELOAD_FAILED_JA;
                }
            }
            return ret;
        }
        switch (errorType) {
            case 0: {
                ret = USER_FAILED_EN;
                break;
            }
            case 1: {
                ret = FILEINFO_FAILED_EN;
                break;
            }
            case 2: {
                ret = FILELOAD_FAILED_EN;
            }
        }
        return ret;
    }
}

