/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.sn2com.execapp;

import java.lang.reflect.Array;
import sanproject.sn2.sn2com.execapp.SJappDefConst;
import sanproject.sn2.sn2com.execapp.SJappLiveNotifier;
import sanproject.sn2.sn2com.execapp.SJappStartApp_Interface;
import sanproject.sn2.sn2com.execapp.SJappWriteLog;

public class SJappStartApp_SVP
implements SJappStartApp_Interface {
    private static final String LOG_FUNCTION = "SJappStartApp_SVP";
    private static final String LOG_TITLE = "SJappStartApp_SVP";
    private String syncEnd = null;
    private String[] execCmd = SJappDefConst.execinitCmd;
    private Process process = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        String LOG_SUBTITLE = "main";
        SJappStartApp_SVP app = new SJappStartApp_SVP();
        try {
            SJappWriteLog.info("SJappStartApp_SVP", "SJappStartApp_SVP", "main", "Start.");
            app.init();
            app.exec();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        finally {
            SJappWriteLog.info("SJappStartApp_SVP", "SJappStartApp_SVP", "main", "End.");
            System.exit(0);
        }
    }

    private SJappStartApp_SVP() {
    }

    private void init() throws Exception {
        String LOG_SUBTITLE = "init";
        try {
            String appPath = SJappLiveNotifier.getProperty(SJappDefConst.SVP_APP_PATH);
            String appArgs = SJappLiveNotifier.getProperty(SJappDefConst.SVP_APP_ARG, "");
            this.syncEnd = SJappLiveNotifier.getProperty(SJappDefConst.SVP_APP_SYNCEND);
            if (appPath == null || this.syncEnd == null) {
                SJappWriteLog.error("SJappStartApp_SVP", "SJappStartApp_SVP", "init", "Start.");
                throw new Exception();
            }
            if (appArgs == null) {
                appArgs = "";
            }
            Object[] appPathArray = new String[]{appPath};
            Object[] argArray = appArgs.split(" ");
            Object[] arg = (String[])this.concat(String.class, appPathArray, argArray);
            this.execCmd = (String[])this.concat(String.class, SJappDefConst.execinitCmd, arg);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public void exec() throws Exception {
        String LOG_SUBTITLE = "exec";
        SJappLiveNotifier notify = new SJappLiveNotifier();
        try {
            notify.init(this);
            Runtime runtime = Runtime.getRuntime();
            this.process = runtime.exec(this.execCmd);
            if (this.process == null) {
                String szMsg = "exec error. cmd=" + this.execCmd;
                SJappWriteLog.error("SJappStartApp_SVP", "SJappStartApp_SVP", "exec", szMsg);
                return;
            }
            this.process.waitFor();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        finally {
            notify.finish();
        }
    }

    @Override
    public void forceAppFinish() {
        String LOG_SUBTITLE = "forceAppFinish";
        if (!this.syncEnd.equals(SJappDefConst.SVP_SYNCEND_END)) {
            SJappWriteLog.warn("SJappStartApp_SVP", "SJappStartApp_SVP", "forceAppFinish", "Dont Force Finish.");
            return;
        }
        if (this.process != null) {
            String szMsg = "force finish. cmd=" + this.execCmd;
            SJappWriteLog.warn("SJappStartApp_SVP", "SJappStartApp_SVP", "forceAppFinish", szMsg);
            this.process.destroy();
        }
    }

    @Override
    public boolean isAlive() {
        return this.process != null;
    }

    private Object[] concat(Class cls, Object[] a, Object[] b) {
        Object[] dst = (Object[])Array.newInstance(cls, a.length + b.length);
        System.arraycopy(a, 0, dst, 0, a.length);
        System.arraycopy(b, 0, dst, a.length, b.length);
        return dst;
    }
}

