/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;

public abstract class RJDGDBaseList
extends JList
implements RJDGDTransferKeyEventComponent {
    private static final String CLASSNAME = "RJDGDBaseList";

    public RJDGDBaseList() {
        this.initInstance();
    }

    public void refreshData() throws RJDGDRefreshDataException {
        ListModel listModel = this.getModel();
        if (listModel instanceof RJDGDDataRefresh) {
            RJDGDDataRefresh rJDGDDataRefresh = (RJDGDDataRefresh)((Object)listModel);
            rJDGDDataRefresh.refreshData();
        }
    }

    protected MouseListener getDefaultMouseListener() {
        return new DefaultMouseAdapter();
    }

    protected ListCellRenderer getDefaultCellRenderer() {
        return new RJDGDDefaultListCellRenderer();
    }

    protected abstract ListModel getUsedListModel();

    private void initInstance() {
        this.addMouseListener(this.getDefaultMouseListener());
        this.setModel(this.getUsedListModel());
        this.setCellRenderer(this.getDefaultCellRenderer());
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                JList jList = (JList)focusEvent.getSource();
                jList.repaint();
            }

            public void focusLost(FocusEvent focusEvent) {
                JList jList = (JList)focusEvent.getSource();
                jList.repaint();
            }
        });
    }

    protected class DefaultMouseAdapter
    extends MouseAdapter {
        private static final String CLASSNAME = "RJDGDBaseList.DefaultMouseAdapter";

        protected DefaultMouseAdapter() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                int n = RJDGDBaseList.this.locationToIndex(new Point(mouseEvent.getX(), mouseEvent.getY()));
                RJDGDBaseList.this.requestFocus();
                if (!RJDGDBaseList.this.isSelectedIndex(n) && n != -1) {
                    RJDGDBaseList.this.clearSelection();
                    RJDGDBaseList.this.addSelectionInterval(n, n);
                }
            }
        }
    }
}

