/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.FileOutputStream;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import sanproject.client.data.RJDataMsg;
import sanproject.server.data.CheckRetObj;
import sanproject.server.data.DGDgetGuardFile;
import sanproject.server.data.DGDsetExtendedGuardFile;
import sanproject.server.data.DISKgetSubsystemInfo;
import sanproject.server.data.GetRmiException;
import sanproject.server.data.RmiControlObj;
import sanproject.server.data.RmiObj_03_03_00;
import sanproject.server.data.SANRmiException;

public class RJDGDJWSDataControler
implements RJDGDFODataControler,
RJDGDJWSCommandlineParser {
    private static final String CLASSNAME = "RJDGDJWSDataControler";
    private static final String PROPERTY_FILENAME = System.getProperty("user.home") + "/.ldevguardjws";
    private static final String PROPERTY_HEADER = "[LDEV Guard File Operator] Property File " + RJDGDGUIVersion.getGUIVersion();
    private static final int DEFAULT_INTERVAL = 5;
    private RmiObj_03_03_00 m_clsRMIObject;
    private RJDGDFOProperties m_clsApplicationProperties;
    private ArrayList m_arlLookupListeners;
    private RJDGDJWSMessageManager m_clsMessageManager;
    private FileOperatorPollingThread m_clsPolling;
    private int m_iPollingInterval;

    public RJDGDJWSDataControler() throws RJDGDException {
        this.initInstance();
    }

    public String[] getGuardNameList() {
        String[] stringArray = null;
        if (this.m_clsRMIObject != null) {
            try {
                stringArray = this.m_clsRMIObject.getGuardFileList();
            }
            catch (Exception exception) {
                RJDGDFOFrontPanel.processException(exception);
            }
        }
        return stringArray;
    }

    public DGDgetGuardFile downloadGuardFile(String string) throws RJDGDException {
        DGDgetGuardFile dGDgetGuardFile = null;
        if (this.m_clsRMIObject != null) {
            try {
                dGDgetGuardFile = this.m_clsRMIObject.getGuardFile(string);
            }
            catch (SANRmiException sANRmiException) {
                sANRmiException.printStackTrace(System.err);
                RJDGDException rJDGDException = new RJDGDException(sANRmiException.nErrCode, sANRmiException.nErrData);
                throw rJDGDException;
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace(System.err);
                RJDGDException rJDGDException = new RJDGDException(9211, 6027);
                throw rJDGDException;
            }
        } else {
            RJDGDException rJDGDException = new RJDGDException(9211, 6027);
            throw rJDGDException;
        }
        return dGDgetGuardFile;
    }

    public void uploadGuardFile(DGDsetExtendedGuardFile dGDsetExtendedGuardFile) throws RJDGDException {
        block6: {
            if (this.m_clsRMIObject != null) {
                try {
                    int n = -1;
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yy/MM/dd HH:mm:ss:SSS:z   ");
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(simpleDateFormat.format(new Date()));
                    arrayList.add(simpleDateFormat.format(new Date()) + "LDEVGuard JWS Application. ");
                    arrayList.add(simpleDateFormat.format(new Date()) + "----------------------------------------------");
                    arrayList.add(simpleDateFormat.format(new Date()) + "Pattern File Upload.");
                    arrayList.add(simpleDateFormat.format(new Date()) + "  @ " + dGDsetExtendedGuardFile + " (" + dGDsetExtendedGuardFile.name + ")");
                    this.m_clsRMIObject.operationLogWrite(arrayList);
                    DGDsetExtendedGuardFile dGDsetExtendedGuardFile2 = this.m_clsRMIObject.setDGDUploadFile(dGDsetExtendedGuardFile);
                    if (dGDsetExtendedGuardFile2 != null) {
                        n = dGDsetExtendedGuardFile2.error;
                    }
                    int n2 = this.m_clsRMIObject.getDGDFOStatus(0x2000000);
                    String string = RJDGDUtilities.convertToHexString(n2, 8);
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    arrayList2.add(simpleDateFormat.format(new Date()) + "----------------------------------------------");
                    arrayList2.add(simpleDateFormat.format(new Date()) + "Pattern File Uploaded.");
                    arrayList2.add(simpleDateFormat.format(new Date()) + "  @ error code = " + n);
                    arrayList2.add(simpleDateFormat.format(new Date()) + "  @ application status = 0x" + string);
                    arrayList2.add(simpleDateFormat.format(new Date()));
                    this.m_clsRMIObject.operationLogWrite(arrayList2);
                    if (n != 0) {
                        RJDGDException rJDGDException = new RJDGDException(9207, n);
                        throw rJDGDException;
                    }
                    break block6;
                }
                catch (SANRmiException sANRmiException) {
                    sANRmiException.printStackTrace(System.err);
                    RJDGDException rJDGDException = new RJDGDException(sANRmiException.nErrCode, sANRmiException.nErrData);
                    throw rJDGDException;
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace(System.err);
                    RJDGDException rJDGDException = new RJDGDException(9211, 6027);
                    throw rJDGDException;
                }
            }
            RJDGDException rJDGDException = new RJDGDException(9211, 6027);
            throw rJDGDException;
        }
    }

    public String getProperty(String string) {
        return this.m_clsApplicationProperties.getProperty(string);
    }

    public Object setProperty(String string, String string2) {
        return this.m_clsApplicationProperties.setProperty(string, string2);
    }

    public DISKgetSubsystemInfo getSubsystemInfo() throws RJDGDException {
        DISKgetSubsystemInfo dISKgetSubsystemInfo = null;
        if (this.m_clsRMIObject != null) {
            try {
                dISKgetSubsystemInfo = this.m_clsRMIObject.getSubsystemInfo();
            }
            catch (GetRmiException getRmiException) {
                getRmiException.printStackTrace(System.err);
                RJDGDException rJDGDException = new RJDGDException(getRmiException.nErrCode, getRmiException.nErrData);
                throw rJDGDException;
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace(System.err);
                RJDGDException rJDGDException = new RJDGDException(9211, 6027);
                throw rJDGDException;
            }
        } else {
            RJDGDException rJDGDException = new RJDGDException(9211, 6027);
            throw rJDGDException;
        }
        return dISKgetSubsystemInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isFileUploaded() throws RJDGDException {
        boolean bl = false;
        if (this.m_clsRMIObject != null) {
            try {
                int n = 0;
                n = this.m_clsRMIObject.getDGDFOStatus(0x2000000);
                if ((n & 0x200) == 0) return bl;
                return true;
            }
            catch (SANRmiException sANRmiException) {
                sANRmiException.printStackTrace(System.err);
                RJDGDException rJDGDException = new RJDGDException(sANRmiException.nErrCode, sANRmiException.nErrData);
                throw rJDGDException;
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace(System.err);
                RJDGDException rJDGDException = new RJDGDException(9211, 6027);
                throw rJDGDException;
            }
        }
        RJDGDException rJDGDException = new RJDGDException(9211, 6027);
        throw rJDGDException;
    }

    public void setFOStatus(int n, int n2) throws RJDGDException {
        if (this.m_clsRMIObject != null) {
            try {
                this.m_clsRMIObject.setDGDFOStatus(n, n2);
            }
            catch (SANRmiException sANRmiException) {
                sANRmiException.printStackTrace(System.err);
                throw new RJDGDException(sANRmiException.nErrCode, sANRmiException.nErrData);
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace(System.err);
                RJDGDException rJDGDException = new RJDGDException(9211, 6027);
                throw rJDGDException;
            }
        } else {
            RJDGDException rJDGDException = new RJDGDException(9211, 6027);
            throw rJDGDException;
        }
    }

    public int getFOStatus(int n) throws RJDGDException {
        int n2 = 0;
        if (this.m_clsRMIObject != null) {
            try {
                n2 = this.m_clsRMIObject.getDGDFOStatus(n);
            }
            catch (SANRmiException sANRmiException) {
                sANRmiException.printStackTrace(System.err);
                throw new RJDGDException(sANRmiException.nErrCode, sANRmiException.nErrData);
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace(System.err);
                RJDGDException rJDGDException = new RJDGDException(9211, 6027);
                throw rJDGDException;
            }
        } else {
            RJDGDException rJDGDException = new RJDGDException(9211, 6027);
            throw rJDGDException;
        }
        return n2;
    }

    public RJDataMsg getMessageObject(int n, int n2) {
        return RJDGDJWSMessageManager.getMessageObject(n, n2);
    }

    public boolean parseCommandlineStrings(String[] stringArray) {
        RJDGDLogManager.putLog(0, this.getClass().getName() + ":" + CLASSNAME, "call parseCommandlineStrings( )");
        boolean bl = true;
        int n = 0;
        String string = "--";
        while (n < stringArray.length) {
            String string2;
            if ((string2 = stringArray[n++]) != null && !string2.equals("")) {
                String string3;
                if (string2.equals(string + "registory")) {
                    try {
                        string3 = stringArray[n++];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        bl = false;
                        break;
                    }
                    if (string3.startsWith(string)) {
                        bl = false;
                        break;
                    }
                    this.m_clsApplicationProperties.setProperty("registory", string3);
                    System.out.println("registory=" + string3);
                    continue;
                }
                if (string2.equals(string + "lock_user")) {
                    try {
                        string3 = stringArray[n++];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        bl = false;
                        break;
                    }
                    if (string3.startsWith(string)) {
                        bl = false;
                        break;
                    }
                    this.m_clsApplicationProperties.setProperty("lock_user", string3);
                    System.out.println("lock_user=" + string3);
                    continue;
                }
                if (string2.equals(string + "vender")) {
                    try {
                        string3 = stringArray[n++];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        bl = false;
                        break;
                    }
                    if (string3.startsWith(string)) {
                        bl = false;
                        break;
                    }
                    this.m_clsApplicationProperties.setProperty("vender", string3);
                    System.out.println("vender=" + string3);
                    continue;
                }
                if (string2.equals(string + "polling_interval")) {
                    try {
                        string3 = stringArray[n++];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        bl = false;
                        break;
                    }
                    if (string3.startsWith(string)) {
                        bl = false;
                        break;
                    }
                    try {
                        int n2 = Integer.parseInt(string3, 10);
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                        break;
                    }
                    this.m_clsApplicationProperties.setProperty("polling_interval", string3);
                    System.out.println("polling_interval=" + string3);
                    continue;
                }
                if (string2.equals(string + "console_id")) {
                    try {
                        string3 = stringArray[n++];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        bl = false;
                        break;
                    }
                    if (string3.startsWith(string)) {
                        bl = false;
                        break;
                    }
                    this.m_clsApplicationProperties.setProperty("console_id", string3);
                    System.out.println("console_id=" + string3);
                    continue;
                }
                if (string2.equals(string + "log_level")) {
                    try {
                        string3 = stringArray[n++];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        bl = false;
                        break;
                    }
                    if (string3.startsWith(string)) {
                        bl = false;
                        break;
                    }
                    try {
                        int n3 = Integer.parseInt(string3, 10);
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                        break;
                    }
                    this.m_clsApplicationProperties.setProperty("log_level", string3);
                    System.out.println("log_level=" + string3);
                    continue;
                }
                if (string2.equals(string + "log_file")) {
                    try {
                        string3 = stringArray[n++];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        bl = false;
                        break;
                    }
                    if (string3.startsWith(string)) {
                        bl = false;
                        break;
                    }
                    this.m_clsApplicationProperties.setProperty("log_file", string3);
                    System.out.println("log_file=" + string3);
                    continue;
                }
                if (string2.equals(string + "help")) {
                    this.m_clsApplicationProperties.setProperty("help", "help");
                    System.out.println("help");
                    continue;
                }
                if (string2.equals(string + "debug")) {
                    this.m_clsApplicationProperties.setProperty("debug", "debug");
                    System.out.println("debug");
                    continue;
                }
                if (string2.equals(string + "connection_address")) {
                    try {
                        string3 = stringArray[n++];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        bl = false;
                        break;
                    }
                    if (string3.startsWith(string)) {
                        bl = false;
                        break;
                    }
                    this.m_clsApplicationProperties.setProperty("connection_address", string3);
                    System.out.println("connection_address=" + string3);
                    continue;
                }
                if (string2.equals(string + "connection_user")) {
                    try {
                        string3 = stringArray[n++];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        bl = false;
                        break;
                    }
                    if (string3.startsWith(string)) {
                        bl = false;
                        break;
                    }
                    this.m_clsApplicationProperties.setProperty("connection_user", string3);
                    System.out.println("connection_user=" + string3);
                    continue;
                }
                if (string2.equals(string + "connection_password")) {
                    try {
                        string3 = stringArray[n++];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        string3 = "";
                    }
                    if (string3.startsWith(string)) {
                        string3 = "";
                    }
                    this.m_clsApplicationProperties.setProperty("connection_password", string3);
                    System.out.println("connection_password=" + string3);
                    continue;
                }
            }
            bl = false;
            System.out.println("Found an Illegal Argument : [" + string2 + "]");
            break;
        }
        if (this.isDebugMode() && bl) {
            String string4 = "connection_address";
            String string5 = this.m_clsApplicationProperties.getProperty(string4);
            if (string5 != null && !string5.trim().equals("")) {
                string4 = "connection_user";
                string5 = this.m_clsApplicationProperties.getProperty(string4);
                if (string5 == null || string5.trim().equals("")) {
                    bl = false;
                } else {
                    string4 = "connection_password";
                    string5 = this.m_clsApplicationProperties.getProperty(string4);
                    if (string5 == null || string5.trim().equals("")) {
                        bl = false;
                    } else {
                        this.m_clsApplicationProperties.setProperty("registory", "dummyString");
                    }
                }
            }
            if ((string5 = this.m_clsApplicationProperties.getProperty(string4 = "lock_user")) == null || string5.trim().equals("")) {
                this.m_clsApplicationProperties.setProperty("lock_user", "dummyString");
            }
        }
        if (bl) {
            String[] stringArray2 = new String[]{"registory", "lock_user"};
            int n4 = 0;
            while (n4 < stringArray2.length) {
                String string6 = stringArray2[n4];
                String string7 = this.m_clsApplicationProperties.getProperty(string6);
                if (string7 == null || string7.trim().equals("")) {
                    bl = false;
                    break;
                }
                ++n4;
            }
        }
        return bl;
    }

    public boolean isPrintHelp() {
        boolean bl = false;
        String string = this.getProperty("help");
        if (string != null) {
            bl = true;
        }
        return bl;
    }

    public void printHelp() {
        String string = System.getProperty("line.separator");
        String string2 = "";
        string2 = string2 + "Usage : " + string;
        string2 = this.isDebugMode() ? string2 + "    RJDGDStartupFileOperator [registory | [connection_address] [connection_user] [connection_passowrd]] {other options}" + string + string : string2 + "    RJDGDStartupFileOperator [registory] {other options}" + string + string;
        string2 = string2 + "Option List :" + string;
        string2 = string2 + "    --registory <registory string>" + string;
        string2 = string2 + "                : The registry name of RMI which carries out a look rise is specified." + string;
        string2 = string2 + string;
        string2 = string2 + "    --lock_user <user name>" + string;
        string2 = string2 + "                : The name of the user who has covered the lock is specified." + string;
        string2 = string2 + string;
        string2 = string2 + "    --vender <vender code>" + string;
        string2 = string2 + "                : The vender type of SVP is specified." + string;
        string2 = string2 + string;
        string2 = string2 + "    --polling_interval <interval time>" + string;
        string2 = string2 + "                : The interval of polling is specified in a second." + string;
        string2 = string2 + string;
        string2 = string2 + "    --polling_interval <interval time>" + string;
        string2 = string2 + "                : In order to discriminate Console ID is specified." + string;
        string2 = string2 + string;
        string2 = string2 + "    --log_level <level [1-9]>" + string;
        string2 = string2 + "                : A log level is specified." + string;
        string2 = string2 + string;
        string2 = string2 + "    --log_file <log file name>" + string;
        string2 = string2 + "                : A log file name is specified." + string;
        string2 = string2 + string;
        string2 = string2 + "    --help" + string;
        string2 = string2 + "                : This help message is displayed." + string;
        string2 = string2 + string;
        if (this.isDebugMode()) {
            string2 = string2 + "    --connection_address <host address>" + string;
            string2 = string2 + "                : When performing simple substance starting, the host address to connect is specified." + string;
            string2 = string2 + string;
            string2 = string2 + "    --connection_user <connectiong user>" + string;
            string2 = string2 + "                : When performing simple substance starting, the user name to connect is specified." + string;
            string2 = string2 + string;
            string2 = string2 + "    --connection_password <connectiong user password>" + string;
            string2 = string2 + "                : When performing simple substance starting, a user's password to connect is specified." + string;
            string2 = string2 + string;
        }
        System.out.println(string2);
    }

    public void addLookupListener(RJDGDLookupListener rJDGDLookupListener) {
        this.m_arlLookupListeners.add(rJDGDLookupListener);
    }

    public void removeLookupListener(RJDGDLookupListener rJDGDLookupListener) {
        ((AbstractCollection)this.m_arlLookupListeners).remove(rJDGDLookupListener);
    }

    public void loadSettings() {
        RJDGDLogManager.putLog(0, this.getClass().getName() + ":" + CLASSNAME, "call loadSettings( )");
        Enumeration enumeration = ((Hashtable)this.m_clsApplicationProperties).keys();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            if (string2.equals("vender")) continue;
            if (string2.equals("polling_interval")) {
                string = (String)((Hashtable)this.m_clsApplicationProperties).get(string2);
                try {
                    this.m_iPollingInterval = Integer.parseInt(string, 10);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (string2.equals("log_level")) {
                string = (String)((Hashtable)this.m_clsApplicationProperties).get(string2);
                try {
                    int n = Integer.parseInt(string, 10);
                    RJDGDLogManager.setOutputLevel(n);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!string2.equals("log_file")) continue;
            string = (String)((Hashtable)this.m_clsApplicationProperties).get(string2);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(System.getProperty("user.home") + "/" + string, true);
                RJDGDFOPrintOutStream rJDGDFOPrintOutStream = new RJDGDFOPrintOutStream(fileOutputStream);
                RJDGDFOPrintErrStream rJDGDFOPrintErrStream = new RJDGDFOPrintErrStream(fileOutputStream);
                System.setOut(rJDGDFOPrintOutStream);
                System.setErr(rJDGDFOPrintErrStream);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
    }

    public void adjustmentWindow(Window window) {
        if (window != null) {
            String string;
            String string2;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension dimension = toolkit.getScreenSize();
            Dimension dimension2 = window.getSize();
            n = (dimension.width - dimension2.width) / 2;
            n2 = (dimension.height - dimension2.height) / 2;
            try {
                string2 = "window_position_x";
                string = (String)((Hashtable)this.m_clsApplicationProperties).get(string2);
                n = Integer.parseInt(string, 10);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                string2 = "window_position_y";
                string = (String)((Hashtable)this.m_clsApplicationProperties).get(string2);
                n2 = Integer.parseInt(string, 10);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                string2 = "window_size_w";
                string = (String)((Hashtable)this.m_clsApplicationProperties).get(string2);
                n3 = Integer.parseInt(string, 10);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                string2 = "window_size_h";
                string = (String)((Hashtable)this.m_clsApplicationProperties).get(string2);
                n4 = Integer.parseInt(string, 10);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n != 0 || n2 != 0 || n3 != 0 || n4 != 0) {
                ((Component)window).setLocation(n, n2);
                ((Component)window).setSize(n3, n4);
            }
        }
    }

    public void saveWindowPosition(Window window) {
        if (window != null) {
            int n = window.getX();
            int n2 = window.getY();
            int n3 = window.getWidth();
            int n4 = window.getHeight();
            String string = "window_position_x";
            String string2 = String.valueOf(n);
            this.m_clsApplicationProperties.setProperty(string, string2);
            string = "window_position_y";
            string2 = String.valueOf(n2);
            this.m_clsApplicationProperties.setProperty(string, string2);
            string = "window_size_w";
            string2 = String.valueOf(n3);
            this.m_clsApplicationProperties.setProperty(string, string2);
            string = "window_size_h";
            string2 = String.valueOf(n4);
            this.m_clsApplicationProperties.setProperty(string, string2);
        }
    }

    protected void finalize() throws Throwable {
        this.m_arlLookupListeners = null;
        this.m_clsApplicationProperties = null;
        this.m_clsRMIObject = null;
        super.finalize();
    }

    protected synchronized void startLookup() {
        String string;
        String string2;
        String string3;
        RJDGDLogManager.putLog(0, this.getClass().getName() + ":" + CLASSNAME, "call startLookup( )");
        int n = 0;
        Exception exception = null;
        RJDGDLookupEvent rJDGDLookupEvent = null;
        rJDGDLookupEvent = new RJDGDLookupEvent(this, 1, n, exception);
        this.sendLookupEvent(rJDGDLookupEvent);
        RJDGDFOFrontPanel.addProgressValue(5);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        RJDGDFOFrontPanel.addProgressValue(5);
        if (this.isDebugMode() && (string3 = this.m_clsApplicationProperties.getProperty(string2 = "connection_address")) != null) {
            string = "rmi://" + string3 + "/RMIControl";
            string2 = "connection_user";
            String string4 = this.m_clsApplicationProperties.getProperty(string2);
            string2 = "connection_password";
            String string5 = this.m_clsApplicationProperties.getProperty(string2);
            RJDGDLogManager.putLog(5, this.getClass().getName() + ":" + CLASSNAME, "Lookup [RmiControlObj] ...");
            try {
                RmiControlObj rmiControlObj = (RmiControlObj)Naming.lookup(string);
                RJDGDFOFrontPanel.addProgressValue(5);
                CheckRetObj checkRetObj = rmiControlObj.checkLicenseEx(string4, string5, 0, 0, 10000, "");
                RJDGDFOFrontPanel.addProgressValue(5);
                if (checkRetObj != null) {
                    RJDGDLogManager.putLog(1, this.getClass().getName() + ":" + CLASSNAME, "returnValue = " + checkRetObj);
                    RJDGDLogManager.putLog(1, this.getClass().getName() + ":" + CLASSNAME, "strRegBindName = " + checkRetObj.strRegBindName);
                    RJDGDLogManager.putLog(1, this.getClass().getName() + ":" + CLASSNAME, "nWarnningCode = " + checkRetObj.nWarnningCode);
                    RJDGDLogManager.putLog(1, this.getClass().getName() + ":" + CLASSNAME, "nOEMTYPE = " + checkRetObj.nOEMTYPE);
                    string2 = "registory";
                    this.m_clsApplicationProperties.setProperty(string2, checkRetObj.strRegBindName);
                } else {
                    RJDGDException rJDGDException = new RJDGDException(9211, 6027);
                    n = Integer.MIN_VALUE;
                    exception = rJDGDException;
                }
            }
            catch (ConnectException connectException) {
                connectException.printStackTrace(System.err);
                n = Integer.MIN_VALUE;
                exception = new RJDGDException(10, 6027);
            }
            catch (ConnectIOException connectIOException) {
                connectIOException.printStackTrace(System.err);
                n = Integer.MIN_VALUE;
                exception = new RJDGDException(10, 6027);
            }
            catch (Exception exception2) {
                exception2.printStackTrace(System.err);
                n = Integer.MIN_VALUE;
                exception = exception2;
            }
        }
        RJDGDFOFrontPanel.addProgressValue(5);
        if (n == 0) {
            string2 = "registory";
            string = this.m_clsApplicationProperties.getProperty(string2);
            RJDGDLogManager.putLog(5, this.getClass().getName() + ":" + CLASSNAME, "Lookup [RmiObj] ...");
            try {
                this.m_clsRMIObject = (RmiObj_03_03_00)Naming.lookup(string);
                this.m_clsRMIObject.getDGDFOStatus(0x1000000);
            }
            catch (ServerException serverException) {
                serverException.printStackTrace(System.err);
                n = Integer.MIN_VALUE;
                exception = new RJDGDException(9211, 6023);
            }
            catch (ConnectException connectException) {
                connectException.printStackTrace(System.err);
                n = Integer.MIN_VALUE;
                exception = new RJDGDException(9211, 6023);
            }
            catch (NotBoundException notBoundException) {
                notBoundException.printStackTrace(System.err);
                n = Integer.MIN_VALUE;
                exception = new RJDGDException(9211, 6023);
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace(System.err);
                n = Integer.MIN_VALUE;
                exception = new RJDGDException(9211, 6023);
            }
            catch (Exception exception3) {
                n = Integer.MIN_VALUE;
                exception = exception3;
            }
        }
        RJDGDFOFrontPanel.addProgressValue(5);
        if (n == 0) {
            RJDGDLogManager.putLog(5, this.getClass().getName() + ":" + CLASSNAME, "Loading Message ...");
            try {
                string = this.m_clsApplicationProperties.getProperty("vender");
                this.m_clsMessageManager = new RJDGDJWSMessageManager(this.m_clsRMIObject, string);
            }
            catch (Exception exception4) {
                n = Integer.MIN_VALUE;
                exception = exception4;
            }
        }
        RJDGDFOFrontPanel.addProgressValue(5);
        rJDGDLookupEvent = new RJDGDLookupEvent(this, 16, n, exception);
        this.sendLookupEvent(rJDGDLookupEvent);
        RJDGDFOFrontPanel.addProgressValue(5);
        if (n == 0) {
            RJDGDLogManager.putLog(5, this.getClass().getName() + ":" + CLASSNAME, "Operator Polling Start");
            this.m_clsPolling = new FileOperatorPollingThread();
            this.m_clsPolling.pollingStart();
        }
    }

    protected synchronized void logoff() {
        String string;
        String string2;
        RJDGDLogManager.putLog(0, this.getClass().getName() + ":" + CLASSNAME, "call logoff( )");
        if (this.m_clsPolling != null && this.m_clsPolling.isAlive()) {
            this.m_clsPolling.pollingStop();
            this.m_clsPolling = null;
        }
        if (this.m_clsRMIObject != null && this.isDebugMode() && (string2 = this.m_clsApplicationProperties.getProperty(string = "connection_address")) != null) {
            try {
                this.m_clsRMIObject.logOff();
                this.m_clsRMIObject = null;
            }
            catch (RemoteException remoteException) {
                RJDGDFOFrontPanel.processException(remoteException);
            }
        }
        ((Hashtable)this.m_clsApplicationProperties).remove("registory");
        ((Hashtable)this.m_clsApplicationProperties).remove("lock_user");
        ((Hashtable)this.m_clsApplicationProperties).remove("vender");
        ((Hashtable)this.m_clsApplicationProperties).remove("polling_interval");
        ((Hashtable)this.m_clsApplicationProperties).remove("console_id");
        ((Hashtable)this.m_clsApplicationProperties).remove("log_level");
        ((Hashtable)this.m_clsApplicationProperties).remove("log_file");
        ((Hashtable)this.m_clsApplicationProperties).remove("help");
        ((Hashtable)this.m_clsApplicationProperties).remove("debug");
        ((Hashtable)this.m_clsApplicationProperties).remove("connection_address");
        ((Hashtable)this.m_clsApplicationProperties).remove("connection_user");
        ((Hashtable)this.m_clsApplicationProperties).remove("connection_password");
        try {
            this.m_clsApplicationProperties.store(PROPERTY_FILENAME, PROPERTY_HEADER);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean isDebugMode() {
        String string = "debug";
        String string2 = this.m_clsApplicationProperties.getProperty(string);
        return string2 != null;
    }

    private void initInstance() {
        this.m_arlLookupListeners = new ArrayList();
        this.m_iPollingInterval = 5;
        this.m_clsApplicationProperties = new RJDGDFOProperties();
        try {
            this.m_clsApplicationProperties.load(PROPERTY_FILENAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sendLookupEvent(RJDGDLookupEvent rJDGDLookupEvent) {
        RJDGDLogManager.putLog(0, this.getClass().getName() + ":" + CLASSNAME, "call sendLookupEvent( )");
        final RJDGDLookupEvent rJDGDLookupEvent2 = rJDGDLookupEvent;
        Iterator iterator = ((AbstractList)this.m_arlLookupListeners).iterator();
        while (iterator.hasNext()) {
            Thread thread;
            final RJDGDLookupListener rJDGDLookupListener = (RJDGDLookupListener)iterator.next();
            if (rJDGDLookupListener == null) continue;
            int n = rJDGDLookupEvent2.getID();
            if (n == 1) {
                thread = new Thread(){

                    public void run() {
                        rJDGDLookupListener.lookupStart(rJDGDLookupEvent2);
                    }
                };
                thread.start();
                continue;
            }
            if (n != 16) continue;
            thread = new Thread(){

                public void run() {
                    rJDGDLookupListener.lookupEnd(rJDGDLookupEvent2);
                }
            };
            thread.start();
        }
    }

    private class FileOperatorPollingThread
    extends Thread {
        private static final String CLASSNAME = "RJDGDJWSDataControler.FileOperatorPollingThread";
        private boolean m_bRequestStop = false;

        public void run() {
            try {
                while (!this.m_bRequestStop) {
                    FileOperatorPollingThread fileOperatorPollingThread = this;
                    synchronized (fileOperatorPollingThread) {
                        Object object;
                        int n = RJDGDJWSDataControler.this.m_clsRMIObject.getDGDFOStatus(0x2000000);
                        RJDGDJWSDataControler.this.setFOStatus(0x2000000, n |= 0x20);
                        n = RJDGDJWSDataControler.this.getFOStatus(0x1000000);
                        String string = RJDGDJWSDataControler.this.m_clsRMIObject.getSetStatusEx();
                        RJDGDLogManager.putLog(5, this.getClass().getName() + ":" + CLASSNAME, "WebConsole Status [" + string + ":" + RJDGDUtilities.convertToHexString(n, 8) + "]");
                        if (!RJDGDJWSDataControler.this.isDebugMode()) {
                            object = "lock_user";
                            String string2 = RJDGDJWSDataControler.this.m_clsApplicationProperties.getProperty((String)object);
                            if (string == null || !string.equals(string2)) {
                                RJDGDJWSDataControler.this.setFOStatus(0x2000000, n |= Integer.MIN_VALUE);
                                RJDGDException rJDGDException = new RJDGDException(9211, 6530);
                                throw rJDGDException;
                            }
                        }
                        if ((n & 0x10) == 0 && (n & 0x20) == 0) {
                            if ((n & 0x10) == 0) {
                                if (!RJDGDJWSDataControler.this.isDebugMode()) {
                                    System.out.println("WebConsole is not started.");
                                    object = new RJDGDException(9211, 6027);
                                    throw object;
                                }
                            } else {
                                if ((n & 0x8000) != 0) {
                                    System.out.println("WebConsole is done.");
                                    object = new RJDGDException(9211, 6027);
                                    RJDGDFOFrontPanel.processException((Throwable)object);
                                    throw object;
                                }
                                if ((n & 0x80010000) != 0) {
                                    System.out.println("WebConsole is timeout.");
                                    object = new RJDGDException(9211, 6030);
                                    throw object;
                                }
                            }
                        }
                    }
                    Thread.sleep(RJDGDJWSDataControler.this.m_iPollingInterval * 1000);
                }
            }
            catch (Exception exception) {
                RJDGDFOFrontPanel.processException(exception);
                this.pollingStop();
            }
        }

        public void start() {
            try {
                FileOperatorPollingThread fileOperatorPollingThread = this;
                synchronized (fileOperatorPollingThread) {
                    int n = RJDGDJWSDataControler.this.getFOStatus(0x2000000);
                    RJDGDJWSDataControler.this.setFOStatus(0x2000000, n |= 0x10);
                }
                super.start();
            }
            catch (Exception exception) {
                RJDGDFOFrontPanel.processException(exception);
            }
        }

        public void pollingStart() {
            this.start();
        }

        public void pollingStop() {
            this.m_bRequestStop = true;
            try {
                FileOperatorPollingThread fileOperatorPollingThread = this;
                synchronized (fileOperatorPollingThread) {
                    int n = RJDGDJWSDataControler.this.getFOStatus(0x2000000);
                    RJDGDJWSDataControler.this.setFOStatus(0x2000000, n |= 0x8000);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

