/*
 * Decompiled with CFR 0.152.
 */
package sanproject.session.server.store.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.session.common.exception.SJsessionParameterException;
import sanproject.session.server.common.SJsessionServerUty;
import sanproject.session.server.store.manager.SJsessionEventHandler;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SJsessionEventManager {
    private static final String LOG_FUNCTION = "SessionServer";
    private static final String LOG_TITLE = SJsessionEventManager.class.getSimpleName();
    private static HashMap<String, SJsessionEventHandler> eventHandler = new HashMap();
    private static HashMap<String, HashMap<Integer, String>> removeList = new HashMap();
    private static Object syncObject = new Object();

    private SJsessionEventManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startHandler(String connectinID, String appID) throws SJcException {
        String LOG_SUBTITLE = "startHandler";
        SJcLoggerInterface logger = SJsessionServerUty.getLogger();
        logger.info(LOG_FUNCTION, LOG_TITLE, "startHandler", "Start. Connection ID:" + connectinID + " APP:" + appID);
        if (connectinID == null) {
            logger.error(LOG_FUNCTION, LOG_TITLE, "startHandler", "invalid parameter.");
            throw new SJsessionParameterException("107001");
        }
        Object object = syncObject;
        synchronized (object) {
            if (!eventHandler.containsKey(connectinID)) {
                SJsessionEventHandler handler = new SJsessionEventHandler(appID);
                eventHandler.put(connectinID, handler);
            }
        }
        logger.info(LOG_FUNCTION, LOG_TITLE, "startHandler", "End.");
    }

    public static HashMap<String, Object> getEvent(String connectionID) throws SJcException {
        String LOG_SUBTITLE = "getEvent";
        SJcLoggerInterface logger = SJsessionServerUty.getLogger();
        logger.trace(LOG_FUNCTION, LOG_TITLE, "getEvent", "Start. Connection ID:" + connectionID);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (connectionID == null) {
            logger.error(LOG_FUNCTION, LOG_TITLE, "getEvent", "invalid parameter.");
            throw new SJsessionParameterException("107001");
        }
        SJsessionEventHandler handler = eventHandler.get(connectionID);
        if (handler == null) {
            logger.warn(LOG_FUNCTION, LOG_TITLE, "getEvent", "handler is null.");
            return map;
        }
        List<HashMap<String, Object>> eventList = handler.waitEvent();
        map.put("EVENT_LIST", eventList);
        logger.trace(LOG_FUNCTION, LOG_TITLE, "getEvent", "End.");
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setEvent(String eventKind, HashMap<String, Object> eventInfo) throws SJcException {
        String LOG_SUBTITLE = "setEvent";
        SJcLoggerInterface logger = SJsessionServerUty.getLogger();
        logger.trace(LOG_FUNCTION, LOG_TITLE, "setEvent", "Start. Event:" + eventKind);
        if (eventKind == null || eventInfo == null) {
            logger.error(LOG_FUNCTION, LOG_TITLE, "setEvent", "invalid parameter.");
            throw new SJsessionParameterException("107001");
        }
        Object object = syncObject;
        synchronized (object) {
            for (String connectionID : eventHandler.keySet()) {
                SJsessionEventHandler handler = eventHandler.get(connectionID);
                logger.trace(LOG_FUNCTION, LOG_TITLE, "setEvent", "Connection ID: " + connectionID);
                handler.setEvent(eventKind, eventInfo);
            }
        }
        if (SJsessionEventManager.isRemove(eventKind, eventInfo)) {
            SJsessionEventManager.addRemoveSessionID(eventInfo);
        } else {
            SJsessionEventManager.delRemoveSessionID(eventInfo);
        }
        logger.trace(LOG_FUNCTION, LOG_TITLE, "setEvent", "End.");
    }

    private static boolean isRemove(String eventKind, HashMap<String, Object> eventInfo) {
        boolean result = false;
        if ("INFO_DEL".equals(eventKind)) {
            result = true;
        } else if ("INFO_CHG".equals(eventKind)) {
            String type = (String)eventInfo.get("CHG_INFO_TYPE");
            if ("INFO_DEL".equals(type)) {
                result = true;
            }
        } else {
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopHandler(String connectionID) throws SJcException {
        String LOG_SUBTITLE = "stopHandler";
        SJcLoggerInterface logger = SJsessionServerUty.getLogger();
        logger.info(LOG_FUNCTION, LOG_TITLE, "stopHandler", "Start. Connection ID:" + connectionID);
        if (connectionID == null) {
            logger.error(LOG_FUNCTION, LOG_TITLE, "stopHandler", "invalid parameter.");
            throw new SJsessionParameterException("107001");
        }
        SJsessionEventHandler handler = eventHandler.get(connectionID);
        if (handler != null) {
            handler.finish();
        }
        Object object = syncObject;
        synchronized (object) {
            eventHandler.remove(connectionID);
        }
        logger.info(LOG_FUNCTION, LOG_TITLE, "stopHandler", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finish() throws SJcException {
        String LOG_SUBTITLE = "finish";
        SJcLoggerInterface logger = SJsessionServerUty.getLogger();
        logger.info(LOG_FUNCTION, LOG_TITLE, "finish", "Start.");
        Object object = syncObject;
        synchronized (object) {
            Iterator<String> itKey = eventHandler.keySet().iterator();
            while (itKey.hasNext()) {
                String connectionID = itKey.next();
                logger.info(LOG_FUNCTION, LOG_TITLE, "finish", "Connection ID:" + connectionID);
                SJsessionEventHandler handler = eventHandler.get(connectionID);
                if (handler != null) {
                    handler.finish();
                }
                itKey.remove();
            }
        }
        logger.info(LOG_FUNCTION, LOG_TITLE, "finish", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addRemoveSessionID(HashMap<String, Object> eventInfo) {
        String LOG_SUBTITLE = "addRemoveSessionID";
        SJcLoggerInterface logger = SJsessionServerUty.getLogger();
        String gsid = (String)eventInfo.get("GLOBALSESSIONID");
        logger.trace(LOG_FUNCTION, LOG_TITLE, "addRemoveSessionID", "Start. GSID:" + gsid);
        List loginList = (List)eventInfo.get("LOGININFO");
        HashMap<String, HashMap<Integer, String>> hashMap = removeList;
        synchronized (hashMap) {
            Integer conUniqID = (Integer)eventInfo.get("IDENTICAL_USERID");
            for (HashMap map : loginList) {
                String appID = (String)map.get("APPLICATIONID");
                HashMap<Integer, String> removeMap = removeList.get(appID);
                if (removeMap == null) {
                    removeMap = new HashMap();
                    removeList.put(appID, removeMap);
                }
                removeMap.put(conUniqID, gsid);
            }
        }
        logger.trace(LOG_FUNCTION, LOG_TITLE, "addRemoveSessionID", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void delRemoveSessionID(HashMap<String, Object> eventInfo) {
        String LOG_SUBTITLE = "delRemoveSessionID";
        SJcLoggerInterface logger = SJsessionServerUty.getLogger();
        String gsid = (String)eventInfo.get("GLOBALSESSIONID");
        logger.trace(LOG_FUNCTION, LOG_TITLE, "delRemoveSessionID", "Start. GSID:" + gsid);
        List loginList = (List)eventInfo.get("LOGININFO");
        HashMap<String, HashMap<Integer, String>> hashMap = removeList;
        synchronized (hashMap) {
            Integer conUniqID = (Integer)eventInfo.get("IDENTICAL_USERID");
            block3: for (HashMap map : loginList) {
                String appID = (String)map.get("APPLICATIONID");
                HashMap<Integer, String> removeMap = removeList.get(appID);
                if (removeMap == null) continue;
                Set<Map.Entry<Integer, String>> entrySet = removeMap.entrySet();
                for (Map.Entry<Integer, String> entry : entrySet) {
                    if (!gsid.equals(entry.getValue())) continue;
                    conUniqID = entry.getKey();
                    logger.info(LOG_FUNCTION, LOG_TITLE, "delRemoveSessionID", "found. GSID:" + gsid + " CUID:" + conUniqID);
                    removeMap.remove(conUniqID);
                    continue block3;
                }
            }
        }
        logger.trace(LOG_FUNCTION, LOG_TITLE, "delRemoveSessionID", "End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getRemoveSessionIDList(String appID) {
        String LOG_SUBTITLE = "getRemoveSessionIDList";
        SJcLoggerInterface logger = SJsessionServerUty.getLogger();
        logger.info(LOG_FUNCTION, LOG_TITLE, "getRemoveSessionIDList", "Start. APP:" + appID);
        ArrayList<String> listStore = new ArrayList();
        HashMap<String, HashMap<Integer, String>> hashMap = removeList;
        synchronized (hashMap) {
            HashMap<Integer, String> removeMap = removeList.get(appID);
            if (removeMap != null) {
                Collection<String> removeList = removeMap.values();
                listStore = new ArrayList<String>(removeList);
            }
        }
        logger.info(LOG_FUNCTION, LOG_TITLE, "getRemoveSessionIDList", "End.");
        return listStore;
    }

    public static boolean isExistsHandler(String connectionID) {
        return eventHandler.containsKey(connectionID);
    }
}

