/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartRegion;
import com.klg.jclass.chart.DerivedInt;
import com.klg.jclass.chart.Drawable;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartNumberFormat;
import com.klg.jclass.chart.TrackChange;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Locale;

public class ChartInteriorRegion
extends TrackChange
implements Drawable,
Serializable {
    protected Insets insets = new Insets(0, 0, 0, 0);
    protected DerivedInt left = new DerivedInt(0, true);
    protected DerivedInt top = new DerivedInt(0, true);
    protected DerivedInt width = new DerivedInt(0, true);
    protected DerivedInt height = new DerivedInt(0, true);
    protected Font font = null;
    protected String name = null;
    protected Color foreground = null;
    protected Color background = null;
    protected JCChart parentChart = null;
    protected ChartRegion parentRegion = null;
    protected boolean visible = true;
    protected boolean updateParent = true;
    protected boolean dimIsDefaultChangedToTrue = false;
    protected boolean inUpdate = false;
    protected boolean needsRepaint = true;
    protected boolean transparent = true;
    private transient JCChartNumberFormat numberFormatter = null;
    protected boolean numberLocalization = true;
    protected boolean groupingUsed = false;

    public ChartInteriorRegion() {
    }

    public ChartInteriorRegion(ChartRegion chartRegion) {
        this.setParentRegion(chartRegion);
        if (chartRegion != null) {
            this.setParentChart((JCChart)chartRegion.getParent());
        }
    }

    public ChartInteriorRegion(JCChart jCChart) {
        this.setParentChart(jCChart);
    }

    public void draw(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        if (graphics == null) {
            return;
        }
        if (this.parentChart == null) {
            return;
        }
        if (!this.transparent) {
            if (this.getBackground() == null) {
                if (this.parentChart != null && this.parentChart.getBackground() != null) {
                    graphics.setColor(this.parentChart.getBackground());
                    graphics.fillRect(this.left.value, this.top.value, this.width.value, this.height.value);
                }
            } else {
                graphics.setColor(this.getBackground());
                graphics.fillRect(this.left.value, this.top.value, this.width.value, this.height.value);
            }
        }
    }

    public Color getBackground() {
        return this.background == null ? (this.parentChart == null ? null : this.parentChart.getBackground()) : this.background;
    }

    public Rectangle getDrawingArea() {
        Rectangle rectangle = new Rectangle();
        this.getDrawingArea(rectangle);
        return rectangle;
    }

    public void getDrawingArea(Rectangle rectangle) {
        rectangle.setBounds(this.insets.left + this.left.value, this.insets.top + this.top.value, Math.max(0, this.size().width - (this.insets.left + this.insets.right)), Math.max(0, this.size().height - (this.insets.top + this.insets.bottom)));
    }

    public Font getFont() {
        return this.font == null ? (this.parentChart == null ? null : this.parentChart.getFont()) : this.font;
    }

    public Color getForeground() {
        return this.foreground == null ? (this.parentChart == null ? null : this.parentChart.getForeground()) : this.foreground;
    }

    Graphics getGraphics() {
        if (this.parentChart == null) {
            return null;
        }
        return this.parentChart.getGraphics();
    }

    public boolean getGroupingUsed() {
        return this.groupingUsed;
    }

    public int getHeight() {
        return this.height.value;
    }

    public boolean getHeightIsDefault() {
        return this.height.isDefault;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public int getLeft() {
        return this.left.value;
    }

    public boolean getLeftIsDefault() {
        return this.left.isDefault;
    }

    public String getName() {
        return this.name;
    }

    public JCChartNumberFormat getNumberFormatter() {
        if (this.numberFormatter == null) {
            this.numberFormatter = new JCChartNumberFormat(this);
        }
        return this.numberFormatter;
    }

    public boolean getNumberLocalization() {
        return this.numberLocalization;
    }

    public JCChart getParentChart() {
        return this.parentChart;
    }

    public ChartRegion getParentRegion() {
        return this.parentRegion;
    }

    public Dimension getSize() {
        return new Dimension(this.width.value, this.height.value);
    }

    public int getTop() {
        return this.top.value;
    }

    public boolean getTopIsDefault() {
        return this.top.isDefault;
    }

    public int getWidth() {
        return this.width.value;
    }

    public boolean getWidthIsDefault() {
        return this.width.isDefault;
    }

    public void hide() {
        if (!this.visible) {
            return;
        }
        this.setVisible(false);
        if (this.parentChart != null) {
            this.parentChart.repaint();
        }
    }

    public Insets insets() {
        return this.insets;
    }

    public boolean inside(int n, int n2) {
        Rectangle rectangle = this.getDrawingArea();
        return rectangle.contains(n, n2);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Point location() {
        return new Point(this.left.value, this.top.value);
    }

    public Dimension preferredSize() {
        Dimension dimension = new Dimension();
        dimension.width = !this.width.isDefault ? (dimension.width += this.width.value) : this.insets.left + this.insets.right;
        dimension.height = !this.height.isDefault ? (dimension.height += this.height.value) : (dimension.height += this.insets.top + this.insets.bottom);
        return dimension;
    }

    public void recalc() {
    }

    public void repaint() {
        if (this.parentRegion != null) {
            this.parentRegion.repaint();
            return;
        }
        if (this.parentChart == null) {
            return;
        }
        Graphics graphics = null;
        if (graphics == null && (graphics = this.parentChart.getGraphics()) == null) {
            this.parentChart.repaint();
            return;
        }
        Rectangle rectangle = new Rectangle(this.left.value, this.top.value, this.width.value, this.height.value);
        graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.draw(graphics);
    }

    public void setBackground(Color color) {
        if (color == this.background) {
            return;
        }
        this.background = color;
        this.setChanged(true, 2);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.left.isDefault) {
            this.left.value = n;
        }
        if (this.top.isDefault) {
            this.top.value = n2;
        }
        if (this.width.isDefault) {
            this.width.value = n3;
        }
        if (this.height.isDefault) {
            this.height.value = n4;
        }
    }

    public void setChanged(boolean bl, int n) {
        if (bl != this.getChanged() || !this.getChanged(n)) {
            if (this.parentRegion != null) {
                this.parentRegion.setChanged(bl, n, false);
            }
            super.setChanged(bl, n);
        }
        if (bl && this.parentChart != null && this.updateParent) {
            this.updateParent(n);
        }
    }

    public void setChanged(boolean bl, int n, boolean bl2) {
        if (this.parentRegion != null) {
            this.parentRegion.setChanged(bl, n, false);
        }
        super.setChanged(bl, n, bl2);
    }

    public void setFont(Font font) {
        if (font == this.font) {
            return;
        }
        this.font = font;
        if (this.getWidth() > 0) {
            this.setChanged(true, 2);
        }
    }

    public void setForeground(Color color) {
        if (color == this.foreground) {
            return;
        }
        this.foreground = color;
        this.setChanged(true, 2);
    }

    public void setGroupingUsed(boolean bl) {
        if (this.groupingUsed == bl) {
            return;
        }
        this.groupingUsed = bl;
        this.setChanged(true, 2);
    }

    public void setHeight(int n) {
        if (this.height.value == n) {
            return;
        }
        this.height.value = n;
        this.height.isDefault = false;
        this.setChanged(true, 2);
    }

    public void setHeightIsDefault(boolean bl) {
        if (this.height.isDefault == bl) {
            return;
        }
        this.height.isDefault = bl;
        this.dimIsDefaultChangedToTrue = bl;
        this.setChanged(true, 2);
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
        this.setChanged(true, 2);
    }

    public void setLeft(int n) {
        if (this.left.value == n) {
            return;
        }
        this.left.value = n;
        this.left.isDefault = false;
        this.setChanged(true, 10);
    }

    public void setLeftIsDefault(boolean bl) {
        if (this.left.isDefault == bl) {
            return;
        }
        this.left.isDefault = bl;
        this.dimIsDefaultChangedToTrue = bl;
        this.setChanged(true, 10);
    }

    public void setLocation(int n, int n2) {
        this.setBounds(n, n2, this.width.value, this.height.value);
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setNumberFormatterLocale(Locale locale) {
        this.getNumberFormatter().setNumberFormatterLocale(locale);
        this.setChanged(true, 2);
    }

    public void setNumberLocalization(boolean bl) {
        if (bl == this.numberLocalization) {
            return;
        }
        this.numberLocalization = bl;
    }

    public void setParentChart(JCChart jCChart) {
        this.parentChart = jCChart;
    }

    public void setParentRegion(ChartRegion chartRegion) {
        this.parentRegion = chartRegion;
    }

    public void setSize(int n, int n2) {
        this.setBounds(this.left.value, this.top.value, n + this.insets.left + this.insets.right, n2 + this.insets.top + this.insets.bottom);
    }

    public void setTop(int n) {
        if (this.top.value == n) {
            return;
        }
        this.top.value = n;
        this.top.isDefault = false;
        this.setChanged(true, 10);
    }

    public void setTopIsDefault(boolean bl) {
        if (this.top.isDefault == bl) {
            return;
        }
        this.top.isDefault = bl;
        this.dimIsDefaultChangedToTrue = bl;
        this.setChanged(true, 10);
    }

    public void setVisible(boolean bl) {
        if (this.visible == bl) {
            return;
        }
        this.visible = bl;
        this.setChanged(true, 2);
    }

    public void setWidth(int n) {
        if (this.width.value == n) {
            return;
        }
        this.width.value = n;
        this.width.isDefault = false;
        this.setChanged(true, 2);
    }

    public void setWidthIsDefault(boolean bl) {
        if (this.width.isDefault == bl) {
            return;
        }
        this.width.isDefault = bl;
        this.dimIsDefaultChangedToTrue = bl;
        this.setChanged(true, 2);
    }

    public void show() {
        this.setVisible(true);
        this.parentChart.repaint();
    }

    public Dimension size() {
        return new Dimension(this.width.value, this.height.value);
    }

    public boolean sizeChanged() {
        if (this.dimIsDefaultChangedToTrue) {
            this.dimIsDefaultChangedToTrue = false;
            return true;
        }
        return this.getLeft() != this.location().x || this.getTop() != this.location().y || this.getWidth() != this.size().width || this.getHeight() != this.size().height;
    }

    public void updateParent(int n) {
        JCChart jCChart = this.getParentChart();
        if (jCChart != null) {
            if ((n & 2) > 0 || (n & 8) > 0) {
                jCChart.invalidate();
                jCChart.getChartArea().invalidate();
                if (!jCChart.isBatched()) {
                    jCChart.validate();
                    jCChart.repaint();
                }
            } else if ((n & 1) > 0 && !jCChart.isBatched()) {
                jCChart.repaint();
            }
        }
    }
}

